
aaa.show_file_begin( "csv_util" )

function fromCSV( s, del )	--del is delimiter
	s = s .. del  -- ending comma
	local t = {}        -- table to collect fields
	local fieldstart = 1
	repeat
		-- next field is quoted? (start with `"'?)
		if string.find( s, '^"', fieldstart ) then
			local a, c
			local i  = fieldstart
			repeat
				-- find closing quote
				a, i, c = string.find( s, '"("?)', i + 1 )
			until c ~= '"'    -- quote not followed by quote?
			if not i then error( 'unmatched "' ) end
				local f = string.sub( s, fieldstart + 1, i - 1 )
				table.insert( t, ( string.gsub( f, '""', '"' ) ) )
				fieldstart = string.find( s, del, i ) + 1
		else                -- unquoted; find next comma
			local nexti = string.find( s, del, fieldstart )
			table.insert( t, string.sub( s, fieldstart, nexti - 1 ) )
			fieldstart = nexti + 1
		end
	until fieldstart > string.len( s )
	return t
end

--[[ not in global
function split( str, delim, max_nb )
	-- Eliminate bad cases...
	if string.find( str, delim ) == nil then
		return { str }
	end
	if max_nb == nil or max_nb < 1 then
		max_nb = 0    -- No limit
	end
	local	result = {}
	local	pat = "(.-)" .. delim .. "()"
	local	nb = 0
	local	last_pos
	for part, pos in string.gmatch( str, pat ) do
		nb = nb + 1
		result[ nb ] = part
		last_pos = pos
		if nb == max_nb then break end
	end
	-- Handle the last field
	if nb ~= max_nb then
		result[ nb + 1 ] = string.sub( str, last_pos )
	end
	return result
end
--]]

function string:split( delimiter )
	local	result = {}
	local	from  = 1
	local	delim_from, delim_to = string.find( self, delimiter, from  )
	while delim_from do
		table.insert( result, string.sub( self, from , delim_from - 1 ) )
		from  = delim_to + 1
		delim_from, delim_to = string.find( self, delimiter, from  )
	end
	table.insert( result, string.sub( self, from  ) )
	return result
end


aaa.show_file_end( "csv_util" )
