#define PROCESSING_COLOR_SHADER

#ifdef GL_ES
precision mediump float;
#endif

uniform vec2 resolution;
uniform float time;
float intense  = .5;
float speed  = 5.;
vec2 graininess = vec2( 1.,1.);

const float offset = 20.0;
const int complexity = 38;
const float Pi = 3.14159;

void main()
{
  	vec2 p=(2.0*gl_FragCoord.xy-resolution)/max(resolution.x,resolution.y);

  	for(int i=1;i<complexity;i++)
  	{
    	vec2 newp=p;
    	newp.x+=graininess.x/float(i)*sin(float(i)*p.y+time/speed+0.3*float(i))+offset;
    	newp.y+=graininess.y/float(i)*sin(float(i)*p.x+time/speed+0.3*float(i+100))+offset;
    	p=newp;
  	}
  	vec3 col=vec3(intense*sin(3.0*p.x)+intense,intense*sin(3.0*p.y)+intense,intense*sin(p.x+p.y)+intense);
	col.g = col.r;
	//col.b = 1.;
  	gl_FragColor=vec4( col, 1.0);
}