--
--	LOG
--
if CLASS.DECLARE( "LOG" ) then
	LOG:set_class_status_doc(	CLASS.STATUS.CORE,
								"use it for file log" )
end

function LOG:init( filename, interval_sec )
	self.queue = QUEUE:create( self:get_name() )
	self.filename = filename
	self.__interval = interval_sec
	if aaa.time then
		self.__time = aaa.time.t_real
	else -- assume we're in watchdog is ok in this case ?
		self.__time = watchdog.get_time()
	end
end
function LOG:create( name, filename, interval_sec )
	local self = LOG:create_instance( name )
	self:init( filename, interval_sec )
	return self
end
function LOG:read()
	local queue = self.queue
	if aaa.file.is_exist( self.filename ) then
		queue:erase()
		for line in io.lines( self.filename ) do
			queue:push( line )
		end
	end
end
function LOG:write()
	local queue = self.queue
	local nb = queue:get_nb()
	if nb > 0 then
		local file = aaa.file.open_no_error( self.filename, "w" )
		if file then
			for i=1,nb do
				file:write( queue:get_front( i ).."\n" )
			end
			file:close()
		end
	end
end
function LOG:__add_line( str, ... )
	if aaa.time then
		str =  "--\t"..aaa.time.get_str_hms().."\t"..str
	else -- assume we're in watchdog mode
		str = "--\t"..watchdog.get_time().."\t"..str
	end
	local queue = self.queue
	local b_no_print, b_no_write = select( 1, ... ), select( 2, ... )
	if b_no_print then else		self:print( str )	end
	queue:push( str )
	if b_no_write then else		self:write()		end
end
function LOG:add( str, ... )		self:__add_line( "OK :\t"..str, ... )	end
function LOG:add_alive( str, ... )	self:__add_line( "Alive", ... )			end
function LOG:add_error( str, ... )	self:__add_line( "ERROR :\t"..str, ... )	end
function LOG:update()
	local interval = self.__interval
	if interval then
		local t
		if aaa.time then
			t = aaa.time.t_real
		else
			t = watchdog.get_time()
		end
		if (self.__time + interval ) < t then
			self:add_alive()
			self.__time = t
		end
	end
end


