# A/ Install Notes
- If not done yet you need to install VScode: https://code.visualstudio.com/. Other text editor options are possible, but this is our default solution and best solution for us now (2025 March).
- we get our video codec from https://codecguide.com/download_kl.htm. Usualy we Install the Mega Pack with all options at default (dialog ok ok ok ...).
- we recommend also Windows PowerToys: https://learn.microsoft.com/en-us/windows/powertoys/.
- XnView Classic or XnView MP are nice image browser at: https://www.xnview.com/en/.
- Blender at https://www.blender.org/ is your 3d free solution.
- Wings3d at https://www.wings3d.com/ need to be mentionned here it exports 3d files in .obj that **AAASeed** love.
- https://www.7-zip.org/ is our compression choice.


# B/ Use Metal version
- **AAASeed_NewMetal.exe** is the most optimized version (Tuned to the metal) and the default version to use.
- But it crashes at start with processors not having AVX2 (Advanced Vector Extension 2). It crashes with no message, no dialog, it just closes in 5 seconds.
- In this case use **AAASeed_Wood.exe** which don't require the AVX2 processor extension.


# C/ File tree and Start sequence 
**AAASeed** is not a traditional software: installed in ProgramFile, having its preference saved somewhere in the system... At some point **AAASeed** will run on other OS than Microsoft windows and we intend to keep the same kind of file tree structure on every OS.

## C.1/ **AAAFoundation** root folder
- **AAAFoundation** is the "root" directory, this name is not mandatory (Mâa use AAA on his Machine) but it is recommended and used by the installer/updater we provide.
```
AAAFoundation	// root folder
	AAADll			// dlls used by AAAFoundation
	AAASeed			// AAASeed environment
		AAAAPPs			// examples, tutorials, tests....	
		AAADoc			// documentation
		AAAKernel		// AAAKernel only for developer
		AAASeed_Metal.exe
		AAASeed_Wood.exe
		README.md		// this document
		ReleaseNotes.md
		version.txt		// version of the installer
	AAAUser		// folder holding your information
		Guest		// folder for AAASeed global preferences
		Guest_net	// folder for network configuration
		AAAWho.txt	// define folder used for prefs, net and APPs
	APPs_Guest	// your APP folder (can change Name)
	Media		// where you should store your medias
```

## C.2/ **AAASeed** folder
- The **AAASeed** folder, inside **AAAFoundation**, holds everything necessary to run **AAASeed** and its related lua AAAGaBuZoMeu environment. Again the **AAASeed** folder name is not mandatory. You can copy and/or rename this directory to keep older versions of the software.

- In fact, there is an exception to the "all in **AAAKernel** rule": the **AAADll** Folder under **AAAFoundation** which holds the dynamic libraries used by **AAASeed**. **DO NOT RENAME THIS FOLDER** or **AAASeed** will not be able to access its dlls.

- This **AAASeed** folder is what is touched when **AAASeed** is updated. Your own data should be somewhere else if you want to preserve it.

## C.3/ **Media** folder
- the **Media** folder, inside **AAAFoundation**, with subdirectories (e.g. users folder Alain, Priam, Tendayi, or project folder) is where users should put their own medias (images, videos, fonts...). We separate it from the applications folder because medias can be way bigger and are usually handled (and saved) very differently in the production process then the application data.
- This is your Media space, organize yourself as you want inside.

## C.4/ **APPs** folders
- this is where **AAASeed** Applications (or APP) are stored:   
	- **AAAAPPs**, in the **AAASeed** folder, with examples, test... Provided and maintained by the AAASeed crew. 
	- **APPs_Guest**, in the **AAAFoundation**, where **AAASeed** users (**Guest** by default) can store their own APPs.

## C.5/ **AAASeed** launch sequence and user notion
- The **start** folder is where **AAASeed** is launched from, for most of you it is where the executables reside, the **AAASeed** folder.
- Then, in this start folder, **AAASeed** found the folder **AAAKernel** which become the kernel folder.
- At this point **AAASeed** will try to find which **user** run the software. **User** have their own global preferences, network preferences and APPs folder.  
- **AAASeed**, in the folder **AAAFoundation**, will try to open a file **AAAWho.txt** inside folder **AAAUser**. Path is ../AAAUser/AAAWho.txt from the starting directory.
```
AAAFoundation
	AAASeed
	AAAUser			// folder holding default user information
		Guest		// Folder holding pref for user Guest 
		Guest_net	// Folder holding network configuration for user Guest 
		AAAWho.txt	// default user configuration
	APPs_User	// your APP folder (can change Name)
	Media		// where you should store your medias
```

## C.6/ AAAWho.txt
- the file path is **AAAFoundation/AAAUser/AAAWho.txt**.
- **AAAWho.txt** contains 3 lines (2025 March):
	- name of the folder for the global preferences: **user folder**.
	- name of the folder for the network preferences: **net folder**.
	- name of the folder for the APPs folder: **app folder**.

- These names are relative to the AAAUser folder

- this is a Default AAAWho.txt file:
```
Guest
Guest_Net
../APPs_Guest
```
- To make your own just copy the directories Guest and Guest_net, also make your app folder then edit the AAAWho.txt. 
- this the AAAWho.txt used by Mâa:
```
Maa
Maa_Net
../APPs_Maa
```
- in this case you should have the corresponding folders:
	- Maa and Maa_net in **AAAUser**
	- APPs_Maa in **AAAFoundation**

## C.7/ APPs folder
- the **APPs** folder just help to the define a relative folder when saving filename, it making it more easy to move APPs around, move prefs from machine to machine, store previous one, etc...

## C.8/ WatchDog
- if the exe name is changed and include **watchdog** (e.g. AAASeed_WatchDog.exe), **AAASeed** start with no graphics windows (just the terminal) and execute a specific lua script in the user folder: **aaa_watchdog.lua**. Currently (2025 March) this script make sure an instance of **AAASeed_Metal.exe** is running. if none is running: it start one. If one is running: it expect to receive information from it at a certain interval. If not the running **AAASeed** is considered crashed, and so the "faulty" **AAASeed** executable is killed and then restarted. Hence the WatchDog concept. 

## C.9/ executable Arguments
- For now (2025 March) the arguments are ot used, but they are just stored in c_info (F10 in flatland, preferences/Executable/exe_arguments), so they can be accessed and stored.

## C.10/ Shift at start
- When **AAASeed** start if you hold the shift key **AAASeed** will be more verbose in the starting phase to help diagnose a problem at start. 



# D/ Git 

This repository holds the environment needed to run **AAASeed** execpt the dll.
The **AAASeed** installer is using these files, and there are regular updates, so, unless you are developping on **AAASeed**, *you should not need* to use this repository.

There is also the [release notes](./ReleaseNotes.md)

You will find documentation in the [./AAADoc](./AAADoc) directory.

- [System overview](./AAADoc/AAASeed_system_overview.md)
- [UI documentation](./AAADoc/AAASeed_design_system.md)
- [Design System](./AAADoc/AAASeed_UI_documentation.md)
- [Technical documentation](./AAADoc/AAASeed_technical_documentation.md)
- [Functionnal documentation](./AAADoc/AAASeed_functionnal_documentation.md)
- Old documentation in the [archives](./AAADoc/archive)

# TODOs
- document watchdog ( and the lua file at the root)
- app on command line to open an app (pass args to lua)