/*
 * For a description of the algorithm and the terms used, please see the
 * documentation for this sample.
 *
 * Each thread calculates a pixel component(rgba), by applying a filter
 * on group of 8 neighbouring pixels in both x and y directions.
 * Both filters are summed (vector sum) to form the final result.
 */


__kernel void sobel_filter(__constant uchar4* inputImage, __global uchar4* outputImage)
{
	uint x = get_global_id(0);
    uint y = get_global_id(1);

	uint width = get_global_size(0);
	uint height = get_global_size(1);

	float4 Gx = (float4)(0);
	float4 Gy = Gx;

	int c = x + y * width;


	/* Read each texel component and calculate the filtered value using neighbouring texel components */
	if( x >= 1 && x < (width-1) && y >= 1 && y < height - 1)
	{
		float4 i00 = convert_float4(inputImage[c - 1 - width]);
		float4 i10 = convert_float4(inputImage[c - width]);
		float4 i20 = convert_float4(inputImage[c + 1 - width]);
		float4 i01 = convert_float4(inputImage[c - 1]);
		float4 i11 = convert_float4(inputImage[c]);
		float4 i21 = convert_float4(inputImage[c + 1]);
		float4 i02 = convert_float4(inputImage[c - 1 + width]);
		float4 i12 = convert_float4(inputImage[c + width]);
		float4 i22 = convert_float4(inputImage[c + 1 + width]);

		Gx =   i00 + (float4)(2) * i10 + i20 - i02  - (float4)(2) * i12 - i22;

		Gy =   i00 - i20  + (float4)(2)*i01 - (float4)(2)*i21 + i02  -  i22;

		/* taking root of sums of squares of Gx and Gy */
		outputImage[c] = convert_uchar4(hypot(Gx, Gy)/(float4)(2));

	}

}

__kernel void invert_filter(__constant uchar4* inputImage, __global uchar4* outputImage)
{
	uint x = get_global_id(0);
    uint y = get_global_id(1);

	uint width = get_global_size(0);
	uint height = get_global_size(1);

	int c = x + y * width;

	uchar4 val = convert_uchar4(inputImage[ c ]);
	uchar4 val_invert = (uchar4)(255, 255, 255, 0) - val;
	val_invert.w = val.w;
	outputImage[c] = val_invert;
	//outputImage[c] = (uchar4)(255,0, 0, 255);

}

	
__kernel void null_filter(__constant uchar4* inputImage, __global uchar4* outputImage)
{
	uint x = get_global_id(0);
    uint y = get_global_id(1);

	uint width = get_global_size(0);
	uint height = get_global_size(1);

	int c = x + y * width;

	outputImage[c] = convert_uchar4(inputImage[ c ]);
}


__kernel void red_filter(__constant uchar4* inputImage, __global uchar4* outputImage)
{
	uint x = get_global_id(0);
    uint y = get_global_id(1);

	uint width = get_global_size(0);
	uint height = get_global_size(1);

	int c = x + y * width;

	uchar4 val = convert_uchar4(inputImage[ c ]);
	val.y = 0;
	val.z = 0;
	outputImage[c] = val;
}
















