-- WINDOW
--
function MEU:add_ui_exploitation_window( rect )
	local ix,iy, sx,sy = unpack(rect)
	sy = sy / 5
	sx = sy
	self:begin_bu_group( "window" )

		local t = self:get_table_always( "__exploitation", "window" )
		self:add_button(	{	ix,		iy,			sy,sy },	"Active", 		t, "b_active",		false			)
		self:add_slider(	{	ix+4,	iy,			4,sy },		"Delay", 		t, "delay",			1,		0,60	)
		self:add_button(	{	ix+sx,	iy+sy,		sy,sy },	"Push", 		t, "b_push",		true			)
		self:add_button(	{	ix+sx,	iy+sy*2,	sy,sy },	"Pop", 			t, "b_pop",			true			)
		self:add_button(	{	ix+sx,	iy+sy*3,	sy,sy },	"NoTopMost", 	t, "b_notopmost",	true			)
		self:add_button(	{	ix+sx,	iy+sy*4,	sy,sy },	"TopMost", 		t, "b_topmost",		true			)

	self:end_bu_group()
end

function MEU:update_exploitation_window()
	local t = self.__exploitation and self.__exploitation.window
	if not t then return end

	if t.b_active then
		--aaa.print_fn()
		local b_do = false
		if t.delay <= 0 then	-- update every frame
			if t.second_last ~= aaa.time.second then
				t.second_last = aaa.time.second
				b_do = true
			end
		else	-- update every t.delay (or nearly)
			local duration = (t.duration or 0) + aaa.time.dt
			if duration >= t.delay then
				duration = 0
				b_do = true
			end
			t.duration = duration
		end
		if b_do then
			if t.b_push			then	aaa.os.push_window()			end
			if t.b_pop			then	aaa.os.pop_window()				end
			if t.b_notopmost	then	aaa.os.set_window_notopmost()	end
			if t.b_topmost		then	aaa.os.set_window_topmost()		end
		end
		t.b_active_last = true
	else
		if t.b_active_last then -- we just stop it
			-- this force window to no top most when we stop forcing the window
			--  so user have control back
			aaa.os.set_window_notopmost()
			t.b_active_last = false
		end
	end
	
end

-- START STOP
--
--todo use __exploitation table here too
function MEU:add_exploitation_start_stop( rect, b_wake, b_shutdown )
	local ui = self.ui
	local bu
	local pre = b_shutdown and "Shutdown" or "Reboot"

	local ix,iy, sx,sy = unpack(rect)

	local sx38 = 3 * sy
	self:add_button(			{ix,		iy,			sy,sy},			"Active", 		self, "b_start_stop",		false		)
--todo clean the onsite stuff
	self:add_button(			{ix+sx/2,	iy,			sy,sy},			"Onsite", 		self, "b_onsite_force",		false		)
	iy = iy + sy
	self:add_slider(			{ix+1,		iy,			sx-1,sy},		pre.." Hour", 	self, "reboot_hour",		0, 0, 23	):set_value_type_integer(true)
	self:add_slider(			{ix+1,		iy+sy,		sx-1,sy},		pre.." Minute", self, "reboot_minute",		0, 0, 59	):set_value_type_integer(true)
	self:add_trig_method(		{ix+1,		iy+sy*2,	sx38,sy},		pre, 			self, "begin_reboot"		):set_color_back("off")
	bu = self:add_text_info(	{ix+1+sx38,	iy+sy*2,	sx-sx38-1,sy},	pre.." info"	)
		ui.bu_info_reboot = bu
	iy = iy + sy * 3

--	bu = self:add_selector(	{ix+1,iy,	7,SY},	"Reboot mode"):set_target_lua( self, "s_reboot"	):set_nb( 2 ):set_text_visible(false)
--		bu:set_item_text( 1, "ReBoot", "ShutDown" )
	if b_wake then
		self:add_slider(		{ix+1,		iy,		sx-1,		sy},	"Start Hour", 	self, "start_hour",			0, 0, 23	):set_value_type_integer(true)
		self:add_slider(		{ix+1,		iy+sy,	sx-1,		sy},	"Start Minute", self, "start_minute",		0, 0, 59	):set_value_type_integer(true)
		self:add_trig_method(	{ix+1,		iy+sy*2,sx38,		sy},	"Wake", 		self, "begin_wake"			):set_color_back("on")
		bu = self:add_text_info({ix+1+sx38,	iy+2,	sx-sx38-1,	sy},	"wake info"		)
			ui.bu_info_wake = bu
		iy = iy + sy * 3
	end

	return iy
end

function MEU:begin_reboot()	self.b_rebooting = true	end
function MEU:is_rebooting()	return self.b_rebooting end

function MEU:update_exploitation_start_stop_shutdown()
	if self.b_start_stop then
		if self.reboot_hour == aaa.time.hour and self.reboot_minute == aaa.time.minute and aaa.time.second <= 15 then
			--if self.s_reboot==1 then
			--	aaa.reboot_no_save()
			--else
				aaa.shutdown_no_save()
			--end
		end
	end
end

function MEU:update_exploitation_start_stop( b_wake, b_shutdown )
	--if not aaa.pc.is_maa() then
	if self.b_start_stop then
		local function comp_time( h, m, s ) return h*10000 + m*100 + (s or 0) end
		local now = comp_time( aaa.time.hour, aaa.time.minute, aaa.time.second )
-- REBOOT
		if (not self:is_rebooting()) and inside( 	now,	comp_time( self.reboot_hour, self.reboot_minute, 0 ),
															comp_time( self.reboot_hour, self.reboot_minute, 10 ) ) then
			self:begin_reboot()
		end
-- START
		--todo not on the nucs monaco not to send magic packet (was commented)
		local b_wake_time
		if self.start_hour and b_wake then
			b_wake_time = inside(	now,	comp_time( self.start_hour, self.start_minute ),
											comp_time( self.start_hour, self.start_minute+1 ) )
			if (not self:is_waking()) and b_wake_time then
				self:begin_wake()
			end
		end

		if self:is_rebooting() then	--todo check when none
			if b_shutdown then
				if app.b_shutdown_allowed and app.b_shutdown_allowed == true then
					aaa.shutdown_no_save()
				end
			else
				aaa.reboot_no_save()
			end
		elseif self.start_hour and self:is_waking() then
			if b_wake_time then	self:update_wake()
			else				self.wake_time = nil
			end
		end

-- SLOW
		--if inside( now, comp_time( 0, 0 ), comp_time( self.start_hour, self.start_minute ) ) then
		--	aaa.sleep( 100 )
		--end
	end
end

function MEU:update_ui_exploitation_start_stop()
	local ui = self.ui
	ui.bu_info_reboot:set_text(	"is "..self.b_rebooting	)
	local bu = ui.bu_info_wake
	if bu then
		bu:set_text( "is "..self:is_waking()	)
	end
end

-- WAKE UP LAN
--
function MEU:begin_wake_base()
	aaa.print( "__________________________WAKE______________________________________")
	if self.wake_time == nil then
		self.wake_time = 0
	end
end
-- used https://winaero.com/blog/how-to-use-wake-on-lan-on-windows-10/
function MEU:wake_up( mac_addr, name )
	self:print( "Send magic packet to "..name )
	aaa.net.send_magic_packet( 0, mac_addr )
end
function MEU:wake_up_table( table_name_mac, name )
	for i, data in IPAIRS( table_name_mac ) do
		self:wake_up( data.mac, data.name )
	end
end

function MEU:is_waking()	return self.wake_time ~= nil end
function MEU:update_wake()	end