if CLASS.DECLARE( "MEU_OUT", MEU ) then
	MEU_OUT:set_class_status_doc(	CLASS.STATUS.GABUZOMEU,						
		"This Meu is the standard way to setup a graphic output,",
		"select the input texture and the output screen",
		"with options to deform, crop and define fuzzy edge (used to merge several projected image)" )
end

function MEU_OUT:define_meu_infos( )
	return { 	author = "Mâa",
				tags = { "2d", "3D", "Texture", "VJ", "Core", "CoreGraphic", "Surface", "Draw", "Output", "unfinished" }
			}
end


function MEU_OUT:reset_grid()
	param.set( self.ref.grid_reset_trig, true )
end
function MEU_OUT:define_ui()
	local ref = self.ref
	local ui = self.ui
	local bu
	local par

	local SY = 1
	local DY = .2
	local SX3 = 8/3

	local ix,iy = 1,1

	bu = self:add_button(	{ix,iy,			SX3,SY},	"Draw",		self,"b_draw",		true )
	self:add_button(		{ix+SX3,iy,		SX3,SY},	"Use Fbo",	self,"b_use_fbo",	false	)
	self:add_trig_fn(		{ix+SX3*2,iy,	SX3,SY},	"Focus", 	aaa.obj.set_focus_ui, ref.bdd )
	iy = iy + SY
	local sha = self:get_shading()

	self:add_button(		{ix+1,iy,		SX3-1,SY},	"TopGrid",	self,"b_top",		false ):set_text("Top")
	local SX = (8-SX3)/3
	bu = self:add_button(	{ix+SX3,		iy,	SX,SY},	"Crop",		self,"b_crop",		true )
	bu = self:add_button(	{ix+SX3+SX,		iy,	SX,SY},	"Force",	self,"b_see_debug",	false )
	-- bu = self:add_selector(	{ix,iy,			4,SY}, 	"Crop" )
	-- 	bu:set_nb(2)
	-- 	bu:set_target_lua( self, "s_crop" )
	-- 	bu:set_item_text( 1,  "Crop", "Full" )
	--bu = self:add_button(	{ix+2,iy,	2,SY}, 	"White",	self, "b_white",	false )
	--bu = self:add_selector(	{ix+6,iy,	2,SY}, 		"Display" )
	--bu:set_item_text( 1, "UV", "White", "Black", "Color" )
	bu = self:add_button(	{ix+SX3+SX*2,	iy,	SX,SY}, 		"Display" )
	-- 	bu:set_nb(2)
		bu:set_menu( { "Black", "Color", "White",  "UV"  } )
		bu:set_target_lua( self, "s_see" )
		self.s_see = 3
		bu:set_text_selector(true)
	
	--bu = self:add_button(	{ix+6.5,iy,		1.5,SY}, 	"UV", self,		"b_see_uv",	false )
	
	iy = iy + SY + DY
	local iy_top = iy

	self:add_camera()
	self:add_screen_viewport()

	--local iys = iy

	self:set_tab_key_def()

	self:add_rendering()
	local S = .6

	local ix = 1
--	self:add_button(		{ix,iy,			SY,SY },	"Pixel_Exact",	self, "b_pixel_exact",	false	)
--	self:add_button(		{ix+SY, iy+SY,	SY,SY },	"Clamp",		self, "b_clamp",		false		)

	local SX = 4
	local ox = 1

-- DEFORM
--
	self.str_ui_intercept = "UI Intercept"
	if ref.deform then
		self:add_button(		{ix, 		iy,	SX3,SY},	"Deform",		ref.deform,			false	)

		self:add_slider(		{ix+SX3,	iy,			SX3		,SY/2},	"deform.nb_u_new",	ref.bdd, "curve_nb_u_new", nil,	2,64	)
			:set_text( "Points U" ):set_color_back("u")
		self:add_slider(		{ix+SX3,	iy+SY/2,	SX3,	SY/2},	"deform.nb_v_new",	ref.bdd, "curve_nb_v_new", nil,	2,64	)
			:set_text( "Points V" ):set_color_back("v")

		self:add_trig_method(	{ix+SX3*2,	iy,	SX3,SY},	"Grid Reset",	self, "reset_grid" )
			:set_color_back("reset")
			:set_confirmation( true, "Reset", "No" )
		iy = iy + SY

		self:add_button(		{ix,	iy,	SX3,SY},		"UI Draw",		ref.ui_draw			)
		SX = SX3

		self:add_trig_method(	{ix+SX3,	iy,			SX3,	SY},	"Set Nb",	self, "ask_new_uv"	)
			:set_confirmation( true, "Set", "No" )
		iy = iy + SY

		ui.bu_ui_intercept =
			self:add_button(	{ix+1,	iy,	6,SY},	self.str_ui_intercept, ref.ui_intercept	)
	end
	iy = iy + SY + DY


-- FUZZY
--
	--iy = iys
	local fuzzy = {}	
	self:add_button( 	{ix,iy, 		8,SY},		"fuzzy.active", fuzzy, "b_active", false ):set_text( "Fuzzy")


if true then
	iy = iy + SY
	local function add_gamma( rect_active, rect_gamma, post, text )
		local t_bu = {}
		local fuz_one = { t_bu = t_bu }
		self:begin_bu_group( "fuzzy_"..post )
			bu = self:add_button( 	rect_active,		"Active"	):set_target_lua( fuz_one, "b_fuz", true )
				:set_text( text )
				:set_text_inside( true )
			t_bu.bu_active = bu
			
			local x,y, sx,sy = unpack(rect_gamma)
			sy = sy / 2
			bu = self:add_slider(	{x,y, sx,sy },"Gamma",	fuz_one, "gamma",	1, 	0,8 )
				:set_color_back( (post=="l" or post=="r") and "u" or "v" )
				:set_draw_gamma( true )
			t_bu.bu_gamma = bu

			y = y + sy
			local sx1 = sx/2
			bu = self:add_button( 	{x,y, sx1,sy },	"How" )
				bu:set_menu( { "Do", "Set", "Get"  } )
				local sel = bu:get_selector()
				sel:set_nb_min_0( 1,3 )
				bu:set_target_lua( fuz_one, "s_rw" )	
				--bu:set_draw_by_value( 2, "false" )
				bu:set_value( 0 )
				bu:set_text_inside( true )
				bu:set_text_selector( true )
				--bu:set_text_visible ( false )
				t_bu.bu_how = bu

			bu = self:add_button(	{x+sx1,y, sx-sx1,sy },		"Target" )
				bu:set_menu( { "1", "2", "3", "4" } )
				local sel = bu:get_selector()
				--sel:set_nb( 4,1 )
				bu:set_target_lua( fuz_one, "id" )
				bu:set_text_selector( true )
				bu:set_text_inside( true )
				--:set_item_text_from_nb()
				--:set_text_visible ( false )
				t_bu.bu_target = bu
		self:end_bu_group()
		fuzzy[post] = fuz_one
	end

	local MAR = .25
	local SXB = 2-MAR
	local MARV = .125

	bu = self:add_slider_two(		{ix,iy+SY,	4,SY},	"LR",			fuzzy, "le", "ri",	.1,.9,	0,1 )
		:set_color_back( "u" )
		:set_min_max_strict( true )
		:set_draw_step( "step_two" )
		ui.bu_lr = bu
	add_gamma(	{ix,iy,			SXB,SY}, 		{ix,iy+SY*2,		2-MARV,SY*2},	"l", "Left" )
	add_gamma(	{ix+4-SXB,iy,	SXB,SY}, 		{ix+2+MARV,iy+SY*2,	2-MARV,SY*2},	"r", "Right" )

	bu = self:add_slider_two(		{ix+5,iy+SY*4,	4,SY,.25},	"BT", 	fuzzy,  "bo", "to",	.1,.9,	0,1 )
	 	:set_color_back( "v" )
	 	:set_min_max_strict( true )
		:set_draw_step( "step_two" )
		ui.bu_bt = bu
	add_gamma(	{ix+4,iy+SXB,	SXB,SY,	.25},	{ix+6,iy,			2,SY*2-MARV},	"t", "Top" )
	add_gamma(	{ix+4,iy+SY*4,	SXB,SY,	.25}, 	{ix+6,iy+SY*2+MARV,	2,SY*2-MARV},	"b", "Bottom" )

	iy = iy + SY*4 + DY*2
else
	local function add_gamma( rect, b_top, b_left, post, text )
		local t_bu = {}
		local fuz_one = { t_bu = t_bu }
		self:begin_bu_group( "fuzzy_"..post )
			local x,y, sx,SY = unpack(rect)
			local le,ri = x, x+sx
			local dy = SY * (b_top and -1 or 1)
			bu = self:add_button( 	{ b_left and le or ri-SY,y, SY,SY},		"Active"	):set_target_lua( fuz_one, "b_fuz", false )
				bu:set_text( text )
				bu:set_text_inside( true )
			t_bu.bu_active = bu

			local r = rect
			local sxg = 2
			y = y + dy
			bu = self:add_slider(	{ b_left and le or ri-sxg, y, sxg, SY },"Gamma",	fuz_one, "gamma",	1, 	0,8 )
				:set_color_back( (post=="l" or post=="r") and "u" or "v" )
				:set_draw_gamma( true )
			t_bu.bu_gamma = bu

			local sxh = 1
			local x = b_left and le+sxg or ri-sxg-sxh
			bu = self:add_button( 	{x,y, sxh,SY },	"How" )
				bu:set_menu( { "Do", "Set", "Get"  } )
				local sel = bu:get_selector()
				sel:set_nb_min_0( 3,1 )
				bu:set_target_lua( fuz_one, "s_rw" )	
				bu:set_draw_by_value( 2, "false" )
				bu:set_value( 0 )
				bu:set_text_inside( true )
				bu:set_text_selector( true )
				--bu:set_text_visible ( false )
				t_bu.bu_how = bu

			local sxt = 1
			x = x + (b_left and sxh or -sxh)
			bu = self:add_button(	{x,y, sxt,SY },		"Target" )
				bu:set_menu( { "1", "2", "3", "4" } )
				local sel = bu:get_selector()
				sel:set_nb( 4,1 )
			 	bu:set_target_lua( fuz_one, "id" )
				bu:set_text_selector( true )
				bu:set_text_inside( true )
			 	--:set_item_text_from_nb()
			 	--:set_text_visible ( false )
				t_bu.bu_target = bu
			self:end_bu_group()
			fuzzy[post] = fuz_one
		end

	iy = iy + SY*2
	local sx = SY
	bu = self:add_slider_two(		{ix+SY,iy,	8-2*SY,SY},	"LR",			fuzzy, "le", "ri",	0,1,	0,1 )
		:set_color_back( "u" )
		:set_min_max_strict( true )
		:set_draw_step( "step_two" )
		ui.bu_lr = bu
	add_gamma(	{ix,iy,	8,SY}, true,  true,	 "l", "Left" )
	add_gamma(	{ix,iy,	8,SY}, true,  false, "r", "Right" )
	iy = iy + SY + .1
	bu = self:add_slider_two(		{ix+SY,iy,	8-2*SY,SY},	"BT", 			fuzzy,  "bo", "to",	0,1,	0,1 )
		:set_color_back( "v" )
		:set_min_max_strict( true )
		:set_draw_step( "step_two" )
	ui.bu_bt = bu
	add_gamma(	{ix,iy,	8,SY}, false, true,	 "b", "Bottom" )
	add_gamma(	{ix,iy,	8,SY}, false, false, "t", "Top" )
	iy = iy + SY*2 + DY
end
	self.fuzzy = fuzzy

	ui.bu_rgb = self:add_rgbf(	{ix,iy,		8,1}	)
	iy = iy + 1
	ui.bu_gamma = self:add_rgbf({ix+1,iy,	7,SY}, 		"Color Gamma",	false )
					:set_gamma( true )
	iy = iy + SY + DY

	-- self:add_rendering(	{ix,iy,			nil,SY*2}	)
	-- iy = iy + SY * 2 + dy
-- COLOR
	ix,iy = 9, 3 + DY

	--self:add_button(		{9,iy,			SY,SY},		"Tex Set", self, "b_tex_set", true )
	bu = self:add_button( 	{ix,iy, 		SY,SY},		"By pixel",			self,"b_by_pixel",			false )
	self:add_blending(		{ix+6,iy}	)
	iy = iy + SY

	--self:begin_bu_group( "grid" )
	self:add_size_uvf_video( {9,iy,			8,SY*2},	nil, true )
	--self:end_bu_group()

	self:begin_bu_group( "pixel" )
	local max = 128
	self:add_slider(		{ix,	iy,		4,SY},		"Offset Pos U",		self,"offset_u",		0,	-max,max)
		:set_value_type_integer( true )
		:set_color_back( "u" )
	self:add_slider(		{ix+4,	iy,		4,SY},		"Offset Pos V",		self,"offset_v",		0,	-max,max)
		:set_value_type_integer( true )
		:set_color_back( "v" )
	self:add_slider(		{ix,	iy+SY,	4,SY},		"Offset Size U",	self,"offset_size_u",	0,	-max,max)
		:set_value_type_integer( true )
		:set_color_back( "u" )
	self:add_slider(		{ix+4,	iy+SY,	4,SY},		"Offset Size V",	self,"offset_size_v",	0,	-max,max)
		:set_value_type_integer( true )
		:set_color_back( "v" )
	self:end_bu_group()
	iy = iy + SY*2 + DY

	self:add_transfo( {ix,iy, 8,2.4} )
	iy = iy + 2.4 + DY

	self:add_bu_texture_target_unit( {9,iy, 8,6} ,	"Tex", 1, false )

	iy = iy + 7

--todolv ?
--	local iy = 14
--	bu = self:add_trig_method(	{9,	iy},				"center", 			self, "center"	)
--	bu = self:add_trig_method(	{9,	iy+1},				"fit in x", 		self, "scale", "fit_x"	)
--	bu = self:add_trig_method(	{9,	iy+2},				"fit in y", 		self, "scale", "fit_y"	)
--	bu = self:add_trig_method(	{9,	iy+3},				"fit in screen",	self, "scale", "screen"	)

-- MAP
--
	self:set_tab_key( "Map" )
--todo generalize this map onglet
	local function define_ui_uv( rect, SX,SY, tab )
		local ix,iy, sx,sy = unpack(rect)
		local LSX = SX*2
		local MSX = sx-LSX
		local MSY = sy-SY
		bu = self:add_slider_two(	{ix+LSX,	iy+MSY,		MSX,SY},		"U", tab, "u_min",  "u_max", 0,1, 0,1)
		--unused
		bu = self:add_slider(		{ix+LSX,	iy+MSY+SY,	MSX,SY},		"U center", tab, "u_center",  .5, 0,1)

		bu = self:add_slider_two(	{ix+SX,		iy+MSY,		MSY,SX,	.25},	"V", tab, "v_min",  "v_max", 0,1, 0,1)
		--unused
		bu = self:add_slider(		{ix,		iy+MSY,		MSY,SX,	.25},	"V center", tab, "v_center",  .5, 0,1)

		bu = self:add_monitor( 		{ix+LSX,	iy,			MSX,MSY},		"choice UV" )
			bu:set_texture_fill( true )
			bu:set_method( "draw_after", self, "draw_uv", bu )
			tab.ui.bu_choice_uv = bu
	end
	define_ui_uv( {1,iy_top, 16,13.6-iy_top},	1,SY,	self )
	--unused
	--iy = 15
	--bu = self:add_button( 		{1,iy,						1,1},		"UV_Scale_active",	self, "b_uv_scale", false ):set_text_visible(false)
	--bu = self:add_slider(			{2,iy,						5,1},		"UV Scale",			self, "uv_scale",  1, 1,2 )

-- MORE
--
--	self:set_tab_key( "More" )

-- MASTER
--
	self:set_tab_key( "Rest" )
	ix,iy = 1,iy_top
	self:add_nb_uv( {ix,iy}, ref.bdd )

	ix,iy = 9,iy_top
	iy = 3 + SY + DY
	bu = self:add_button(		{ix,iy, 	SY,SY },	"Master_gamma_use",	app, "__b_master_gamma_use",	false ):set_text("Use")
	bu = self:add_slider(		{ix,iy+SY,	8,SY},		"Master_Gamma",		app, "__master_gamma",			.45,	0,8	)
	iy = iy + SY*2 + DY
	self:add_shading_ui( 		{ix,iy+SY,	8,SY}		)

end

function MEU_OUT:ask_new_uv()
	param.set( self.ref.bdd, "curve_nb_new_trig", true )
end

function MEU_OUT:draw_uv( bu )

	gol.color_white()
	local c = self.v_min-.5
	aaa.draw_line( -.5, c, .5, c )
	c = self.v_max-.5
	aaa.draw_line( -.5, c, .5, c )
	c = self.u_min-.5
	aaa.draw_line( c, -.5, c, .5 )
	c = self.u_max-.5
	aaa.draw_line( c, -.5, c, .5 )

	gol.color_blue()
	c = self.u_center-.5
	aaa.draw_line( c, -.5, c, .5 )
	c = self.v_center-.5
	aaa.draw_line( -.5, c, .5, c )
end

--todolv ?
--function MEU_OUT:center()		end
--function MEU_OUT:scale( how )	end

function MEU_OUT:init()
	local ref = self.ref

	local layers = self:get_layers()
	ref.fbo_use = param.get_ref( layers, "FBO" )
	local layer = self:get_layer(1)
	ref.b_active = param.get_ref( layer, "active" )

	ref.use_bdd = self:get_layer_ref_table(1).use_bdd
	
	local bdd = self:get_layer_bdd(1)
	--self:box_debug( "bdd is "..bdd )
	ref.bdd = bdd
	-- No error in case the layer use a regular bdd_grid (there is no center param in bdd_adjustable )
	ref.deform			= param.get_ref_no_error( bdd, "deform"				)
	ref.ui_draw			= param.get_ref_no_error( bdd, "ui_draw"			)
	ref.ui_intercept	= param.get_ref_no_error( bdd, "ui_intercept"		)
	ref.grid_reset_trig = param.get_ref_no_error( bdd, "grid_reset_trig"	)

	ref.top_line		=	param.get_ref(	 ref.rendering, "top_line"		)
							param.set_save(  ref.top_line, false			)
	ref.top_line_cull	=	param.get_ref(   ref.rendering, "top_line_cull" )
							param.set(    	 ref.top_line_cull, "front"		)
							param.set_save(  ref.top_line_cull, false		)
	ref.top_point		= 	param.get_ref(   ref.rendering, "top_point"		)
							param.set_save(  ref.top_point, false			)
	ref.top_point_cull	=	param.get_ref(   ref.rendering, "top_point_cull" )
							param.set(    	 ref.top_point_cull, "back"		)
							param.set_save(  ref.top_point_cull, false		)

--	ref.camera_use = param.get_ref( self:get_layers(), "use_camera" )

	if ref.ui_intercept then	--protect from layer have a grid instead of a grid_ajustable
		param.set_save( bdd, "ui_index_u", false )
		param.set_save( bdd, "ui_index_v", false )
	end

	self:add_shading()
		:set_save_vert_int(		false, 1,4	)

		:set_save_frag_int(		false, 1,3	)
		--:set_save_frag_float(	false, 1,4	)
		:set_save_frag_vec4(	false, 1,6	)
end

function MEU_OUT:update_ui()
	local ui = self.ui
	local bind = self:get_texture_bind_2d(1)
	--self:print( "ui bind is  "..bind )
	if ui.bu_choice_uv then	--protect from bad init then
		ui.bu_choice_uv:set_texture_bind_2d( bind )
	end

	local tab_key = self:get_tab_key()
	--aaa.show( tab_key, "Out tab" )
	local b_main = tab_key=="main"
	self:set_bu_group_active( "pixel", b_main and self.b_by_pixel )
	self:set_bu_group_active( "grid", b_main and not self.b_by_pixel )
	
	local bu = ui.bu_ui_intercept
	if bu then
		local b = bu:get_value_as_bool()
		bu:set_text( b and "Key q to exit" or self.str_ui_intercept )
		bu:set_text_color_problem_info( not b )
	end

--FUZZY
	local fuz = self.fuzzy
	local b_fuz = fuz.b_active
	local alpha
	for i,key in ipairs( { "l","r", "t","b" } ) do
		local f = fuz[key]
		local t_bu = f.t_bu
		t_bu.bu_active:interpolate_alpha_bu( b_fuz )
		local b = f.b_fuz and b_fuz
		alpha = t_bu.bu_gamma:interpolate_alpha_bu( f.s_rw==1 or (f.s_rw~=2 and b) )
		--t_bu.bu_how:interpolate_alpha_bu( true )
		t_bu.bu_target:interpolate_alpha_bu( f.s_rw==1 or (f.s_rw==2 and b) )
	end
	ui.bu_lr:interpolate_alpha_bu( b_fuz and (fuz.l.b_fuz or fuz.r.b_fuz) )
	ui.bu_bt:interpolate_alpha_bu( b_fuz and (fuz.b.b_fuz or fuz.t.b_fuz) )
end

-- use to set and get gammma in a global table shared by Meu_Out
local gamma_global = { 1,1,1, 1 }

function MEU_OUT:update()
	--aaa.print_fn()
	local sha = self:get_shading()
	if not sha then return end
	-- sha:set_vert_int( 1, self.b_by_pixel and 1 or 0 )
	-- self.ui.bu_type:set_value( 3 )
	local ref = self.ref

	param.set( ref.fbo_use, self.b_use_fbo and 0 or 1 )
	if ref.ui_intercept then
		local b = param.get_bool( ref.ui_intercept )
		if self.__ui_intercept_last ~= b then	
			self.__ui_intercept_last = b
			if b then	--cheat once activated because the ui one to interect alt q for example
				aaa.bdd.set_ui( ref.bdd )
			end
		end
	end

--hack mona
	local b_white = self.b_white
	if app and app.get_screens_white and app:get_screens_white() then
		b_white = true
	end
	local value
	if b_white then
		value = 256 * 2
	elseif self.b_see_debug then 
		value = 256 * self.s_see
	else
		value = 0
	end
	if self.b_crop then
		value = value + 1
	end
	sha:set_frag_int( 1, value<=513 and value or -value )

	local r,g,b = self.ui.bu_gamma:get_rgba()
	
	sha:set_frag_vec4( 1, r,g,b )

	local r,g,b = self.ui.bu_rgb:get_rgba()
	--self:print( "toto "..self.__alpha_meu.." "..self:get_alpha()  )
	sha:set_frag_vec4( 2, r,g,b, self:get_alpha()  ) -- problem : all slider change all values ..?!

	sha:set_frag_vec4( 3, self.u_min, self.v_min, self.u_max, self.v_max )
--[[
	if self.b_uv_scale then
		sha:set_frag_int( 3, 1 )
		local scale = 1. / self.uv_scale
		sha:set_frag_vec4( 4, self.u_center, self.v_center, scale, scale )
	else
		sha:set_frag_int( 3, 0 )
	end
]]--

--FUZZY
	local fuz = self.fuzzy
	local b_fuz = fuz.b_active
	if b_fuz then
		local gamma_local = {}
		for i,key in ipairs( { "l","r", "t","b" } ) do
			local f = fuz[key]
			--self:print( key.." "..f.s_rw )
			if 		f.s_rw == 1 then	gamma_global[f.id] = f.gamma
			elseif	f.s_rw == 2 then	f.gamma = gamma_global[f.id]						
			else
			end
			gamma_local[i] = app.__b_master_gamma_use and app.__master_gamma or f.gamma		
		end

		local le = fuz.l.b_fuz
		local ri = fuz.r.b_fuz
		local bo = fuz.b.b_fuz
		local to = fuz.t.b_fuz
		b_fuz = le or ri or bo or to
		if b_fuz then
			sha:set_frag_int( 2, 1 )
			le = le and fuz.le or 0
			ri = ri and fuz.ri or 1
			bo = bo and fuz.bo or 0
			to = to and fuz.to or 1
	--	self:print( le .. " " .. gamma_local[1] )
			sha:set_frag_vec4( 5,	1/le, 1/(1-ri),		1/bo, 1/(1-to) )
			sha:set_frag_vec4( 6,	gamma_local[1], gamma_local[2], gamma_local[4], gamma_local[3] )	-- because order is lrbt
		end
	end
	sha:set_frag_int( 2, b_fuz and 1 or 0 )

	-- --we forgot for now
	-- --redo later
	--if self.b_pixel_exact  then
	-- 	sha:set_active(true)
	-- 	param.set( ref.use_shading, "Owner" )
	-- 	sha:set_frag_float( 1, self.b_clamp and 1 or 0 )

	-- 	local cam = self:get_camera_used()
	-- 	if cam then	-- need this because until layers have being updated there no camrea used in the layers
	-- 		if self.cam ~= cam or not self.ref.viewport then
	-- 			self.cam = cam
	-- 			local view = aaa.obj.get_branch_by_class_no_error( cam, "viewport" )
	-- 			if view then
	-- 				local pgr  = param.get_ref
	-- 				self.ref.viewport = { obj=view, x=pgr(view,"x"), y=pgr(view,"y"), sx=pgr(view,"size_x"), sy=pgr(view,"size_y") }
	-- 			else
	-- 				self.ref.viewport = nil
	-- 			end
	-- 		end
	-- 	end
	-- 	local vi = self.ref.viewport
	-- 	if vi then
	-- 		local pg  = param.get
	-- 		local vx, vy, vsx, vsy = pg(vi.x), pg(vi.y), pg(vi.sx), pg(vi.sy)
	-- 		local sx,sy = self:get_texture_size()
	-- 		if sy then
	-- 			sha:set_frag_int( 3, vx )
	-- 			sha:set_frag_int( 4, vsy+vy-sy )
	-- 		end
	-- 	end
	--else

		-- this is just a small opt (perhaps even too small)
		if sha:is_active() then
		 	param.set( ref.use_shading, "Owner" )
		else
		 	param.set( ref.use_shading, "none" )
		end
	--end

	local b = self.b_top
	if self.b_top_last ~= b then 
		param.set( ref.top_line, b )
		param.set( ref.top_point, b )
		self.b_top_last = b
	end
end

function MEU_OUT:draw()
	local ref = self.ref
	local sha = self:get_shading()

	self:draw_layers_begin()
		local s_param_draw
		if self.b_by_pixel then
			local wsx,wsy = aaa.get_window_size()
			--self:print( wsx w)
			local sl,sb, sr,st= aaa.screen.get_lbrt( 0 )
			local l,b, r,t= aaa.screen.get_lbrt( self.ui.bu_screen_id:get_value() )
			local screen_sx,screen_sy = r-l,b-t
			--sha:set_vert_int_1_4(	sx+self.offset_size_u,	sy+self.offset_size_v,
			sha:set_vert_int_1_4(	screen_sx,				screen_sy,
									l-sl+self.offset_u,		t-st-screen_sy+wsy-self.offset_v )	--to better pass in thru frag
			sha:set_frag_float_14_16( self.color_gamma, self.offset_size_u, self.offset_size_v )
			s_param_draw = 1	-- none
		else
			sha:set_vert_int_1( 0 )
			s_param_draw = self.b_draw and 2 or 3	-- update and draw
		end
		param.set( ref.use_bdd, s_param_draw )
		self:draw_layer(1)
		if self.b_by_pixel and self.b_draw then
			local s = 1
			aaa.draw_rect( -s,-s, s,s )
		end
		param.set( ref.use_bdd, 2 )	-- make it have the right value at init/load
	self:draw_layers_end()
end
