
--todo ?
-- use 	aaa.hook_quit( b_shutdown, b_shutdown_reboot )
function meu:define_ui()
	local ref = self.ref
	local ui = self.ui
	local bu
	local ix,iy = 1,1
	local SY = 1
	local DY = .2

	local SXS = 4
	local SYS = SY * 2

--	self:set_tab_key( "Art" )
	--iy = self:add_exploitation_start_stop(	{ix,iy,		7,SY},	true, true )
	self:add_trig_method(	{ix,iy,			4,SY},	"Notes",	self, "edit_note"			):set_color_back( "load" )
	iy = iy + SY + DY

	self:add_ui_exploitation_window(	{ix,iy,			7,5}	)
	iy = iy + 5 + DY

	self:add_trig_method(	{ix+2,iy,		4,SY},	"FULLSCREEN", 	ga,			"force_fullscreen"	):set_color_back( "restart" )
	iy = iy + SY + SY/2

	self:add_slider(		{ix,iy,			8,SY},	"Volume", 		self,		"volume",	.8,	0,1	)
	iy = iy + SY + DY

	self:add_trig_method(	{ix,iy,			4,SY},	"Launch Pd", 	self,		"launch_pd"				):set_color_back( "load" )
	self:add_trig_method(	{ix+4,iy,		4,SY},	"Kill Pd", 		self,		"kill_pd", 100, 100		):set_color_back( "load" )
	iy = iy + SY 
	self:add_trig_method(	{ix,iy,			4,SY},	"OSC init", 	app,		"init_osc"				):set_color_back( "load" )
	ui.bu_osc_info =
	self:add_text_info(		{ix+4,iy,		4,SY},	"OSC Info"		):set_text_align_x( "right" )
	iy = iy + SY
	self:add_button(     	{ix,iy,			4,SY},	"OSC Send", 	app.osc,	"b_send",	false		)
	self:add_trig_method(	{ix+4,iy,		4,SY},	"OSC Test", 	self,		"send_osc_info", "Test"	):set_color_back( "reset" )
	iy = iy + SY
	self:add_button(     	{ix,iy,			4,SY},	"OSC Verbose", 	app.osc,	"b_verbose",	false	)
	self:add_trig_method(	{ix+4,iy,		4,SY},	"OSC Quit", 	self,		"send_osc_quit"	):set_color_back( "reset" )
	iy = iy + SY + SY/2

	self:add_slider(		{ix,iy,			8,SY},	"Flatland_offset_X", 	aaa.ref.draw_focus_offset_x	):set_min_max( 0, 4000 )
	iy = iy + SY + DY

	ix,iy = 9,1
	self:add_selector(		{ix,iy,			8,SY},	"Detection"		)
		:set_item_text( 1, "Detection", "Simulation", "Direct" )
		:set_target_lua( self, "s_detection" )
		--:set_nb( 3 )
	--	:set_value( 2 )
	iy = iy + SY
	local pres = self.presence
	for i = 1,3 do
		local s = 8/3
		self:add_slider(	{ix+s*(i-1),iy,		s,SY},	"Cov Max"..i,	pres[i],	"coverage_max",	0,	0,.5 	)
		self:add_slider(	{ix+s*(i-1),iy+SY,	s,SY},	"Cov "..i,		pres[i],	"cov",			0,	0,1 	)
		self:add_slider(	{ix+s*(i-1),iy+SY*2,s,SY},	"Accum "..i,	pres[i],	"accum",		0,	0,1 	)
	--	:set_draw_min(false)	--todo works but not the right way ? solve later
	end
	iy = iy + SY*3
	self:add_button(     	{ix,iy,	4,SY},	"Detection Send", 				self,	"b_detection_send",	false		)
	iy = iy + DY + SY + DY

	self:add_slider_two(	{ix,iy,	8,SY},	"Recit Temporisation", 			self, 	"recit_away_min", "recit_away_max",				3,8, 3,16  )
	iy = iy + SY
	self:add_slider_two(	{ix,iy,	8,SY},	"Recit Temporisation Occupe", 	self, 	"recit_away_min_busy", "recit_away_max_busy",	7,12, 3,16  )
	iy = iy + SY + DY

--	local SYB = SY

--	self:set_tab_key( "Exploit" )
--	ix = 1
--	iy = iy + SYS + DY + SYB*2
--	self:add_trig_method(	{ix,iy,			SXS*4,SY},	"Load All", 	app,	"load_media"		):set_color_back( "load" )
--	iy = iy + SY + DY

--	self:add_trig_method(	{ix+2,iy,		4,SY*1.5},	"CONFIGURE", 	self,	"configure"			):set_color_back( "restart" )
--	iy = iy + SY * 1.5 + DY
end

function meu:edit_note()
	local path = self:get_dir_absolute().."nimes_note.txt"
--	aaa.show( path )
	aaa.os.open_editor( path )
end

local exe_name = "pd.com"
function meu:kill_pd( sleep, max_try)
	self:print( "will try to kill \""..exe_name.."\"" )
	--aaa.print( process.get_id_by_name( exe_name ) )
	while process.get_id_by_name( exe_name ) and max_try > 0 do
		process.kill_by_name( exe_name )
		self:print( "\tfound and killed \""..exe_name.."\"" )
		aaa.sleep( sleep )
		max_try = max_try - 1
	end
end

function meu:launch_pd( b_check_already )
	if b_check_already then
		if process.get_id_by_name( exe_name ) then
			return
		end
	end
	local dir = aaa.dir.make_media_path( "Nimes_2023\\Audio_app\\" )
	-- -nogui -stderr
	local str_err = aaa.os.execute_process( dir.."bin\\pd.com", " -open "..dir.."\\extra\\patch.pd -send \"port 18100\"" )
	-- pd-0.54-1\bin\pd.com -nogui -stderr -open pd-0.54-1\receive.osc.pd -send "port 9002"
	self:print( str_err )
end
function meu:send_osc_info( ... )
	app:send_aaaseed_info( ... )
end
function meu:send_osc_quit()
	app:send_osc( "romanite/audio/quit" )
end

function meu:init()
	local ref = self.ref
--	local bdd = self:get_layer_bdd(1)
--	ref.temp	= param.get_ref( bdd, "received_number_last" )
	self.s_fullscreen_needed = 0
	self.s_init = 0
	--self:print( "init s_init "..self.s_init )
	if not aaa.pc.is_maa() then
		ga:set_ui_on_screen(1)
		ga:force_fullscreen()
	end

	self.presence = {}
	for i = 1,3 do
		local pre = {}
		pre.ref_bdd = self:get_layer_bdd(i)
		pre.ref_cov = param.get_ref( pre.ref_bdd, "out_coverage" )
		pre.ref_cov_max = param.get_ref( pre.ref_bdd, "coverage_max" )
		self.presence[i] = pre
	end

	app:init_osc()
end

function meu:update_ui()
	local ui = self.ui

--	self:update_ui_exploitation_start_stop()

	if app.osc then
		ui.bu_osc_info:set_text( app.osc.count )
	end

	--aaa.show( app.osc.b_send, "osc.b_send" )
end

--todo ?
function meu:configure()
-- 	local host_id = aaa.net.get_host_id()
-- 	if inside( host_id, 211, 215 ) then
-- 	else
-- --		aaa.net.set_active(true)
-- 	end
end

function meu:get_circle_cov( i )
	local pre = self.presence[i]
	return pre.cov
end
function meu:get_circle_accum( i )
	local pre = self.presence[i]
	return pre.accum
end
function meu:set_circle_accum( i, accum )
	local pre = self.presence[i]
	pre.accum = accum
end
function meu:update()
	local ref = self.ref
	local b_onsite = not aaa.pc.is_maa()	
	self:set_ui_slot_at_start( 3 )

	local dt = aaa.time.dt

	local pres = self.presence
	for i=1,3 do
		local pre = pres[i]
		if self.s_detection~=3 then
			if self.s_detection==1 then
				param.set( pre.ref_cov_max, pre.coverage_max )
				self:update_then_draw( pre.ref_bdd )
				pre.cov = param.get( pre.ref_cov )
			end
			local cov = pre.cov
			pre.accum = clamp_01( pre.accum + ((cov>.05) and (cov*.5) or -1) * dt )
		end
		if self.b_detection_send then
		 	app:send_osc( "romanite/accum", "NoName", i-2, pre.accum )
		end
	end
	
	
	if self.volume_last ~= self.volume then
		if self:get_render_index() > 60*60 then	-- during the furst 3600 frames (one minute at 60fps) we force the sending of volume 
			self.volume_last = self.volume
		end
		app:send_osc( "romanite/volume", self.volume )
	end

	-- if b_onsite or self.b_onsite_force then
	-- 	self:update_exploitation_start_stop( true, true )
	-- end

	self:update_exploitation_window()

	--	activate the right Kinect block
	local count = self.s_init
	--self:print( "s_init "..count )
	if count then
		count = count + 1
		if count > 8 then
			self:launch_pd( true )
			self:send_osc_info( "osc_begin" )
			self:send_osc_info( "begin"		)
--			self:configure()
			count = nil
		end
		self.s_init = count
	else
		local m = self:get_meu_by_name_no_error( "ImgParts_1" )
		m:set_recit_away_min_max( self.recit_away_min, self.recit_away_max, self.recit_away_min_busy, self.recit_away_max_busy )
	end

end

