
function meu:define_ui()
	local ref = self.ref
	local ui = self.ui
	local bu

	self.time = 0.0
	self.b_play = false
	self.b_started = false
	self.b_verbose = false
	self.animation_name = ""
	local ix = 1
	local iy = 1
	local SY = 1
	local SY2 = 1 * .5
	local DY = SY*.2
	local SX13 = 8 / 3

	local SX = (8)/3

	iy = self:define_time( 		{ix,iy,		1,SY}, 500, false )

	--bu = self:add_button(	{	ix, iy,				SY, SY },	"Draw FBX", 		self, "b_draw_fbx",	true )
	iy = iy + SY
	bu = self:add_trig_method(	{ix,		iy,	SX,SY},	"Audience QUIET", 	self, "audience_quiet" )
	bu = self:add_trig_method(	{ix+SX,		iy,	SX,SY},	"Audience NERVE", 	self, "audience_nerve" )
	bu = self:add_trig_method(	{ix+SX*2,	iy,	SX,SY},	"Audience NONE", 	self, "audience_none" )

	iy = iy + SY

	bu = self:add_button(		{ix,iy,			SY,SY},	"Draw Animation", 	self, "b_draw_anim",	false )
	iy = iy + SY
	bu = self:add_trig_method(	{ix,iy,			SX,SY},	"Restart Anim", 	self, "restart_anim" )
	iy = iy + SY
end

function meu:init()
	local ref = self.ref
	self.animations = {}
	self.b_audience_present = false
	self.b_audience_quiet = false
	self.b_audience_nerve = false
	self.loop_cycle = 0
	self.animation_name = ""
	self:define_anim()
end

function meu:update_ui()	self:update_time_ui()	end


function meu:set_play( b )
	self.__time.b_play = b
end


function meu:start_anim()
	self.b_draw_anim = true
	self.b_anim_active = true
	self:set_play( true )
	self:restart_anim()
end

function meu:stop_anim()
	self.b_draw_anim = false
	self:set_play( false )
	local meu_fbx = self:get_meu_by_name_no_error( self.fbx_name )
	self.b_anim_active = false
	if meu_fbx then
		meu_fbx:set_mu_value( 0 )
	end

	--self:restart_anim()
end

function meu:audience_quiet()
	self.b_audience_present = true
	self.b_audience_quiet = true
	self.b_audience_nerve = false
end

function meu:audience_nerve()
	self.b_audience_present = true
	self.b_audience_quiet = false
	self.b_audience_nerve = true
end

function meu:audience_none()
	self.b_audience_present = false
	self.b_audience_nerve = false
	self.b_audience_quiet = false
	--self.loop_cycle = 0
end

function meu:update_animation( anim )
	for key, val in PAIRS( anim ) do
		val.start_time_s = val.start_time / 60.
		val.end_time_s = val.end_time / 60.
		val.duration = val.end_time_s - val.start_time_s
	end
end

function meu:define_anim()
	local mray = {
			GR20 = { comment = "", start_time = 188, end_time = 638, b_loop = true },
			GR30 = { comment = "", start_time = 638, end_time = 764, b_loop = false },
			GR40 = { comment = "", start_time = 0, end_time = 188, b_loop = false },
		}
	self:update_animation( mray )
	self.name = "MRAY"
	self.animations[ self.name ] = mray
	self.fbx_name = "Fbx_MRAY_C_PIJ"
end

function meu:restart_anim()
	self.animation_name = ""
	self.start_anim_t = 0
	self.loop_cycle = 0
	self:audience_none()
	self:restart_time()
end

function meu:update_fbx_start_time( meu_fbx, t )
	local start_time = self.animations[ self.name ][ self.animation_name ].start_time_s
	meu_fbx:set_time( start_time )
	if app:is_seq_looping() then
		self:restart_time()
		t = 0
	end
	self.start_anim_t = t
	--self:print( "Start Animation : "..self.animation_name.." at "..start_time )
end

function meu:fbx_update_time( meu_fbx, t, next )
	local duration = self.animations[ self.name ][ self.animation_name ].duration
	if t - self.start_anim_t >= duration then
		self.animation_name = next
		self:update_fbx_start_time( meu_fbx, t )
	else
		local meu_time = self.animations[ self.name ][ self.animation_name ].start_time_s + t - self.start_anim_t
		meu_fbx:set_time( meu_time )
	end
end

function meu:update_anim()
	local t = self:update_time()
	local meu_fbx = self:get_meu_by_name_no_error( self.fbx_name )
	if t and meu_fbx then
		meu_fbx:set_play(false)
		if self.animation_name == "" then
			-- must start animation
			self.animation_name = "GR40"
			local start_time = self.animations[ self.name ][ self.animation_name ].start_time_s
			self:set_time_speed( 1.0 )
			self:restart_time()
			self.start_anim_t = 0
			meu_fbx:set_time( start_time )
		--	self:print( "Start Animation : "..self.animation_name.." at "..start_time )
		elseif self.animation_name == "GR40" then
			self:set_time_speed( 1.0 )
			local duration = self.animations[ self.name ][ self.animation_name ].duration
			if t - self.start_anim_t >= duration then
			--	self:print( "dgdgf")
				if self.b_audience_present then
					self.animation_name = "GR30"
					self:print( "audience present")
					self:update_fbx_start_time( meu_fbx, t )
				else
					self:fbx_update_time( meu_fbx, t, "GR20" )
				end
			else
				local meu_time = self.animations[ self.name ][ self.animation_name ].start_time_s + t - self.start_anim_t
			--	self:print( "For anim index 2, setting meu time : "..meu_time )
				meu_fbx:set_time( meu_time )
			end
			--self:fbx_update_time( meu_fbx, t, "GR20" )
		elseif self.animation_name == "GR20" then
			self:set_time_speed( 2.0 )
			local duration = self.animations[ self.name ][ self.animation_name ].duration
			if t - self.start_anim_t >= duration then
				--self:print( "dgdgf")
				if self.b_audience_present then
					self.animation_name = "GR30"
					self:print( "audience present")
					self:update_fbx_start_time( meu_fbx, t )
				else
					self:update_fbx_start_time( meu_fbx, t )
				end
			else
				local meu_time = self.animations[ self.name ][ self.animation_name ].start_time_s + t - self.start_anim_t
			--	self:print( "For anim index 2, setting meu time : "..meu_time )
				meu_fbx:set_time( meu_time )
			end
		elseif self.animation_name == "GR30" then
			self:set_time_speed( 1.0 )
			self:fbx_update_time( meu_fbx, t, "GR40" )
		end
	end
end

function meu:update_interactivity()
	if app.const then
		local interactivity = app:get_presence_SO( "KL1" )
		local delta_x = 0.5
		local screen = 1
		local x_min = app.const.mona.k_lar * ( screen - 1 ) + app.const.mona.kc_interval * ( screen - 1 ) + delta_x
		local x_max = app.const.mona.k_lar * screen + app.const.mona.kc_interval * ( screen - 1 ) - delta_x
		--if inside( interactivity.x, x_min, x_max ) then
			if interactivity.coverage > 0.002 then
			--	self:print( "audience present")
				self.b_audience_present = true
			else
			--	self:print("a "..interactivity.coverage )
				self.b_audience_present = false
			end
		--else
			--self.b_audience_present = false
		--end
	end
end

function meu:update()
	if self.b_draw_anim then
		local meu_fbx = self:get_meu_by_name_no_error( self.fbx_name )
		if meu_fbx then
			local b_is = app:is_kl(1) or app:is_pc_dev()
			if not b_is then
			-- dev pc
			elseif b_is == true then
			--	meu_whale
				meu_fbx:set_mu_value( 1 )
				if app:is_location( "KL1") or app:is_pc_dev() then
					self:update_interactivity()
				end
				self:update_anim()
			else
				meu_fbx:set_mu_value( 0 )
			end
		end
	end
end

function meu:draw()
end
