if not aaa.mess.update then

	function aaa.mess.__init()
		if not aaa.mess.ref then
			local mess = aaa.mess
			mess.ref = {}
			local ref = mess.ref
			ref.layer = aaa.obj.get_by_class_and_name_symbo( "layer", "mess_layer1" )
			ref.active = param.get_ref( ref.layer, "active" )
			param.set_and_save( ref.active, false, false )
			ref.bdd_text = aaa.obj.get_down( ref.layer, "mess_text1" )
			ref.text = param.get_ref( ref.bdd_text, "text" )
			param.set_save( ref.text, false )
			ref.color = aaa.layer.create_color( ref.layer, "aaa.mess" )
			ref.model = aaa.layer.get_model( ref.layer )
			ref.size = param.get_ref( ref.model, "size_factor" )
			param.set_save( ref.size, false )
			mess.size = 1.
		end
	end

	function aaa.mess.show_low( str, size, duration )
		local mess = aaa.mess
		mess.size = size or 1.
		mess.str = str
		mess.time_left = duration or 2.
		aaa.print( "aaa.mess.show : "..str )
	end 

	function aaa.mess.update()
		local mess = aaa.mess
		local t = mess.time_left
		if t then
			if t > 0. then
				aaa.mess.__init()
				param.set( mess.ref.text, mess.str )
				local t = t - math.min( aaa.time.dt_real, .04 )
				t = math.max( t, 0 )	--avoid error when using power
				mess.time_left = t
				t = t * .2
				t = math.min( t, 1 )
				t = math.pow( t, .5 )
				--aaa.print( "----------------------------------------------- t is "..t )
				mess.ref.color:set_alpha( t )
				param.set( mess.ref.size,  t * mess.size )
				param.set( mess.ref.active, true )
			else
				param.set( mess.ref.active, false )
			end
		end
	end

end

aaa.mess.update()