if CLASS.DECLARE( "FACE_INFO" ) then
end
	FACE_INFO.triangles_def =
	{
		b85 =
		{
			--sous la bouche
			{	10,	9,	58	},
			{	10,	58,	57	},
			{	11,	10,	57	},
			{	11,	57,	56	},
			{	12,	11,	56	},
			{	12,	56, 55	},
			{	13,	12,	55	},
			{	14,	13,	55	},
			{	15,	14,	55	},
			--nez
			{	36,	34,	28	},
			--nez oeil
			{	36,	28,	43	},
			{	36,	43,	48	},
			--Joue
			{	17,	16, 46	},
			{	16,	47, 46	},
			{	16,	15, 47	},
			{	55,	54, 47	},
			{	15,	55, 47	},
			{	47, 54, 48	},
			{	48, 54, 36	},
			--bouche nez
			{	54, 53, 36	},
			{	36, 53, 34	},
			{	53, 52, 34	},
			--sous paupiere ext vers nez
			{	17,	46, 27	},
			{	27,	46, 26	},
			{	46,	45, 26	},
			{	26,	45, 25	},
			{	45,	44, 25	},
			{	25, 44, 24	},
			{	44, 43, 24	},
			{	24, 43, 23	},
			{	23, 43, 28	},
			--oeil
			{	46, 47, 45	},
			{	45, 47, 44	},
			{	44, 47, 48	},
			{	44, 48, 43	},
			--haut nez vers ext
			{	23, 28, 72	},
			{	24, 23, 72	},
			{	24, 72, 73	},
			{	73, 70, 85	},
			{	24, 73, 85	},

			{	25, 24, 85	},
			{	25, 85, 84	},
			{	26, 25, 84	},
			{	26, 84, 83	},
			{	27, 26, 83	},
			{	27, 83, 82	},
			{	27, 82, 81	},
			{	27, 81, 80	},
			{	27, 80, 17	},
			--levres haute
			{	55, 65, 54	},
			{	65, 53, 54	},
			{	65, 64, 53	},
			{	64, 52, 53	},
			{	64, 63, 52	},
			--levres basse
			{	55, 56, 65	},
			{	56, 66, 65	},
			{	56, 57, 66	},
			{	57, 58, 66	},
			{	58, 67, 66	},

		--[[
			{	17, 27, 71	},
			{	27, 26, 71	},
			{	26, 25, 71	},
			{	71, 25, 70	},

			{	25, 24, 70	},
			{	24, 23, 70	},
			{	23, 28, 70	},
		--]]
		},
		b85_more =
		{
			--sous la bouche
			{	10,	9,	58	},
			{	10,	58,	57	},
			{	11,	10,	57	},
			{	11,	57,	56	},
			{	12,	11,	56	},
			{	12,	56, 55	},
			{	13,	12,	55	},
			{	14,	13,	55	},
			--{	15,	14,	55	},
			--nez
			--{	36,	34,	28	},
			{	36,	31,	28	},
			--nez oeil
			{	36,	28,	43	},
			{	36,	43,	48	},
			{	36,	35,	31	},
			{	35,	34,	31	},
			--Joue
			{	17,	16, 46	},
			--{	16,	47, 46	},
			--{	16,	15, 47	},
			--{	55,	54, 47	},
			--{	15,	55, 47	},
			--{	47, 54, 48	},
			--{	48, 54, 36	},
			{	87, 47, 46	},
			{	87, 48, 47	},
			{	87, 36,	48	},
			{	87, 54,	36	},
			{	87, 55,	54	},
			{	87, 14,	55	},
			{	87, 15,	14	},
			{	87, 16,	15	},
			{	87, 46,	16	},
			--bouche nez
			{	54, 53, 36	},
			--{	36, 53, 34	},
			--{	53, 52, 34	},
			{	35, 36, 53	},
			{	34, 35, 53	},
			{	53, 52, 34	},
			--sous paupiere ext vers nez
			{	17,	46, 27	},
			{	27,	46, 26	},
			{	46,	45, 26	},
			{	26,	45, 25	},
			{	45,	44, 25	},
			{	25, 44, 24	},
			{	44, 43, 24	},
			{	24, 43, 23	},
			{	23, 43, 28	},
			--oeil
			{	46, 47, 45	},
			{	45, 47, 44	},
			{	44, 47, 48	},
			{	44, 48, 43	},
			--haut nez vers ext
			{	23, 28, 72	},
			{	24, 23, 72	},
			{	24, 72, 73	},
			{	73, 70, 85	},
			{	24, 73, 85	},

			{	25, 24, 85	},
			{	25, 85, 84	},
			{	26, 25, 84	},
			{	26, 84, 83	},
			{	27, 26, 83	},
			{	27, 83, 82	},
			{	27, 82, 81	},
			{	27, 81, 80	},
			{	27, 80, 17	},
			--levres haute
			{	55, 65, 54	},
			{	65, 53, 54	},
			{	65, 64, 53	},
			{	64, 52, 53	},
			{	64, 63, 52	},
			--levres basse
			{	55, 56, 65	},
			{	56, 66, 65	},
			{	56, 57, 66	},
			{	57, 58, 66	},
			{	58, 67, 66	},

		--[[
			{	17, 27, 71	},
			{	27, 26, 71	},
			{	26, 25, 71	},
			{	71, 25, 70	},

			{	25, 24, 70	},
			{	24, 23, 70	},
			{	23, 28, 70	},
		--]]
		},
		eye_brow =
		{
			{	10,	9,	34	},
			{	10,	34,	36	},
			{	11,	10,	36	},
			{	12,	11,	36	},
			{	13,	12,	36	},
			{	14,	13,	36	},
			{	36,	34,	28	},
			{	36,	28,	43	},
			{	36,	43,	48	},
			{	36,	48, 47	},
			{	36,	47, 15	},
			{	15,	14, 36	},
			{	16,	15, 47	},
			{	16,	47, 46	},
			{	17,	16, 46	},

			{	17,	46, 27	},
			{	27,	46, 26	},
			{	46,	45, 26	},
			{	26,	45, 25	},
			{	45,	44, 25	},

			{	25, 44, 24	},
			{	44, 43, 24	},
			{	24, 43, 23	},
			{	23, 43, 28	},
			{	46, 47, 45	},
			{	45, 47, 44	},
			{	44, 47, 48	},
			{	44, 48, 43	},

			{	17, 27, 71	},
			{	27, 26, 71	},
			{	26, 25, 71	},
			{	71, 25, 70	},
			{	25, 24, 70	},
			{	24, 23, 70	},
			{	23, 28, 70	},
		},
		simple =
		{
			{	10,	9,	34	},
			{	10,	34,	36	},
			{	11,	10,	36	},
			{	12,	11,	36	},
			{	13,	12,	36	},
			{	14,	13,	36	},
		--	{	36,	34,	28	},
			{	36,	34,	31	},
			{	36,	31,	28	},
			{	36,	28,	43	},
			{	36,	43,	48	},
			{	36,	48, 47	},
			{	36,	47, 15	},
			{	15,	14, 36	},
			{	16,	15, 47	},
			{	16,	47, 46	},
			{	17,	16, 46	},

			{	46, 47, 45	},
			{	45, 47, 44	},
			{	44, 47, 48	},
			{	44, 48, 43	},

			{	17, 46, 71	},
			{	46, 45, 71	},
			{	45, 44, 71	},
			{	71, 44, 70	},
			{	44, 43, 70	},
			{	43, 28, 70	},
		}
	}

	--	69-71	top of rectangle

	FACE_INFO.sym_table =
	{
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1,	--	face
		27, 26, 25, 24, 23,
		22, 21, 20, 19, 18,
		28, 29, 30, 31,
		36, 35, 34, 33, 32,
		46, 45, 44, 43, 48, 47,
		40, 39, 38, 37, 42, 41,
		55, 54, 53, 52, 51, 50, 49,	--	top ext lip
		60, 59, 58, 57, 56,			--	bottom ext lib
		65, 64, 63, 62, 61,			--	top int lip
		68, 67, 66,					--	bottom in lip
		71, 70, 69,					--	top rect
		72, 73,						--	forehead middle
		--	forehead top
		80, 81, 82, 83, 84, 85,
		74, 75, 76, 77, 78, 79,
		87, 86,
	}

	FACE_INFO.uv_dior =
	{
		{ 0.95607449654412, 0.62604830034108 },		{ 0.95426450670235, 0.5353049619844 },		{ 0.94804614503037, 0.44438162924846 },		{ 0.93734832965796, 0.35091123627055 },
		{ 0.89908123243719, 0.25973081681543 },		{ 0.82166135311863, 0.17428475426737 }, 	{ 0.73775209641611, 0.10596527230754 },		{ 0.63764906470633, 0.044430316941853 },
		{ 0.500261316992, 0.037028505098599 },		{ 0.38786306099673, 0.044424475214477 },	{ 0.27988902667194, 0.083472534963978 },	{ 0.18668612574834, 0.13512748457903 },
		{ 0.11712913592634, 0.19843992196702 },		{ 0.078441652125503, 0.27729893948634 },	{ 0.05931710114613, 0.36258652727789 },		{ 0.048556343342642, 0.44671573189935 },
		{ 0.046156740623564, 0.52835717543701 },	{ 0.90254737363297, 0.69563101284817 },		{ 0.84540124711643, 0.7331767147808 },		{ 0.760000626626, 0.74755918328762 },
		{ 0.67431363782576, 0.7383017248704 },		{ 0.59601377992863, 0.71123561221432 },		{ 0.42380886557146, 0.67473728404369 },		{ 0.34455305360421, 0.69996837936109 },
		{ 0.26192439873892, 0.70549064868942 },		{ 0.18501323845824, 0.69615162888088 },		{ 0.1239445284846, 0.66288686414065 },		{ 0.50050417760641, 0.58661468232693 },
		{ 0.50569944882472, 0.57546268354187 },		{ 0.50544035223233, 0.51422108335654 },		{ 0.50133512255124, 0.41957606118829 },		{ 0.63158001238064, 0.42295929116463 },
		{ 0.58010692070976, 0.40311366025628 },		{ 0.50117618919586, 0.34732144310386 },		{ 0.46222221825794, 0.35749705096508 },		{ 0.42243682494388, 0.36454309004939 },
		{ 0.80231843519886, 0.63177824599029 },		{ 0.75078386002019, 0.65207948593393 },		{ 0.67440140349653, 0.64801609208645 },		{ 0.62071910722521, 0.62300575803168 },
		{ 0.69213848450166, 0.61514868128035 },		{ 0.75529449944748, 0.61587248080314 },		{ 0.37829563033759, 0.56287965114403 },		{ 0.32381233815045, 0.59394834468235 },
		{ 0.2618991313905, 0.59220749006726 },		{ 0.21058989971822, 0.56872349637775 },		{ 0.25915273510619, 0.55238661638376 },		{ 0.31987641084298, 0.5528411087034 },
		{ 0.74272708032251, 0.33101522476356 },		{ 0.66946680079662, 0.35052756920882 },		{ 0.57883695807336, 0.35166452396721 },		{ 0.50144590929946, 0.28398220616905 },
		{ 0.45893326394029, 0.29018315096556 },		{ 0.39061073445813, 0.27218811580946 },		{ 0.32495818786073, 0.24394012415095 },		{ 0.38667948729277, 0.20522337492256 },
		{ 0.45341931919687, 0.18852373487305 },		{ 0.50074699092594, 0.18568743480017 },		{ 0.60279668739188, 0.22466823776068 },		{ 0.68160312531028, 0.25977353348413 },
		{ 0.7005878444562, 0.32186291579972 },		{ 0.57303597367498, 0.32221552713193 },		{ 0.50147371043777, 0.24904079322392 },		{ 0.4560936644722, 0.2505527628605 },
		{ 0.35453069219639, 0.24340140032906 }, 	{ 0.45558157019077, 0.2420978407076 },		{ 0.50175105745003, 0.24024071534547 },		{ 0.58380714371838, 0.26745327495214 },
		{ 1, 1 },									{ 0.50050797744148, 0.97067921818759 },		{ 0, 1 },									{ 0.50048945099742, 0.71361008337636 },
		{ 0.50050699486866, 0.84086365825045 },		{ 0.95876491773184, 0.71183586482509 },		{ 0.93967692190959, 0.78803740059914 },		{ 0.90166743029159, 0.85213754149086 },
		{ 0.82109626865465, 0.90153285613078 },		{ 0.71991003021043, 0.9371552395592 },		{ 0.61859821346291, 0.95636671058507 },		{ 0.047771379750508, 0.64113970438467 },
		{ 0.063062017647361, 0.72661574110463 },	{ 0.10918335405197, 0.80532513978091 },		{ 0.18274253130598, 0.87585930063758 },		{ 0.27620012028636, 0.92669038323246 },
		{ 0.38522031538831, 0.96010317696724 },		{ 0.83706277262363, 0.4536242167414 },		{ 0.18503924093746, 0.34477061902471 }
	}


	FACE_INFO.ou = 0
	FACE_INFO.ov = 0

--todo
	FACE_INFO.face_lines =
		{
			{ name = "face_low"		,	1,	17, false 					},
			{ name = "eyebrow_right",	18,	22, false,	b_bary = true	},
			{ name = "eyebrow_left"	,	23,	27, false,	b_bary = true	},
			{ name = "noise_top"	,	28,	31, false,	b_bary = true	},
			{ name = "noise_bottom"	,	32,	36, false,	b_bary = true	},
			{ name = "eye_right"	,	37,	42, true,	b_bary = true	},
			{ name = "eye_left"		,	43,	48, true,	b_bary = true	},
			{ name = "mouth_outside",	49,	60, true,	b_bary = true	},
			{ name = "mouth_inside",	61,	68, true,	b_bary = true	}
		}
	FACE_INFO.face_lines_b85 =
		{
			{ name = "face_low"		,	1,	17, false 					},
			{ name = "eyebrow_right",	18,	22, false,	b_bary = true	},
			{ name = "eyebrow_left"	,	23,	27, false,	b_bary = true	},
			{ name = "noise_top"	,	28,	31, false,	b_bary = true	},
			{ name = "noise_bottom"	,	32,	36, false,	b_bary = true	},
			{ name = "eye_right"	,	37,	42, true,	b_bary = true	},
			{ name = "eye_left"		,	43,	48, true,	b_bary = true	},
			{ name = "mouth_outside",	49,	60, true,	b_bary = true	},
			{ name = "mouth_inside",	61,	68, true,	b_bary = true	},
			{ name = "face_top",		{1,74,75,76,77,78,79,70,85,84,83,82,81,80,17}, 1, false	},
			--{ name = "face_top_left",	74,	79, false	},
			--{ name = "face_top_right",	80,	85, false	},
			--{ name = "rac_1",			1,	85, false	},
		}
	FACE_INFO.face_lines_dior =
		{
			{ name = "eye_right"	,		37,	42, true,	b_bary = true	},
			{ name = "eyebrow_right",		18,	22, false,	b_bary = true	},
			{ name = "eye_left"		,		43,	48, true,	b_bary = true	},
			{ name = "eyebrow_left"	,		23,	27, false,	b_bary = true	},
			{ name = "noise_top"	,		28,	31, false,	b_bary = true	},
			{ name = "noise_bottom"	,		32,	36, false,	b_bary = true	},
			{ name = "mouth_outside_top",	50,	54, false,	b_bary = true	},
			{ name = "mouth_outside_bot",	56,	60, false,	b_bary = true	},
			{ name = "mouth_inside"	,		61,	68, true,	b_bary = true	},
			{ name = "face_low"		,		1,	17, false 					},
			{ name = "face_top",	{74,75,76,77,78,79,70,85,84,83,82,81,80}, 1, false	},
			--{ name = "face_top_left",	74,	79, false	},
			--{ name = "face_top_right",	80,	85, false	},
			--{ name = "rac_1",			1,	85, false	},
		}
	FACE_INFO.__points_for_color =
		{
			{	31, 86, 	.7, 0,	8	},
			{	3, 86, 		.3, 0,	6	},
			--lunnetes : bad
			--{	28, 86, 	.7, .1,	10	},
			{	5, 86, 		.3, .1,	5	},
--				{	49, 86, 	.3, .1,	5	},
--				{	32, 86, 	.5, .1,	4	},
			{	32, 50, 	.3, .3,	3	},
			{	49, 6, 		.5, .3,	3	},
			{	60, 7, 		.2, .3,	5	},
			{	49, 7, 		.3, .3,	5	},
			{	6, 60, 		.3, .3,	5	},
			{	49, 5, 		.4, .3,	5	},
			{	6, 86, 		.4, .05, 5	}
		}

local color_density = 2
function FACE_INFO:draw_points_for_color_side( pts, data, sym )
	local S = .02
	for i = 1, #data do
		local l = data[i]
		local a, b = l[1], l[2]
		if sym then
			 a, b = sym[a], sym[b]
		end
		a, b = pts[a], pts[b]
		local c ={}
		local en = 1. - l[4]
		local s = (en-l[3]) / (l[5]*color_density-1.) - .0001
		aaa.draw_line( a[1], a[2], b[1], b[2] )
		for inter = l[3],en,s do
			V2.interpolate( c, a, b, inter )
			aaa.draw_mul_line(	c[1], c[2], S, S )
		end
	end
end

function FACE_INFO:draw_points_for_color()
	local data = FACE_INFO.__points_for_color
	local pts = self:get_pts()
	self:draw_points_for_color_side( pts, data )
	self:draw_points_for_color_side( pts, data, FACE_INFO.sym_table )
end

function FACE_INFO:get_points_for_color_side( bind, pts, data, sym )
	aaa.img.set_lua_cur( bind )
	--aaa.print( "toto" )
	local S = .02
	local t = 0
	local rt, gt, bt = 0,0,0,0 -- t for total
	for i = 1, #data do
		local l = data[i]
		local a, b = l[1], l[2]
		if sym then
			 a, b = sym[a], sym[b]
		end
		a, b = pts[a], pts[b]
		if a and b then
			local c = {}
			local en = 1. - l[4]
			local s = (en-l[3]) / (l[5]*color_density-1.) - .0001
			for inter = l[3],en,s do
				--self:print( "zobi "..inter )
	 			V2.interpolate( c, a, b, inter )
	 			local u, v = c[1], c[2];
	 			if aaa.b_ios then
	 				u, v = u/2. + .5, -(v*.75)/2. + .5;	--.75 is comming from ratio
				else
					u, v = u/4.5 + .5, -v/9 + .5
				end
				local r,g,b,a = aaa.img.get_color_uv(	nil, u, v,	true )
				if r then
					t = t+1
					rt, gt, bt = rt+r, gt+g, bt+b
					--self:print( t.." -> "..u.." "..v )
					--self:print( t.." -> "..rt.." "..gt.." "..bt )
				else
					self:print( "no image to read from" )
				end
			end
		end
	end
	return rt/t, gt/t, bt/t
end

function FACE_INFO:get_points_color( bind )
	local data = FACE_INFO.__points_for_color
	local uvs = self:get_pts()

	--return self:get_points_for_color_side( bind, uvs, data )
	if uvs then
		local rt, gt, bt	= self:get_points_for_color_side( bind, uvs, data )
		local r, g, b 		= self:get_points_for_color_side( bind, uvs, data, FACE_INFO.sym_table )
		return (r+rt)*.5, (g+gt)*.5, (b+bt)*.5
		--return rt, gt, bt
	end
end

function FACE_INFO:update_triangulation()
	--self:print( "b_85 is "..self.b_85 )
	if self.b_dior then
		self.tri		= FACE_INFO.triangles_def.b85_more
		self.face_lines = FACE_INFO.face_lines_dior
	elseif self.b_85 then
		self.tri		= FACE_INFO.triangles_def.b85_more
		self.face_lines = FACE_INFO.face_lines_b85
	else
		self.face_lines = FACE_INFO.face_lines
		if self.b_eye_brow then
			self.tri	= FACE_INFO.triangles_def.eye_brow
		else
			self.tri	= FACE_INFO.triangles_def.simple
		end
	end
end

function FACE_INFO:set_triangulation( b_85, b_eye_brow )
	self.b_85 = b_85
	self.b_eye_brow = b_eye_brow
end

local function draw_edge( a, b )
	--aaa.draw_line( a[1], a[2], (b[1]+a[1])*.5, (b[2]+a[2])*.5 )
	aaa.draw_line( a[1], a[2], b[1], b[2] )
end
local function draw_triangle_abc( pts, b_side, ia, ib, ic )
	local sym = FACE_INFO.sym_table
	local a, b, c
	if b_side then
		 a, b, c = pts[sym[ia]], pts[sym[ib]], pts[sym[ic]]
	else
		 a, b, c = pts[ib], pts[ia], pts[ic]
	end
	if a and b and c then
		draw_edge( a, b )
		draw_edge( b, c )
		draw_edge( c, a )
	end
end

function FACE_INFO:draw_tri_half( pts, b_side, uvs, b_sym_uv, b_sym_u )
	if not pts then return end
--	if b_sym then return end
--	self:print( "FACE_INFO:draw_tri_half() b_side b_sym_uv b_sym_u -> "..b_side.." "..uvs.." "..b_sym_uv.." "..b_sym_u )
--	b_sym_uv = not( b_sym_uv == b_sym )
--	self:print( "                                -> "..b_sym.." "..b_sym_uv )

	local su,sv,ou,ov
	-- hack
--	self:print( "       "..self.b_duplicate_half )
--	if self.b_duplicate_half then
	if false then
		--b_sym_uv = false
		su = 1./4.5
		sv = -.5/4.5
		ou = 0.5
		ov = -.3
	else
		su = 1
		sv = 1
		ou = 0
		ov = 0
	end

	--b_sym_u = true
	local function draw_triangle_abc_uvs( pts, b_side, ia, ib, ic )
		--self:print( ia.." "..ib.." "..ic )
		local sym = FACE_INFO.sym_table
		local a,  b,  c
		local auv,buv,cuv
		if b_side then
			a, b, c = pts[sym[ia]], pts[sym[ib]], pts[sym[ic]]
			if b_sym_uv then
				auv,buv,cuv = uvs[ia], uvs[ib], uvs[ic]
			else
				auv,buv,cuv = uvs[sym[ia]], uvs[sym[ib]], uvs[sym[ic]]
			end
		else
			a, b, c = pts[ib], pts[ia], pts[ic]
			if b_sym_uv then
				auv,buv,cuv = uvs[sym[ib]], uvs[sym[ia]], uvs[sym[ic]]
			else
				auv,buv,cuv = uvs[ib], uvs[ia], uvs[ic]
			end
		end

		local function draw_pt( xy, uv )
			if xy then
				local u, v
				u = b_sym_u and (1-uv[1]) or uv[1]
				v = uv[2]
				u,v = u*su+ou, v*sv+ov
				gol.draw_uv_xy( u+self.ou, v+self.ov, xy[1], xy[2] )
			end
		end

		draw_pt( a, auv )
		draw_pt( b, buv )
		draw_pt( c, cuv )
	end

	local tri = self.tri
	if uvs then gol.begin_triangles() end

	local fn_draw = uvs and draw_triangle_abc_uvs or draw_triangle_abc
	for i = 1, #tri do
		--if i % 2 == 1 then
			local t = tri[i]
			fn_draw( pts, b_side, t[1], t[2], t[3] )
		--end
	end

	if uvs then gol.do_end() end
end

function FACE_INFO:draw_tri_tex_one( id, pts, uvs, b_sym_uv, b_sym_u )
	local uvs = uvs or self:get_pts_full()
	if uvs then
		if self.side_valid[id] then
			self:draw_tri_half( pts, id==2, uvs, b_sym_uv, b_sym_u )
		end
	end
end
function FACE_INFO:draw_tri_tex_spe( pts, s_duplicate )
	local uvs = self:get_pts_full()
	--self:print( "uvs "..uvs.." "..s_duplicate )
	local b = s_duplicate==1
	self:draw_tri_half( pts, false, uvs, b==true, false )
	self:draw_tri_half( pts, true,  uvs, b==false, false  )
end
function FACE_INFO:draw_tri_tex( pts, uvs, b_sym_uv, b_sym_u )
	self:draw_tri_tex_one( 1, pts, uvs, b_sym_uv, b_sym_u )
	self:draw_tri_tex_one( 2, pts, uvs, not b_sym_uv, not b_sym_u )
end
function FACE_INFO:draw_tri_edge( pts )
	self:draw_tri_half( pts, false )
	self:draw_tri_half( pts, true )
end

function FACE_INFO:draw_edge_one( id_tri, id_edge, b_sym )
	local t = self.tri[id_tri]
	if b_sym then
		local st = FACE_INFO.sym_table
		t = { st[t[3]], st[t[2]], st[t[1]] }
	end
	local a,b
	if id_edge == 3 then
		a,b = t[3], t[1]
	else
		a,b = t[id_edge], t[id_edge+1]
	end
	local pts = self:get_pts()
	--if a>68 or b>	68 then return end
	a,b = pts[a], pts[b]
	aaa.draw_line( a[1], a[2], b[1], b[2] )
end
function FACE_INFO:draw_edges_random( nb )
	local nb_tri = #self.tri
	for i=1,nb do
		self:draw_edge_one( math.random(nb_tri), math.random(3), math.random(2)==2 )
	end
end


function FACE_INFO:create( name )
	local self = FACE_INFO:create_instance( name )
	self.data		= { 	pl = POINT_LIST:create() 	}
	self.data_full	= { 	pl = POINT_LIST:create() 	}
	self.ref		= {}
	self.side_valid = {}
	self.pl_draw	= POINT_LIST:create( "draw" )
	self.pre		= 0
	self.face_nb	= 0
	self.tra		= { 0, 0, 0 }
	self.rot		= { 0, 0, 0 }

	--	set default for Dior ( no ui in first versions of vm )
	self.b_85				= true
	self.b_dior				= true
	self.b_eye_brow			= false
	self.b_old				= false
	self.b_nose_scale		= false
	self.b_validate_half	= false

	self.__dataset_id 		=	1

	self:update_triangulation()

	return self
end

function FACE_INFO:set_target( bdd, dataset_id )
	if aaa.b_ios then return end

	local ref = self.ref

	self.__bdd			= bdd
	self.__dataset_id	= dataset_id
	ref.face_nb 		= param.get_ref( bdd, "face_detected_nb" )
	ref.model_nb 		= param.get_ref( bdd, "model_active_nb" )

	local t = {}
	local pre = "face_"..dataset_id.."_"
	t.certainty = param.get_ref( bdd, pre.."certainty" )
	t.tra 		= param.get_ref_xyz_packed( bdd, pre.."tra" )
	t.rot 		= param.get_ref_xyz_packed( bdd, pre.."rot" )
	ref.face = t
end

function FACE_INFO:is_use()			return self.__b_use end
function FACE_INFO:get_face_nb()	return self.face_nb	end

function FACE_INFO:update( tex_rect, ratio_x )
--	self:print( "rx "..ratio_x )
--	self.__ratio_x = ratio_x
--	if true then return end
	self:update_triangulation()

	local ref = self.ref
	if aaa.b_ios then
		self.face_nb	= 1
		self.model_nb	= 1
	else
		self.face_nb	= param.get( ref.face_nb )
		self.model_nb	= param.get( ref.model_nb )
	end
	--		local face_nb = aaa.bdd.get_point_dataset_nb()
	local data = self.data
	local pts
	local dataset_id = self.__dataset_id
	local b_use = true
	if dataset_id <= self.model_nb then
		--aaa.bdd.set_point_dataset( dataset_id )
		local pl = data.pl
		--pl:set_interpolate_factor( .5 )
		pts = pl:read_bdd( self.__bdd, 1 )
		local nb = pl:get_size()
		if nb == 0 then
			aaa.show( "no Pt ìn face info" )
			b_use = false
		elseif nb ~= 68 then
			self:box_error( "we have "..nb.." instead if 68 points" )
			b_use = false
		end
	else
		b_use = false
		--aaa.print( "we have "..self.face_nb.." faces detected : can't read dataset_id "..dataset_id )
	end

	self.__b_use = b_use
	if not b_use then
		return
	end

	if aaa.b_ios then
		self.certainty	= 1
	else
		local ref_face = ref.face
		self.certainty	= param.get( ref_face.certainty )
		self.tra		= param.get_v3_packed( ref_face.tra )
		self.rot		= param.get_v3_packed( ref_face.rot )
	end

	--	we needed an orthogonal world for rotation and distance
	local t	= {}
	--todo opt by transforming only the pts needeed
	V2.mul_x_table( t, pts, ratio_x )

	--	a : vertical line of the face
	local a = V2.get_sub( t[28], t[9] )
	local norn_a
	local fa
	local dx = 0.

	if self.b_old then
		--	28 haut du nez
		--	9 bas centre du menton
		a = V2.get_sub( t[28], t[9] )
		norn_a = V2.norm( a )
		V2.scale( a, 1/norn_a )

		--	we scale to get top of face
		if self.b_nose_scale then
			--local size = V2.dist( t[31], t[28] )
			local nose = V2.get_sub( t[31], t[28] )
			local size = -V2.dot( a, nose )
			--local size = V2.dist( t[31], t[28] )
			fa = norn_a + size*(2.-1*math.tan( self.rot[1]*math.pi*2. ) )
		else
			local tan_inf = .4
			--todo dy will depend on the vert angle
			local dy = 1.6 + tan_inf*math.tan( self.rot[1]*math.pi*2. ) + dx * 3
			--local dy = 1.6 + tan_inf*math.tan( self.rot[1]*math.pi*2. ) + dx * 3

			fa = norn_a * dy
		end
	else
		local m
		if self.b_nose_scale then
			m = V2.get_middle( t[1], t[17] )
		else
			--	22 23 bord des sourcils
			m = V2.get_middle( t[22], t[23] )
		end
		--	9 bas centre du menton
		a = V2.get_sub( m, t[9] )
		norn_a = V2.norm( a )
		V2.scale( a, 1/norn_a )

		local tan_inf
		local dy
		if self.b_nose_scale then
			tan_inf = .2
			dy = 1.4 + tan_inf*math.tan( self.rot[1]*math.pi*2. ) + dx * 3
		else
			tan_inf = .2
			dy = 1.4 * ( 1. + tan_inf*math.tan( self.rot[1]*math.pi*2. ) )
		end
		fa = norn_a * dy
	end

	--	and b orthogonal
	local b = V2.get_rotate_90( a )
	V2.scale( a, fa )

	-- dist from side to central line
	local dist_l 	= V2.dist_to_line_ab( t[17], t[28], t[9] ) + dx
	local dist_r	= V2.dist_to_line_ab( t[1],	 t[28], t[9] ) + dx
	local dist		= (dist_l + dist_r) * .3

	--aaa.show( dist_l/dist.." "..dist_r/dist, "LR" )
	--self:print( dist, dist_l, dist_r, FACE_INFO.b_validate_half )
	self.side_valid[1] = not FACE_INFO.b_validate_half or (dist_l > dist)
	self.side_valid[2] = not FACE_INFO.b_validate_half or (dist_r > dist)
	--self:print( "1 :"..self.side_valid[1]..", 2 :"..self.side_valid[2] )
	--self:print( dist_r.." "..dist.." "..(dist_r > dist) )

	--	uv rect of face
	local r = { {}, {}, {}, {} }

	--	now we build bottom 2 points
	V2.scale_add( r[1], b,  dist_l, t[9] )
	V2.scale_add( r[3], b, -dist_r, t[9] )

	--	then top points
	V2.add( r[2], r[1], a )
	V2.add( r[4], r[3], a )

	--	scale to go back from the ortho world to texture
	V2.mul_x_table( r, r, 1/ratio_x )

	local pt_nb = 68
	local function new_point( pt_in )
		pt_nb = pt_nb + 1
		pts[pt_nb] = pt_in and V2.clone( pt_in ) or V2.new()
		return pts[pt_nb]
	end
	--	then introduce new points
	new_point( r[4] )	--	69
	local pt = new_point()	--	70
	V2.interpolate( pt, r[4], r[2], dist_r/(dist_l+dist_r) )
	new_point( r[2] )	--	71

	if self.b_85 then
		pt = new_point()	--	72
		V2.interpolate( pt, pts[28], pts[70], .33 )
		pt = new_point()	--	73
		V2.interpolate( pt, pts[28], pts[70], .66 )

		local function add_top_half( a, b, c )
			a,b,c = pts[a], pts[b], pts[c]
			local pt = new_point()	--	73
			V2.interpolate( pt, a, b, .25 )
			local v = V2.get_sub( b, pt )
			local o = V2.get_sub( c, v )
			--new_point( o )
			local u = V2.get_sub( pt, o )
			local nb = 5
			for i=1,nb do
				pt = new_point( o )
				local ang = math.pi * .5 * i / (nb+1)
				local c,s = math.cos(ang), math.sin(ang)
				V2.scale_add( pt, u, c, pt )
				V2.scale_add( pt, v, s, pt )
			end
		end
		add_top_half( 1, 69, 70 )
		add_top_half( 17, 71, 70 )
		--add point in the middle of the cheek
		pt = new_point()	--	73
		V2.interpolate( pt, pts[2], pts[49], .5 )
		pt = new_point()	--	73
		V2.interpolate( pt, pts[16], pts[55], .5 )
	end

--[[
	local function add_center3( a, b, c )
		local p = V2.get_middle( pts[a], pts[b] )
		p = V2.get_middle( p, pts[c] )
		local pt = new_point( p )
	end
	local function add_mid_front( a, b, inc, c )
		add_center3(	a,		a+1,	b	)
		add_center3(	a+1,	a+2,	b+inc )
		add_center3(	a+2,	a+3,	b+inc*2	)
		add_center3(	a+3,	c,		b+inc*3	)
	end
	add_mid_front( 75, 19, 1, 70 )
	add_mid_front( 81, 26, -1, 70 )

	local function add_mid_nb( a, b, inc, nb )
		for i=1, nb do
			add_center3(	a,		a+1,	b	)
			a = a+1
			b = b+inc
		end
	end
	add_mid_nb( 18, 37, 1, 4 )
	add_mid_nb( 23, 43, 1, 4 )

	local function add_on_line_nb( a, b, nb )
		for i=1, nb do
			local pt = new_point()
			V2.interpolate( pt, pts[a], pts[b], i/(nb+1) )
		end
	end
	add_on_line_nb( 28, 32, 2 )
	add_on_line_nb( 28, 36, 2 )
--]]

--todo extend as source
	data.tex_rect = tex_rect
	data.rect = r

	local fx = tex_rect.r - tex_rect.l
	local fy = tex_rect.t - tex_rect.b
	local ox = 1 - tex_rect.r
	local oy = tex_rect.b

	local data_full = self.data_full
	local pts_fulls = data_full.pl:get_pts()
	V2.mul_add_table( pts_fulls, pts, fx, fy, ox, oy )
	local r_full = {}
	V2.mul_add_table( r_full, r, fx, fy, ox, oy )

	data_full.tex_rect = {0,0,1,1}
	data_full.rect = r_full
end

function FACE_INFO:get_pl()				return self.pl_cur										end
function FACE_INFO:get_pts()			return self.pl_cur    and self.pl_cur:get_pts()			end
function FACE_INFO:get_uv_rect() 		return self.data      and self.data.rect				end

function FACE_INFO:get_pl_full()		return self.data_full and self.data_full.pl				end
function FACE_INFO:get_pts_full()		return self.data_full and self.data_full.pl:get_pts()	end
function FACE_INFO:get_uv_rect_full() 	return self.data_full and self.data_full.rect			end

function FACE_INFO:use_transfo( ox, oy, sx, sy )
--	local pts = self:get_pts()
--	if not pts then return end
	if ox then
		ox = ox - .5 * sx
		oy = oy - .5 * sy
		self.__transfo = { ox=ox, oy=oy, sx=sx, sy=sy }
		self.data.pl:mul_add_2d_to( self.pl_draw, sx, sy, ox, oy )
		self.pl_cur = self.pl_draw
	else
		self.pl_cur = self.data.pl
	end
end

function FACE_INFO:draw_line_quad( a, b )
	aaa.draw_line( a[1], a[2], b[1], b[2] )
end
function FACE_INFO:draw_lines_one( id, target, method, ph_begin, ph_end, ... )
	local pl = self:get_pl()
	if pl:get_size() == 0 then return end
	--self:print( "FACE_INFO:draw_lines_one( "..id )
	local t = self.face_lines[id]
	--self:print( "  t -> "..t[1].." "..t[2].." "..t[3] )
	--self:print( "  pl -> "..pl:get_size() )
	if type(t[1]) == "table" then
		pl:draw_lines_table(		target, method, ph_begin, ph_end, t[1], ... )
	else
		pl:draw_lines_begin_end(	target, method, ph_begin, ph_end, t[1], t[2], t[3], ... )
	end
end
function FACE_INFO:draw_lines( target, method, ... )
	for key,_ in pairs(self.face_lines) do self:draw_lines_one( key, target, method, 0, 1, key, ... ) end
end

function FACE_INFO:get_lines_nb( )
	return #(self.face_lines)
end
function FACE_INFO:draw_lines_progressive( target, method, ph_begin, ph_end )
	local nb = #(self.face_lines)
	ph_begin	= ph_begin * nb
	ph_end		= ph_end * nb
	for id=1,nb do
		local ph_b = clamp_01( ph_begin - id + 1 )
		local ph_e = clamp_01( ph_end - id + 1 )
		--self:print( id.." : "..ph )
		self:draw_lines_one( id, target, method, ph_b, ph_e )
	end
end

function FACE_INFO:get_lines_by_name( name )
	local t = self.face_lines
	if t then
		return array.find_elt_by_field_val( t, #t, "name", name )
	end
end
function FACE_INFO:get_lines_bary_2d( name )
	local t = self:get_lines_by_name( name )
	--self:print( t[1].." "..t[2] )
	return self:get_pl():get_bary_2d( t[1], t[2] )
end

function FACE_INFO:get_rect_min_from_lines_by_name( name_or_tab )
	local pl = self:get_pl()
	if pl:get_size() == 0 then return end

	local tab = type(name_or_tab)=="string" and { name_or_tab } or name_or_tab
	local BIG_VALUE = 1000000.
	local rect = { l=BIG_VALUE, r=-BIG_VALUE, b=BIG_VALUE, t=-BIG_VALUE }
	for i=1,#tab do
		local t = self:get_lines_by_name( tab[i] )
		if t then
			if type(t[1]) == "table" then
				t = t[1]
				for i=1,#t do
					--self:print( "a i is "..i )
					aaa.lbrt.include_point( rect, pl:get_pt_xy(t[i]) )
				end
			else
				for i=t[1],t[2] do
					--self:print( "i is "..i )
					aaa.lbrt.include_point( rect, pl:get_pt_xy(i) )
				end
			end
		end
	end
	return rect
end
function FACE_INFO:draw_lines_bary( name )
	local x,y = self:get_lines_bary_2d( name )
	aaa.draw_null( x, y, 0, .4 )
end
function FACE_INFO:draw_lines_bary_all()
	--todo this is heavy to use val.name
	for _,val in ipairs(self.face_lines) do
		if val.b_bary then
			self:draw_lines_bary( val.name )
		end
	end
end
function FACE_INFO:draw_point( id, pt, s  )
	s = s or .01
	local x = pt[1]
	local y = pt[2]
	aaa.draw_rect_line( x-s, y-s, x+s, y+s )
end
function FACE_INFO:draw_face_points( target, method, ... )
--	local pts = self:get_pts()
--	if not pts then return end
	--self.__pl:process_points_with_method( self, "draw_null" )
--	self.data.pl:mul_add_2d_to( self.pl_draw, sx, sy, ox-.5*sx, oy-.5*sy )
	if not target then
		target = self
		method = "draw_point"
	end
	local pl = self:get_pl()
	if pl then
		pl:process_points_with_method( target, method, ... )
	end
end

--[[
function FACE_INFO:draw_face_points( ox, oy, sx, sy  )
	local pts = self:get_pts()
	if not pts then return end
	--self.__pl:process_points_with_method( self, "draw_null" )
	local S = .01
	local p = {}

	V2.mul_add_table( p, pts, sx, sy, ox-.5*sx, oy-.5*sy )
	for i=1,#pts do
		local pt = p[i]
		local x = pt[1]
		local y = pt[2]
		aaa.draw_rect_line( x-S, y-S, x+S, y+S )
	end
end
--]]

function FACE_INFO:get_uv_rect_transfo()
	local uv = self:get_uv_rect()
	if not uv then return end
	local r = {}
	local t = self.__transfo
	V2.mul_add_table( r, uv, t.sx, t.sy, t.ox, t.oy )
	return r
end
function FACE_INFO:draw_face_rect_line()
	local r = self:get_uv_rect_transfo()
	if not r then return end

	gol.draw_line_loop_2d(				r[1][1], r[1][2],	r[2][1], r[2][2],	r[4][1], r[4][2],	r[3][1], r[3][2]	)

	if true then
		aaa.draw_grid_nbxy_4xy( 9, 9,	r[1][1], r[1][2],	r[2][1], r[2][2],	r[3][1], r[3][2],	r[4][1], r[4][2]	)
	end
end


function FACE_INFO:draw_face_rect_uv()
	local r = self:get_uv_rect_transfo()
	if not r then return end
	--table.print( r, 4, 3 )
	aaa.draw_quad_strip_4xy_uv(				r[2][1], r[2][2],	r[1][1], r[1][2],	r[4][1], r[4][2],	r[3][1], r[3][2]	)
end

function FACE_INFO:draw_face_map( x, y, sx, sy )
	local uv = self:get_uv_rect()
	if not uv then return end

	--	draw texture
	gol.color_white()
		if aaa.b_ios then
			gol.set_texture_dim( 42 )
			SHADING.cur:update_uniforms()
		else
			gol.set_texture_dim( 2 )
			gol.bind_texture( self.tex_bind )
		end

		local uv = self:get_uv_rect_full()
		gol.set_quad_uv(
							uv[1][1],	uv[1][2] -  self.ov,
							uv[2][1],	uv[2][2] -  self.ov,
							uv[3][1],	uv[3][2] -  self.ov,
							uv[4][1],	uv[4][2] -  self.ov
						)
		aaa.draw_rect_uv( x-sx*.5, y-sy*.5, x+sx*.5, y+sy*.5 )
	gol.set_texture_dim( 0 )
end

function FACE_INFO:draw_map( sx, sy )
	local pts = self:get_pts()

	gol.color_white()

		if aaa.b_ios then
			gol.set_texture_dim( 42 )
			SHADING.cur:update_uniforms()
		else
			gol.set_texture_dim( 2 )
			gol.bind_texture( self.tex_bind )
		end
		local dd = -.02
		local i = 36
		gol.set_quad_uv(	pts[17][1]-dd,	pts[9][2]-dd,	pts[17][1]-dd,	pts[20][2]+dd,
							pts[1][1]+dd,	pts[9][2]-dd,	pts[1][1]+dd,	pts[20][2]+dd	)

		--gol.set_quad_uv(	0, 0,	0, 1,	1, 0,	1, 1	)
		--gol.set_quad_uv(	tab[39][1], 0,	tab[39][1], 1,	1, 0,	1, 1	)
		--aaa.draw_rect_uv_size()
	gol.set_texture_dim( 0 )
end

