function meu:define_meu_infos()
	return {
		author = "Abdalight",
		date = "2025",
		tags = { "2D", "Shader", "Distortion", "Deform" },
		help = "ImgPixelPull — étire ou compresse l'image perpendiculairement à un segment défini par centre, angle et longueur."
	}
end

function meu:define_ui()
	local ui = self.ui
	local sha = self:get_shading()
	local ix, iy = 1, 1
	local SY, DY = 1, 0.2

	self:add_shading_ui({ix, iy, 8, SY})
	iy = iy + SY + DY
	local y_begin = iy
	self:set_tab_key("Main")

	-- input texture
	local bu = self:add_bu_texture_target_unit(		{ix,iy,		8,5*SY, b_compact=true}, "Tex_Input", 1, true	)
	ui.bu_tex_input = bu
	iy = iy + 5 * SY + DY

	-- controls
	self:add_slider(	{ix,iy, 		4,SY},		"Center U",		self,		"center_u",				0.5,		0.0,1.0		)
	self:add_slider(	{ix+4,iy, 		4,SY}, 		"Center V", 	self, 		"center_v", 			0.5,		0.0,1.0		)
	iy = iy + SY + DY

	self:add_slider(	{ix,iy,			4,SY},		   "Angle", 	self, 		   "angle", 			0.0, 		0.0,360.0	)
	self:add_slider(	{ix+4,iy, 		4,SY}, 	 "Half Length", 	self,    "half_length", 		   0.25,		0.0,1.0		)
	iy = iy + SY + DY

	self:add_slider(	{ix,iy,			4,SY},      "Strength", 	self, 	    "strength", 			0.5, 		-5.0,5.0	):set_color_back("r")
	self:add_slider(	{ix+4,iy, 		4,SY}, 		  "Radius", 	self, 		  "radius", 			0.2, 		0.0,1.0		)
	iy = iy + SY + DY

	-- right panel
	ix = 9; iy = y_begin
	self:add_camera()
	self:add_rendering()

	self:add_shading_sliders_tab(sha, {"Vert","Frag"}, y_begin, SY)
end

function meu:init()
	self.layer_shading = 2
	local sha = self:add_shading(self.layer_shading)

	self.center_u = 0.5
	self.center_v = 0.5
	self.angle = 0.0
	self.half_length = 0.25
	self.strength = 0.5
	self.radius = 0.2
	self.ref_bind_use = 0
end

function meu:update()
	local ui = self.ui
	local bu_tex = ui.bu_tex_input
	if bu_tex then
		local changed, bind_2d = bu_tex:get_bind_2d_dim_asked()
		if changed then self.ref_bind_use = bind_2d end
	end
end

function meu:draw_card(x, y, z, sx, sy, u_min, u_max, v_min, v_max, texture_bind)
	local sha = self:get_shading()
	sha:set_frag_float(1, self.center_u)
	sha:set_frag_float(2, self.center_v)
	sha:set_frag_float(3, self.angle)
	sha:set_frag_float(4, self.half_length)
	sha:set_frag_float(5, self.strength)
	sha:set_frag_float(6, self.radius)

	gol.bind_texture(texture_bind)
	gol.update_uniform_fragment_float()

	aaa.draw_rect_uv_at_z(x - sx * 0.5, y - sy * 0.5, x + sx * 0.5, y + sy * 0.5, z)
end

function meu:draw()
	self:draw_layers_begin()
		self:draw_layer(1)
		self:draw_layer(2)
		self:draw_card(0, 0, 0, 2, 1.5, 0, 1, 0, 1, self.ref_bind_use)
	self:draw_layers_end()
end
