-- inside brackets mean optional: [,optional_arg]
--
--	GOL ATTRIB
--
	gol.push_attrib( attrib )
	gol.push_attrib()		-- push all attrib : GL_ALL_ATTRIB_BITS
	gol.pop_attrib()

	gol.reset()					-- same as the one use before drawing a frame in C, this a Hack for the Aquarium (try to contournate a bug )
								--		+do a set_quad_uv( 0,0,1,1 )
	gol.set_default()			--	for GaBu no texture / no depth / no light / fill / no cull / blend_default
								--		+do a set_quad_uv( 0,0,1,1 )

--	color are untouched and passed as it to the graphic lib
	gol.color3		( r,g,b )			--	faster version for color
	gol.color4		( r,g,b, a )		--	faster version for color
	--todo depreciate
	gol.color_direct( r,g,b [,a] )
--	color are altered by global color modifier (in app) and can be controled thru "general" params
	gol.color		( r,g,b [,a] )
	gol.color		( grey )
	gol.color		( { r,g,b, a } )
-- faster fns, no alpha mean alpha is 1
	gol.color_white(	[a] )	
	gol.color_black(	[a] )
	gol.color_red(		[a] )
	gol.color_green(	[a] )
	gol.color_blue(		[a] )	
	gol.color_yellow(	[a] )	
	gol.color_cyan(		[a] )	
	gol.color_magenta(	[a] )
	gol.color_orange(	[a] )

	gol.color_grey(	grey [,a] )

	r,g,b, a = gol.get_color()	-- AAASeed cache the value so stalling of the pipeline

	gol.set_tex_unit_2d_bind( tex_unit [,bind] )	--tex_unit in [0,31], we don't know cur tex_unit after this
	gol.set_tex_unit_0d( tex_unit )					--tex_unit in [0,31], we don't know cur tex_unit after this
													--setting dimension have sense only to unit 0,1,2,3
													--	(this is old school pre shader) and AAASeed deal with 4
	gol.set_tex_unit_cur( tex_unit )				--tex_unit in [0,31]

	bind = gol.get_tex_unit_2d_bind( tex_unit )		--tex_unit in [0,31]

	gol.set_texture_dim( dim )	--	change the dimension 0,1,2,3 on current tex_unit
	dim = gol.get_texture_dim()	--	get the dimension 0,1,2,3 on current tex_unit

	gol.bind_texture( bind )	--	change the texture (make it the current texture)
	gol.dump_tex_unit()			--	Arg will be added, for now call GOL::dump_tex_unit() 

	gol.set_minification_nearest()
	gol.set_minification_linear()
	gol.set_minification_nearest_mipmap_nearest()
	gol.set_minification_linear_mipmap_nearest()
	gol.set_minification_nearest_mipmap_linear()
	gol.set_minification_linear_mipmap_linear()

	gol.set_magnification_nearest()
	gol.set_magnification_linear()

-- change texture repetition param for u and v
-- attention do it after setting the texture (stored by texture not sampler)
	gol.set_wrap_2d_edge			()	--	GL_CLAMP_TO_EDGE,			GL_CLAMP_TO_EDGE
	gol.set_wrap_2d_border			()	--	GL_CLAMP_TO_BORDER,			GL_CLAMP_TO_BORDER
	gol.set_wrap_2d_repeat			()	--	GL_REPEAT,					GL_REPEAT
	gol.set_wrap_2d_mirror			()	--	GL_MIRRORED_REPEAT,			GL_MIRRORED_REPEAT
	gol.set_wrap_2d_mirroredge		()	--	GL_MIRROR_CLAMP_TO_EDGE,	GL_MIRROR_CLAMP_TO_EDGE

--todo add mirroredge combinaison
--todo find way setting S T R separate so 3d will be ok too
	gol.set_wrap_2d_edge_border		()	--	GL_CLAMP_TO_EDGE,			GL_CLAMP_TO_BORDER
	gol.set_wrap_2d_edge_repeat		()	--	GL_CLAMP_TO_EDGE,			GL_REPEAT
	gol.set_wrap_2d_edge_mirror		()	--	GL_CLAMP_TO_EDGE,			GL_MIRRORED_REPEAT

	gol.set_wrap_2d_border_edge		()	--	GL_CLAMP_TO_BORDER,			GL_CLAMP_TO_EDGE
	gol.set_wrap_2d_border_repeat	()	--	GL_CLAMP_TO_BORDER,			GL_REPEAT
	gol.set_wrap_2d_border_mirror	()	--	GL_CLAMP_TO_BORDER,			GL_MIRRORED_REPEAT

	gol.set_wrap_2d_repeat_edge		()	--	GL_REPEAT,					GL_CLAMP_TO_EDGE
	gol.set_wrap_2d_repeat_border	()	--	GL_REPEAT,					GL_CLAMP_TO_BORDER
	gol.set_wrap_2d_repeat_mirror	()	--	GL_REPEAT,					GL_MIRRORED_REPEAT

	gol.set_wrap_2d_mirror_edge		()	--	GL_MIRRORED_REPEAT,			GL_CLAMP_TO_EDGE
	gol.set_wrap_2d_mirror_border	()	--	GL_MIRRORED_REPEAT,			GL_CLAMP_TO_BORDER
	gol.set_wrap_2d_mirror_repeat	()	--	GL_MIRRORED_REPEAT,			GL_REPEAT

	gol.enable_blend				()
	gol.disable_blend				()

	--all the set_blend function enable_blend implicitly
	gol.set_blend_add				()	--	 GL_FUNC_ADD,				GL_SRC_ALPHA,			GL_ONE_MINUS_SRC_ALPHA
	gol.set_blend_add_inv			()	--	 GL_FUNC_ADD,				GL_ONE_MINUS_SRC_ALPHA, GL_SRC_ALPHA
	gol.set_blend_add_alpha_one		()	--	 GL_FUNC_ADD,				GL_SRC_ALPHA,			GL_ONE
	gol.set_blend_add_alpha_one_inv	()	--	 GL_FUNC_ADD,				GL_ONE,					GL_SRC_ALPHA
	gol.set_blend_add_color			()	--	 GL_FUNC_ADD,				GL_SRC_COLOR,			GL_ONE_MINUS_SRC_COLOR
	gol.set_blend_add_color_inv		()	--	 GL_FUNC_ADD,				GL_ONE_MINUS_SRC_COLOR,	GL_SRC_COLOR
	gol.set_blend_add_color_one		()	--	 GL_FUNC_ADD,				GL_SRC_COLOR,			GL_ONE
	gol.set_blend_add_color_one_inv	()	--	 GL_FUNC_ADD,				GL_ONE,					GL_SRC_COLOR
	gol.set_blend_add_one_zero		()	--	 GL_FUNC_ADD,				GL_ONE,					GL_ZERO
	--
	gol.set_blend_min				()	--	 GL_MIN,					GL_SRC_ALPHA,			GL_ONE_MINUS_SRC_ALPHA
	gol.set_blend_min_inv			()	--	 GL_MIN,					GL_ONE_MINUS_SRC_ALPHA,	GL_SRC_ALPHA
	gol.set_blend_min_color			()	--	 GL_MIN,					GL_SRC_COLOR,			GL_ONE_MINUS_SRC_COLOR
	gol.set_blend_min_color_inv		()	--	 GL_MIN,					GL_ONE_MINUS_SRC_COLOR, GL_SRC_COLOR
	--
	gol.set_blend_max				()	--	 GL_MAX,					GL_SRC_ALPHA,			GL_ONE_MINUS_SRC_ALPHA
	gol.set_blend_max_inv			()	--	 GL_MAX,					GL_ONE_MINUS_SRC_ALPHA,	GL_SRC_ALPHA
	gol.set_blend_max_color			()	--	 GL_MAX,					GL_SRC_COLOR,			GL_ONE_MINUS_SRC_COLOR
	gol.set_blend_max_color_inv		()	--	 GL_MAX,					GL_ONE_MINUS_SRC_COLOR, GL_SRC_COLOR
	--
	gol.set_blend_sub				()	--	 GL_FUNC_SUBTRACT,			GL_SRC_ALPHA,			GL_ONE_MINUS_SRC_ALPHA
	gol.set_blend_sub_inv			()	--	 GL_FUNC_SUBTRACT,			GL_ONE_MINUS_SRC_ALPHA,	GL_SRC_ALPHA
	gol.set_blend_sub_color			()	--	 GL_FUNC_SUBTRACT,			GL_SRC_COLOR,			GL_ONE_MINUS_SRC_COLOR
	gol.set_blend_sub_color_inv		()	--	 GL_FUNC_SUBTRACT,			GL_ONE_MINUS_SRC_COLOR, GL_SRC_COLOR
	--
	gol.set_blend_rev_sub			()	--	 GL_FUNC_REVERSE_SUBTRACT,	GL_SRC_ALPHA,			GL_ONE_MINUS_SRC_ALPHA
	gol.set_blend_rev_sub_inv		()	--	 GL_FUNC_REVERSE_SUBTRACT,	GL_ONE_MINUS_SRC_ALPHA,	GL_SRC_ALPHA
	gol.set_blend_rev_sub_color		()	--	 GL_FUNC_REVERSE_SUBTRACT,	GL_SRC_COLOR,			GL_ONE_MINUS_SRC_COLOR
	gol.set_blend_rev_sub_color_inv	()	--	 GL_FUNC_REVERSE_SUBTRACT,	GL_ONE_MINUS_SRC_COLOR, GL_SRC_COLOR
	--
	gol.texcoord_set_unit_0()	--	make sure texcoor are passed to unit 0

	gol.set_mask_alpha( b_alpha )
	gol.set_mask_color( b_red, b_green, b_blue )
	gol.set_mask_color( b_red, b_green, b_blue, b_alpha )

	--experimental (2023 October)
	gol.enable_alpha_test()
	gol.disable_alpha_test()
	gol.set_alpha_test( b_test )	-- call glEnable/Disable with GL_ALPHA_TEST

	gol.set_depth( b )				-- call glEnable/Disable with GL_DEPTH_TEST
--todo
--	gol.set_depth_write( b )		-- call glEnable/Disable depth write

	gol.set_point_smooth( b )		-- call glEnable/Disable with GL_POINT_SMOOTH
	gol.set_point_size  ( size )
	size = gol.get_point_size()

	gol.set_line_smooth( b )		-- call glEnable/Disable with GL_LINE_SMOOTH
	gol.set_line_width ( size )
	size = gol.get_line_width()

	gol.disable_lighting()			-- glDisable( GL_LIGHTING )
	gol.enable_lighting ()			-- glEnable( GL_LIGHTING )

	gol.set_logic_op_none  ()		-- glDisable( GL_COLOR_LOGIC_OP );
	gol.set_logic_op_xor   ()		-- glEnable( GL_COLOR_LOGIC_OP );	glLogicOp( GL_XOR );
	gol.set_logic_op_invert()		-- glEnable( GL_COLOR_LOGIC_OP );	glLogicOp( GL_INVERT );

	gol.set_front_point()			-- glPolygonMode( GL_FRONT,	GL_POINT 	);
	gol.set_front_line ()			-- glPolygonMode( GL_FRONT,	GL_LINE		);
	gol.set_front_fill ()			-- glPolygonMode( GL_FRONT,	GL_FILL		);
	gol.set_back_point ()			-- glPolygonMode( GL_BACK,	GL_POINT	);
	gol.set_back_line  ()			-- glPolygonMode( GL_BACK,	GL_LINE		);
	gol.set_back_fill  ()			-- glPolygonMode( GL_BACK,	GL_FILL		);

	gol.set_cull_none ()
	gol.set_cull_front()
	gol.set_cull_back ()
--
--	GOL MATRIX / TRANSFO
--
-- model and view are not separate yet but will be
-- modelview is the currebnt camera by default and it should staty this may (will be model later)
	gol.set_matrix_modelview();
	gol.set_matrix_projection();
	gol.set_matrix_texture();

	gol.set_matrix_identity();

	gol.push_matrix()
	gol.pop_matrix ()

	gol.translate( x )
	gol.translate( x,y )
	gol.translate( x,y,z )
	gol.translate( { x,y,z } )
	gol.translate_x( x )
	gol.translate_y( y )
	gol.translate_z( z )

--	angle in turn (.25 mean a quarter turn, or 90 deg, or pi/2 radian)
--todo add a rotate fn with 3 angle and an order of rotation
	gol.rotate_x( angle )
	gol.rotate_y( angle )
	gol.rotate_z( angle )

	gol.scale( f )			-- scale x, y and z
	gol.scale( x,y )
	gol.scale( x,y,z )
	gol.scale( { x,y,z } )
	gol.scale_x( x )
	gol.scale_y( y )
	gol.scale_z( z )

	gol.push_scale_2d						( sx,sy						)	--	push_matrix()	scale( sx,sy )
	gol.push_scale_translate_2d				( sx,sy,		tx,ty		)	--	push_matrix()	scale( sx,sy )			translate( tx,ty )
	gol.push_translate_scale_2d				( tx,ty,		sx,sy		)	--	push_matrix()	translate( tx,ty )		scale( sx,sy )
	gol.push_translate_rotate_z_scale_2d	( tx,ty,	rz,	sx,sy		)	--	push_matrix()	translate( tx,ty )		gol.rotate_z( rz )	scale( sx,sy )

	gol.push_scale_3d						( sx,sy,sz					)	--	push_matrix()	scale( sx,sy,sz )
	gol.push_scale_translate_3d				( sx,sy,sz,		tx,ty,tz	)	--	push_matrix()	scale( sx,sy,sz )		translate( tx,ty,tz )
	gol.push_translate_scale_3d				( tx,ty,tz,    	sx,sy,sz	)	--	push_matrix()	translate( tx,ty,tz )	scale( sx,sy,sz )
	gol.push_translate_rotate_z_scale_3d	( tx,ty,tz,	rz,	sx,sy,sz	)	--	push_matrix()	translate( tx,ty,tz )	gol.rotate_z( rz )	scale( sx,sy,sz )

--
--	GOL SHADER
id = gol.get_program_used()
gol.use_program( id )		--	no arg or 0 desactivate program
							--	Useful to refine GP, avoid heavy set_default
-- these fns are here to avoid updating whole layer and/or C shading object
--   when drawing from directly from lua these fns pass the data to the current shader

gol.update_uniform_render()	-- update really all the uniforms like the layer would do it
							-- update the vertex, geometry (if needed), and fragment update plus AAASeed uniforms 
gol.update_uniform_vertex()	-- call the 3 fns below
	gol.update_uniform_vertex_float()
	gol.update_uniform_vertex_int()
	gol.update_uniform_vertex_vec4()

gol.update_uniform_geometry() -- call the 3 fns below
	gol.update_uniform_geometry_float()
	gol.update_uniform_geometry_int()
	gol.update_uniform_geometry_vec4()

gol.update_uniform_fragment() -- call the 3 fns below
	gol.update_uniform_fragment_float()		-- set src and out too
	gol.update_uniform_fragment_int()
	gol.update_uniform_fragment_vec4()

gol.update_uniform_compute() -- call the 3 fns below
	gol.update_uniform_compute_float()
	gol.update_uniform_compute_int()
	gol.update_uniform_compute_vec4()

--	update all the uniforms in the fbo
--gol.update_uniform_ubo()

--	GOL DRAW
--
	gol.begin_points()			--	GL_POINTS			Treats each vertex as a single point. Vertex n defines point n. N points are drawn.
	gol.begin_lines()			--	GL_LINES			Treats each pair of vertices as an independent line segment. Vertices 2 ? n - 1 and 2 ? n define line n. N 2 lines are drawn.
	gol.begin_line_strip()		--	GL_LINE_STRIP		Draws a connected group of line segments from the first vertex to the last. Vertices n and n + 1 define line n. N - 1 lines are drawn.
	gol.begin_line_loop()		--	GL_LINE_LOOP		Draws a connected group of line segments from the first vertex to the last, then back to the first. Vertices n and n + 1 define line n. The last line, however, is defined by vertices N and 1 . N lines are drawn.
	gol.begin_triangles()		--	GL_TRIANGLES		Treats each triplet of vertices as an independent triangle. Vertices 3 ? n - 2 , 3 ? n - 1 , and 3 ? n define triangle n. N 3 triangles are drawn.
	gol.begin_triangle_strip()	--	GL_TRIANGLE_STRIP	Draws a connected group of triangles. One triangle is defined for each vertex presented after the first two vertices. For odd n, vertices n, n + 1 , and n + 2 define triangle n. For even n, vertices n + 1 , n, and n + 2 define triangle n. N - 2 triangles are drawn.
	gol.begin_triangle_fan()	--	GL_TRIANGLE_FAN		Draws a connected group of triangles. One triangle is defined for each vertex presented after the first two vertices. Vertices 1 , n + 1 , and n + 2 define triangle n. N - 2 triangles are drawn.
	gol.begin_quads()			--	GL_QUADS			Treats each group of four vertices as an independent quadrilateral. Vertices 4 ? n - 3 , 4 ? n - 2 , 4 ? n - 1 , and 4 ? n define quadrilateral n. N 4 quadrilaterals are drawn.
	gol.begin_quad_strip()		--	GL_QUAD_STRIP		Draws a connected group of quadrilaterals. One quadrilateral is defined for each pair of vertices presented after the first pair. Vertices 2 ? n - 1 , 2 ? n , 2 ? n + 2 , and 2 ? n + 1 define quadrilateral n. N 2 - 1 quadrilaterals are drawn. Note that the order in which vertices are used to construct a quadrilateral from strip data is different from that used with independent data.
	gol.begin_polygon()			--	GL_POLYGON			Draws a single, convex polygon. Vertices 1 through N define this polygon.	void	gol_register( lua_State* L )

	gol.do_end()				--	gol.end() can't be done in lua this is why

	gol.vertex	( x,y	)
	gol.vertex	( x,y,z	)
	gol.vertex2	( x,y	[ ,x,y ]	)
	gol.vertex3	( x,y,z	[ ,x,y,z ]	)

	gol.normal3	( x,y,z )

	gol.texcoor2( u,v )

	gol.draw_uv_xy(								u,v,	x,y		[,u,v,	x,y]	)
	gol.draw_uv_xyz(							u,v,	x,y,z	[,u,v,	x,y,z]	)
	--todo add repetition too
	gol.draw_rgba_uv_xyz(			r,g,b,a,	u,v,	x,y,z	)
	gol.draw_rgb_uv_xyz(			r,g,b,		u,v,	x,y,z	)
	-- in test
	gol.draw_rgba_uv_xyz_uv_xyz(	r,g,b,a,	u,v,	x,y,z,	u1,v1,	x1,y1,z1 )
	gol.draw_rgb_uv_xyz_uv_xyz(		r,g,b,		u,v,	x,y,z,	u1,v1,	x1,y1,z1 )
	gol.draw_g_uv_xyz_uv_xyz(		g,			u,v,	x,y,z,	u1,v1,	x1,y1,z1 )

	gol.set_quad_uv(				u_min,v_min,  u_max,v_max )		--		13	max
	gol.set_quad_uv(				u0,v0,  u1,v1,  u2,v2,  u3,v3 )	--	min 02
	gol.set_quad_uv()									--	do gol.set_quad_uv( 0, 0,  1, 1 )

	gol.draw_quads_2d			(	x1,y1,	x2,y2, 	x3,y3,	x4,y4		[	,x,y	,x,y	,x,y	,x,y	] )
	gol.draw_quad_strip_2d		(	x1,y1,	x2,y2, 	x3,y3,	x4,y4		[	,x,y	,x,y					] )
	gol.draw_triangles_2d		(	x1,y1,	x2,y2, 	x3,y3				[	,x,y	,x,y	,x,y			] )
	gol.draw_triangle_strip_2d	(	x1,y1,	x2,y2, 	x3,y3				[	,x,y							] )
	gol.draw_triangle_fan_2d	(	x1,y1,	x2,y2, 	x3,y3				[	,x,y							] )
	gol.draw_lines_2d			(	x1,y1,	x2,y2						[	,x,y	,x,y					] )
	gol.draw_line_strip_2d 		(	x1,y1,	x2,y2						[	,x,y							] )
	gol.draw_line_loop_2d		(	x1,y1,	x2,y2						[	,x,y							] )
	gol.draw_points_2d			(	x1,y1 								[	,x,y							] )

	--these don't use uv
	gol.draw_quads_3d			(	x1,y1,z1,	x2,y2,z2,	x3,y3,z3,	x4,y4,z4 	[	,x,y,z	,x,y,z 	,x,y,z	,x,y,z	] )
	gol.draw_quad_strip_3d		(	x1,y1,z1,	x2,y2,z2,	x3,y3,z3,	x4,y4,z4 	[	,x,y,z	,x,y,z					] )
	gol.draw_triangles_3d		(	x1,y1,z1,	x2,y2,z2,	x3,y3,z3				[	,x,y,z	,x,y,z	,x,y,z			] )
	gol.draw_triangle_strip_3d	(	x1,y1,z1,	x2,y2,z2,	x3,y3,z3				[	,x,y,z							] )
	gol.draw_triangle_fan_3d	(	x1,y1,z1,	x2,y2,z2,	x3,y3,z3				[	,x,y,z							] )
	gol.draw_lines_3d			(	x1,y1,z1,	x2,y2,z2 							[	,x,y,z	,x,y,z					] )
	gol.draw_line_strip_3d		(	x1,y1,z1,	x2,y2,z2							[	,x,y,z							] )
	gol.draw_line_loop_3d		(	x1,y1,z1,	x2,y2,z2							[	,x,y,z							] )
	gol.draw_points_3d			(	x1,y1,z1										[	,x,y,z							] )

-- same functions but with another interface
--	a table: flat table with all the coordonates
	gol.draw_xxx_2d				(	table 		[,nb		[,offset] ] )	-- nb of points, offset in points start at 0
	gol.draw_xxx_3d				(	table 		[,nb		[,offset] ] )	-- nb of points, offset in points start at 0
--	or arrayfp32 (userdata) is passed
	gol.draw_xxx_2d				(	arrayfp32 	,nb			[,offset]	)	-- nb of points, offset in points start at 0
	gol.draw_xxx_3d				(	arrayfp32 	,nb			[,offset]	)	-- nb of points, offset in points start at 0
-- or separate coordonates
	gol.draw_xxx_2d				(	x1,y1 		[,x,y	]	)
	gol.draw_xxx_3d				(	x1,y1,z1	[,x,y,z	]	)
-- functions using uv, normal and both with the same 3 method possible describe before:
--   table / arrayfp32 / separate coor symbolized here as ARGS
	gol.draw_xxx_uv_2d			(	ARGS )
	gol.draw_xxx_uv_3d			(	ARGS )
	gol.draw_xxx_normal_2d		(	ARGS )
	gol.draw_xxx_normal_3d		(	ARGS )
	gol.draw_xxx_uv_normal_2d	(	ARGS )
	gol.draw_xxx_uv_normal_3d	(	ARGS )

	gol.set_attrib_uv				( 	table_uv		[,nb	[,offset] ] )
	gol.set_attrib_normal			( 	table_normal	[,nb	[,offset] ] )
	gol.set_attrib_color3			( 	table_color3	[,nb	[,offset] ] )
	gol.set_attrib_color4			( 	table_color4	[,nb	[,offset] ] )

	gol.set_attrib_normal3_repeat_3( 	table_normal	,nb  )	-- support only table


-- direct call for speed: here geometry have to generated directly in the vertex shader for the vertex/instance id
	gol.draw_arrays_xxx			(	vertex_nb	[,instance_nb] )
	gol.draw_arrays				(	vertex_nb	[,instance_nb] )	-- primitive used is prim from current render attribute object

	gol.set_draw_attachment( bool [,bool...] )	--	true = draw attachment is enable, false = draw attachment is disable

	gol.flush_always()
	gol.flush()		-- really execute if flush_allow  is ON in AAAASeed prefs
	gol.finish_always()
	gol.finish()	-- really execute if finish_allow is ON in AAAASeed prefs

	err = gol.get_error( str )	--	return nil if no error

--DRAW
	aaa.draw_rgba( color_ref )	--	color_ref is a color obj ref
	aaa.draw_rgb ( color_ref )	--	color_ref is a color obj ref

	aaa.draw_null(		x,y,z	[,size]	)			-- default size is 1
	aaa.draw_null(				[size]	)			-- aaa.draw_null( 0, 0, 0 [,size]  )

	aaa.draw_null_2d(	x,y,z	[,size [,axe] ] )	-- default size is 1, default axe is 2
	aaa.draw_null_2d(			[,size [,axe] ] )	-- aaa.draw_null_2d( 0, 0, 0 [,size [,axe] ] )

	aaa.draw_axe_and_plane( planes )	-- PLANE_YZ	= 1, PLANE_XZ = 2, PLANE_XY	= 4, PLANE_NONE	= 0 or nil, PLANE_ALL	= PLANE_XY | PLANE_YZ | PLANE_XZ = 7

	aaa.draw_cube				()					--	aaa.draw_cube( 0,0,0, 1 )
	aaa.draw_cube				( x,y,z )			--	aaa.draw_cube( x,y,z, 1 )
	aaa.draw_cube				( x,y,z, 	size )
	aaa.draw_box				( sx,sy,sz	[ ,x,y,z ] )
	aaa.draw_box_using_transfo	( sx,sy,sz	[ ,x,y,z ] ) --	avoid freezing driver bug for EO
	aaa.draw_box_top_line		( sx,sy,sz	[ ,x,y,z ] )

	aaa.draw_sphere				(			size, 	u_nb, v_nb )
	aaa.draw_sphere_xyz			( x,y,z,	size,	u_nb, v_nb )
	--todo add ellipsoid
	
	aaa.draw_teapot				( size, grid_nb )

	aaa.draw_line_x				( x1,x2 )			-- y = 0
	aaa.draw_line_y				( y1,y2 )			-- z = 0
	aaa.draw_line				( x1,y1,   	x2,y2 )
	aaa.draw_line				( x1,y1,z1,	x2,y2,z2 )
	aaa.draw_line_uv			( u,v,		du,dv )			--u v is x y here
---	aaa.draw_line_uv			( u,v,		du,dv,	axe )	--2022 Dec axe not implemented yet

	aaa.draw_lines_vert_nb		(	nb, x, step, bottom, top )
	aaa.draw_lines_hori_nb		(	nb, y, step, left, right )

-- no normal, no texture, the most simple fast and direct plain rect
	aaa.draw_rect				(	min_x,min_y, max_x,max_y )
	aaa.draw_rect_size			(	[ size_x [,size_y] ] ) -- if no size_y, size_x is used. if no arg sizes are 1
	aaa.draw_rect_at_z			(	min_x,min_y,	max_x,max_v,	pos_z )
	aaa.draw_rect_axe_x			(	x,y,z, [ size_u [,size_v [,rot_axe ] ] ] ) -- if no size_v, size_u is used. if no arg sizes are 1
	aaa.draw_rect_axe_y			(	x,y,z, [ size_u [,size_v [,rot_axe ] ] ] ) -- if no size_v, size_u is used. if no arg sizes are 1
	aaa.draw_rect_axe_z			(	x,y,z, [ size_u [,size_v [,rot_axe ] ] ] ) -- if no size_v, size_u is used. if no arg sizes are 1

	-- draw a simple rect perpendicular to z
	--		uv used depend and c_layer::cur
	aaa.draw_rect_line			(	min_x,min_y, max_x,max_y )
	aaa.draw_rects_line			(	min_x,min_y, max_x,max_y [,min_x,min_y, max_x,max_y]	)
	aaa.draw_rect_line_size		(	[ size_x [,size_y] ] ) -- if no size_y, size_x is used. if no arg sizes are 1
	aaa.draw_rect_line_at_z		(	min_x,min_y,	max_x,max_y,	pos_z )
	aaa.draw_rect_line_axe_x	(	x,y,z, [ size_u [,size_v [,rot_axe ] ] ] ) -- if no size_v, size_u is used. if no arg sizes are 1
	aaa.draw_rect_line_axe_y	(	x,y,z, [ size_u [,size_v [,rot_axe ] ] ] ) -- if no size_v, size_u is used. if no arg sizes are 1
	aaa.draw_rect_line_axe_z	(	x,y,z, [ size_u [,size_v [,rot_axe ] ] ] ) -- if no size_v, size_u is used. if no arg sizes are 1	

	--	draw_rect_uv() always pass uv to Opengl texture
	--		use gol.set_quad_uv( u_min, v_min, u_size, v_size ) to set uv
	--todo extend passing rect xysxy or rbtl and propagate in lua
	aaa.draw_rect_uv			(	min_x,min_y,	max_x,max_y )
	aaa.draw_rect_uv_size		(	[ size_x [,size_y] ] ) -- if no size_y, size_x is used. if no arg sizes are 1
	aaa.draw_rect_uv_at_z		(	min_x,min_y,	max_x,max_y,	pos_z )
	aaa.draw_rect_uv_axe_x		(	x,y,z, [ size_u [,size_v [,rot_axe ] ] ] ) -- if no size_v, size_u is used. if no arg sizes are 1
	aaa.draw_rect_uv_axe_y		(	x,y,z, [ size_u [,size_v [,rot_axe ] ] ] ) -- if no size_v, size_u is used. if no arg sizes are 1
	aaa.draw_rect_uv_axe_z		(	x,y,z, [ size_u [,size_v [,rot_axe ] ] ] ) -- if no size_v, size_u is used. if no arg sizes are 1

	--	1	3
	--	0	2
	aaa.draw_quad_strip_4xy_uv	( 	x0,y0,		x1,y1,		x2,y2, 		x3,y3		)
	aaa.draw_quad_strip_4xyz_uv	(	x0,y0,z0,	x1,y1,z1,	x2,y2,z2,	x3,y3,z3	)

	aaa.bind_draw_rect			( 	bind,	x_min,y_min,	x_max,y_max )		--canonic uv, texture cur dimension is the same after this call
	-- do in C
	--	push_texture_dim( 2 )
	--	if bind then
	--		gol.bind_texture( bind )
	--	end
	--	draw_rect_uv( x_min,y_min, x_max,y_max ) -- using canonical text coor 0,0, 1,1
	--	pop_texture_dim()

	aaa.draw_disk_axe_x			(	x,y,z, size	[,nb_arc] )		-- default nb_arc = 12
	aaa.draw_disk_axe_y			(	x,y,z, size	[,nb_arc] )		-- default nb_arc = 12
	aaa.draw_disk_axe_z			(	x,y,z, size	[,nb_arc] )		-- default nb_arc = 12
--todo regroup with previous one
	aaa.draw_disk_arc_axe_z		(	x,y,z, size, angle_start, angle	[,nb_arc] )		-- default nb_arc = 12

	aaa.draw_circle_axe_x		(	x,y,z, size	[,nb_arc] )		-- default nb_arc = 12
	aaa.draw_circle_axe_y		(	x,y,z, size	[,nb_arc] )		-- default nb_arc = 12
	aaa.draw_circle_axe_z		(	x,y,z, size	[,nb_arc] )		-- default nb_arc = 12
--todo regroup with previous one
	aaa.draw_circle_arc_axe_z	(	x,y,z, size, angle_start, angle	[,nb_arc] )		-- default nb_arc = 12

	aaa.draw_ellipse_axe_x		(	x,y,z, size_u, size_v [,nb_arc=12] )
	aaa.draw_ellipse_axe_y		(	x,y,z, size_u, size_v [,nb_arc=12] )
	aaa.draw_ellipse_axe_z		(	x,y,z, size_u, size_v [,nb_arc=12] )
	aaa.draw_ellipse_line_axe_x	(	x,y,z, size_u, size_v [,nb_arc=12] )
	aaa.draw_ellipse_line_axe_y	(	x,y,z, size_u, size_v [,nb_arc=12] )
	aaa.draw_ellipse_line_axe_z	(	x,y,z, size_u, size_v [,nb_arc=12] )
	
	aaa.draw_tri_line	(	x,y, s )		-- draw a triangle with lines 
	aaa.draw_tri_line	(	x,y, sx,sy )
	aaa.draw_mul_line	(	x,y, s )		-- draw a multiplication sign with lines
	aaa.draw_mul_line	(	x,y, sx,sy )
	aaa.draw_plus_line	(	x,y, s )		-- draw a plus sign with lines
	aaa.draw_plus_line	(	x,y, sx,sy )

	x,y = aaa.get_str_translate( str )
	-- the fns below draw with a nice line font
	aaa.draw_str		(	str		[,str...] )					-- done for flatland (tricky with scale)
	aaa.draw_str_xy		(	str		[,x [,y [,sx[,sy ] ] ] ] )	--	optional params are 0, 0,	1, 1
	aaa.draw_str_xyz	(	str,	x,y,z 	[,sx[,sy ] ]  )		--	optional params are 		1, 1
	-- the fns below draw with a faster line font, but not so nice
	aaa.draw_str_maa	( 	str		[,str...] )					-- done for flatland (tricky with scale)
	aaa.draw_str_maa_xy	( 	str 	[,x[,y	[,sx[,sy ] ] ] ] )	--	optional params are 0, 0,	1, 1
	aaa.draw_str_maa_xyz(	str,	x,y,z 	[,sx[,sy ] ]  )		--	optional params are 		1, 1

--IMAGE
-- what designate component : 1=RED / 2=GREEN / 3=BLUE / 4=ALPHA / 5=GREY
-- x and y as fn argument mean pixel space 0 to number of pixel-1
-- u and v as argument mean uv space ( 0. to 1. )
-- vert coor at 0 mean bottom of image
-- b_... means Boolean (en C) le plus facile 0 pour FALSE 1 pour TRUE
-- was available as aaa.img_...

--
--	GOL LIST (depreceated)
--
	id_list = gol.gen_list()
	gol.compile_list( id_list )
	gol.end_list	()
	gol.call_list	( id_list )

--2D--
	bind = aaa.img.make_tex_index( bank, bind )		-- AAASeed do trick on bank 6 used in aaa.img.make_bind_2d

	--	load image at bind index, return true if ok or nil
	b = aaa.img.read( bind, filename [,b_free [,b_async [,b_force_keep [,b_premultiply] ] ] ] )	-- optional args are false by default
	b = aaa.img.read_no_error( bind, filename [,b_free [,b_async [,b_force_keep [,b_premultiply] ] ] ] )	-- same but C don't trigger error or message
	b			= aaa.img.is_ready(				bind )		--in case if async load test if it is done

	value		= aaa.img.get_bind_index(		filename )	--	get bind index from image filename
	filename	= aaa.img.get_bind_filename(	index )
				  aaa.img.set_bind_filename(	index[, filename] )	--if no filename or filename is nil or "", it clear the bind filename

	b			= aaa.img.exist(				index )		-- return if there an image at this bind
															--		infact id there is a cpu img
	b			= aaa.img.set_lua_cur( 			index )		-- avoid passing index every time, very useful in loops
															--		once set pass a nil index to use it
															--	return true for a non empty image
	sx,sy		= aaa.img.get_size(				index )		-- get image size x and y
															--	return nothing if no texture
															--	we use it for now to test existence of texture
	sx,sy,nb_ch = aaa.img.get_size_channel(		index )		-- get image size x and y and channel_nb
	nb_ch		= aaa.img.get_channel( 			index )		-- get image channel_nb
	--todo add aaa.img.get_type

	b = aaa.img.set_size_channel( 				index, sx,sy, nb_ch ) 	-- return true when done with sucess
	str = aaa.img.get_format_name( 				index )
	id = aaa.img.get_state_unique()

	b = aaa.img.set_cpu_keep(					index, b )	-- return true if there was an image to set
	aaa.img.move_to_gpu(						index )
	aaa.img.copy_tex_to_tex(					index_src, index_dst [,b_mipmap_generate]	)	--b_mipmap_generate true if nor specified
	aaa.img.move_from_gpu(						index )

	aaa.img.destroy(							index )
	aaa.img.swap(								index_a, index_b )	

	b = aaa.img.save(							index,	filename [,ext]  )	-- save image index with filename return true if success
	aaa.img.copy(								index_src, index_dst, ox,oy, sx,sy )

												--	what : RED=1, GREEN=2, BLUE=3, ALPHA=4, GREY=5
	c = aaa.img.get_component_xy(				index, x,y, what )							-- get pixel component at xy
	max = aaa.img.get_component_max_rect_xy(	index, x_begin,x_end, y_begin,y_end, what )	-- get pixel maximum component in rectangle xy edges included

	r,g,b, a = aaa.img.get_color_xy(			index, x,y )								-- get pixel color at xy
	c = aaa.img.get_component_uv(				index, u,v,	what, b_clamped, b_linear )		-- get pixel color at uv
	c = aaa.img.get_component_uv(				index, u,v,	what, b_clamped )				-- idem consider linear as FALSE
	c = aaa.img.get_component_uv_ellipse(		index, u,v,	ru,rv, nb, what, b_clamped, b_linear )
																							-- idem but on the nb outside point of an ellipse
	r,g,b, a = aaa.img.get_color_uv(			index, u,v,	b_clamped )						-- get pixel color at uv
	x,y = aaa.img.get_gradient_uv(				index, u,v,	what, b_clamped, b_linear )		-- get pixel color at uv
	x,y = aaa.img.get_gradient_uv(				index, u,v,	what, b_clamped )				-- idem but consider linear as FALSE
	x,y = aaa.img.get_gradient_from_uv_ellipse(	index, u,v,	ru,rv, nb, what, b_clamped, b_linear )
																							-- idem but on the nb outside point of an ellipse


	-- when we pass grey or only r,g,b we don't change the alpha
	aaa.img.set_color_xy(						index, x,y, grey )
	aaa.img.set_color_xy(						index, x,y, r,g,b [,a ] )
	aaa.img.set_color_xy(						index, x,y, { r,g,b, a } )


--3D--
	--	load image at bind index, return true if ok or nil
	b = aaa.img3d.read( bind, filename[,b_free [,b_async [,b_force_keep [,b_premultiply] ] ] ] )	-- optional args are FALSE by default
	b = aaa.img3d.read_no_error( bind, filename [,b_free [,b_async [,b_force_keep [,b_premultiply] ] ] ] )	-- same but C don't trigger error or message
	b			= aaa.img3d.is_ready(			bind )		--in case if async load test if it is done

	value		= aaa.img3d.get_bind_index(		filename )	-- get bind index from image filename
	filename	= aaa.img3d.get_bind_filename(	index )
				  aaa.img3d.set_bind_filename(	index[, filename] )	--if no filename or filename is nil or "", it clear the bind filename

	b			= aaa.img3d.exist(				index )		-- return if there an image at this bind
															--		infact id there is a cpu img
	b			= aaa.img3d.set_lua_cur(		index )		--	avoid passing index every time, very useful in loops
															--		once set pass a nil index to use it
															--	return true for a non empty image
	sx,sy,sz	= aaa.img3d.get_size(			index )		-- get image size x,y,z
															--	return nothing if no texture
															--	we use it for now to test existence of texture
	sx,sy,sz, nb_ch = aaa.img3d.get_size(		index )		-- get image size x,y,z and channel_nb
	nb_ch			= aaa.img3d.get_channel(	index )		-- get image channel_nb

	b = aaa.img3d.set_size_channel(				index, sx,sy,sz, nb_ch )	-- return true when done with sucess
	str = aaa.img3d.get_format_name(			index )
	id = aaa.img3d.get_state_unique()

	b = aaa.img3d.set_cpu_keep(					index, b )	-- return true if there was in image to set
	aaa.img3d.move_to_gpu(						index )
	
	aaa.img3d.erase(							index )
	aaa.img3d.swap(								index_a, index_b )	

	str = aaa.img.build_snap_filename()

--COLOR
	h,s,v	= aaa.color.rgb_to_hsv ( r,g,b )
	r,g,b	= aaa.color.hsv_to_rgb ( h,s,v )
	g		= aaa.color.rgb_to_grey( r,g,b )

--FONT
	aaa.font.read( bind, filename )