-- MSI Mac addr 30-9C-23-90-BA-B0
--		192.168.53.207
--	was	192.168.1.53
-- PriseDigital projection
--		192.168.53.208
-- Prise
--		192.168.53.209
-- Free
--		192.168.53.221
--		192.168.53.222
-- Mask
--		255.255.255.0
-- Routeur
--		192.168.53.254
-- DNS
--		194.2.0.20
--		194.2.0.50
-- DNS Google
--		8.8.8.8
-- 16h55 <-> 00h02
--		24 NOV 19h10 -> 0h02
--		24 DEC 16h55 -> 2h02
--		31 DEC 16h55 -> 2h02

-- ANYDESK 145119570 Laavaal88
-- MAAHEX 843159090

local prise_name		= "PowerStrip"
local socket_name		= "Socket"
local epson_socket_id	= 4
local calor_socket_id	= 1

function meu:set_energie_socket( id, what )
	--https://github.com/unterwulf/egctl

	local command = "C:/Program Files/Power Manager/pm.exe"
	local args = "-"..what.." -"..prise_name.." -"..socket_name..id

	local str_err = aaa.os.execute_process( command, args )
-- this one is a locking call
--	local str_err = aaa.os.execute_shell( command, args )
end

function meu:get_dp_meu()
	local meu = self.meu_dp
	if not meu then
		meu = self:get_meu_by_name( "DigitalProjection_1" )
		self.meu_dp = meu
	end
	return meu
end

function meu:set_dp_power( b )
	aaa.print( "__________________________DP POWER"..b.."______________________________________")
	local meu = self:get_dp_meu()
	meu:set_power( b )
end
function meu:set_dp_shutter( b )
	aaa.print( "__________________________DP SHUTTER"..b.."______________________________________")
	local meu = self:get_dp_meu()
	meu:set_shutter( b )
end

function meu:begin_wake()
	MEU.begin_wake( self )
	self:set_dp_power( true )
	self.b_need_shutter = true
	self:begin_epson_on()
end

function meu:begin_epson_off()
	aaa.print( "__________________________EPSON OFF______________________________________")
	aaa.set_monitor_off()
	self.epson_time_off = 0.
end
function meu:begin_epson_on()
	aaa.print( "__________________________EPSON ON______________________________________")
	self:set_energie_socket( epson_socket_id, "off" )
	self.epson_time_on = 0.
end

function meu:begin_reboot()
	MEU.begin_reboot( self )
	self:set_dp_power( false )
	self:begin_epson_off()
end

function meu:define_ui()
	local ref = self.ref
	local ui = self.ui
	local bu
	local ix = 1
	local iy = 1
	local SY = 1
	local DY = .5
	local SYM = SY * .8

	iy = iy + DY
	self:add_slider(	{ix,iy,	8,SY},			"Flatland_offset_X", 			aaa.ref.draw_focus_offset_x	):set_min_max( 0, 4000 )
	iy = iy + SY + DY

	--	192.168.1.100
	local SX = 2.5
	self:add_text(	{ix,iy,	8-SX*2,SYM},	"DP"	)
	self:add_trig_method(	{ix+8-SX*2,iy,		SX, SY},	"DP Off",		self, "set_dp_power",	false	):set_text( "Off" )	:set_color_back( "off" )
	self:add_trig_method(	{ix+8-SX  ,iy,		SX, SY},	"DP On",		self, "set_dp_power",	true	):set_text( "On" )	:set_color_back( "on" )
	iy = iy + SY
	self:add_text(	{ix,iy,	8-SX*2,SYM},	"Shutter"	)
	self:add_trig_method(	{ix+8-SX*2,iy,		SX, SY},	"Shutter On",	self, "set_dp_shutter", true	):set_text( "On" )	:set_color_back( "off" )
	self:add_trig_method(	{ix+8-SX  ,iy,		SX, SY},	"Shutter Off",	self, "set_dp_shutter", false	):set_text( "Off" )	:set_color_back( "on" )
	iy = iy + SY + DY

	self:add_text(	{ix,iy,	8-SX*2,SYM},	"Epson"	)
	self:add_trig_method(	{ix+8-SX*2,iy,		SX, SY},	"Epson Off",	self, "begin_epson_off"	):set_text( "Off" )	:set_color_back( "off" )
	self:add_trig_method(	{ix+8-SX  ,iy,		SX, SY},	"Epson On",		self, "begin_epson_on"	):set_text( "On" )	:set_color_back( "on" )
	iy = iy + SY + DY

	bu = self:add_selector(	{ix,iy,	8,SY*1.5}, "Serial port nb" ):set_target_param( ref.port_nb ):set_nb(16,2)
		for i=1,32,4 do
			bu:set_item_text( i, i )
		end
	iy = iy + SY * 1.5
								self:add_button( 	{ix,iy,		SY,SY},	"Temp", self, "b_temp", false ):set_text_visible(false)
	ui.bu_temp_open_info	=	self:add_text_info(	{ix+1,iy,	3,SYM}, "Closed" ):set_text_color( "problem" )
	ui.bu_temp_info			=	self:add_text_info(	{ix+4,iy,	4,SYM}, "Temperature RT" )
	self:add_slider_two(	{ix,iy+1,	8,1}, "Temperature", self, "temp_min", "temp_max", 0, 700, 0, 700 ):set_value_type_integer(true)
	self:add_button( {ix, iy+2, SY,SY },	"Log", self, "b_temp_log", false )
	iy = iy + SY * 3 + DY

	for i=1,4 do
		local x = ix+2*(i-1)
		self:add_trig_method(	{x,	iy,			2, SY},	"Off"..i,	self, "set_energie_socket", i, "off" )
		self:add_trig_method(	{x,	iy+1,		2, SY},	"On"..i,	self, "set_energie_socket", i, "on" )
	end
	iy = iy + SY * 2 + DY

	ix, iy = 9, 1
	iy = self:add_exploitation_start_stop(	{ix,iy,	8,SY}, true, false )

	self:add_ui_exploitation_window(	{ix,iy,	8,5 })
	iy = iy + 5

	self:add_button(	{		ix,	iy },					"Force Screens",		self, "b_replace",			false		)

end

function meu:init()
	local ref = self.ref
	local bdd = self:get_layer_bdd(1)
	ref.temp	= param.get_ref( bdd, "received_number_last" )
	ref.received= param.get_ref( bdd, "received" )
	ref.is_open	= param.get_ref( bdd, "open_state" )
	ref.port_nb	= param.get_ref( bdd, "com_port_nb" )
end

function meu:update_ui()
	local ui = self.ui
	--todo check this is_open
	ui.bu_temp_open_info:set_visible( not self.b_temp or not param.get_bool( self.ref.is_open ) )
	self:update_ui_exploitation_start_stop()
end

function meu:update()
	local b_onsite = not aaa.pc.is_maa()
	self:set_ui_slot_at_start( 4 )

	if b_onsite or self.b_onsite_force then
		-- temperature
		if self.b_temp then
			local temp = param.get( self.ref.temp )
			if temp ~= 0 then
				self.temperature = temp
				self.ui.bu_temp_info:set_text( temp )
				if aaa.time.minute ~= self.__minute_last then
					self.__minute_last = aaa.time.minute
					temp = self.temperature or 0
					if temp > self.temp_max then
						self:set_energie_socket( calor_socket_id, "off" )
					elseif temp < self.temp_min then
						self:set_energie_socket( calor_socket_id, "on" )
					end
					if self.b_temp_log then
						local fname = "temperature_"..aaa.time.month_start.."_"..aaa.time.day_start..".txt"
						local file = io.open( fname, "a" )
						io.output(file)
						io.write( aaa.time.hour.."h"..aaa.time.minute.." temperature is , "..param.get( self.ref.received ).."\n" )
						io.close(file)
						--self:print( "save temperature file "..fname )
					end
				end
			end
		end

		self:update_exploitation_start_stop( true, false )

	end

	self:update_exploitation_window()

	--do that every second
	if self.__second_last ~= aaa.time.second then
		self.__second_last = aaa.time.second

		if self.b_replace then
			ga:set_ui_on_screen(1)

			-- resize and replace outskeep others windows behind
			local sx, sy = aaa.get_window_size()
			if sx~=(1920*3) or (sy~=1200) then
				ga:force_fullscreen()
				self.replace_time = 0
			end

			local t = self.replace_time
			if t then
				self:get_meu_by_name( "Out_Wall" ):set_screen_viewport( 2 )
				self:get_meu_by_name( "Out_Floor" ):set_screen_viewport( 3 )
				t = t + 1
				if t > 4 then -- do viewport every second : 6 times 0 1 2 3 4 5
					t = nil
				end
				self.replace_time = t
			end
		end
	end

	local t = self.epson_time_on
	if t then
		t = t + aaa.time.dt
		if self.b_need_shutter and t > 30 then
			self:set_dp_shutter( true )
			self.b_need_shutter = false
		end
		if t > 70 then
			self:set_energie_socket( epson_socket_id, "on" )
			self:set_dp_shutter( false )
			t = nil
			self.wake_time = nil
		end
		self.epson_time_on = t
	end

	local t = self.epson_time_off
	if t then
		t = t + aaa.time.dt
		if t > 75 then
			aaa.print( "aaa.set_monitor_on" )
			aaa.set_monitor_on()
			t = nil
		end
		self.epson_time_off = t
	elseif self:is_rebooting() then
		aaa.reboot_no_save()
	end

end

function meu:draw()
	if self.b_temp then
		MEU.draw(self)
	end
end