--
--	STACK
--
if CLASS.DECLARE( "STACK" ) then
	STACK.__depth_min	= 0
	STACK:set_class_status_doc(	CLASS.STATUS.CORE, "implement a LIFO" )
end

function STACK:erase()
	self.__last	= 0
	self.__data	= {}
end

function STACK:set_size_min( new_min )
	self.__depth_min	= new_min
end
function STACK.init_instance(self)
	oo.getsuper(STACK).init_instance(self)
	self:erase()
end
function STACK:create( name )
	return STACK:create_instance( name )
end
function STACK:get_top()
	local last = self.__last
	if last <= 0 then
		self:print( "data is empty" )
		return nil
	end
	return self.__data[ last ]
end
function STACK:set_top( val )
	local last = self.__last
	if last <= 0 then
		self:print( "data is empty" )
		self:push( val )
	end
	self.__data[ last ] = val
end
function STACK:push( val )
	local last = self.__last + 1
	self.__last = last
	self.__data[ last ] = val
	self.__store = nil
end

function STACK:pop()
	local last = self.__last
	if last <= self.__depth_min then
		self:print_error( "stack is fuck up. pop() failed because it wasn't match by a push()" )
		--self:print( "data is empty" )
		return self.__store
	end
	local val = self:get_top()
	if val then
		if last == 1 then
			self.__store = self.__data[ 1 ]	--quick to keep bottom of stack
		end
		self.__data[ last ] = nil
	end
	self.__last = last - 1
	return val
end
function STACK:get_size()
	return self.__last
end
function STACK:get_from_bottom( index )
	--todo protect and use neg inddex
	return self.__data[index]
end
function STACK:print_fn( fn_str )
	self:print( fn_str.."() -> "..self:get_size() )
	--aaa.debug.print_traceback()
end
function STACK:get_table_and_nb()
	return self.__data, self.__last
end

--
--	QUEUE
--
--todo nake sure we consume less memoty and are still fast
if CLASS.DECLARE( "QUEUE" ) then
	QUEUE:set_class_status_doc(	CLASS.STATUS.CORE, "implement a FIFO" )
end

function QUEUE:erase()
	self.__last = -1
	self.__data = {}
	self.__first = 0
end

function QUEUE.init_instance(self)
	oo.getsuper(QUEUE).init_instance(self)
	self:erase()
end
function QUEUE:create( name )
	return QUEUE:create_instance( name )
end

--todo start at 1 not zero
function QUEUE:push( val )
	local last = self.__last + 1
	self.__last = last
	self.__data[ last ] = val
end
function QUEUE:insert( index_one_based, val )
	local index = self.__first + index_one_based - 1
	if index > self.__last then
		self:push( val )
	else
		self.__last = self.__last + 1
		table.insert( self.__data, index, val )
	end
end
function QUEUE:pop()
	local first = self.__first
	if first > self.__last then
		--self:print( "data is empty" )
		return nil
	end
	local val = self:get_first()
	if val then
		self.__data[ first ] = nil
		self.__first = first + 1
	end
	return val
end

function QUEUE:get_nb()	return self.__last - self.__first + 1 end

function QUEUE:get_front( index_one_based )
	local index = self.__first + index_one_based - 1
	if index > self.__last then
		--self:print( "data is empty" )
		return nil
	end
	return self.__data[ index ]
end
function QUEUE:get_last()
	local last = self.__last
	if self.__first > last then
		--self:print( "data is empty" )
		return nil
	end
	return self.__data[ last ]
end
function QUEUE:get_first()	return self:get_front( 1 )	end


