
function meu:define_meu_infos( )
	return { author = "Mâa Abdalight", date="2024",
			tags = { "Core", "Tutorial", "3d", "2d", "draw" },
			help = { "Show how to using the Opengl lua glue for different graphic primitives.",
                     "https://math.hws.edu/graphicsbook/c3/s1.html#gl1geom.1.1 simple reference on primitives" }
			 }
end

function meu:define_ui()

	local ref = self.ref
	local ui = self.ui
    local ix,iy = 1,1
    local SY,DY = 1,.2
    local bu

    self:add_rendering()
	self:add_camera()

    bu = self:add_button( {ix,iy,       4*SY,SY},  "Primitive",    nil, nil,        0   )
 		bu:set_menu{ "Quad Strip", "Triangle Fan", "Triangle Strip", "Line Loop", "Line Strip", 
                        "Polygon" , "Quads" , "Triangles" ,"Lines", "Points"   
                    }:set_nb_min_0( 2, 5 )
        bu:set_target_lua( self, "selec_prim", 7 )
        bu:set_text_selector( true )
    bu = self:add_button( {ix+4,iy,     4*SY,SY},   "Fast",     self,"b_fast",      false   )
    iy = iy + SY + DY

    bu = self:add_slider( {ix,iy,       8*SY,SY},   "Size",     self,"size",        5,      0,10 )
    iy = iy + SY + DY

    bu = self:add_slider( {ix,iy,       4*SY,SY},   "u factor", self,"u_factor",    1,      0,5 )
        bu:set_color_back( "u" )
    bu = self:add_slider( {ix+4,iy,     4*SY,SY},   "v factor", self,"v_factor",    1,      0,5 )
        bu:set_color_back( "v" )
    iy = iy + SY + DY

    bu = self:add_bu_texture_target_unit( {ix,iy,       8*SY,6*SY}, "Tex", 1, true )
    iy = iy + 6 * SY

    ix, iy = 9, 2 + DY
    bu = self:add_transfo( {ix,iy,   8*SY,2.5*SY} )
    iy = iy + 2.5 + DY

end


function meu:init()
end

function meu:draw()
    aaa.show( self.selec_prim, "select primitive" ) -- debug helper

    self:draw_layers_begin()
        self:draw_layer( 1 )    -- set the attributes using Layer A 
        gol.color_white( self:get_alpha() )
        self:draw_primitive( self.size )
    self:draw_layers_end()
end


-- selec_prim switch the function called
function meu:draw_primitive( size )
    local b_slow = not self.b_fast
    if     self.selec_prim == 0 then
        --self:draw_quad_strip(size)
    elseif self.selec_prim == 1 then
        --self:draw_triangle_fan(size)
    elseif self.selec_prim == 2 then    self:draw_triangle_strip(size)
    elseif self.selec_prim == 3 then
        --self:draw_line_loop(size)
    elseif self.selec_prim == 4 then
        --self:draw_line_strip(size)
    elseif self.selec_prim == 5 then    self:draw_polygon( size, 6 )
    elseif self.selec_prim == 6 then    self:draw_quads( size, b_slow )
    elseif self.selec_prim == 7 then    self:draw_triangles( size, b_slow )
    elseif self.selec_prim == 8 then    self:draw_lines( size, b_slow )
    elseif self.selec_prim == 9 then    self:draw_points( size, b_slow )
    end
end



-- Function drawing using triangles primitive
--      3___________2    6___________5
--       \         /      \         /
--        \       /        \       /
--         \     /          \     /
--          \   /            \   /
--           \ /              \ /
--            1                4
--
function meu:draw_triangles( size, b_slow )
    local size_half    = 0.5 * size
    local u_fac, v_fac = self.u_factor, self.v_factor

    -- UV for a triangle with the tip pointing downward
    local u1, v1     = 0.5 * u_fac, 0 * v_fac
    local u2, v2     =   1 * u_fac, 1 * v_fac
    local u3, v3     =   0 * u_fac, 1 * v_fac

    -- First triangle
    local x1, y1, z1 = -2.5, -size_half, 0          -- Bottom tip
    local x2, y2, z2 = x1 + size_half, size_half, 0   -- Upper-right corner
    local x3, y3, z3 = x1 - size_half, size_half, 0   -- Upper-left corner


    if b_slow then
        gol.begin_triangles()   -- old school method similar to opengl 1.0
            gol.texcoor2( u1,v1 )
            gol.vertex3(  x1,y1,z1 )      -- gol.vertex2( x1, y1 ) for 2D
            gol.texcoor2( u2,v2 )
            gol.vertex3(  x2,y2,z2 )
            gol.texcoor2( u3,v3 )
            gol.vertex3(  x3,y3,z3 )
        gol.do_end()
    else    -- more efficient/modern method: less lua calls, less opengl calls 
        -- Second triangle
        local x4, y4, z4 = 2.5, -size_half, 0
        local x5, y5, z5 = x4+size_half, size_half, 0
        local x6, y6, z6 = x4-size_half, size_half, 0

        -- define the uv
        local uv = { u1,v1, u2,v2, u3,v3, u1,v1, u2,v2, u3,v3 }
        gol.set_attrib_uv(  uv )    -- 6 couples of uv coordonates for 6 points
        if false then    -- direct arguments          
            gol.draw_triangles_uv_3d( x1,y1,z1, x2,y2,z2, x3,y3,z3, x4,y4,z4, x5,y5,z5, x6,y6,z6 )
        else            -- passing table  
            -- Coordinates for 2 triangles
            local triangles = { x1,y1,z1, x2,y2,z2, x3,y3,z3, x4,y4,z4, x5,y5,z5, x6,y6,z6 }
            -- Draw one or more triangles
            gol.draw_triangles_uv_3d( triangles )       -- here the number of points correspond to the arra ysize
            -- or
            --gol.draw_triangles_uv_3d( triangles, 3 )  -- here the number of points is explicitly passed : 1 triangle -> 3 points
            --gol.draw_triangles_uv_3d( triangles, 6 )  -- here the number of points is explicitly passed : 2 triangles -> 6 points
            --gol.draw_triangles_uv_3d( triangles, 3, 2 )  -- 1 trinagle (3 points) but with an offset of 2 in the points array
        end
    end
end


-- Function to draw a quad
function meu:draw_quads( size, b_slow )
    local size_half    = 0.5 * size
    local u_fac, v_fac = self.u_factor, self.v_factor

    -- UV for a quad
    local u1, v1 = 0 * u_fac, 0 * v_fac -- Bottom-left
    local u2, v2 = 1 * u_fac, 0 * v_fac -- Bottom-right
    local u3, v3 = 1 * u_fac, 1 * v_fac -- Top-right
    local u4, v4 = 0 * u_fac, 1 * v_fac -- Top-left

    -- First quad centered at the origin
    local x1, y1, z1 = -size_half, -size_half, 0   -- Bottom-left
    local x2, y2, z2 =  size_half, -size_half, 0   -- Bottom-right
    local x3, y3, z3 =  size_half,  size_half, 0   -- Top-right
    local x4, y4, z4 = -size_half,  size_half, 0   -- Top-left
    
    -- Second quad translated
    local x_tr, y_tr, z_tr = 6, 0, 0
    local x5, y5, z5 = x_tr + x1, y_tr + y1, z_tr + z1 -- Translated bottom-left
    local x6, y6, z6 = x_tr + x2, y_tr + y2, z_tr + z2 -- Translated bottom-right
    local x7, y7, z7 = x_tr + x3, y_tr + y3, z_tr + z3 -- Translated top-right
    local x8, y8, z8 = x_tr + x4, y_tr + y4, z_tr + z4 -- Translated top-left


    if b_slow then
        gol.begin_quads()
            gol.texcoor2( u1,v1     )
            gol.vertex3(  x1,y1,z1 )
            gol.texcoor2( u2,v2     )
            gol.vertex3(  x2,y2,z2 )
            gol.texcoor2( u3,v3     )
            gol.vertex3(  x3,y3,z3 )
            gol.texcoor2( u4,v4     )
            gol.vertex3(  x4,y4,z4 )
        gol.do_end()
    else
        -- define the UV coordinates for 8 points
        local uv = { u1,v1, u2,v2, u3,v3, u4,v4, u1,v1, u2,v2, u3,v3, u4,v4 }
        -- Coordinates for 2 quads
        local quad = {  x1,y1,z1, x2,y2,z2, x3,y3,z3, x4,y4,z4, --first quad
                        x5,y5,z5, x6,y6,z6, x7,y7,z7, x8,y8,z8  --second quad
                    }
            -- Set up UVs
        gol.set_attrib_uv( uv )       
        gol.draw_quads_uv_3d( quad )  -- Draw the 2 quads at once
        --gol.draw_quads_uv_3d( quad, 4 )  -- Draw the first quad (4 points)
        --gol.draw_quads_uv_3d( quad, 4, 4 )  -- Draw the second quad (4 points) and with an offset of 4
    end
end


-- Function to draw a triangle using points as primitives
function meu:draw_points( size, b_slow )
    local size_half  = 0.5 * size

    -- Points
    local x_tr, y_tr, z_tr = -6, 2, 0
    local x1, y1, z1 =          0, -size_half, 0
    local x2, y2, z2 =  size_half,  size_half, 0
    local x3, y3, z3 = -size_half,  size_half, 0
    local x4, y4, z4 =  x_tr - x1,  y_tr + y1, z_tr + z1
    local x5, y5, z5 =  x_tr + x2,  y_tr + y2, z_tr + z2
    local x6, y6, z6 =  x_tr + x3,  y_tr + y3, z_tr + z3

    local points = { x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6 }

    if not b_slow then
        gol.begin_points()
            gol.vertex3( x1, y1, z1 )
            gol.vertex3( x2, y2, z2 )
            gol.vertex3( x3, y3, z3 )
            gol.vertex3( x4, y4, z4 )
            gol.vertex3( x5, y5, z5 )
            gol.vertex3( x6, y6, z6 )
        gol.do_end()
    else
        gol.draw_points_3d( points )
    end
end

-- Function to draw a triangle using lines as primitives
--TOTEST
function meu:draw_lines( size, b_slow )
    local size_half  = 0.5 * size

    local x_tr, y_tr, z_tr = -6, 2, 0
    local x1, y1, z1 =          0, -size_half, 0
    local x2, y2, z2 =  size_half,  size_half, 0
    local x3, y3, z3 = -size_half,  size_half, 0
    local x4, y4, z4 =  x_tr - x1,  y_tr + y1, z_tr + z1
    local x5, y5, z5 =  x_tr + x2,  y_tr + y2, z_tr + z2
    local x6, y6, z6 =  x_tr + x3,  y_tr + y3, z_tr + z3

    local lines = {
        x1, y1, z1, x2, y2, z2,
        x2, y2, z2, x3, y3, z3,
        x3, y3, z3, x4, y4, z4,
        x4, y4, z4, x5, y5, z5,
        x5, y5, z5, x6, y6, z6,
        x6, y6, z6, x2, y2, z2
    }

    if not b_slow then
        gol.begin_lines()
            gol.vertex3( x1, y1, z1 )
            gol.vertex3( x2, y2, z2 )

            gol.vertex3( x2, y2, z2 )
            gol.vertex3( x3, y3, z3 )

            gol.vertex3( x3, y3, z3 )
            gol.vertex3( x4, y4, z4 )

            gol.vertex3( x4, y4, z4 )
            gol.vertex3( x5, y5, z5 )

            gol.vertex3( x5, y5, z5 )
            gol.vertex3( x6, y6, z6 )

            gol.vertex3( x6, y6, z6 )
            gol.vertex3( x1, y1, z1 )
        gol.do_end()
    else
        gol.draw_lines_3d(lines)
    end
end



-- Fonction pour dessiner un triangle strip
--TOEND
function meu:draw_triangle_strip( size )
    local size_half = size / 2
    local u_fac, v_fac = self.u_factor, self.v_factor

    local u1, v1     = 0.5 * u_fac, 0 * v_fac
    local u2, v2     =   1 * u_fac, 1 * v_fac
    local u3, v3     =   0 * u_fac, 1 * v_fac

    local x_tr, y_tr, z_tr = -6, 2, 0
    local x1, y1, z1 =          0, -size_half, 0   
    local x2, y2, z2 =  size_half,  size_half, 0   
    local x3, y3, z3 = -size_half,  size_half, 0   
    local x4, y4, z4 =  x_tr - x1,  y_tr + y1, z_tr + z1
    local x5, y5, z5 =  x_tr + x2,  y_tr + y2, z_tr + z2
    local x6, y6, z6 =  x_tr + x3,  y_tr + y3, z_tr + z3

    self.uv = {u1, v1, u2, v2, u3, v3}

    self.coordinates = {
        x1, y1, z1,           
        x2, y2, z2,
        x3, y3, z3,
        x4, y4, z4,
        x5, y5, z5,
        x6, y6, z6
    }

    gol.set_attrib_uv(self.uv)
    gol.draw_triangle_strip_uv_3d(self.coordinates)
end


-- Fonction pour dessiner un polygone
--TOEND
function meu:draw_polygon(alpha, num_sides)
    gol.color_white(alpha)
    local size = self.size
    local half_size = size / 2
    local angle_step = 2 * math.pi / num_sides
    local vertices = {}
    local uv = {}
    local angle = 0
    for i = 0, 2 * num_sides - 1 do
        table.insert(vertices, math.cos(angle) * half_size)
        table.insert(vertices, math.sin(angle) * half_size)
        table.insert(uv, math.cos(angle) )
        table.insert(uv, math.sin(angle) )
        angle = angle + angle_step
    end
    gol.set_attrib_uv( uv )
    gol.draw_quads_uv_2d( vertices )
end



-- Fonction pour dessiner un quad strip
--TOEND
function meu:draw_quad_strip(alpha)
    gol.color_white(alpha)
    local size = self.size
    local half_size = size / 2
    self.uv = {1, -1, 1, 1, -1, 1,-1,-1}
    self.coordinates = {half_size, -half_size, -half_size, -half_size, -half_size, half_size, half_size, half_size}
    
    gol.set_attrib_uv( self.uv )
    gol.draw_quad_strip_uv_2d(self.coordinates)
end

