--OGE
--	we use the the AAASeed usual axis so
--		x/u is directed from left to right
--		y/v is directed from bottom to top
if CLASS.DECLARE( "OGE", nil, {
	class_name_human = "Ouput_Geo_Edit",
	outs = {},
	ou = 1,
	ov = 1,
	ou_min = 12222,
	ou_max = -12222,
	ov_min = 12222,
	ov_max = -12222,
	b_active = false,
	} ) then
		
end

function OGE:create()
	local self = OGE:create_instance_no_name()
	self.global_table = {}
	self.iu = 1
	self.iv = 1
	return self
end

function OGE:output_set_fuz( o, b_on )
	local t = o.fuz
	if not t then return end
	for k in pairs(t) do
		param.set( t[k], "active", b_on )
	end
end
function OGE:output_set_line( o, b_on )
	local ref = o.ref
	if ref.map_dim 		then	param.set( ref.map_dim, b_on and 0 or 2 ) end
	if ref.render_front then	param.set( ref.render_front, b_on and 1 or 0 ) end
end

function OGE:set_active( b_on )
	oo.getsuper(OGE).set_active( self, b_on )
	local t = self.global_table
	for k in pairs(t) do
		self:output_set_fuz( t[k], not b_on )
		self:output_set_line( t[k], b_on )
	end
end

function OGE:add( ou, ov, obj_ref, b_no_map )
	if not ou 		then self:box_error( "ou is nil" ) 			return end
	if not ov 		then self:box_error( "ov is nil" ) 			return end
	if not obj_ref	then self:box_error( "obj_ref is nil" ) 	return end
	if obj_ref==0 	then self:box_error( "obj_ref is zero" ) 	return end

	if not self.outs[ou]		then self.outs[ou] = {}		end
	if not self.outs[ou][ov]	then self.outs[ou][ov] = {}	end
	local o = self.outs[ou][ov]
	table.insert( self.global_table, o )
	o.ou = ou
	o.ov = ov
	o.ref = { obj = obj_ref }

	self.ou_min = math.min( ou, self.ou_min )
	self.ou_max = math.max( ou, self.ou_max )
	self.ov_min = math.min( ov, self.ov_min )
	self.ov_max = math.max( ov, self.ov_max )

	local ref = o.ref
	ref.ui_draw				= param.get_ref( ref.obj, "ui_draw" )
--	ref.ui_draw_selected	= param.get_ref( ref.obj, "ui_draw_selected" )
	ref.iu					= param.get_ref( ref.obj, "ui_index_u" )
	ref.iv					= param.get_ref( ref.obj, "ui_index_v" )
	ref.nb_iu				= param.get_ref( ref.obj, "curve_nb_u" )
	ref.nb_iv				= param.get_ref( ref.obj, "curve_nb_v" )
	ref.grid_reset			= param.get_ref( ref.obj, "grid_reset_trig" )
	ref.point_reset			= param.get_ref( ref.obj, "pos_reset_trig" )
	--ref.pos_u				= param.get_ref( ref.obj, "pos_u" )
	--ref.pos_v				= param.get_ref( ref.obj, "pos_v" )

	param.set( ref.obj, "force_compute", 1 )

	obj_ref = aaa.obj.get_root( obj_ref )
	if b_no_map~=true then
		local map = aaa.obj.get_branch_by_class_no_error( obj_ref, "mapping" )
		if map then ref.map_dim = param.get_ref( map, "tex_use" ) end
	end
	local render = aaa.obj.get_branch_by_class_no_error( obj_ref, "rendering" )
	if render then ref.render_front = param.get_ref( render, "front_mode" ) end
	table.insert( self.global_table, o )
end
function OGE:start()
	--	nb of output
	self.ou = self.ou_min
	self.ov = self.ov_min
	self.ou_nb = self.ou_max - self.ou_min + 1
	self.ov_nb = self.ov_max - self.ov_min + 1

	aaa.print( "OGE: we have a "..self.ou_nb.." by "..self.ov_nb.." grid" )
	--	nb of editing points by output
	local o = self.global_table[1]
	self.iu_nb_by_output = param.get( o.ref.nb_iu ) - 2
	self.iv_nb_by_output = param.get( o.ref.nb_iv ) - 2

	self.iu_nb = 2*(self.ou_nb-1) + self.iu_nb_by_output - 1
	self.iv_nb = 2*(self.ov_nb-1) + self.iv_nb_by_output - 1

	aaa.print( "OGE: using "..self.iu_nb.." by "..self.iv_nb.." points" )

	--	we start at bottom left
	self.iu = 1
	self.iv = 1
	self.ou = 1
	self.ov = 1
end

function OGE:add_fuzzy( obj_ref )
	if not obj_ref then self:box_error( "obj_ref is nil" ) return end
	if obj_ref==0 then self:box_error( "obj_ref is zero" ) return end

	local o = self.outs[self.ou][self.ov]
	o.fuz = o.fuz or {}
	table.insert( o.fuz, obj_ref )
end
-- specialized for a 2 u grid
function OGE:inc_u()
	if not self:is_active() then return end
	if self.iu >= self.iu_nb then return end
	self.iu = self.iu + 1
	if self.iu > self.iu_nb_by_output then
		self.ou = 2
	end
end
function OGE:dec_u()
	if not self:is_active() then return end
	if self.iu <= 1 then return end
	self.iu = self.iu - 1
	if self.iu <= self.iu_nb_by_output-2 then
		self.ou = 1
	end
end
--[[
-- specialized for a 2 v grid
function OGE:inc_v()
	if not self:is_active() then return end
	if self.iv >= self.iv_nb then return end
	self.iv = self.iv + 1
	if self.iv > self.iv_nb_by_output then
		self.ov = 2
	end
end
function OGE:dec_v()
	if not self:is_active() then return end
	if self.iv <= 1 then return end2222222222222
	self.iv = self.iv - 1
	if self.iv <= self.iv_nb_by_output-2 then
		self.ov = 1
	end
end
--]]
-- specialized for a 3 v grid
function OGE:inc_v()
	if not self:is_active() then return end
	if self.iv >= self.iv_nb then return end
	self.iv = self.iv + 1
	if self.iv > self.iv_nb_by_output then
		if self.iv <= self.iv_nb_by_output + 2 then
			self.ov = 2
		else
			self.ov = 3
		end
	end
end
function OGE:dec_v()
	if not self:is_active() then return end
	if self.iv <= 1 then return end
	self.iv = self.iv - 1
	if self.iv <= self.iv_nb_by_output-2 then
		self.ov = 1
	elseif self.iv <= self.iv_nb - self.iv_nb_by_output then
		self.ov = 2
	end
end
function OGE:beep()
end
function OGE:select_bl()
	if not self:is_active() then return end
	local dv
	if self.iu == 1 or self.iu == 4 then
		dv = nil
	else
		local tv = { nil, 1, 1, 2, 2, nil }
		dv = tv[self.iv]
	end
	if dv then
		self.ou = 1
		self.ov = dv
	else
		self:beep()
	end
end
function OGE:select_br()
	if not self:is_active() then return end
	local dv
	if self.iu == 1 or self.iu == 4 then
		dv = nil
	else
		local tv = { nil, 1, 1, 2, 2, nil }
		dv = tv[self.iv]
	end
	if dv then
		self.ou = 2
		self.ov = dv
	else
		self:beep()
	end
end
function OGE:select_tl()
	if not self:is_active() then return end
	local dv
	if self.iu == 1 or self.iu == 4 then
		dv = nil
	else
		local tv = { nil, 2, 2, 3, 3, nil }
		dv = tv[self.iv]
	end
	if dv then
		self.ou = 1
		self.ov = dv
	else
		self:beep()
	end
end
function OGE:select_tr()
	if not self:is_active() then return end
	local dv
	if self.iu == 1 or self.iu == 4 then
		dv = nil
	else
		local tv = { nil, 2, 2, 3, 3, nil }
		dv = tv[self.iv]
	end
	if dv then
		self.ou = 2
		self.ov = dv
	else
		self:beep()
	end
end

function OGE:move( key, d )
	if not self:is_active() then return end
	local ref = self.outs[self.ou][self.ov].ref
	local u = param.get( ref.obj, key )
	param.set( ref.obj, key, u + d )
end
function OGE:move_u( d ) self:move( "pos_u", d ) end
function OGE:move_v( d ) self:move( "pos_v", d ) end

function OGE:reset_grid()
	if not self:is_active() then return end
	if aaa.box_ask( "ATTENTION", "remettre cette grille a zero ?" ) then
		local o = self.outs[self.ou][self.ov]
		param.set( o.ref.grid_reset, 1 )
	end
end
function OGE:reset_point()
	if not self:is_active() then return end
	local o = self.outs[self.ou][self.ov]
	param.set( o.ref.point_reset, 1 )
end

function OGE:output_update( o )
	local b_visible = self:is_active()
	local b_selected = (self.ou == o.ou) and (self.ov == o.ov)
	local ref = o.ref
	param.set( ref.ui_draw, b_visible )
--	param.set( ref.ui_draw_selected, b_selected )
	if b_selected then
		local i = self.iu - ( (o.ou-1) * (self.iu_nb_by_output-2) )
		-- ok for 2 v
		--local j = self.iv - ( (o.ov-1) * (self.iv_nb_by_output-2)
		--for 3
		local j = self.iv
		if self.ov==1 then
		elseif self.ov==2 then
			j = j - 1
		else
			j = j - 3
		end
		--aaa.print( self.ou.." "..self.ov.." - "..i.." "..j )
		param.set( ref.iu, i )
		param.set( ref.iv, j )
	end
end
function OGE:update()
	local t = self.global_table
	for k in pairs(t) do
		self:output_update( t[k] )
	end
end



--unused kept for later
--[[
function oge_max_u()
	local ov = self.ov_min
	local c = 0
	for ou = self.ou_min, self.ou_max do
		local o = self.outs[ou][ov]
		if o then
			c = c + param.get( o.ref.obj, "curve_nb_u" ) - 2
			c = c - 2 -- because of overlap
		end
	end
	if c~=0 then c = c + 2 end	-- because of overlap
	return c
end
function oge_max_v()
	local ou = self.ou_min
	local c = 0
	for ov = self.ov_min, self.ov_max do
		local o = self.outs[ou][ov]
		if o then
			c = c + param.get( o.ref.obj, "curve_nb_v" ) - 2
			c = c - 2 -- because of overlap
		end
	end
	if c~=0 then c = c + 2 end	-- because of overlap
	return c
end
--]]

--aaa.print( "OGE" )