function c5.set_popup_size_and_pos( i )
	local bu = c5.bu_popup[i]
	if bu then
		local ds = -aaa.time.dt * .5
		if not bu:get_video() then
			aaa.print( bu.." in c5.set_popup_size_and_pos() have no video" )
			return
		end
		local b_play = bu:get_video():is_playing()
		if not bu.pos_inter then bu.pos_inter = 0 end
		local inter = bu.pos_inter
		if b_play then
			ds = -ds
		end
		inter = inter + ds
		inter = clamp_01( inter + ds )
		bu.pos_inter = inter

		local s = math.min( math.pow( inter, .5 ), 1 ) * c5.ray_pop
		--s = c5.spe_curve( inter, .5, .8 ) * c5.ray_pop
		bu:set_sxy( s, s )
		if inter==0 then inter=1 end	-- so nthe editor will have the rigth position
		--if inter > .8 then
		--	inter = (inter-.8)/.2
		--	inter = math.pow( inter, .1 )
		--	inter = inter*.2+.8
		--end
		inter = c5.spe_curve( inter, 3.)
		--inter = math.pow( inter, 2.5 )

		local cx, cy = c5.bu_mire[i]:get_xy()
		local ox, oy = bu:get_pos_orig_xy()
		bu:set_xy( interpolate( cx, ox, inter ), interpolate( cy, oy, inter ) )
		-- bug when stop at end
		--if b==1 and pos.sx == 0. then
		--	bu:get_video():set_stop()
		--end
	end
end

function c5.define_gene( name, list )
	aaa.print( "c5."..name.."()" )

	local bus = BUS:create( "name" )
	--BEGIN
	bus:init_begin_add_to_ga()
		local bu = BU_OBJ:create_from_list( name, list )
		bus:add_bu( bu )
		--END
		bus:set_bu_pos_load( false )
	bus:init_end()

	return bus
end

function c5.define_cam()
	c5.define_gene( "define_cam",
						{
						"c5_cam_in",
						"c5_cam_treat_1", "c5_cam_treat_2", "c5_cam_treat_3",
						"c5_cam_treat_4", "c5_cam_treat_5", "c5_cam_treat_6",
						"c5_cam_all"
						}
					)
end
function c5.define_sol_before()
	c5.define_gene	( 	"define_sol_before",
						{	"c5_fbo_in"	}
					)
end

function c5.update_sol_fbo()
	local v = aaa.midi.get_control( c5.ch_sol, 2 )
	param.set( aaa.obj.get_by_name_symbo( "c5_fbo_in" ), "active", v )
	param.set( aaa.obj.get_by_name_symbo( "c5_6_fbo_out" ), "active", v )
end

--MARKER
function c5.define_sol_marker()
	return c5.define_gene	( 	"define_sol_marker",
								{	"c5_marker"	}
							)
end
function c5.define_sol_after()
	local v = c5.pc.simul==true and 0 or 1
	aaa.midi.set_control( c5.ch_sol, 2, v )

	local bus = c5.define_gene( 	"define_sol_after",
							{	"c5_cache_fore", "c5_6_fbo_out", "c5_test_ecran"	}
						)

end

function c5.define_size()
	c5.scale = 1.5/1.6
	c5.ray_mire = 1. * c5.scale
	c5.ray_pop = 1.3 * c5.scale
	c5.ray_text = c5.ray_mire * 1.1
end
function c5.fill_sol( bus )
	local bu
	local noms

	bu = BU_OBJ:create_from_list( "sol", {	"" } )
	bus:add_bu( bu )

	VIDEOS:set_dir_media( "Vulcania" )
	MEDIA.set_dir_media( "Vulcania" )
	local noms =	{
					"accretion",	"fusion",		"limite",
					"magnetisme",	"onde",			"point",
					"subduction",	"convection",	"volcan"
					}
	local s
	if aaa.keyboard.is_shift() then
		s = "350_32"
	else
		s = "400"
	end
	local ri = 2.2
	local re = 3.2
	local rii = 1.2

	--bu = bus:add_image( "mire", {0,0, 4,4}, "mire/text_for_rot/"..noms[1]..".png" )

	for i=1,c5.pop_nb do
		local a = ( .125 + i * .08 ) * math.pi2
		local cos = math.cos( a )
		local sin = math.sin( a )

		--bu = bus:add_video( "popup_".."1"..".mov", {1.5,2-i*.5, .7,.7} )
		--bu = bus:add_video( "popup_avi/popup_"..i..".avi", {1.5,2-i*.5, .5,.5} )
		bu = bus:add_video( "popup_avi/"..noms[i].."_"..s..".avi", {re*cos,re*sin, c5.ray_pop,c5.ray_pop} )
		c5.bu_popup[i] = bu
		bu:disable_mobile()
		bu:set_ui_active( false )
		--bu:set_video_loop( true )
		bu:set_border( false )
		bu:set_dist_circle( true )

		--bu = bus:add_image( "mire", {.5,2-i*.5, .5,.5},						"Mire/Mire_0001.png" )
		--bu = bus:add_video( "mire", {ri*cos,ri*sin, c5.ray_mire,c5.ray_mire},	"mire/mire_for_rot/mire_0001.png" )
		bu = bus:add_video( "mire/mire_100.avi", {ri*cos,ri*sin, c5.ray_mire,c5.ray_mire} )
		c5.bu_mire[i] = bu
		bu:disable_mobile()
		bu:set_video_loop( false )
		bu:set_video_play_on_page( true )
		bu:set_border( false )
		bu.blend_spe = true
		bu:set_dist_circle( true )

		bu:set_fn_on_click( c5.click, i )

		bu = bus:add_image( noms[i], {ri*cos,ri*sin, c5.ray_text,c5.ray_text}, "mire/text_for_rot/"..noms[i]..".png" )
		c5.bu_text[i] = bu
		bu:disable_mobile()
		bu.blend_spe = true
		bu:set_border( false )
	end

	---[[
	bu = BU_OBJ:create_from_list( "pizza", { "c5_pizza" } )
	bus:add_bu( bu )

	--[[
	bu = bus:add_video( "panache.avi", {0,-2.40, 3.1,3} )
	c5.bu_panache = bu
	bu:disable_mobile()
	bu:set_ui_active( false )
	bu:set_border( false )
	bu.no_edit = 1
	bu:set_video_loop( true )
	bu:set_video_play_on_page( true )
	bu.blend_spe = true
	--]]

	bu = bus:add_video( "bg_1968.avi", {0,0, 8,8} )
	c5.bu_back = bu
	bu:disable_mobile()
	bu:set_ui_active( false )
	bu:set_border( false )
	bu.no_edit = 1
	bu:set_video_loop( true )
	bu:set_video_play_on_page( true )
	--]]
end

function c5.update_before_sol( bus )
	c5.update_sol_fbo()
	--aaa.print( "bus_update_before( "..bus.." )" )
	for i=1,c5.pop_nb do
		c5.set_angle( c5.bu_popup[i] )
		c5.set_popup_size_and_pos( i )
		c5.set_angle( c5.bu_mire[i] )

		c5.bu_text[i]:set_xy( c5.bu_mire[i]:get_x(), c5.bu_mire[i]:get_y() )
		c5.bu_text[i]:set_angle( math.fmod( c5.bu_text[i]:get_angle() + aaa.time.dt / 100, 1. ) )
	end
	param.set( aaa.obj.get_by_name_symbo( "c5_test_ecran" ), "active", aaa.midi.get_control( c5.ch_sol, 1 ) )

	if c5.out then
		for i=1,6 do
			param.set( c5.out[i].ref.layer, "active", aaa.midi.get_control( c5.ch_sol, i+8 ) )
		end
	end
	--c5.bu_back:get_video():set_stop()
	--c5.bu_back:set_video_play_on_page( true )

	c5.marker_update()
end

function c5.define_sol()
	local bus = BUS:create( "define_sol" )
	--BEGIN
	bus:init_begin_add_to_ga()
		c5.fill_sol( bus )
	--END
	bus:init_end()

	bus:set_fn( "update_before",	 c5.update_before_sol	)
	--bus:set_method( "draw_after", 	c5, "draw_after_sol" )
end

function c5.update_after_cam_ui( bus )
	--aaa.print( "bus_update_before( "..bus.." )" )
	c5.marker_update()
end

function c5.img_reset_son()
	if c5.pc.b_img then
		snd.vc_init()
		c5.snd.start_nappe()
	end
end

function c5.cam_reset_son( bu )
	bu:set_value_cano( false )
	aaa.print( "c5.cam_reset_son()" )
	if c5.pc.b_cam then
		c5.send( "c5.img_reset_son()" )
	end
end

function c5.define_cam_ui()
	local bu
	local ch = c5.ch_cam
	local x,y

	local bus = BUS:create( "c5_cam_ui" )
	bus:init_begin_add_to_ga()

	local x = c5.pc.simul and 3 or -4
	local y = 2.5
	local sx = .3
	local sy = .3
	local dx = sx * 1.25
	local dy = sy * 1.25

	local st = .2

	bus:add_text( "voir camera", { x + dx*.5, y, st, st  } )
	bu = bus:add_button( "voir camera", {x,y, sx,sy} )
		bu:set_midi( c5.ch_cam, 1 )
		bu:set_text( nil )
	y = y - dy

	bus:add_text( "reset remanence", { x + dx*.5, y, st, st } )
	bu = bus:add_button( "reset remanence", {x,y, sx,sy} )
		bu:set_midi( c5.ch_cam, 2 )
		bu:set_text( nil )
	y = y - dy

	y = y - dy
	if c5.pc.b_cam then
		bus:add_text( "calibrate zone", {	x + dx*.5, y, st, st } )
		bu = bus:add_button( "calibrate zone", {x,y, sx,sy} )
		bu:set_midi( c5.ch_cam, 63 )
		bu:set_text( nil )
		y = y - dy
	elseif c5.pc.simul then
		bus:add_text( "test marker loop", {	x + dx*.5, y, st, st } )
		bu = bus:add_button( "test marker loop", {x,y, sx,sy, 0.125} )
		bu:set_midi( c5.ch_cam, 63 )
		bu:set_text( nil )
		y = y - dy
	end
	c5.bu_marker_mess = bus:add_text( "message", {	x + .5 * dx, y, st, st } )
	y = y - dy

	bus:add_text( "reset son", {	x + dx*.5, y, st, st } )
	bu = bus:add_button( "reset son", {x,y, sx,sy} )
	bu:set_fn_on_click( c5.cam_reset_son, bu )
	y = y - dy

	bus:set_bu_pos_load( false )
	bus:init_end()
	bus:set_fn( "update_after", c5.update_after_cam_ui )

	return bus
end

function c5.define_sol_ui()
	aaa.print( "define_sol_ui()" )

	local bu
	local ch = c5.ch_sol
	local x,y

	local bus = BUS:create( "c5_sol_ui" )
	bus:init_begin_add_to_ga()


	local x = c5.pc.simul and -2 or -7
	local y = c5.pc.simul and 2.5 or 3.5
	local sx = .3
	local sy = .3
	local dx = sx * 1.25
	local dy = sy * 1.25

	local xmarker =  x + 3 * dx

	local st = .2

	bus:add_text( "grid", {	x + dx*.5, y, st, st } )
	bu = bus:add_button( "grid", {x,y, sx,sy} )
	bu:set_midi( ch, 1 )
	bu:set_text( nil )
	--if c5.pc.simul then
		bus:add_text( "test marker loop", { xmarker + .5 * dx, y, st, st } )
		bu = bus:add_button( "test marker loop", {xmarker,y, sx,sy, 0.125} )
		bu:set_midi( c5.ch_cam, 63 )
		bu:set_text( nil )
	--end
	y = y - dy


	bus:add_text( "fbo", { x + dx*.5, y, st, st } )
	bu = bus:add_button( "fbo", {x,y, sx,sy} )
	bu:set_midi( ch, 2 )
	bu:set_text( nil )
	--if c5.pc.simul then
		c5.bu_marker_mess = bus:add_text( "message", { xmarker + .5 * dx, y, st, st} )
	--end
	y = y - dy

	--	button by projector
	local texts = { "haut", "milieu", "bas" }
	for j=1,3 do
		for i=1,2 do
			bu = bus:add_button( texts[i], {x+(i-1)*dx + .2,y, sx*.8,sy*.8} )
			bu:set_midi( ch, 8 + (3-j) * 2 + i )
			bu:set_text( nil )
		end
		bus:add_text( texts[j], {x + 2 * dx,y, st,st} )
		y = y - dy
	end

	bus:set_bu_pos_load( false )
	bus:init_end()

	return bus
end

if IS_BUSS_OPEN() then
	aaa.print_inverse( "___ VULCANIA C5 SCRIPT START ___" )
	c5.img_reset_son()
	c5.init()

	if c5.pc.simul then
		c5.pc.b_cam = false
		c5.pc.b_img = not c5.pc.b_cam
	end

	c5.define_size()

	if c5.pc.b_cam then
		c5.define_cam()
		local bus = c5.define_cam_ui()
		ga:register_ui_group( bus )
	else
		c5.define_sol_before()
		c5.define_sol()
		c5.bus_marker = c5.define_sol_marker()
		c5.define_sol_after()

		local bus = c5.define_sol_ui()
		ga:register_ui_group( bus )
		bus:set_active( false )
	end
--	c5.ui_sol_pages_define()
end