if  aaa.lua.global.declare_table( "c5_np" ) then
	c5_np.th = {	min_sx=.04, min_sy=.04, max_sx=.25, max_sy=.25,
					dx=.06, dy=.06,
				}
end

function c5_np.pt_make( index, min_x, min_y, max_x, max_y )
	local t = {}
	t.index = index
	t.min_x = min_x
	t.max_x = max_x
	t.min_y = min_y
	t.max_y = max_y
end

function c5_np.rect_get_from_anal( index )
	local anal = c5.vin.ref[index].anal
	local t = {}
	t.index = index
	t.min_x = param.get( anal, "out_min_u" )
	t.max_x = param.get( anal, "out_max_u" )
	t.min_y = param.get( anal, "out_min_v" )
	t.max_y = param.get( anal, "out_max_v" )
	t.sx = t.max_x - t.min_x
	t.sy = t.max_y - t.min_y
	t.x = (t.max_x + t.min_x) * .5
	t.y = (t.max_y + t.min_y) * .5
	if t.sx < c5_np.th.min_sx then return nil end
	if t.sx > c5_np.th.max_sx then return nil end
	if t.sy < c5_np.th.min_sy then return nil end
	if t.sy > c5_np.th.max_sy then return nil end
	return t
end
function c5_np.pat_build_from_anal()
	local t = {}
	for i=1,6 do
		local elt = c5_np.rect_get_from_anal( i )
		if elt then
			table.insert( t, elt )
		end
	end
	if #t > 0 then
		return t
	end
	return nil
end

function c5_np.zone_add( t, index, min_x, min_y, max_x, max_y )
	table.insert( t, c5_np.pt_make( index, min_x, min_y, max_x, max_y ) )
end

function c5_np.rect_is_similar( a, b )
	if math.abs( a.min_x - b.min_x ) > c5_np.th.dx then return false end
	if math.abs( a.min_y - b.min_y ) > c5_np.th.dy then return false end
	if math.abs( a.max_x - b.max_x ) > c5_np.th.dx then return false end
	if math.abs( a.max_y - b.max_y ) > c5_np.th.dy then return false end
	return true
end

function c5_np.zone_is_similar( a, b )
	if not (a.index == b.index) then return false end
	return c5_np.rect_is_similar( a, b )
end

function c5_np.pat_is_similar( a, b )
	local nb = #a
	if not ( nb == #b ) then return false end
	for i=1,nb do
		if not c5_np.zone_is_similar( a[i], b[i] ) then return false end
	end
	return true
end

function c5_np.build_zone_str(t)
	local str = "{ "
	for field, value in pairs(t) do
		str = str..field.."="..value..", "
	end
	str = str.." }"
	return str
end
function c5_np.build_pat_str(i,t)
	local str = "c5.marker.targets["..i.."] =\n{\n"
	for i=1, #t do
		str = str.."\t"..c5_np.build_zone_str( t[i] )..",\n"
	end
	str = str.." }\n"
	aaa.print( str )
	return str
end

function c5.show_zone_low( index, prog )
	if not c5.bu_mire then return end

	if index > 0 then aaa.print( "c5.show_zone_low( "..index..", "..prog..")" ) end

	if c5.pc.b_img then
		c5.marker.index = index
		c5.marker.prog = prog
	end
	if index==0 then
		if c5.bus_marker then c5.bus_marker:set_active( false ) end
		return
	end
	prog = math.min( prog, 1. )
	if c5.bus_marker then c5.bus_marker:set_active( true ) end

	local x,y = c5.bu_mire[index]:get_xy()
	local ref = aaa.obj.get_by_name_symbo( "c5_marker_transfo" )
	param.set( ref, "translate_x", x )
	param.set( ref, "translate_y", y )

	ref = aaa.obj.get_by_name_symbo( "c5_marker_cone" )
	param.set( ref, "u_center", -prog*.5 - .25 )
	param.set( ref, "u_range", prog )
end

function c5.show_zone( index, prog )
	--aaa.print( "c5.show_zone( "..index..", "..prog..")" )
	if c5.pc.b_cam then
		--aaa.print( "send c5.show_zone( "..index..", "..prog..")" )
		c5.send( "c5.show_zone_low( "..index..", "..prog..")" )
	else
		c5.show_zone_low( index, prog )
	end
end

function c5.marker_start()
	local m = c5.marker
	m.b_calib = true
	m.index = 1
	m.prog = 0.
	m.target = {}
	m.str_to_save = "c5.marker.targets = {}\n"
end
function c5.marker_stop()
	local m = c5.marker
	m.b_calib = false
	m.index = 0
	m.prog = 0.
end

function c5.marker_load()
	aaa.print( "c5.marker_load()" )
	aaa.file.do_if_exist( "c5_pat.lua" )
	aaa.print( table.show( c5.marker.targets, "c5.marker.targets" ) )
end

function c5.marker_save( str )
	local file = aaa.file.open( "c5_pat.lua", "w" )
	if file then
		file:write( "-- pattern for popup\n" )
		file:write( str )
		file:close()
	end
	c5.marker_load()
end

function c5.marker_do_popup(ip)
	--aaa.print( "c5.marker_do_popup("..ip..")" )
	local targets = c5.marker.targets[ip]
	--aaa.print( table.show( targets, "targets" ) )
	for i=1, #targets do
		--aaa.print( "target "..i )
		local target = targets[i]
		local index = target.index
		--index = 4
		--aaa.print( "index "..index )
		local anal = c5.vin.ref[index].anal
		param.set( anal, "find_rect", 0 )

		param.set( anal, "begin_u", target.min_x )
		param.set( anal, "begin_v", target.min_y )
		param.set( anal, "end_u", target.max_x )
		param.set( anal, "end_v", target.max_y )
--[[
		param.set( anal, "begin_u", .40 )
		param.set( anal, "begin_v", .40 )
		param.set( anal, "end_u", .60 )
		param.set( anal, "end_v", .60 )
--]]
		aaa.obj.update_then_draw( c5.vin.ref[index].layer_anal )
		local cov = param.get( anal, "out_coverage" )
		param.set( anal, "find_rect", 1 )
		if cov > .00 then
			--aaa.print( "cov in "..ip.." "..i.." "..index )
			c5.click( ip )
			return
		end
	end
end

function c5.marker_do()
	if not c5.vin then return end
	for i=1,9 do
		c5.marker_do_popup(i)
	end
end

function c5.marker_update_calib()
	local m = c5.marker
	if c5.pc.simul then
		m.prog = m.prog + aaa.time.dt * .25
		if m.prog > 1. then
			m.prog = 0.
			m.index = m.index + 1
			if m.index > 9 then
				c5.marker_stop()
				return
			end
		end
	else
		if c5.vin then
			for i=1,6 do
				local anal = c5.vin.ref[i].anal
				param.set( anal, "begin_u", 0 )
				param.set( anal, "begin_v", 0 )
				param.set( anal, "end_u", 1 )
				param.set( anal, "end_v", 1 )
			end
		end
		m.prog = m.prog + aaa.time.dt * .25
		if m.prog < 1. then
			local target = m.target[m.index]
			local cur = c5_np.pat_build_from_anal()
			if not target or not cur or not c5_np.pat_is_similar( target, cur ) then
				m.target[m.index] = cur
				m.prog = 0
			end
		elseif m.prog > 2. then
			m.str_to_save = m.str_to_save..c5_np.build_pat_str( m.index, m.target[m.index] )
			m.prog = 0.
			m.index = m.index + 1
			if m.index > 9 then
				c5.marker_save( m.str_to_save )
				c5.marker_stop()
				return
			end
		end
	end
end

function c5.marker_update()
	if not c5.marker then
		c5.marker = {}
		c5.marker_stop()
		c5.marker_load()
	end

	--aaa.print( "c5.marker_update()" )
	--this trig a start of the ui calibration directly from the cameras
	local v = aaa.midi.get_control( c5.ch_cam, 63 )
	if v > .5 then
		aaa.midi.set_control( c5.ch_cam, 63, 0 )
		if c5.marker.b_calib then
			c5.marker_stop()
		else
			c5.marker_start()
		end
	end
	if c5.marker.b_calib then
		c5.marker_update_calib()
	else
		c5.marker_do()
	end
	if c5.marker.index > 0 then
		c5.bu_marker_mess:set_text( "popup "..c5.marker.index.."\n"..c5.marker.prog )
	else
		c5.bu_marker_mess:set_text( nil )
	end
	c5.show_zone( c5.marker.index, c5.marker.prog )
end
