function c5_init_out()
	c5.out = {}
	c5.out.x_nb = 2
	c5.out.y_nb = 3
	c5.out.nb = c5.out.x_nb * c5.out.y_nb
	local i = 0
	local ref
	c5.out.attrib = {}
	c5.out.attrib.ref = {}
	ref = c5.out.attrib.ref
	ref.layer = aaa.obj.get_by_name_symbo( "gabu_out_layer_attrib" )
	ref.model = aaa.layer.get_model( ref.layer )
	ref.render = aaa.layer.get_rendering( ref.layer )
	for iy=1,c5.out.y_nb do
		for ix=1,c5.out.x_nb do
			i = i + 1
			c5.out[i] = {}
			local out = c5.out[i]
			out.i = i
			out.ix = ix
			out.iy = iy
			out.b_lef = (ix == 1 )
			out.b_rig = (ix == c5.out.x_nb)
			out.b_bot = (iy == 1 )
			out.b_top = (iy == c5.out.y_nb)
			out.ref = {}
			ref = out.ref
			ref.layer	= 	aaa.obj.get_by_name_symbo( "gabu_out_layer_"..i )
			ref.grid	= 	aaa.obj.get_branch_by_class( ref.layer, "bdd_grid_adjustable" )
			ref.map		= 	aaa.layer.get_mapping( ref.layer )
			ref.shader	= 	aaa.layer.get_shading( ref.layer )
		end
	end
end

function c5_build_uv( b_min, b_max, overlap )
	aaa.print( (b_min and "true " or "false ")..(b_max and "true " or "false ") )
	local t
	if not b_min and not b_max then
		t = { 0, overlap, 1-overlap, 1 }
	elseif b_min then
		t = { 0, 1-overlap, 1, 2 }
	else
		t = { 0, overlap, 1, 2 }
	end
	aaa.print( table.show( t, "table" ) )
	return t
end

function c5_build_point_u_v()
	local out
	local ref

	ref = c5.out.attrib.ref
	aaa.obj.update( ref.layer )

	for i=1,c5.out.nb do

		out = c5.out[i]
		ref = out.ref
		local intercept = param.get( ref.grid, "ui_intercept" )
		local iu = param.get( ref.grid, "ui_index_u" )
		local iv = param.get( ref.grid, "ui_index_v" )
		param.set( ref.grid, "ui_intercept", 0 )

		local nb_x = 6
		if out.b_lef then nb_x = nb_x - 1 end
		if out.b_rig then nb_x = nb_x - 1 end
		local nb_y = 6
		if out.b_bot then nb_y = nb_y - 1 end
		if out.b_top then nb_y = nb_y - 1 end
		aaa.print( "i "..i.." nb_x="..nb_x.." nb_y="..nb_y )
		param.set( ref.grid, "curve_nb_u", 6 )
		param.set( ref.grid, "curve_nb_v", 6 )
		param.set( ref.grid, "grid_reset_trig", 1 )
		aaa.obj.update( ref.grid )

		local val
		nb_x = nb_x-2
		val = c5_build_uv( out.b_lef, out.b_rig, c5.out.x_overlap )
		for i=1,4 do
			param.set( ref.grid, "ui_index_u", i )
			aaa.obj.update_params( ref.grid )
			param.set( ref.grid, "ui_u", val[i] )
			aaa.obj.update_params( ref.grid )
		end

		nb_y = nb_y-2
		val = c5_build_uv( out.b_bot, out.b_top, c5.out.y_overlap )
		aaa.print( table.show( val, nb_y.." val=" ) )

		for i=1,4 do
			param.set( ref.grid, "ui_index_v", i )
			aaa.obj.update_params( ref.grid )
			param.set( ref.grid, "ui_v", val[i] )
			aaa.obj.update_params( ref.grid )
		end
		param.set( ref.grid, "curve_nb_u", nb_x+2 )
		param.set( ref.grid, "curve_nb_v", nb_y+2 )
		param.set( ref.grid, "ui_intercept", intercept )
		param.set( ref.grid, "ui_index_u", iu )
		param.set( ref.grid, "ui_index_v", iv )
		param.set( ref.grid, "grid_reset_trig", 1 )
		aaa.obj.update( ref.grid )
	end
end


function c5_adjust_geo()
	local master = c5.out
	master.x_size_one = 1.97
	master.y_size_one = 1.60

	master.x_overlap = .138
	master.y_overlap = .251

	local b_test = true

	if true then
		master.x_dist = 2
		master.y_dist = 1.6
	else
		master.x_dist = master.x_size_one * ( 1 - master.x_overlap )
		master.y_dist = master.y_size_one * ( 1 - master.y_overlap )
	end

	local ref
	ref = c5.out.attrib.ref
	param.set( ref.model, "size_u", master.x_size_one )
	param.set( ref.model, "size_v", master.y_size_one )
	--aaa.obj.update( ref.layer )

	for i=1,c5.out.nb do
		local out = c5.out[i]
		ref = out.ref
		if false then
			param.set( ref.grid, "center_x", (out.ix*2-3) * master.x_dist * .5 )
			param.set( ref.grid, "center_y", (out.iy-2) * master.y_dist )
		else
			param.set( ref.grid, "center_x", c5.out.ox[i] * master.x_dist  )
			param.set( ref.grid, "center_y", c5.out.oy[i] * master.y_dist *.5 )
		end
		param.set( ref.grid, "grid_reset_trig", 1 )
			local dx = 1 / ( master.x_nb - master.x_overlap * ( master.x_nb - 1 ) )
		param.set( ref.shader, "fu_02_b_z", dx )
		param.set( ref.shader, "fu_02_r_x", (out.ix-1) * dx * (1-master.x_overlap)  )
		local dy = 1 / ( master.y_nb - master.y_overlap * ( master.y_nb - 1 ) )
		param.set( ref.shader, "fu_02_a_w", dy )
		param.set( ref.shader, "fu_02_g_y", (out.iy-1) * dy * (1-master.y_overlap)  )
		param.set( ref.shader, "fu_float_01", out.b_lef and 0 or master.x_overlap  )
		param.set( ref.shader, "fu_float_02", out.b_rig and 0 or master.x_overlap  )
		param.set( ref.shader, "fu_float_03", out.b_bot and 0 or master.y_overlap  )
		param.set( ref.shader, "fu_float_04", out.b_top and 0 or master.y_overlap  )
		--aaa.obj.update( ref.layer )
	end
end

function c5_set_render_line( b_on )

	param.set( c5.out.attrib.ref.render, "front_mode", b_on and 1 or 0 )
	for i=1,c5.out.nb do
		local out = c5.out[i]
		ref = out.ref
		param.set( ref.shader, "fu_int_01", b_on and 1 or 0 ) --	o ok, 1 plain color
		param.set( ref.shader, "fu_int_02", 0 ) --	fuzzy by eight
		--param.set( ref.grid, "ui_intercept", 0 )
		param.set( ref.grid, "ui_draw", b_on and 1 or 0 )
	end
end

function c5_adjust_render()

	for i=1,c5.out.nb do
		local out = c5.out[i]
		ref = out.ref
		param.set( ref.map, "blend_equation", 2 )
		if true then
			param.set( ref.map, "blend_src", 1 )
			param.set( ref.map, "blend_dst", 1 )
		else
			param.set( ref.map, "blend_src", 6 )
			param.set( ref.map, "blend_dst", 7 )
		end
		param.set( ref.shader, "fu_01_a_w", .40	) --	gamma
		--aa.param.set( ref.shader, "fu_01_a_w", .0 ) --	gamma
		param.set( ref.grid, "nb_u", 26	)
		param.set( ref.grid, "nb_v", 17	)

		--aaa.obj.update( ref.layer )
	end
end

if c5 and not c5.out then c5_init_out() end

if c5 and c5.out then
	c5.out.ox = { 1,  1,	-1,  0,		-1, 0 }
	c5.out.oy = { 1, -1,	-1,	-1,		 1,	1 }
end

--if c5 and c5.out then c5_adjust_geo() end
--if c5 and c5.out then c5_build_point_u_v() end
if c5 and c5.out then c5_adjust_render() end

