--[[
function split( str, delim, max_nb )
	-- Eliminate bad cases...
	if string.find( str, delim ) == nil then
		return { str }
	end
	if max_nb == nil or max_nb < 1 then
		max_nb = 0    -- No limit
	end
	local	result = {}
	local	pat = "(.-)" .. delim .. "()"
	local	nb = 0
	local	last_pos
	for part, pos in string.gmatch( str, pat ) do
		nb = nb + 1
		result[ nb ] = part
		last_pos = pos
		if nb == max_nb then break end
	end
	-- Handle the last field
	if nb ~= max_nb then
		result[ nb + 1 ] = string.sub( str, last_pos )
	end
	return result
end
--]]

function string:split( delimiter )
	local	result = {}
	local	from  = 1
	local	delim_from, delim_to = string.find( self, delimiter, from  )
	while delim_from do
		table.insert( result, string.sub( self, from , delim_from - 1 ) )
		from  = delim_to + 1
		delim_from, delim_to = string.find( self, delimiter, from  )
	end
	table.insert( result, string.sub( self, from  ) )
	return result
end
-- Medialon Commands
if aaa.lua.global.declare_table( "medialon" ) then
	medialon.dst = 3
end
function medialon.send( str )
	aaa.print( "sending "..str )
	aaa.net.send_text8( medialon.dst, str )
end

function medialon.camera_color()
	medialon.send( "cam_color" )
	--medialon.send( "camcolor" )
end

function medialon.camera_nb()
	medialon.send( "cam_nb" )
end

function medialon.leds_on()
	medialon.send( "led_on" )
end

function medialon.leds_off()
	medialon.send( "led_off" )
end

--aaa.print( "tst" )
--medialon.camera_color()
--b_ok = nil
--if b_ok == nil then
--	medialon.leds_off()
--	b_ok = true
--end

function medialon.led( index, b_off )
	if index ~= nil then
		local state = 0
		if b_off then
			state = 1
		end
		medialon.send( string.format( "led_%2d_%d", index, state ) )
	end
end

function medialon.set_vol_master_low( vol )
	if c5.pc.b_img then
		aaa.print( "medialon.set_vol_master_low() :" .. vol )
		snd.set_master_vol( vol )
	end
end
--snd.set_master_vol( -40 )
function medialon.set_vol_master( vol )
	if c5.pc.b_cam then
		aaa.print( "medialon.set_vol_master() :" .. vol )
		c5.send( "medialon.set_vol_master_low( "..vol.." )" )
	end
end

function medialon.process( str )
--	local	command = str.split( "\\" )
	aaa.print( "medialon.process( "..str.." )" )

	local medialon_str = "//aaa//vc5//"
	if string.find( str, medialon_str.."volbas" ) then
		aaa.print( "Vol Bas received from Medialon" )
		-- set sound vol
		medialon.set_vol_master( snd.vol_bas )
	elseif string.find( str, medialon_str.."volhaut" ) then
		aaa.print( "Vol Haut received from Medialon" )
		-- set sound vol
		medialon.set_vol_master( snd.vol_haut )

	end

	--[[
	local	command = split( str, "//" )
	table.print( command, "huhu", 4 )
	if command ~= nil then
		if command[ 2 ] ~= nil and command[ 2 ] == "aaa" then
			aaa.print( "command 2 "..command[ 2 ] )
			if command[ 3 ] ~= nil and command[ 3 ] == "vc5" then
				aaa.print( "command 3 "..command[ 3 ] )
				if command[ 4 ] ~= nil then
					aaa.print( "command 4 "..command[ 4 ] )
					if command[ 4 ] == "volbas" then
						aaa.print( "Vol Bas received from Medialon" )
						-- set sound vol
							aaa.print( command[ 4 ] )
							medialon.set_vol_master( snd.vol_bas )
							--snd.vol_master( snd.vol_bas )
					elseif command[ 4 ] == "volhaut" then
						aaa.print( "Vol Haut received from Medialon" )
						-- set sound vol
							medialon.set_vol_master( snd.vol_haut )
							--snd.vol_master( snd.vol_haut )
					elseif command[ 4 ] == "shutdown" then
						aaa.print( "Shutdown received from Medialon" )
						-- shutdown
						c5.shutdown()
					end
				end
			end
		end
	end
	]]--
end

function aaa.net.hook_receive_text8( str )
	aaa.print( "Lua net.hook_receive_text8()" )
	if str ~= nil then
		medialon.process( str )
	end
	--aaa.print( tostring(str) )
end

--str = "//aaa//vc5//shutdown"
--medialon.process( str )
--table1 = split( str, "//" )
--for index,today in pairs(table1) do
--	aaa.print( "String Split : "..index.." "..today )
--end
--table2 = str.split( str, "\\" )
--for index,today in pairs(table1) do
--	aaa.print( "String.split : "..index.." "..today )
--end

