local c5_cam_in_index = { 0, 1, 3, 4, 5, 6 }

local function c5_sync_treat()
	if not c5.vin then return end

	local ref = c5.vin.ref
	local v = aaa.midi.get_control( c5.ch_cam, 2 )
	if v > .5 then
		param.set( ref[1].cvmulti, "remanence_restart_trig", 1 )
		aaa.midi.set_control( c5.ch_cam, 2, 0 )
	end
	for i=2,6 do
		--aaa.print( c5_vin.ref[i].cvmulti )
		aaa.obj.set_param_from_skip( ref[i].cvmulti,	ref[1].cvmulti,	10	)
		aaa.obj.set_param_from_skip( ref[i].anal,	ref[1].anal, 	3,		3	)
	end
	for i=1,6 do
		if c5.pc.simul then
			param.set( ref[i].cvmulti, "image_src", 38	)
		else
			param.set( ref[i].cvmulti, "image_src", 38 + i - 1	)
		end
		param.set( ref[i].bind_offset, 32 + i-1 )


		param.set( ref[i].cvmulti,	"image_dst_base", 44 + i - 1	)
		param.set( ref[i].anal,		"image_src", 44 + i - 1	)

		ref[i].cov	= param.get( ref[i].anal,	"out_coverage" 	)
		ref[i].cu	= param.get( ref[i].anal,	"out_center_u" 	)
		ref[i].cv	= param.get( ref[i].anal,	"out_center_v" 	)
		ref[i].su	= param.get( ref[i].anal,	"out_size_u" 	)
		ref[i].sv	= param.get( ref[i].anal,	"out_size_v" 	)
	end
	--aaa.print( aaa.script.get_name() )
end

local function c5_video_in_init()
	if c5.vin then return end

	c5.vin = {}
	c5.vin.ref = {}
	local ref

	for i=1,6 do
		c5.vin.ref[i] = {}
		ref = c5.vin.ref[i]
		--layer
		ref.layer = aaa.obj.get_by_name_symbo( "c5_video_layer_"..i )
		--active
		ref.layer_active = param.get_ref( ref.layer, "active" )
		--param.set( ref.layer_active, 0 )
		--video
		ref.video = aaa.obj.get_branch_by_class( ref.layer, "tex_video" )
		param.set( ref.video, "capture_type", 1 )
		param.set( ref.video, "capture_running", 1 )
		param.set( ref.video, "capture_device_index", c5_cam_in_index[i] )
		param.set( ref.video, "image_on_cpu_wanted", 1 )
		-- 2025 Feb try to salvage vulcania
		param.set( ref.video, "bind_dst", 32 + 6 + i - 1 )
		--param.set( ref.video, "image_on_cpu_dst", 32 + 6 + i - 1 )
		--bind
		aaa.layer.set_bind_2d( ref.layer, 0 )
		ref.bind_offset = param.get_ref( ref.layer, "bind_2d_offset" )
		param.set( ref.bind_offset, 32+i-1	)

		--cvmultitouch
		ref.cvmulti = aaa.obj.get_by_name_symbo( "c5_cvmulti_"..i )
		--aaa.print( ref.cvmulti, c5_vin.ref[i].cvmulti )
		--anal
		ref.anal = aaa.obj.get_by_name_symbo( "c5_anal_"..i )
		--aaa.print( ref.anal )
		ref.layer_anal = aaa.obj.get_root( ref.anal )
		param.set( ref.layer_anal, "bind_2d", 12 )
		param.set( ref.layer_anal, "bind_2d_offset", i-1 )
	end

	ref = c5.vin.ref
	ref.text = aaa.obj.get_by_name_symbo( "c5_cam_text" )
	ref.text_str = param.get_ref( ref.text, "text" )

	ref.layer_grid = aaa.obj.get_by_name_symbo( "c5_cam_layer_grid" )

	ref.cov_layer = aaa.obj.get_by_name_symbo( "c5_visu_coverage" )
	ref.cov_grid = aaa.obj.get_branch_by_class( ref.cov_layer, "bdd_grid" )
	ref.cov_model = aaa.layer.get_model( ref.cov_layer )
end

c5_video_in_init()
c5_sync_treat()