APP.DECLARE( "TABLE_KINECT", APP )

function TABLE_KINECT:init_app( ... )
	self.time_start = aaa.time.t

	if not oo.getsuper(TABLE_KINECT).init_app( self, ... ) then return end

	param.set( "table_kinect_blob_tracker", "active", false )
	self.no_max_count = 0

	if aaa.pc.is_maa() then
	else
	end

	param.set( aaa.ref.pref, "keyboard_country", aaa.pc.is_maa() and "UK" or "France" )

	local ref = self.ref

	--KINECT
	ref.kinect_layers	=	aaa.obj.get(	"table_kinect_layers"		)
	ref.kinect_texvideo	=	aaa.obj.get(	"table_kinect_texvideo"		)
	ref.kinect			=	aaa.obj.get(	"table_kinect_kinect"		)
		ref.kinect_nb		=	param.get_ref(	ref.kinect,		"camera_nb_present" )
	ref.kinect_cam		=	aaa.obj.get(	"table_kinect_cam"			)
	ref.kinect_map		=	aaa.obj.get(	"table_kinect_map"			)
	ref.open_cv			=	aaa.obj.get(	"table_kinect_openCV"		)
		ref.restart			=	param.get_ref(	ref.open_cv,	"remanence_restart_trig" )
		ref.accum			=	param.get_ref(	ref.open_cv,	"remanence_accumulate_max" )
		ref.max_found		=	param.get_ref(	ref.open_cv,	"remanence_max_found"	)
		ref.erode			=	param.get_ref(	ref.open_cv,	"erode"	)
		ref.dilate			=	param.get_ref(	ref.open_cv,	"dilate"	)
	ref.contour			=	aaa.obj.get(	"table_kinect_img_contour"	)
	ref.tracker			=	aaa.obj.get(	"table_kinect_blob_tracker"	)
		ref.filter				=	param.get_ref(	ref.tracker,	"filter" )
		ref.tracker_active		=	param.get_ref(	ref.tracker,	"active" )

	self.b_need_accum = true

	return true
end

function TABLE_KINECT:base_define()
	local bus = BUS:begin_window( "Table Kinect" )

	local bu

	local	function add_slider( text )
		local bu = bus_cur:add_slider( text )
		return bu
	end

	local ref = self.ref

	bus:move_prev()
	bus:add_but_trig_fn( "Focus Capture",	nil, aaa.obj.set_focus_ui, 	self.ref.kinect_texvideo )	:set_color_back("focus")
	bus:add_but_trig_fn( "Focus Kinect",	nil, aaa.obj.set_focus_ui,	self.ref.kinect )			:set_color_back("focus")
	bu = add_slider( "Motor" )
		bu:set_target_param( param.get_ref( self.ref.kinect, "motor_position") )

	bus:move_next()
	bu = bus:add_button( "Flip Y" )
		bu:set_target_param( param.get_ref( ref.kinect_texvideo, "flip_vertical") )
	bu = add_slider( "Min" )
		bu:set_target_param( param.get_ref( ref.kinect, "depth_raw_min") )
		bu:set_min_max( 0, 1 )
	bu = add_slider( "Max" )
		bu:set_target_param( param.get_ref( ref.kinect, "depth_raw_max") )
		bu:set_min_max( 0, 1 )

	bus:move_next()
	bu = add_slider( "Rot" )
		bu:set_target_param( param.get_ref( ref.kinect_cam, "rot_z") )
		bu:set_min_max(	-1, 1 )
	bu = add_slider( "size" )
		bu:set_target_param( param.get_ref( ref.kinect_cam, "ortho_size") )
		bu:set_min_max(	-1, 1 )
	bu = add_slider( "Left" )
		bu:set_target_param( param.get_ref( ref.kinect_map, "tex_left") )
		bu:set_min_max(	0, 1 )
	bu = add_slider( "Right" )
		bu:set_target_param( param.get_ref( ref.kinect_map, "tex_right") )
		bu:set_min_max(	0, 1 )
	bu = add_slider( "Top" )
		bu:set_target_param( param.get_ref( ref.kinect_map, "tex_top") )
		bu:set_min_max(	0, 1 )
	bu = add_slider( "Bottom" )
		bu:set_target_param( param.get_ref( ref.kinect_map, "tex_bottom") )
		bu:set_min_max(	0, 1 )

	bus:move_next_col()
	bu = bus:add_trig( "Reset" )
		bu:set_target_param( ref.restart )
	bu = bus:add_button( "Accumalate" )
		bu:set_target_param( ref.accum )
		self.bu_accum = bu
	bu = add_slider( "Area" )
		bu:set_target_param( param.get_ref( ref.contour, "blob_area_min" ) )
		bu:set_min_max(	0, 5000 )
	bu = add_slider( "Size_x" )
		bu:set_target_param( param.get_ref( ref.contour, "blob_size_x_min" ) )
		bu:set_min_max(	0, .2 )
	bu = add_slider( "Size_y" )
		bu:set_target_param( param.get_ref( ref.contour, "blob_size_y_min" ) )
		bu:set_min_max(	0, .2 )
	bu = add_slider( "Filter blob" )
		bu:set_target_param( ref.filter )
		bu:set_min_max(	0, .99 )

	bus:end_window()
	--bus:set_method( "draw_after",	self,	"draw_ui_back"	)

	return bus
end

function TABLE_KINECT:define_app_ui()

	local bu

	local bus = BUS:create( "TK" )
	bus:set_active( true )
	bus:init_begin_add_to_ga()

	bu = bus:add_window( "Base", self:base_define(),	{0,0, 2,2} )

		local function add_monitor( name, bind, x, y, sx, sy )
			return bus:add_monitor( name, {x,y, sx or 2,sy or 1}, bind  )
		end

	--	 add_monitor(	name,				bind,	x,	y,		sx,		sy		)
	bu = add_monitor(	"32-Raw",			32,		-2,	1.5,	1.3333,	1.		)
	bu = add_monitor(	"33-Transformed",	33,		-2,	.5		)
	bu = add_monitor(	"40-Accum",			40,		-2,	-.5		)
	bu = add_monitor(	"35-diff",			35,		-2,	-1.5	)
	bu = add_monitor(	"34 result",		34,		2,	0.5		)
--	bu = add_monitor(	"41-contour",		35,		2,	-.50	)

	bus:init_end()

	ga:register_ui_group( bus )
	ga:set_ui_group_active( true )

	return bus
end

local function show_no_print( mess_in )
	if app.mess_in == mess_in then return end
	app.mess_in = mess_in
	local mess = aaa.mess
	param.set( mess.ref.text, mess_in )
	mess.time_left = 2.
end

local CALIBRATION_TIME = 360.	-- en secondes
function TABLE_KINECT:update()
	APP.update( self )

	local nb = param.get( self.ref.kinect_nb )
	ga:set_ui_group_active( nb~=0 )
	if nb==0 then
		local r = wrap_01( aaa.time.t )
		if r < .05 then
			aaa.mess.show( "pas de KINECT", 3. )
		end
		return
	end

	if self.time_start then
		local max_found = param.get( self.ref.max_found )
		show_no_print( math.floor( CALIBRATION_TIME - ( aaa.time.t - self.time_start ) ).." secs a attendre : "..max_found )
		local b_done = false
		if aaa.time.t < ( self.time_start + CALIBRATION_TIME ) then
			if aaa.time.t < ( self.time_start + 1. ) then
				param.set( self.ref.restart, true )
			end
			if self.b_need_accum  then
				self.bu_accum:set_value( 1 )
				self.b_need_accum = false
			end
			if max_found > 0 then
				self.no_max_count = 0
			else
				self.no_max_count = self.no_max_count + 1
				if self.no_max_count > 100 then
					b_done = true
					aaa.mess.show( "KINECT calibrated only in "..(aaa.time.t - self.time_start) )
				end
			end
		else
			b_done = true
			aaa.mess.show( "KINECT calibrated after "..CALIBRATION_TIME )
		end
		if b_done then
			self.bu_accum:set_value( 0 )
			self.time_start = nil
		end
	end

	local b = self.bu_accum:get_value() == 0
	param.set( self.ref.erode, b )
	param.set( self.ref.dilate, b )
	param.set( self.ref.tracker_active, b )
end

-- Call Zo
if IS_BUSS_OPEN() then
	APP.CREATE_INST( TABLE_KINECT )
end

