


function smartv.video_restart_slave()
	if not smartv:is_master() then
		smartv.video:set_restart()
	end
	smartv.video:set_restart()
end

function smartv.video_restart()
	smartv.send_fn( "video_restart_slave" )
	smartv.video:set_restart()
end


function smartv.video_start_separate_slave( d )
	if not smartv:is_master() then
		smartv.video_sep_d = d
	end
end

function smartv.video_start_separate( d )
	if smartv:is_master() then
		smartv.send( "if smartv.video_start_separate_slave then smartv.video_start_separate_slave("..d..") end" )
	end
	smartv.video_sep_d = d
end

	local	TC_EXPLO = 22.7
	local	TC_EXPLO_DURATION = .4
	local	TC_CRUNCH = 92.5
	local	TC_CRUNCH_DURATION = 4.

function smartv.video_update()
	local video = smartv.video
	if not video then return end

	local s = smartv

	s.video_sep = s.video_sep or 0
	if s.video_sep_d then
		s.video_sep = s.video_sep + s.video_sep_d * aaa.time.dt
		if outside( s.video_sep, 0, 1 ) then
			s.video_sep_d = nil
			s.video_sep = clamp_01( s.video_sep )
		end
		local a = s.video_sep
		if smartv:is_master() or smartv.machine_id==0 then a = 1 - a end
		param.set( s.ref.video_alpha, a )
		--aaa.print( a )
	end

	local b_play = smartv.ui.bu_video_play:get_value_as_bool()
	if b_play ~= video:is_playing() then
		video:toggle()
	end
	video:update()
	--video:set_focus()
	if not smartv:is_master() then
		return
	end

	if not video:is_playing() and b_play then
		smartv.video_restart()
	end

	smartv.vtime = smartv.video:get_time()
	--aaa.print( smartv.b_skel )


	local t = smartv.vtime
	if t < TC_EXPLO or (TC_CRUNCH + TC_CRUNCH_DURATION) < t  then
		smartv.tc_explo = nil
	elseif t < TC_CRUNCH then
		smartv.tc_crunch = nil
	end

	local state = smartv.boid_state

	if not smartv.b_skel then
		local b_need_explo	= inside( t, TC_EXPLO,	TC_EXPLO + TC_EXPLO_DURATION ) and not smartv.tc_explo
		--aaa.print( t.." "..b_need_explo.." "..smartv.tc_explo )
		local b_need_crunch	= inside( t, TC_CRUNCH,	TC_CRUNCH + TC_CRUNCH_DURATION ) and not smartv.tc_crunch

		if b_need_explo then
	--		if not smartv.b_skel then
				--really do it
				smartv.tc_explo = t
				aaa.print_inverse( "EXPLO" )
				smartv.start_boid()
	--		end
		end
		if b_need_crunch then
	--		if not smartv.b_skel then
				--really do it
				smartv.tc_crunch = t
				aaa.print_inverse( "CRUNCH" )
				smartv.stop_boid()
	--		end
		end
 	end

	if smartv.tc_explo and t > (smartv.tc_explo + TC_EXPLO_DURATION) then
		smartv.tc_explo = nil
		smartv.normal_boid( "after EXPLO" )
	end
	if smartv.tc_crunch and t > (smartv.tc_crunch + TC_CRUNCH_DURATION) then
		smartv.tc_crunch = nil
		smartv.normal_boid( "after CRUNCH" )
		smartv.restart_boid()
	end

end

function smartv.video_reset( bu )
	aaa.print( "smartv.video_reset()" )
	if smartv.video then
		smartv.video:set_restart()
	end
end
function smartv.video_set_to_explosion()
	aaa.print( "smartv.video_set_to_explosion()" )
	smartv.video:set_time(TC_EXPLO-1)
end
function smartv.video_set_to_crunch()
	aaa.print( "smartv.video_set_to_crunch()" )
	smartv.video:set_time(TC_CRUNCH-1)
end
--smartv.video_restart()
