if not smartv.ui then
	smartv.ui = {}
end

function smartv.draw_background()
	bus_cur:draw_debug_str( "Back", -4, 1.5 )

	local function conv( f ) return math.floor(f*100.)*.01 end
	local str = "TC "..conv( smartv.video:get_time() ).." / "..conv( smartv.video:get_duration() )
	smartv.ui.bu_tc_1:set_text( str )
	smartv.ui.bu_tc_2:set_text( str )

end

function smartv:draw_foreground()
	bus_cur:draw_debug_str( "Fore", -4, 1.4 )
	--	smartv.draw_boid()
end

function smartv:draw_first()
	aaa.draw_tex( 256, 2,.25, 2,1.125, "Video" )
end

function smartv:draw_second()
	local ref = self.ref

	aaa.draw_tex( 32, 1.75,.25, 2,1.5, "Capture" )

	local b = self.ui.bu_skel:get_value_as_bool()
	gol.push_matrix()
		gol.translate( 2, 3 )
		gol.scale( -2, 2, 2 )

		param.set( ref.skel_usebdd_1, "update_and_draw" )
			aaa.obj.update_then_draw( ref.skel_layer_1 )
		param.set( ref.skel_usebdd_1, b and "update_and_draw" or "update" )

		param.set( ref.skel_usebdd_2, "update_and_draw" )
			aaa.obj.update_then_draw( ref.skel_layer_2 )
		param.set( ref.skel_usebdd_2, b and "update_and_draw" or "update" )
	gol.pop_matrix()
end


function smartv.define_ui_first()
	local bus = BUS:create( "SmarTV_First" )
	bus:init_begin()

	local bup = bus:add_bup( {.2,.2, 3.7,3.6} ):set_size( 1.7, .2 )
	--bup:move_next( 2 )

	bus:add_wiz_fps()
	smartv.ui.bu_tc_1 = smartv.add_tc( bus )

	--START

	local bu

	bu = bus:add_text( "AAASeed Smart TV "..smartv.machine_name, {0.1,3.9,	.1,.1}	)
	bu:set_ui_top_size( true )
	
	local function add_but_draw( name, text, b_on, fn_name )
		local bu_name = "bu_"..name
		local function fn_change( bu )
			if fn_name then
				aaa.print( "send "..fn_name.."()" )
				smartv.send_fn( fn_name )
				aaa.print( "send "..fn_name.."() done" )
			else
				local v = bu:get_value()
				local full_name = "smartv.ui."..bu_name
				local str = "if smartv.ui and "..full_name.." then "..full_name..":set_value("..v..") end"
				--aaa.print( str )
				smartv.send( str )
			end
		end
		bu = bus:add_button( text )

		smartv.ui[bu_name] = bu
		bu:set_value( b_on )
		bu:set_fn_on_click( fn_change, bu )
		return bu
	end

	bu = add_but_draw( "grille_draw",			"Grille Draw",		false	)
	bu = add_but_draw( "particle_draw", 		"Particle Draw",	true	)
	bu = add_but_draw( "boid_draw",				"Boid Draw",		true	)
	bu = add_but_draw( "video_draw",			"Video Draw",		true	)
	bu = add_but_draw( "foreground_draw",		"Foreground Draw",	false	)

	bup:move_next()
	bu = add_but_draw( "rect_draw",				"Rect Draw",		false	)
	bu = add_but_draw( "fbo_out",				"FBO OUT",			true	)
	bu = add_but_draw( "screen",				"SCREEN",			true	)

	bup:move_next()
	bu = add_but_draw( "video_play",			"Video Play",		true	)
	bu = add_but_draw( "video_reset",			"Video Reset",		false,	"video_reset" )
		bu:set_trig()
	bu = add_but_draw( "video_set_to_explosion", "Video to explosion", false, "video_set_to_explosion" )
		bu:set_trig()
	bu = add_but_draw( "video_set_to_crunch",	"Video to crunch",	false,	"video_set_to_crunch" )
		bu:set_trig()

	bup:move_next( 1 )
	bu = add_but_draw( "reboot_slave",			"Reboot Slave",		false,	"reboot_slave"	)
		bu:set_trig()
	bu = add_but_draw( "reboot_master",			"Reboot Master",	false,	"reboot_master"	)
		bu:set_trig()

--	for i=1,32 do
--		bu = bus:add_slider( "str_"..i )
--	end

	bus:init_end()

	bus:set_transfo( 4,4, 2,2 )
	bus:set_method( "draw_before", smartv, "draw_first" )

	return bus
end

function smartv.ui.add_text( bus, text, x, y )
	local bu = bus:add_text_info( text,	{x,y, .25,.25}	)
	bu:set_ui_top_size( true )
	return bu
end

function smartv.add_tc( bus )	return smartv.ui.add_text( bus, "TC",	2, 3.6 ) end

function smartv.set_param( ref, val )
	param.set( ref, val )
end

function smartv.define_ui_second()
	local bus = BUS:create( "SmarTV_Second" )
	bus:init_begin()

	local bup = bus:add_bup( {.2,.2, 3.8,3.8} ):set_size( 1.1, .2 )

	bus:add_wiz_fps()
	smartv.ui.bu_tc_2 = smartv.add_tc( bus )
	--START

	local bu

	bu = bus:add_text( "Second "..smartv.machine_name,	{0.1,3.9,	.1,.1}	)
	bu:set_ui_top_size( true )

	bus:add_but_trig_fn( "Focus capture", nil, function() aaa.obj.set_focus_ui( smartv.ref.kinect_tex_video ) end ):set_color_back("focus")
	bus:add_but_trig_fn( "Focus Kinect",  nil, function() aaa.obj.set_focus_ui( smartv.ref.kinect ) end ):set_color_back("focus")
	bup:move_next()

	bu = bus:add_button( "skeleton" )
	smartv.ui.bu_skel = bu

	bu = bus:add_button( "No Viscosity" )
	smartv.ui.bu_vis = bu

	bu = bus:add_button( "Boid in Line" )
	bu:set_value( smartv:is_master() )
	smartv.ui.bu_boid_line = bu

	bus:add_but_trig_fn( "Birth Trig", nil,	smartv.start_boid )
	--bup:move_next()
	bus:add_but_trig_fn( "Restart", nil, smartv.restart_boid )
	bus:add_but_trig_fn( "Focus", nil, function() aaa.obj.set_focus_ui( smartv.ref.boid.bdd ) end ):set_color_back("focus")

	bus:init_end()

	bus:set_transfo( 4,4, 2,2 )
	bus:set_method( "draw_before", smartv, "draw_second" )

	return bus
end

function smartv.define_app_ui()
	smartv.ui.bus_first = smartv.define_ui_first()
	smartv.ui.bus_second = smartv.define_ui_second()

	local bu

	local bus = BUS:create( "SmartTV" )
	smartv.ui.bus = bus
	bus:set_active( true )
	bus:init_begin_add_to_ga()

		bu = bus:add_window( "Base", smartv.ui.bus_first,	{-3,0, 2,2} )
		bu = bus:add_window( "Skel", smartv.ui.bus_second,	{ 3,0, 2,2} )

	bus:init_end()

	bus:set_method( "draw_before", 	smartv, "draw_background" )
	bus:set_method( "draw_after",	smartv, "draw_foreground" )

	ga:register_ui_group( bus )
--	ga:set_ui_group_active( false )

	return bus
end