function smartv.set_time_slave( t )
	if not smartv:is_master() then
		smartv.time = t
	end
end

function smartv.draw()
	local see_rect
	if smartv:is_master() then
		see_rect = 0
	else
		see_rect = smartv.machine_id + 2
	end
	local ref = smartv.ref
	--	CAMERA and FBO
	if see_rect==0 then
		aaa.obj.update_then_draw( ref.camera_layers )
	else
		aaa.obj.update_then_draw( ref.rect[ see_rect ].camera_layers )
	end
	--	GRILLE
	if smartv.ui.bu_grille_draw:get_value_as_bool() then aaa.obj.update_then_draw( ref.grille_layers )	end
	--	RECT
	if smartv.ui.bu_rect_draw:get_value_as_bool() then
		for i=1,3 do aaa.obj.update_then_draw( ref.rect[i].layers ) end
	end
	--	PARTICLE
	if smartv.ui.bu_particle_draw:get_value_as_bool() then
		aaa.obj.update_then_draw( ref.part_grad_layer )
		aaa.obj.update_then_draw( ref.part_layer )
	end
	--	BOID
	smartv.update_boid()
	if smartv.ui.bu_boid_draw:get_value_as_bool() then
		if smartv.ui.bu_vis:get_value_as_bool() then
			param.set( ref.boid.vis, 1 )
		end
		aaa.obj.update_then_draw( ref.boid.layers )
	end
	--	PARTICLE HALO
	if smartv.ui.bu_particle_draw:get_value_as_bool() then
		aaa.obj.update_then_draw( ref.part_grad_layer )
		aaa.obj.update_then_draw( ref.part_halo_layer )
	end
	--	VIDEO
	if smartv.ui.bu_video_draw:get_value_as_bool() then
		smartv.adjust_video_size( smartv:is_master() and 2 or see_rect )
		aaa.obj.update_then_draw( ref.video_layers )
	end
	--	FOREGROUND
	if smartv:is_master() then
		if smartv.ui.bu_foreground_draw:get_value_as_bool() then aaa.obj.update_then_draw( ref.foreground_layers )	end
	end
	--	FBO_OUT
	if smartv.ui.bu_fbo_out:get_value_as_bool() then
		param.set( ref.fbo_out_bind, see_rect + 16 )
		aaa.obj.update_then_draw( ref.fbo_out_layers )
	end
	--	SCREENS
	if smartv.ui.bu_screen:get_value_as_bool() then
		if see_rect~=0 then
			smartv.draw_rects( see_rect )
		end
	end
end

function smartv.part_update()
	local ref = smartv.ref
	local nb = param.get( ref.kinect_skel_nb )

	local b_skel = nb>0
	if b_skel then
		param.set( ref.part_halo_nb_by_sec,	4096	)
		param.set( ref.part_nb_by_sec,		512		)
	else
		param.set( ref.part_halo_nb_by_sec,	0		)
		param.set( ref.part_nb_by_sec,		0		)
	end

	if smartv.b_skel ~= b_skel then
		aaa.print( "skel change to "..b_skel )
		if b_skel then
			if smartv.video_sep	and smartv.video_sep == 0 then
				smartv.stop_fast_boid()
			end
			smartv.video_start_separate( 1 )
		else
			smartv.video_start_separate( -1 )
		end
		smartv.b_skel = b_skel
	end
end

function smartv.init_fullscreen()
	--2024 June comment to access
	-- if not smartv.ref then return end
	-- local ref = smartv.ref
	-- if not ref.last_width then
	-- 	smartv.last_width = -42
	-- end
end

function smartv.force_fullscreen()
	--2024 June comment to access
	-- smartv.init_fullscreen()
	-- local ref = smartv.ref
	-- local w = aaa.get_window_size()
	-- if not smartv.last_width or smartv.last_width ~= w then
	-- 	smartv.last_width = w
	-- 	ga:force_fullscreen()
	-- end
	-- local key = aaa.keyboard.get_ascii()
	-- --aaa.print( key )
	-- if key == 32 then 	-- on space
	-- 	ga:force_fullscreen()
	-- end
end


function smartv.update()
	ga:force_fullscreen()

	if smartv:is_master() then
		smartv.time = aaa.time.t
		smartv.send_no_print( "if smartv.set_time_slave then smartv.set_time_slave( "..smartv.time.." ) end" )
	else
		smartv.time = smartv.time or 0.
	end

	if smartv:is_master() and aaa.time.t > (smartv.time_aaaseed_start + 15.) then
		aaa.obj.update_then_draw( smartv.ref.capture_layers )
	end
--[[
	if not smartv.net_started and aaa.time.t > (smartv.time_aaaseed_start + 16.) then
		aaa.net.set_active( true )
		smartv.net_started = true
	end
--]]

	smartv.read_rects()
	smartv.video_update()
	smartv.part_update()
	smartv.draw()
end
if smartv.b_init then
	smartv.update()
end

function smartv.free()
	smartv.b_init = false
end

function smartv.reboot_slave()
	if not smartv:is_master() then
		aaa.reboot_no_save()
	end
end
function smartv.reboot_master()
	if smartv:is_master() then
		aaa.reboot_no_save()
	end
end
if IS_BUSS_OPEN() then
	smartv.b_init = false
	smartv.init()
	smartv.define_app_ui()
	GABU.add_free_fn( smartv.free )
end



