if aaa.lua.global.declare_table( "smartv" ) then
	smartv.ref = {}
	smartv.time_aaaseed_start = aaa.time.t

	function smartv:is_master() 	return self.__b_master												end
	function smartv:set_master( b )	self.__b_master = b		aaa.print_inverse( "Master is now "..b )	end
end

function smartv.set_frustum()
	if not smartv.b_init then return end

	local ref = smartv.ref
	if smartv:is_master() then
		param.set( ref.camera_frustrum_x, 0 )
		param.set( ref.camera_frustrum_y, 0 )
	else
		local d = .95
		param.set( ref.camera_frustrum_x, smartv.machine_id*d )
		param.set( ref.camera_frustrum_y, 0 )
	end
end

function smartv.init_rect( ma )
	local	t = {	"a", "b", "c"	}
	local	start = "smartv_rect_"..t[ma]

	smartv.ref.rect[ma] = {}
	local ref = smartv.ref.rect[ma]

	ref.layers			= 	aaa.obj.get( start.."_layers" )
	ref.grid			= 	aaa.obj.get( start.."_grid" )
		ref.x				=	param.get_ref( ref.grid, "center_x" )
		ref.y				=	param.get_ref( ref.grid, "center_y" )
		ref.z				=	param.get_ref( ref.grid, "center_z" )
	ref.model			= 	aaa.obj.get( start.."_model" )
		ref.sx				=	param.get_ref( ref.model, "size_u" )
		ref.sy				=	param.get_ref( ref.model, "size_v" )

--	ref.trs				=	aaa.obj.get( start.."_trs" )

	ref.camera_layers	=	aaa.obj.get( start.."_camera_layers" )
		ref.camera_active	=	param.get_ref( ref.camera_layers, "active" )
	ref.camera			=	aaa.obj.get( start.."_camera" )
		ref.camera_tra_z	=	param.get_ref( ref.camera, "tra_z" )
	ref.fbo				=	aaa.obj.get( start.."_fbo" )
		ref.fbo_sx			=	param.get_ref( ref.fbo, "size_asked_x" )
		ref.fbo_sy			=	param.get_ref( ref.fbo, "size_asked_y" )

	ref.screen = {}
	for i=1,4 do
		ref.screen[i] = {}
		local r  = ref.screen[i]
		r.grid	= aaa.obj.get( start..i.."_grid" )
			r.x		=	param.get_ref( r.grid, "center_x" )
			r.y		=	param.get_ref( r.grid, "center_y" )
			r.z		=	param.get_ref( r.grid, "center_z" )
		r.model	= aaa.obj.get( start..i.."_model" )
			r.sx	=	param.get_ref( r.model, "size_u" )
			r.sy	=	param.get_ref( r.model, "size_v" )
	end
end

function smartv.init_rects()
	local ref = smartv.ref
	ref.rect = {}
	for i=1,3 do
		smartv.init_rect( i )
	end
end

local	pix_nb = 2048
local	pix_nb_over = 1 / pix_nb
local	inset_size = 16 * pix_nb_over
function smartv.read_rect( ma, tra_z )
	smartv.rect[ma] = {}
	local rect = smartv.rect[ma]
	local ref = smartv.ref.rect[ma]
	param.set( ref.camera_tra_z, tra_z )

	rect.x			=	param.get( ref.x )
	rect.y			=	param.get( ref.y )
	rect.z			=	param.get( ref.z )
	rect.sx			=	param.get( ref.sx )
	rect.sy			=	param.get( ref.sy )


	param.set( ref.fbo_sx, rect.sx * pix_nb )
	param.set( ref.fbo_sy, rect.sy * pix_nb )

	rect.screen = {}
	for i=1,4 do
		rect.screen[i] = {}
		local screen  = rect.screen[i]
		local r  = ref.screen[i]
		screen.x			=	param.get( r.x )
		screen.y			=	param.get( r.y )
		screen.z			=	param.get( r.z )
		screen.sx			=	param.get( r.sx )
		screen.sy			=	param.get( r.sy )

		screen.u			=	( screen.x - rect.x ) / rect.sx + .5
		screen.v			=	( screen.y - rect.y ) / rect.sy + .5
		screen.su			=	screen.sx / rect.sx
		screen.sv			=	screen.sy / rect.sy
	end
end

function smartv.read_rects()
	smartv.rect = {}
	local tra_z = param.get( smartv.ref.camera_tra_z )

	for i=1,3 do
		smartv.read_rect( i, tra_z )
	end
end

function smartv.draw_rects( rect_id )
	local ref = smartv.ref
	aaa.obj.update_then_draw( ref.out_att_layers )

	local rect = smartv.rect[rect_id]
	param.set( ref.out_screen_bind, 16 + rect_id )
	for i=1,4 do
		local screen = rect.screen[i]
		--	POS
		param.set( ref.out_screen_x, i*2-5 )
		--	TEX
		local su = ( screen.su - inset_size ) * .5
		local l = screen.u - su
		local r = screen.u + su
		local sv = ( screen.sv - inset_size ) * .5
		local b = screen.v - sv
		local t = screen.v + sv

		param.set( ref.out_screen_tex_flip_uv, i==3 )
		if i==3 then
			l,r,b,t = t,b,r,l
			param.set( ref.out_screen_tex_flip_uv, true )
		else
			param.set( ref.out_screen_tex_flip_uv, false )
		end
		---[[
		param.set( ref.out_screen_tex_l, l )
		param.set( ref.out_screen_tex_r, r )
		local sv = screen.sv * .5
		param.set( ref.out_screen_tex_b, b )
		param.set( ref.out_screen_tex_t, t )
		--aaa.print( screen.sv )
		--]]

		aaa.obj.update_then_draw( ref.out_screen_layer )
	end
end

local offset_x = { .028, .0, -.003 }
local offset_y = { -.01, .0, .0 }
function smartv.adjust_video_size( rect_id )
	--2024 June Maa commented for access
	-- local screen = smartv.rect[rect_id].screen[1]
	-- local ref = smartv.ref
	-- --aaa.print( smartv.machine_id )
	-- param.set( ref.video_x, screen.x + offset_x[ rect_id ] )
	-- param.set( ref.video_y, screen.y + offset_y[ rect_id ] )
	-- param.set( ref.video_sx, screen.sx *.95 )
	-- param.set( ref.video_sy, screen.sy *.95)
end
function smartv.init()

	if smartv.b_init then return end

	if aaa.pc.is_maa() or aaa.net.machine == "SMARTV_MST" then
		smartv:set_master( true )
		smartv.machine_id = 0
		smartv.machine_name = "Master 0"
	else
		if aaa.net.machine == "SMARTV_A" then
			smartv.machine_id = -1
		elseif aaa.net.machine == "SMARTV_B" then
			smartv.machine_id = 0
		elseif aaa.net.machine == "SMARTV_C" then
			smartv.machine_id = 1
		end
		smartv:set_master( false )
		--smartv.machine_id = aaa.net.host_id - 62
		--smartv.machine_name = "Slave "..select( smartv.machine_id, {"A Gauche", "B Centre", "C Droite"} )
		local str = {"A Gauche", "B Centre", "C Droite" }
		smartv.machine_name = "Slave "..str[ smartv.machine_id+2]
	end

	if not smartv:is_master() then
		--2024 June Maa commented for access
		--aaa.flatland.set_draw( false )
		--aaa.set_lua_silent()
	end
	param.set( aaa.ref.app, "quit_do_save", smartv:is_master() )

	local ref = smartv.ref
	smartv.init_rects()

	--KINECT
	ref.kinect_tex_video	=	aaa.obj.get( "smartv_capture_texvideo" )
	ref.kinect				=	aaa.obj.get( "smartv_kinect_ui" )
	param.set( ref.kinect, "skeleton_select_min_x", -.6 )
	param.set( ref.kinect, "skeleton_select_max_x", .3 )
	param.set( ref.kinect, "skeleton_select_min_y", -1. )
	param.set( ref.kinect, "skeleton_select_max_y", 9.261 )
	param.set( ref.kinect, "skeleton_select_min_z", 2 )
	param.set( ref.kinect, "skeleton_select_max_z", 3.30921 )
	--ref.kinect				=	aaa.obj.get( "smartv_kinect" )
	ref.kinect_skel_nb		=		param.get_ref( ref.kinect, "skeleton_nb_tracked" )
	ref.kinect_body_nb		=		param.get_ref( ref.kinect, "body_seen_nb" )

	--SKELETON
	ref.skel				=	aaa.obj.get( "smartv_skeleton_1" )
	ref.skel_layer_1		=	aaa.obj.get( "smartv_skel_layer_1" )
	ref.skel_usebdd_1			=	param.get_ref(  ref.skel_layer_1, "use_bdd" )
	ref.skel_layer_2		=	aaa.obj.get( "smartv_skel_layer_2" )
	ref.skel_usebdd_2			=	param.get_ref(  ref.skel_layer_2, "use_bdd" )

	--PARTICLE
	ref.part_layers			=	aaa.obj.get( "smartv_part_layers" )
	ref.part_grad_layer		=	aaa.obj.get( "smartv_part_grad_layer" )
	ref.part_halo_layer		=	aaa.obj.get( "smartv_part_halo_layer" )
	ref.part_halo_bdd		=	aaa.obj.get( "smartv_part_halo_bdd" )
	ref.part_halo_nb_by_sec		=	param.get_ref(  ref.part_halo_bdd, "nb_by_sec" )
	ref.part_layer			=	aaa.obj.get( "smartv_part_layer" )
	ref.part_bdd			=	aaa.obj.get( "smartv_part_bdd" )
	ref.part_nb_by_sec			=	param.get_ref(  ref.part_bdd, "nb_by_sec" )
	ref.part_trs			=	aaa.obj.get( "smartv_part_trs" )
	ref.part_x					=	param.get_ref(  ref.part_trs, "translate_x" )
	ref.part_y					=	param.get_ref(  ref.part_trs, "translate_y" )
	ref.part_z					=	param.get_ref(  ref.part_trs, "translate_z" )
	ref.part_sx					=	param.get_ref(  ref.part_trs, "scale_x" )
	ref.part_sy					=	param.get_ref(  ref.part_trs, "scale_y" )
	ref.part_sz					=	param.get_ref(  ref.part_trs, "scale_z" )
	ref.part_sf					=	param.get_ref(  ref.part_trs, "scale_factor" )
	--BOID
	ref.boid = {}
	local r = ref.boid
	r.layers			=	aaa.obj.get( "smartv_boid_layers" )
	r.bdd				=	aaa.obj.get( "smartv_boid" )
	r.birth_nb_trig			=	param.get_ref( r.bdd, "birth_nb_trig" )
	r.nb					=	param.get_ref( r.bdd, "nb_current" )
	r.nb_alive_max			=	param.get_ref( r.bdd, "nb_alive_max" )
	r.death_trig			=	param.get_ref( r.bdd, "death_nb_trig" )
	r.acc_max				=	param.get_ref( r.bdd, "acceleration_max" )
	r.v_min					=	param.get_ref( r.bdd, "speed_min" )
	r.v_max					=	param.get_ref( r.bdd, "speed_max" )
	r.box_type				=	param.get_ref( r.bdd, "box_type" )
	r.vis					=	param.get_ref( r.bdd, "viscosity" )
	r.restart				=	param.get_ref( r.bdd, "restart_trig" )
	r.d_repulse				=	param.get_ref( r.bdd, "repulse_distance" )
	aaa.obj.update_then_draw( r.layers )
	smartv.stop_boid()
	--OBJ_3D
	ref.trs_cube		=	aaa.obj.get( "smartv_cube_trs" )
	ref.trs_cube_factor		=	param.get_ref( ref.trs_cube, "scale_factor" )
	ref.trs_plate		=	aaa.obj.get( "smartv_plate_trs" )
	ref.trs_plate_factor	=	param.get_ref( ref.trs_plate, "scale_factor" )

	--FOREGROUND
	ref.foreground_layers	=	aaa.obj.get( "smartv_foreground_layers" )
	--VIDEO
	ref.video_layers		=	aaa.obj.get( "smartv_video_layers"	)
	--ref.video_layer			=	aaa.obj.get( "smartv_video_layer"	)
	ref.video_grid			=	aaa.obj.get( "smartv_video_grid"	)
		ref.video_x			=	param.get_ref( ref.video_grid, "center_x" )
		ref.video_y			=	param.get_ref( ref.video_grid, "center_y" )
	ref.video_model			=	aaa.obj.get( "smartv_video_model"	)
		ref.video_sx			=	param.get_ref( ref.video_model, "size_u" )
		ref.video_sy			=	param.get_ref( ref.video_model, "size_v" )
	ref.video_color			=	aaa.obj.get( "smartv_video_color"	)
	ref.video_alpha				=	param.get_ref( ref.video_color, "global_alpha" )

	--GRILLE
	ref.grille_layers		=	aaa.obj.get( "smartv_grille_layers" )
	--FBO
	ref.fbo_out_layers		=	aaa.obj.get( "smartv_fbo_out_layers" )
	ref.fbo_out_layer		=	aaa.obj.get( "smartv_fbo_out_layer" )
	ref.fbo_out_bind			=	param.get_ref( ref.fbo_out_layer, "bind_2d" )

	if smartv:is_master() then
		param.set( ref.fbo_out_bind, 16 )
	else
		param.set( ref.fbo_out_bind, smartv.machine_id+2+16 )
	end

	--OUT_ATT
	ref.out_att_layers		=	aaa.obj.get( "smartv_out_att_layers" )
	ref.out_screen_layer	=	aaa.obj.get( "smartv_out_screen_layer" )
	ref.out_screen_bind			=	param.get_ref( ref.out_screen_layer, "bind_2d" )
	ref.out_screen_grid		=	aaa.obj.get( "smartv_out_screen_grid" )
	ref.out_screen_x			=	param.get_ref( ref.out_screen_grid, "center_x" )
	ref.out_screen_map		=	aaa.obj.get( "smartv_out_screen_map" )
	ref.out_screen_tex_l		=	param.get_ref( ref.out_screen_map, "tex_left" )
	ref.out_screen_tex_r		=	param.get_ref( ref.out_screen_map, "tex_right" )
	ref.out_screen_tex_b		=	param.get_ref( ref.out_screen_map, "tex_bottom" )
	ref.out_screen_tex_t		=	param.get_ref( ref.out_screen_map, "tex_top" )
	ref.out_screen_tex_flip_uv	=	param.get_ref( ref.out_screen_map, "tex_flip_uv" )

	--CAMERA
	ref.camera_layers		=	aaa.obj.get( "smartv_camera_layers" )
	ref.camera				=	aaa.obj.get( "smartv_camera" )
	ref.camera_tra_z			=	param.get_ref(	ref.camera,	"tra_z"				)
	ref.camera_frustrum_x		=	param.get_ref(  ref.camera,	"frustum_offset_x"	)
	ref.camera_frustrum_y		=	param.get_ref(  ref.camera,	"frustum_offset_y"	)
	smartv.set_frustum()

	--CAPTURE
	ref.capture_layers		=	aaa.obj.get( "smartv_capture_layers" )

	--todo this is bad it infer where the APP dir is
	local dir = aaa.dir.get_dir_start()

	param.set( dir.."/AAAAPPs/OldSchool/APP_SmarTv/Boid/fx_a.boid", "net_received", not smartv:is_master() )
	param.set( dir.."/AAAAPPs/OldSchool/APP_SmarTv/Boid/fx_a.boid", "net_send", 	smartv:is_master() )
	param.set( "smartv_capture_layers", "active",								smartv:is_master() )
	param.set( ref.part_bdd,		"net_received",	not smartv:is_master() )
	param.set( ref.part_bdd,		"net_send", 		smartv:is_master() )
	param.set( ref.part_halo_bdd,	"net_received",	not smartv:is_master() )
	param.set( ref.part_halo_bdd,	"net_send", 		smartv:is_master() )


	MEDIA.set_dir_media( "SmarTv/3d/Maps/PNG" )
	local noms =	{
					"deroule_allocine",
					"deroule_bfm",
					"deroule_facebook",
					"deroule_gulli",
					"deroule_orange",
					"deroule_pagesjaunes",
					"deroule_skype",
					"deroule_smartreplay",
					"deroule_tf1",
					"deroule_videofutur",
					"explore 3D"
					}
	for i=1, #noms do
		IMGS.get_bind( noms[i]..".png" )
	end

	smartv.video = VIDEOS:get( aaa.dir.make_media_path( "SmarTv/smart_TV_HD_Maa.avi" ) )
	--smartv.video:set_loop( true )
	smartv.video:play()
	smartv.b_init = true
end

smartv.set_frustum()


