function smartv.boid_init()
	local ref = smartv.ref
	if ref.att_3d then return end

	local function build_obj_refs( r, str )
		str = "smartv_"..str.."_"
		r.trs		=	aaa.obj.get( str.."trs" )
		r.tx			=	param.get_ref(  r.trs, "translate_x" )
		r.ty			=	param.get_ref(  r.trs, "translate_y" )
		r.tz			=	param.get_ref(  r.trs, "translate_z" )

		r.rx			=	param.get_ref(  r.trs, "rotate_x" )
		r.ry 			=	param.get_ref(  r.trs, "rotate_y" )
		r.rz			=	param.get_ref(  r.trs, "rotate_z" )

		r.layer		=	aaa.obj.get( str.."layer" )
		r.use_bdd		=	param.get_ref( 	r.layer, "use_bdd" )
		r.bind 			= 	param.get_ref(	r.layer, "bind_2d" )
	end

	ref.cube = {}
	build_obj_refs( ref.cube, "cube" )
 	ref.plate = {}
	build_obj_refs( ref.plate, "plate" )

	ref.att_3d = aaa.obj.get( "smartv_boid_att" )

	aaa.obj.update_then_draw( ref.att_3d )
	param.set( ref.cube.use_bdd, "update_and_draw" )
	aaa.obj.update_then_draw( ref.cube.layer )
	param.set( ref.cube.use_bdd, "draw" )

	param.set( ref.plate.use_bdd, "update_and_draw" )
	aaa.obj.update_then_draw( ref.plate.layer )
	param.set( ref.plate.use_bdd, "draw" )

end

function smartv.draw_boid_generic( fn, layer_attrib )
	aaa.obj.update_then_draw( layer_attrib )

	local SPEED_Z = .4
	--param.set( self.ref.phase, self.phase )
	local bdd = smartv.ref.boid.bdd

	--gol.set_texture_dim( 0 )
	local nb = aaa.bdd.get_point_nb( bdd )
	--aaa.print( nb )
	local get = aaa.bdd.get_point_and_id
	for i=1,nb do
		local x, y, z, id = get( bdd, i )
		local _, id = poid.split_id( id )
		if id ~= 0 then
			fn( id, x, y, z  )
		end
	end
end

function smartv.draw_boid_one_visu( id, x, y, z )
	aaa.draw_circle_axe_z( x,y,z, .1, 8  )
end

function smartv.update_boid()
	if smartv.boid_time_normal then
		--aaa.print( aaa.time.t )
		if smartv.boid_time_normal < aaa.time.t then
			smartv.boid_time_normal = nil
			smartv.normal_boid( "after fast kill" )
		end
	end

	if not smartv.b_skel then return end
	local t = smartv.time

	local ref = smartv.ref
	local tx = param.get( ref.part_x )
	local ty = param.get( ref.part_y )
	local tz = param.get( ref.part_z )

	local f = param.get( ref.part_sf )
	local sca_x = param.get( ref.part_sx ) * f
	local sca_y = param.get( ref.part_sy ) * f
	local sca_z = param.get( ref.part_sz ) * f

	--aaa.print( tx.." "..ty.." "..tz.." / "..sca_x.." "..sca_y.." "..sca_z )

	local mocap = ref.skel
	local boid = ref.boid.bdd
	if math.random() < 4. then
		x ,y, z, sx, sy, sz = aaa.bdd.get_random_point_and_speed( mocap, 0 )
		--aaa.print( x.." "..y.." "..z.." / "..sx.." "..sy.." "..sz )
		local n = sx * sx + sy * sy + sz * sz
		if n > .05 then
			--aaa.print( "create" )
			x = x * sca_x + tx
			y = y * sca_y + ty
			z = z * sca_z + tz
			local f = .0
			sx = sx * f * sca_x
			sy = sy * f * sca_y
			sz = sz * f * sca_z
			poid.create_at( boid, x, y, z, sx, sy, sz )
		end
	end

end

function smartv.draw_boid()
	smartv.boid_init()
	local t = smartv.time

	function smartv.draw_boid_one( id, x, y, z )
		--aaa.print(id)
		local ref
		local ref_scale
		if math.fmod( id, 2 )==1 then
			ref			= smartv.ref.cube
			ref_scale	= smartv.ref.trs_cube_factor
		else
			ref			= smartv.ref.plate
			ref_scale	= smartv.ref.trs_plate_factor
		end
		local ref = math.fmod( id, 2 )==1 and smartv.ref.cube or smartv.ref.plate
		local bind = wrap( id, 0, 10.99999 )
		param.set( ref.bind, bind )
		param.set( ref.tx, x )
		param.set( ref.ty, y )
		param.set( ref.tz, z )
		param.set( ref.rx, t * (.02+id*.000000021) + id*.0045 )
		param.set( ref.ry, t * (.05+id*.000000045) + id*.0202 )
		param.set( ref.rz, t * (.07+id*.000000037) + id*.0078 )

		y= y + .30
		local n = x*x + y*y
		n = math.sqrt( n )
		n = n - .6
		n = clamp_01( n )
		n = clamp_01( .15 + n * 1.5 )
		local f = n * .16
		param.set( ref_scale, f )
		aaa.obj.update_then_draw( ref.layer )
	end

	if smartv.ref.att_3d and smartv.ui.bu_boid_line then
		if smartv:is_master() and smartv.ui.bu_boid_line:get_value_as_bool() then
			smartv.draw_boid_generic( smartv.draw_boid_one_visu, "smartv_boid_attrib_visu" )
		else
			smartv.draw_boid_generic( smartv.draw_boid_one, smartv.ref.att_3d )
		end
	end
end

function smartv.restart_boid()
	param.set( smartv.ref.boid.restart, 1 )
end

function smartv.start_boid()
	aaa.print( "BOID start" )
	local ref = smartv.ref.boid
 	local nb = param.get( ref.nb_alive_max ) - param.get( ref.nb )
	param.set( ref.birth_nb_trig, nb )
	param.set( ref.acc_max, 128 )
	param.set( ref.v_max, 6 )
	param.set( ref.vis, 0 )
	param.set( ref.d_repulse,	0.33 )
	param.set( ref.box_type, "repulse" )
	smartv.boid_state = "full"
end

function smartv.normal_boid( str )
	aaa.print( "BOID normal "..str.." at "..aaa.time.t )
	local ref = smartv.ref.boid
	param.set( ref.acc_max, 1 )
	param.set( ref.v_max, 1 )
	param.set( ref.vis, 0.1 )
	param.set( ref.d_repulse,	0.33 )
	param.set( ref.box_type, "repulse" )
	smartv.boid_state = "normal"
end

function smartv.stop_boid()
	aaa.print( "BOID stop" )
	local ref = smartv.ref.boid
	local nb = param.get( ref.nb )
	param.set( ref.death_trig, nb )
	param.set( ref.acc_max, 4 )
	param.set( ref.v_max, 4 )
	param.set( ref.vis, 0.00 )
	param.set( ref.d_repulse,	0. )
	param.set( ref.box_type, "no" )
	smartv.boid_state = "none"
end

function smartv.stop_fast_boid()
	aaa.print( "BOID stop FAST ".." at "..aaa.time.t )
	local ref = smartv.ref.boid
	local nb = param.get( ref.nb ) + 12
	aaa.print( "kill "..nb )
	param.set( ref.death_trig, nb )
	param.set( ref.acc_max,		32 )
	param.set( ref.v_max,		32 )
	param.set( ref.vis,			0.00 )
	param.set( ref.d_repulse,	0. )
	param.set( ref.box_type, "no" )
	smartv.boid_state = "none"
	smartv.boid_time_normal = aaa.time.t + 1.
	aaa.print( "boid_time_normal".." is "..smartv.boid_time_normal )
end
smartv.draw_boid()