--[[
	dans sang blanc
	le calage se fait sur une zone au sol entourant l'estrade
	de 4.25m sur 7.50m
	plutot a 20cm du bas, et a 50 cm a jardin
	ainsi l'estrade est ds le cone de projection

--]]
local sangblanc_bank = 0

local function midi_panel_update_after( bus )
	--aaa.obj.set_focus_ui( bu_video:get_video().ref.video )
	--aaa.print( "bus_update_after( "..bus.." )" )
	for i=1,0	 do
		local bu = bus.get_bu( i + 8 )
		bu:set_value_cano( math.sin( aaa.time.t*.8	 + i*.8 ) * .5 + .5 )
	end
end
local function bu_set_text( ch, ctl, text )
	local bu = bus_cur:find_bu_by_key_pair( "ch", ch, "ctl", ctl )
	if text and bu then
		bu:set_text( text )
		bu:set_text_draw( true )
		if text == "pal V" then
			bu.use_tex = 255
		elseif text == "Hue" then
			bu.use_tex = 253
		end
	else
		bu:set_text_draw( false )
	end
end
local function tab_set_text( tab, ch_offset, ctl_offset )
	for i = 1, #tab do
		local t = tab[i]
		bu_set_text( t[1]+ch_offset, t[2]+ctl_offset, t[3] )
	end
end
local function set_text( bu, text )
	bu:set_text( text )
	bu:set_text_draw( true ) --TODO regrouop in one call
end
local function do_store()
	aaa.print( "store" )
	param.set(  aaa.dir.get_dir_tracker().."/default_a.midipref", "bank_store_a_trig", 1 )
end
local function do_save()
	aaa.print( "save in bank "..sangblanc_bank )
	param.set( aaa.dir.get_dir_tracker().."/default_a.midipref", "bank_a_save_trig", 1 )
end
local function add_store_ui()
	local bu
	bu = bus_cur:add_trig(	"Store",	{-2.65,0.35,	.1,.1} ):set_color_back("save")
		bu:set_fn_on_click( do_store )

	bu = bus_cur:add_trig(	"Save",		{-2.2,0.35,		.1,.1} ):set_color_back("save")
		bu:set_fn_on_click( do_save )
end

local function recall_bank( bu )
	aaa.print( bu.." changed to "..bu:get_value() )
	sangblanc_bank = bu.spe_bank + bu:get_value()
	param.set( aaa.dir.get_dir_tracker().."/default_a.midipref", "bank_cur", sangblanc_bank )
end
local function add_seq_ui( id, str, bank )
	local bu = bus_cur:add_slider( str,	{-2.2,0.2 - (id-1)*.15, 1,.1} )
	bu:set_min_max( 0, 7 )
	bu.__du = .125 --todo regroup with step
	bu:set_fn_on_click( recall_bank, bu )
	bu.spe_bank = bank
end
local function sangblanc_pages_define()
	local dir = app and app.media_dir_rel or APP.media_dir_rel
	aaa.img.read( 22, dir.."SangBlanc/MIRE1.jpg"				)
	aaa.img.read( 23, dir.."SangBlanc/plaque_constraint.png"	)
	aaa.img.read( 24, dir.."SangBlanc/plaque_cache.png"		)

	local bu
	local tab
	local noms

	local bus = BUS:create( "SangBlanc" )
	bus:init_begin_add_to_ga()
	--START

	--bus:inc_page()

	--keep default value
	--local slider_du_prev = SLIDER.__du
	--SLIDER.__du = .06
	--SLIDER:set_meter( true )

	BUI:set_meter( true )
	local	X1L = -4.1
	local	DX = 1.2
	local	X1R = X1L + DX
	local	X2L = X1L - DX - .2
	local	X2R = X2L + DX
	local	X3L = X2L - DX - .2
	local	X3R = X3L + DX
	local	DY = 1.5
	local	Y = 0.1
	tab = SLIDER.create_midi_vert(	X1L, DX,	Y-DY, 2*DY,			8,			1, 1 )
	set_text( tab[1], "Taille" )
	set_text( tab[2], "Repulsion" )
	set_text( tab[3], "Speed_min" )
	set_text( tab[4], "nb_min" )
	set_text( tab[5], "nb_max" )
	set_text( tab[6], "Regrouper" )
	set_text( tab[7], "Ecarter" )
	set_text( tab[8], "trainee" )
--restore DIAL
	SLIDER.create_midi_hori(			X1L, DX,	Y+DY+.05, .15+DX,	8,		2, 1 )

	DY = .6
	Y = .8
	tab = SLIDER.create_midi_vert(	X2L, DX,	Y-DY, 2*DY,			5, 			1, 72 )
	set_text( tab[1], "Red" )
	set_text( tab[2], "Green" )
	set_text( tab[3], "Blue" )
	set_text( tab[4], "GENERAL" )
	set_text( tab[5], "INV" )
--restore DIAL
	SLIDER.create_midi_hori(		X2L, DX,	Y+DY+.05, .15+DX,	4,		2, 9 )

	Y = -.8
	tab = SLIDER.create_midi_vert(	X2L, DX,	Y-DY, 2*DY,			3,			1, 14 )
	set_text( tab[1], "Chaos" )
	set_text( tab[2], "Viscosity" )
	set_text( tab[3], "Alpha boid" )
--restore DIAL
	SLIDER.create_midi_hori(		X2L, DX,	Y+DY+.05, .15+DX,	4,		2, 13 )

	Y = -.8
	tab = SLIDER.create_midi_vert(	X3L, DX,	Y-DY, 2*DY,			4,			1, 33 )
	set_text( tab[1], "Regrouper x" )
	set_text( tab[2], "Regrouper y" )
	set_text( tab[3], "Ecarter x" )
	set_text( tab[4], "Ecarter y" )

	bu = bus_cur:add_slider_xy( "Regrouper", {	-2.2, 1.2,	4.25*.2, 7.5*.2 } )
	bu:set_midi( 1, 33 )
	bu:set_text_draw( true )

	bu = bus_cur:add_slider_xy( "Ecarter", {		-2.2, -1.1,	4.25*.2, 7.5*.2 } )
	bu:set_midi( 1, 35 )
	bu:set_text_draw( true )

	BUI:set_meter( false )

	add_seq_ui( 1, "A", 10 )
	add_seq_ui( 2, "B", 20 )
	add_seq_ui( 3, "C", 30 )
	add_seq_ui( 4, "D", 40 )
	add_store_ui()

	bus:inc_page()

	--bus:make_bus_loop()

	--the scrolling bu is on the bottom
	--bus:add_scroll( -4, -2 )

	bus:init_end()
end

if IS_BUSS_OPEN() then
	sangblanc_pages_define()
end

