if aaa.lua.global.declare_table( "partdieu" ) then
	partdieu.plasma = { sx=1366, sy=768 }	--	taille native des plasmas

	param.set( aaa.ref.pref, "camera_format_custom_x",		partdieu.plasma.sx * 2	)
	param.set( aaa.ref.pref, "camera_format_custom_y", 		partdieu.plasma.sy		)
	param.set( aaa.ref.pref, "camera_format_custom_factor",	.75						)

	local snd_dir = "AAAAPPs/OldScholl/APP_PartDieu/Sound/"
	partdieu.obj_snd_name_a = snd_dir.."fx_a.bdd_snd_wave"
	partdieu.obj_snd_name_b = snd_dir.."fx_b.bdd_snd_wave"
	partdieu.obj_snd_name_c = snd_dir.."fx_c.bdd_snd_wave"

end

function partdieu:is_master() 		return self.__b_master	end
function partdieu:set_master( b )	self.__b_master = b		end
function partdieu:is_slave()		return self.__b_slave	end
function partdieu:set_slave( b )	self.__b_slave = b		end


function partdieu:get_ortho_max_size()
	if self.b_image then
		return 8, 2.25
	else
		--local size_x, size_y = ga.cam:get_ortho_max_size()
		return 8, 4.5
	end
end
-- server board intel s3420gp

function partdieu.update_before( bus )
	--aaa.print( "partdieu.update_before( "..bus.." )" )
end
--
--	LOCK
--
function partdieu:click_for_lock( id )

	--	LOCK and SHUT
	if id == 4 or id == 5 then
		if not self.b_spe then return end
		if id == 4 then
			self.b_lock = true
		else
			partdieu_quit( 1 )
		end
		self.code = nil
	--	button on logo
	elseif id == 1 then
		if not self.code then
			self.code = 1
		elseif self.code==3 then
			self.code = 4
		else
			self.code = nil
		end
	elseif id == 2 then
		if not self.code then
			self.code = 2
		elseif self.code==4 then
			self.code = 5
		else
			self.code = nil
		end
	elseif id == 3 then
		if not self.code then
			self.code = 3
		elseif self.code==5 then
			self.code = 6
		else
			self.code = nil
		end
	end

	if self.code == 6 then
		if not self.b_lock then
			self.bu_lock:set_visible( true )
		end
		self.bu_shut:set_visible( true )
		self.b_spe = true
	elseif not self.code then
		self.bu_lock:set_visible( false )
		self.bu_shut:set_visible( false )
		self.b_spe = false
	end

end
--
--	BANG
--
function partdieu:init_bang()
	self.bang					= aaa.obj.get( "partdieu_bang" )
	self.bang_particle			= aaa.obj.get( "partdieu_bang_particle" )
	self.bang_s					= param.get_ref( self.bang_particle, "param_01" )
	self.bang_cone				= aaa.obj.get( "partdieu_bang_cone" )
	self.bang_cone_model		= aaa.obj.get( "partdieu_bang_cone_model" )
	self.bang_cone_size			= param.get_ref( self.bang_cone_model, "size_factor" )
	self.bang_cone_bdd			= aaa.obj.get( "partdieu_bang_cone_bdd" )
	self.bang_cone_radius_top	= param.get_ref( self.bang_cone_bdd, "radius_top" )

	self.bang_transfo			= aaa.obj.get( "partdieu_bang_transfo" )
	self.bang_transfo_x			= param.get_ref( self.bang_transfo, "translate_x" )
	self.bang_transfo_y			= param.get_ref( self.bang_transfo, "translate_y" )

	self.bang_black				= aaa.obj.get( "partdieu_bang_black" )
	self.bang_black_active		= param.get_ref( self.bang_black, "active" )
	self.bang_black_model		= aaa.obj.get( "partdieu_bang_black_model" )
	self.bang_black_size		= param.get_ref( self.bang_black_model, "size_factor" )
	self.bang_black_color		= COLOR_REF:create( "partdieu_bang_black", aaa.obj.get( "partdieu_bang_black_color" ) )

	ga:get_bus_ctx():get_top():set_method( "draw_after", partdieu, "draw_bang" )
end
function partdieu:start_bang_low()
	self.bang_val = 0
end
function partdieu:start_bang()
	aaa.print( "partdieu:start_bang()" )
	aaa.net.lua_send( 0, 0, "partdieu:start_bang_low()" )
	self.time_play = os.clock()
	self.b_standby_show = false
end

function partdieu:draw_bang()
	--aaa.print( "partdieu:draw_bang()" )
	if self.bang_val then
		self.bang_val = self.bang_val + aaa.time.dt * 1.
		if self.bang_val > 1 then
			self.bang_val = nil
			if self.next_video then
				self:start_video( self.next_video )
				self.next_video = nil
			end
		else
			param.set( self.bang_s,	self.bang_val )
			local tx, ty
			local f
			local rt
			if self:is_master() then
				tx = 0
				ty = 2.25
				f = 13
				rt = 1.02
			else
				tx = 0
				local d = -4.5 / 4
				ty = -1.125 + 2 * d * (3-self.y_index)*1.
				f = 22
				rt = 1.000
				self.bang_black_color:set_rgb( 1, 1, 1 )
				local v = 1 - self.bang_val
				v = v * 1.5
				self.bang_black_color:set_grey( v*v )
			end
			param.set( self.bang_transfo_x, tx )
			param.set( self.bang_transfo_y, ty )
			param.set( self.bang_cone_size, self.bang_val * f )
			param.set( self.bang_black_size, self.bang_val * f )
			self.bang_black_color:set_alpha( 1 )
			param.set( self.bang_cone_radius_top, rt )
		--	aaa.obj.update_then_draw( self.bang )
		end
	else
		self.bang_black_color:set_alpha( 0 )
	end
	param.set( self.bang_black_active, self:is_slave() )
	aaa.obj.update_then_draw( self.bang )
end

--
--	VIDEO
--
function partdieu:video_init()
	self.video = {}
	self.video.nb = 0
	self.video.videos = {}

	local pre = { "a", "b", "c", "d", "e", "f", "g" }
	for chapitre=1,5 do
		local section = 1
		while true do
			local nbeg = pre[chapitre]..string.format( "%02d", section )
			local video = VIDEOS:get( nbeg..self.video_name_end )
			if video then
				aaa.print( "add video "..nbeg )
				table.insert( self.video.videos, video )
				self.video.nb = self.video.nb + 1
			else
				break
			end
			local video = VIDEOS:get( nbeg..self.video_name_end_eng )
			if video then
				aaa.print( "add video "..nbeg )
				table.insert( self.video.videos, video )
				self.video.nb = self.video.nb + 1
			end
			section = section + 1
		end
	end
	local video = VIDEOS:get( self.standby_name..self.video_name_end )
	if video then
		aaa.print( "add video "..self.standby_name )
		table.insert( self.video.videos, video )
		self.video.nb = self.video.nb + 1
	end

end

function partdieu:set_video_size()
	local size_x, size_y = self:get_ortho_max_size()

	local DX = .0015
	local DY = .0035
	local VX = 2
	local VY = 1

	if self:is_master() then
		size_x = 1.5
		size_y = size_x / 16 * 9
	else
		size_x = size_x * .5
		size_y = size_y * .5
	end

	local bu = self.bu[1]
	bu:set_xy( self:is_master() and VX-size_x*.5 or -size_x*.5, self.b_master and VY or 0 )
	bu:set_sxy( size_x, self:is_master() and size_y or size_y * 2. )
	bu:set_texture_lbtr( {l=0, b=DY, r=.5-DX, t=1-DY} )
	--bu:set_alpha(  self:is_master() and .7 or 1. )

	bu = self.bu[2]
	bu:set_xy( self:is_master() and VX+size_x*.5 or size_x*.5, self.b_master and VY or 0 )
	bu:set_sxy( size_x, self:is_master() and size_y or size_y * 2. )
	bu:set_texture_lbtr( {l=.5+DX, b=DY, r=1, t=1-DY} )
	--bu:set_alpha( self:is_master() and .8 or 1. )
end

function partdieu:start_video( name )
	local str = "partdieu:start_video("..name..")"
	aaa.print( str )

	if self:is_slave() then
		local lang_name
		local video = nil
		--	try english if needed and exist
		if self.b_eng then
			lang_name = name..self.video_name_end_eng
			video = VIDEOS:find( lang_name )
		end
		if not video then
			lang_name = name..self.video_name_end
			video = VIDEOS:find( lang_name )
		end
		if video then
			bu = self.bu[1]
				bu:assign_video( video )

			bu = self.bu[2]
				bu:assign_video( video )

			video:restart()
			--video_r:restart()
			video:play()
			--video_r:play()
			self:set_video_size()
			self.video_cur = video
		else
			aaa.mess.show(  "No video "..name )
		end
	end
end

function partdieu:play_video_low( name )
	local str = "partdieu:play_video_low("..name..")"
	aaa.print( str )

	if self:is_slave() then
		self.next_video = name
	end
end

function partdieu:play_video( name )
	local str = "partdieu:play_video( \""..name.."\" )"
	aaa.print( str )

	if (self.b_demo and self.b_master_demo) or self:is_master() then
		self:start_bang()
	end
	aaa.net.lua_send( 0, 0, "partdieu:play_video_low( \""..name.."\" )" )

end

function partdieu:play_video_and_sound( name, sound )
	if self.b_lock then return end

	if name then
		if sound == "jpg" then
			param.set( partdieu.obj_snd_name_a, "wave_filename", app.media_dir_rel.."PartDieu/Son/jpeg.wav" )
		else
			param.set( partdieu.obj_snd_name_a, "wave_filename", app.media_dir_rel.."PartDieu/Son/video.wav" )
		end
		param.set( partdieu.obj_snd_name_a, "trig_restart",	true )
		param.set( partdieu.obj_snd_name_a, "trig_start",	true )
		self:set_demo( false )
		self:play_video( name )
	else
		param.set( partdieu.obj_snd_name_b, "trig_restart",	true )
		param.set( partdieu.obj_snd_name_b, "trig_start",	true )
	end
end

function partdieu:define_video()
	aaa.print( "---- ---- ---- ---- Part Dieu video ---- ---- ---- ----" )

	self:video_init()

	local bus = BUS:create( "PartDieu_video" )
	bus:init_begin_add_to_ga()

		local size_x, size_y = self:get_ortho_max_size()
		aaa.print( " cam size : "..size_x..", "..size_y )

		self.bu = {}
		for i=1,2 do
			local bu = BU:create( "pardieu_bu_"..i, {(i-1.5)*size_x, 0, size_x*.5, size_y*.5} )
			--aaa.print( table.show( bu, "bu"..i ) )
			--bu:set_fn_on_click_double( chanel.bu_trig_close, bu )
			bu:set_border( false )
			bu:disable_mobile()
			bu:set_xy( size_x*.5, size_y*i*.5 )
			self.bu[i] = bu
			bus:add_bu( bu )
		end

		self:set_video_size()

	bus:init_end()
end

--
--	LANG
--
--	Change image for one bu
local function partdieu_bu_set_lang( bu )
	if bu.fr then
		local target = partdieu.b_eng and bu.eng or bu.fr
		bu:set_texture_bind_2d(	target.tex_bind		and target.tex_bind		or bu.fr.tex_bind    )
		bu:set_texture_bind_on(	target.tex_bind_on	and target.tex_bind_on	or bu.fr.tex_bind_on )
	end
end
--	where the work is done
function partdieu:set_eng_low( b_on )
	local str = "partdieu:set_eng_low("..(b_on and "true" or "false")..")"
	aaa.print( str )

	self.b_eng = b_on
	if self:is_master() then
		self.bus_ui:apply_fn_down( partdieu_bu_set_lang )
	else

	end
end
--	dispatch fn to all using the net
function partdieu:set_eng( b_on )
	if self:is_master() then
		aaa.net.lua_send( 0, 0, "partdieu:set_eng_low( "..(b_on and "true" or "false").." )" )
	end
end
function partdieu:flip_lang()
	self:set_eng( not self.b_eng )
end
function partdieu:playing()
	if self:is_master() then
		self.time_play = os.clock()
	end
end

function partdieu:player_started()
	if self:is_master() then
		self.time_play = os.clock()
		self:set_demo( false )
		self:play_video( self.standby_name )
		self.b_standby_show = true
	end
end

--
--	DEMO
--
function partdieu:update_demo()
	if self.b_demo then
		if self:is_slave() and self.b_master_demo and not self.next_video then
			if self.video_cur and not self.video_cur:is_playing() then
				self.demo_loop_id = self.demo_loop_id + 1
				local nb = #self.demo_loop_name
				if self.demo_loop_id > nb then
					self.demo_loop_id = 1
				end
				aaa.print( "update demo" )
				self:play_video( self.demo_loop_name[self.demo_loop_id] )
			end
		end
	else
		if self:is_master() then
		--	if ga.time_no_touch > self.demo_start_time_in_second then
			if not self.b_standby_show then
				--aaa.print( "update master" )
				if ( os.clock() - self.time_play ) > self.standup_time_in_second then
					self.time_play = os.clock()
					self:set_demo( false )
					self:play_video( self.standby_name )
					self.b_standby_show = true
					--if self.b_standby_show then
						aaa.print( "going in standby")
					--	self:set_demo( true )	--	switch to demo page and so to demo mode
					--	self.b_standby_show = false
					--end
				end
			else
				if ( os.clock() - self.time_play ) > self.demo_start_time_in_second then
					aaa.print( "going in demo")
					self:set_demo( true )
					self:set_demo( true )	--	switch to demo page and so to demo mode
					self.b_standby_show = false
					--self:play_video( self.standby_name )
					--self.b_standby_show = true
				end
			end
		else
			if self.video_cur and self.video_cur:is_playing() then
				-- end of film
				aaa.net.lua_send( 0, 0, "partdieu:playing()" )
			end
		end
	end
end
function partdieu:set_demo_low( b_on )
	local str = "partdieu:set_demo_low("..(b_on and "true" or "false")..")"
	aaa.print( str )

	self.b_demo = b_on

	if self.b_demo and self:is_slave() and self.b_master_demo then
		self.demo_loop_id = 1
		self:play_video( self.demo_loop_name[self.demo_loop_id] )
		aaa.print( "here" )
	end
end

function partdieu:set_demo( b_on )
	if self.b_demo ~= b_on then
		if self:is_master() then
			aaa.net.lua_send( 0, 0, "partdieu:set_demo_low( "..(b_on and "true" or "false").." )" )
		end
	end
end

function partdieu:switch_to_page( page_id )
	if self.b_lock then return end

	param.set( partdieu.obj_snd_name_c, "trig_restart",	true )
	param.set( partdieu.obj_snd_name_c, "trig_start",	true )
	if page_id == -2 then		--	DEMO
		self:set_demo( true )
	elseif page_id == -1 then	--	ENGLISH
		self:flip_lang()
	elseif page_id == 4 then	--	CREDIT
		BUS.static_set_page( page_id - 1 )
	else						--	REST
		BUS.static_set_page( page_id - 1 )
		self:set_demo( false )
	end
end

--
--	UI
--
function partdieu:define_app_ui()
	aaa.print( "---- ---- ---- ---- Part Dieu UI ---- ---- ---- ----" )

	local bus = BUS:create( "PartDieu_UI" )
	bus:init_begin_add_to_ga()
	bus.__b_page_no_inertia = true
	self.bus_ui = bus

	local size_x, size_y = self:get_ortho_max_size()

	local function pixel_to_coor( x, y, sx, sy )
		local NBPX = 1600
		local NBPY = 900

		sx = (sx/NBPX)*size_x
		sy = (sy/NBPY)*size_y

		--aaa.print( x.." "..y )
		x = (x / NBPX)	--	goto [0,1]
		x = (x-.5) * size_x + sx *.5
		y = (y / NBPY)	--	goto [0,1]
		y = (y-.5) * size_y + sy *.5
		--aaa.print( x.." "..y.." after" )
		return x, y, sx, sy
	end
	aaa.lua.global.declare( "add_button_method" )
	function add_button_method( name, x,y, sx,sy, fn_name, method, arg1, arg2 )
		local ext = ".tga"
		x,y, sx,sy = pixel_to_coor( x, y, sx, sy )
		local bu = bus:add_button_image_on_method( name, {x,y, sx,sy}, name..ext, fn_name, self, method, arg1, arg2 )
		local filename =  name.."_on"..ext
		if aaa.file.is_exist( self.image_dir..filename ) then
			local bind = IMGS.get_bind( filename )
			bu:set_texture_bind_on( bind )
		end
		bu.fr = {}
		bu.fr.tex_bind		= bu:get_texture_bind_2d()
		bu.fr.tex_bind_on	= bu:get_texture_bind_on()
		bu.eng = {}
		filename =  name.."_eng"..ext
		bu.eng.tex_bind		= aaa.file.is_exist( self.image_dir..filename ) and IMGS.get_bind( filename ) or nil
		filename =  name.."_eng_on"..ext
		bu.eng.tex_bind_on	= aaa.file.is_exist( self.image_dir..filename ) and IMGS.get_bind( filename ) or nil
		return bu
	end
	aaa.lua.global.declare( "add_button_video" )
	function add_button_video( name, x,y, sx,sy, video_name, sound_index )
		return add_button_method( name, x,y, sx,sy, "click", "play_video_and_sound", video_name, sound_index )
	end
	aaa.lua.global.declare( "add_button_page" )
	function add_button_page( name, x, y, sx, sy, page_id )
		local bu = add_button_method( name, x,y, sx,sy, "click", "switch_to_page", page_id )
		return bu
	end
	local add_page_global_button = assert( loadfile( "APP/APP_PartDieu/PartDieu/button.lua" ) )

	aaa.lua.global.declare( "add_fond" )
	function add_fond( name )
		add_page_global_button()
		local bu = bus:add_fond( name..".tga", {0,0, size_x,size_y}  )
		bu.fr = {}
		bu.fr.tex_bind		= bu:get_texture_bind_2d()
		bu.eng = {}
		local filename =  name.."_eng"..".tga"
		bu.eng.tex_bind		=  aaa.file.is_exist( self.image_dir..filename ) and IMGS.get_bind( filename ) or nil
		bu:set_dplane( -42 )
	end
	aaa.lua.global.declare( "set_page" )
	function set_page( page_id )
		bus:set_page( page_id - 1 )
	end

--[[
	set_page(1)
	for i=1,16 do
		local bu = bus_cur:add_trig( "video_"..i,	{-2,(8-i) * size_y/10, .2,size_y/12} )
		bu:set_fn_on_click( self.play_video, i )
	end
--]]

    local fn = assert( loadfile( "AAAAPPs/OldSchool/APP_PartDieu/PartDieu/page.lua" ) )
	fn()

	--	REST
	set_page(1)

	bus:init_end()
end
--
--	QUIT
--
function partdieu:quit_low( b_shutdown )
	param.set( aaa.ref.app, "force_shutdown",  b_shutdown )
	param.set( aaa.ref.app, "quit_no_save_trig", true )
end
local function partdieu_quit( shutdown, shutdown_reboot )

	if partdieu:is_master() then
		if shutdown ~= 0 then
			aaa.net.lua_send( 0, 0, "partdieu:quit_low( true )" )
		else
			aaa.net.lua_send( 0, 0, "partdieu:quit_low( false )" )
		end
	end
end
aaa.hook_quit = partdieu_quit

--
--	SETUP
--
if IS_BUSS_OPEN() then
	partdieu.host_id = aaa.net.host_id
	partdieu.host_name = aaa.net.machine
	aaa.print( "PartDieu : machine "..partdieu.host_name.." with host_id "..partdieu.host_id )

	aaa.net.send_magic_packet( 0, "6c-f0-49-51-43-b6" )	--	Machine Yaniss
	--	there is 2 adaptor by PC so we try to wake thru each
	aaa.net.send_magic_packet( 0, "00-15-17-f8-b4-40" )	--	Partdieu 101
	aaa.net.send_magic_packet( 0, "00-15-17-f8-b4-41" )	--	Partdieu 101
	aaa.net.send_magic_packet( 0, "00-15-17-f8-c5-b0" )	--	Partdieu 102
	aaa.net.send_magic_packet( 0, "00-15-17-f8-c5-b1" )	--	Partdieu 102
	aaa.net.send_magic_packet( 0, "00-15-17-f8-c2-98" )	--	Partdieu 103
	aaa.net.send_magic_packet( 0, "00-15-17-f8-c2-99" )	--	Partdieu 103


	local part_name = { "hau", "cen", "bas" }

	if partdieu.host_id == 80 then	-- for tests at home
		partdieu.host_id = 101
	end

	if partdieu.host_name == "MAAQUAD" or partdieu.host_name == "MAAHEX" then
		partdieu:set_master(	true	)
		partdieu:set_slave(		true	)
		partdieu.b_master_demo = true
		partdieu.y_index = 1
		partdieu.y_name = part_name[1]
		ga:set_screen_rotate( false )
	elseif partdieu.host_name == "VISU0-PC" then
		partdieu:set_master( 	true	)
		partdieu:set_slave(		false	)
		partdieu.y_index = 1
		partdieu.y_name = part_name[1]
		ga:set_screen_rotate( true )
		ga:lock_app()
		aaa.set_shutdown_on_exit( false )
	elseif inside( partdieu.host_id, 101, 103 ) then
		partdieu:set_master( 	false	)
		partdieu:set_slave(		true	)
		partdieu.b_master_demo = partdieu.host_id==101
		partdieu.b_image = true
		partdieu.y_index = partdieu.host_id-100
		partdieu.y_name = part_name[ partdieu.y_index ]
		ga:lock_app()
		aaa.set_shutdown_on_exit( false )
	else
		partdieu:set_master(	true	)
		partdieu:set_slave(		true	)
		partdieu.y_name = part_name[1]
		partdieu.y_index = 1
		local str = "l'adresse reseau ne fini pas par 100, 101, 102 ou 103\n et ne correspond donc pas a une machine de la table partdieu."
		--aaa.box_error( str )
		aaa.print( str )
	end

	partdieu.video_name_end		= "_"..partdieu.y_name..".mov"
	partdieu.video_name_end_eng	= "_"..partdieu.y_name.."_eng.mov"

	local dir
	if partdieu.b_image then
		dir = "E:/AAA/Media/"
	else
		dir = aaa.dir.get_dir_media()
	end
	dir = dir .."PartDieu/"
	partdieu.image_dir = dir.."Interface/"
	MEDIA.set_dir( partdieu.image_dir )
	VIDEOS:set_dir( dir.."Video/" )

	ga.click_double_time = .0
	partdieu.b_eng = false
	partdieu.b_demo = false
	partdieu.time_play = os.clock()
	partdieu.b_standby_show = false
	partdieu.standby_name = "standby"
	partdieu.standup_time_in_second = 20.

	--todo this is bad it infer where the APP dir is
	local dir = aaa.dir.get_dir_start()
	local fn = assert( loadfile( dir.."/AAAAPPs/OldSchool/APP_PartDieu/PartDieu/demo.lua" ) )
	fn()

	--todo something wrong here
	--it was buss.fn_update_before = partdieu.update_demo
	--ga:get_buss_cur():set_method( "update_before", partdieu, "update_demo" )
	ga:set_method( "update_before", partdieu, "update_demo" )

	partdieu:init_bang()
	if partdieu:is_master()	then	partdieu:define_app_ui()		end
	if partdieu:is_slave() then
		partdieu:define_video()
		aaa.net.lua_send( 0, 0, "partdieu:player_started()" )
	end
end

--	mode demo
--		button on/off sur demo
--		fn sur fin des films
--		transmittion a la machine centrale
--		lancement par un entier pas un nom
--	isoler script
--	start
--		magic packet
--	stop
--		trig shutdown or not


