if not FX.cur then
	aaa.layers.skip_rest()
	return
end
local fx = FX.cur


function fx:load()
	if self:load_from_def() then
	end
end

function fx:is_bind_ok_one( bind, i, j )
	if i < 1 or i > self.nb_u or j < 1 then return true end
	if bind == self.elt[i][j].bind then return false end
	return true
end
function fx:is_bind_ok_line( bind, b, e, j )
	local ok = true
	for i = b,e do
		ok = ok and self:is_bind_ok_one( bind, i,	j )
	end
	return ok
end
function fx:is_bind_ok( bind, i, j )
	return 		self:is_bind_ok_line( bind, i-5,	i-1,	j )
			and self:is_bind_ok_line( bind, i-4,	i+4,	j-1 )
			and self:is_bind_ok_line( bind, i-2,	i+2,	j-2 )
			and self:is_bind_ok_line( bind, i-1,	i+1,	j-3 )
			and self:is_bind_ok_line( bind, i-1,	i+1,	j-4 )
end
function fx:init()
	self:load()
	self.nb_u = 17
	self.nb_v = 5
	self.nb = self.nb_u * self.nb_v
	self.elt = {}
	local elt = self.elt
	for i=1,self.nb_u do
		elt[i] = {}
		for j=1,self.nb_v do
			elt[i][j] = { bind=-1, inter=0, s_angle=1 }
		end
	end
	--math.randomseed( 42 )
	for index=1, self.nb do
		local j = math.floor( (index-1)/self.nb_u )
		local i = index - j * self.nb_u
		j = j + 1
		local bind
		local loop_nb = 0
		repeat
			bind = math.random( 0, self.nb_tex-2 )
			loop_nb = loop_nb + 1
			if loop_nb > 1000 then
				self:print_error( "probablement pas assez d'image dans la mosaique pour satisfaire les contraintes" )
				break
			end
		until self:is_bind_ok( bind, i, j )
		local elt = self.elt[i][j]
		elt.bind = bind
		self:set_elt_color( elt )
	end
end
function fx:set_elt_color( elt )
	if self.pal_bind then
		elt.r, elt.g, elt.b =  aaa.img.get_color_uv( self.pal_bind, math.random(), math.random(), true )
	else
		elt.r, elt.g, elt.b =  math.random(), math.random(), math.random()
	end
end
function fx:flip_elt( i, j )
	local elt = self.elt[i][j]
	if elt.d then return end

	if elt.inter <= 0. then
		elt.d = 1
		self:set_elt_color( elt )
		elt.s_angle = math.random( 1, 8 )
	end
end

function fx:is_elt_contact( i, j )
	if outside(i, 2, 16 ) then return false end
	local sx,sy = aaa.img.get_size( 140 )
	--self:print( sx.." "..sy )
	sx = sx/15
	sy = sy/5
	i = i - 2
	j = j - 1
	local max = aaa.img.get_component_max_rect_xy( 140, sx*(i), sx*(i+1), sy*j, sy*(j+1), 2 )
	--if max > 0. then
	--	self:print( i..", "..j.." -> "..max )
	--end
	return max > .8
end
function fx:draw_elt( i, j )
	local elt = self.elt[i][j]
	local inter = elt.inter
	if elt.d then
		inter = inter + elt.d * .5 * aaa.time.dt
		if inter >= 1. then
			elt.d = nil
			elt.tempo = 2.
		elseif inter <= 0. then
			elt.d = nil
		end
		elt.inter = clamp_01( inter )
	else
		if self:is_elt_contact( i, j ) then self:flip_elt( i, j ) end
	end
	local tempo = elt.tempo
	if tempo then
		tempo = tempo - aaa.time.dt
		if tempo <= 0. then
			if not self:is_elt_contact( i, j ) then
				elt.tempo = nil
				elt.d = -1.
			end
		else
			elt.tempo = tempo
		end
	end

	gol.push_matrix()

		if elt.d then
			if elt.d>0 then
				inter = math.pow( inter, .4 )
			else
				inter = math.pow( inter, 1/.4 )
			end
		end

		if inter < .5 then
			gol.set_texture_dim( 2 )
			gol.bind_texture( elt.bind + self.bind )
		else
			gol.set_texture_dim( 0 )
		end

		i = i-9
		j = j-3
		local S = .6 * .5
		x = i*.6 - S*.5
		y = j*.6 - S*.5
		--aaa.draw_rect_uv( x,	y, x+S		, y+S			)
		gol.translate( x+S*.5, y+S*.5 )
		--phase = math.cos( phase * 3.1416 ) *.25
		--gol.rotate_z( .5 )	--	Dec 2012 image were upside / down

		--aaa.print( inter )
		local delta = .3
		S = S * ( 1 - delta + ( .5 + math.cos( inter * math.pi2 ) * .5 ) * delta )
		local phase = inter * .5
		--aaa.print( elt.s_angle )
		gol.rotate_z( .125 * (elt.s_angle-1) )
		gol.rotate_x( phase )
		gol.rotate_z( -.125 * (elt.s_angle-1) )

		local g = 1 - math.sin( inter * math.pi ) * .6
		if inter < .5 then
			gol.color_grey( g )
			aaa.draw_rect_uv(	-S,-S, 	S,S	)
		else
			gol.color( elt.r*g, elt.g*g, elt.b*g )
			aaa.draw_rect(		-S,-S, 	S,S	)
			S = S * .5
			gol.color_grey( g )
			aaa.draw_rect(		-S,-S,	S,S	)
		end

	gol.pop_matrix()
end

function fx:draw_low()
	if not self.elt then return end


	--if math.random() < aaa.time.dt then
	--	self:flip_elt( math.random( 3, self.nb_u -2 ), math.random( 1, self.nb_v ) )
	--end
--	gol.push_attrib())
	aaa.obj.update_then_draw( self.ref.layer_a )
	for i=1,self.nb_u do
		for j=1,self.nb_v do
			self:draw_elt( i, j )
		end
	end
--	gol.pop_attrib()
end



