if not FX.cur then
	aaa.layers.skip_rest()
	return
end
local fx = FX.cur

function fx:load()
	if self:load_from_def() then
		self.repartition = tab.repartition or "hazard"
		self.nb_u = tab.quinconce_nb_u or 50
		self.nb_v = tab.quinconce_nb_v or 12
		self.nb = tab.nb or 200
		self.size_min = tab.taille_min_cm and ( tab.taille_min_cm * .01 ) or .1
		self.size_max = tab.taille_max_cm and ( tab.taille_max_cm * .01 ) or .1
		self.noise = tab.position_bruit_cm and ( tab.position_bruit_cm * .01 ) or .01
		self.rot_noise = tab.rotation_bruit_degre and (tab.rotation_bruit_degre / 360.) or (5./360.)
	end
end

function fx:init_quinconce()
	self.elt = {}
	local elt = self.elt
	local su = self.su
	local sv = self.sv
	local du = su / ( self.nb_u )
	local dv = sv / ( self.nb_v )
	local v = -sv * .5 + dv * .5
	local i = 0
	local b_full = true
	for iv = 1,self.nb_v do
		local u = -su * .5 + du * (b_full and .5 or 1)
		local nb = b_full and self.nb_u or (self.nb_u - 1)
		b_full = not b_full
		for iu = 1,nb do
			i = i + 1
			elt[i] = {	x =	u + (math.random()-.5) * self.noise,
						y =	v + (math.random()-.5) * self.noise,
						rot = (math.random()-.5) * self.rot_noise }
			u = u + du
		end
		v  = v + dv
	end
	self.nb = i
end
function fx:init_random()
	self.elt = {}
	local elt = self.elt
	local su = self.su
	local sv = self.sv
	for i=1,self.nb do
		local u = su * ( math.random() - .5 )
		local v = sv * ( math.random() - .5 )
		local rot = math.random()
		elt[i] = { x=u, y=v, rot=rot }
	end
end
function fx:init_size_and_bind()
	local elt = self.elt
	local smin = self.size_min
	local sf = self.size_max - smin
	for i=1,self.nb do
		local one = elt[i]
		one.size = smin + math.random() * sf
		one.bind = math.random( self.bind, self.bind + self.nb_tex - 1 )
		one.x_ori = one.x
		one.y_ori = one.y
	end
end

function fx:init()
	self:load()

	self.su = 9.
	self.sv = 3.
	self.elt = {}
	local elt = self.elt

	if self.repartition == "quinconce" then
		self:init_quinconce()
	elseif self.repartition == "hazard" then
		self:init_random()
	end
	self:init_size_and_bind()
end

--[[
function fx:is_elt_contact( i, j )
	if outside(i, 2, 16 ) then return false end
	local sx,sy = aaa.img.get_size( 140 )
	--self:print( sx.." "..sy )
	sx = sx/15
	sy = sy/5
	i = i - 2
	j = j - 1
	local max = aaa.img.get_component_max_rect_xy( 140, sx*(i), sx*(i+1), sy*j, sy*(j+1), 2 )
	--if max > 0. then
	--	self:print( i..", "..j.." -> "..max )
	--end
	return max > .8
end
--]]
function fx:draw_elt( i )
	local elt = self.elt[i]
	local x = elt.x
	local y = elt.y
	local rot = elt.rot
	local s = elt.size
--[[
	local inter = elt.inter
	if elt.d then
		inter = inter + elt.d * .5 * aaa.time.dt
		if inter >= 1. then
			elt.d = nil
			elt.tempo = 2.
		elseif inter <= 0. then
			elt.d = nil
		end
		elt.inter = clamp_01( inter )
	else
		if self:is_elt_contact( i, j ) then self:flip_elt( i, j ) end
	end
	local tempo = elt.tempo
	if tempo then
		tempo = tempo - aaa.time.dt
		if tempo <= 0. then
			if not self:is_elt_contact( i, j ) then
				elt.tempo = nil
				elt.d = -1.
			end
		else
			elt.tempo = tempo
		end
	end
--]]
	local u = x / self.su + .5
	local v = y / self.sv + .5
	local gx,gy = aaa.img.get_gradient_uv( 141, u, v, 5, true, true )
	local dt = aaa.time.dt
	local d = -dt * 10.
	gx = gx * d
	gy = gy * d
	x = x + gx
	y = y + gy
	elt.x = interpolate( x, elt.x_ori, dt * .3 )
	elt.y = interpolate( y, elt.y_ori, dt * .3 )
	gol.push_matrix()
		gol.bind_texture( elt.bind )
		--self:print( x.." "..y )
		gol.translate( x, y )
		if rot then gol.rotate_z( rot ) end
		gol.scale( s )
		--self:print( s )
		aaa.draw_rect_uv( -.5,	-.5, 	.5,	.5	)
	gol.pop_matrix()
end

function fx:draw_low()
	if not self.elt then return end


	--if math.random() < aaa.time.dt then
	--	self:flip_elt( math.random( 3, self.nb_u -2 ), math.random( 1, self.nb_v ) )
	--end
	gol.push_attrib()
		--aaa.obj.update_then_draw( self.ref.layer_a )
		gol.set_default()
		gol.set_texture_dim( 2 )
		gol.color_white()
		--aaa.draw_box( 1, 1, 1 )
		for i=1,self.nb do
			self:draw_elt( i )
		end
	gol.pop_attrib()
end



