
function ota:add_window_xy( title, bus_down,	x,y )
	y = y * ( self:is_onsite() and .25 or 1. )
	local bu = bus_cur:add_window( title, bus_down,		{x,y,	2,2} )
	local S = self:is_onsite() and 1. or 2.
	bu:set_sxy( S,S )
	bu:__set_window_state( "mini" )
	return bu
end
function ota:add_window_auto( title, bus_down,	i )
	return self:add_window_xy( 	title, bus_down,	-3., -2+i*.25 )
end

function ota:draw_background()
	bus_cur:draw_debug_str( "Back", -4, 1.3 )
end

function ota:draw_foreground()
	bus_cur:draw_debug_str( "Fore", -4, 1.2 )
end

local	function add_slider( text )
	local bu = bus_cur:add_slider( text )
	return bu
end

function ota.ui.add_text( bus, text, x, y )
	local bu = bus:add_text_info( text,	{x,y, .25,.25} )
	bu:set_ui_top_size( true )
	return bu
end

function ota:define_ui_first()
	local bus = BUS:begin_window( "OT Aix 1" )

		local bu
		bu = self:add_flag( "b_fbo",		"FBO",				true	)
		bu = self:add_flag( "b_fbo_out",	"FBO PROJ",			self:is_onsite()	)
		bu = self:add_flag( "b_gamma",		"FBO Gamma",		true	)
			bu = add_slider( "gamma" )
			bu:set_min_max( 0, 2 )
			bu:set_value( .8 )
			self.ui.bu_gamma = bu

		bus:move_next()
		self.cam_in			:add_ui()
		self.cam_edit		:add_ui()
		self.cam_draw		:add_ui()
		self.cam_process	:add_ui()

		bu = self:add_flag( "b_fond",		"Fond",	true )
		self.fxs:add_ui()
		local fx = self.fxs.fx
		if fx then
			fx[1].bu:set_value( 0 )
		else
			self:print_error( "no fx" )
		end

	bus:end_window()

	return bus
end

local function __set_window_state( self, state )
	--local c = oo.getclass(self)
	--table.print( c, "toto", 3 )
	--self:print( " Fuck it "..type(c).." "..c )
	oo.getclass(self).__set_window_state( self, state )
	local t = app.cam_in.bu_to_flip
	for _, v in IPAIRS( t ) do
		v:set_active( state == "normal"  )
	end
end

function ota:define_app_ui()
	local bu

	local bus = BUS:create( "OT Aix" )
	self.ui.bus = bus
	bus:set_active( true )
	bus:init_begin_add_to_ga()

		bu = self:add_window_xy( "Base", self:define_ui_first(),	-3, 0 )

		local fx = self.cam_in
		bu = self:add_window_xy( fx:get_name(), fx.bus,		-4*.5, 0 )
		bu.__set_window_state = __set_window_state
		bu:__set_window_state( "normal" )
		bu:__set_window_state( "mini" )
		--bu:set_fn_on_click( fx.set_focus, fx )

		self.fxs:add_window()

	bus:init_end()

	bus:set_method( "draw_before", 	self,	"draw_background"	)
	bus:set_method( "draw_after",	self,	"draw_foreground"	)

	ga:register_ui_group( bus )
	ga:set_ui_group_active( not self:is_onsite() )

	return bus
end