if not FX.cur then
	aaa.layers.skip_rest()
	return
end

local fx = FX.cur

function fx:add_color( ref, name, pre  )
	local p = param.get_ref( ref, "global_"..name )
	if pre then name = pre.."_"..name end
	local bu = bus_cur:add_slider( name )
	bu:set_target_param( p )
	bu:set_min_max( 0, 1 )

	return bu
end
function fx:add_color_abgr( ref, pre  )
	local bu = fx:add_color( ref, "Alpha", pre  )
	bu:set_meter( true )
	fx:add_color( ref, "Red", pre  )
	fx:add_color( ref, "Green", pre  )
	fx:add_color( ref, "Blue", pre  )
end
function fx:add_ui_window()
	FX.add_ui_window( self, false )

	local ref = self.ref
	self:add_color_abgr( ref.color, nil )\
	
	bus_cur:move_next()
	ref.layer_b		=	aaa.layers.get_layer( ref.obj, 2 )
	ref.color_b		=	aaa.layer.get_color( ref.layer_b )
	self:add_color_abgr( ref.color_b, "B"  )

	bus_cur:move_next()
	ref.layer_c		=	aaa.layers.get_layer( ref.obj, 3 )
	ref.color_c		=	aaa.layer.get_color( ref.layer_c )
	self:add_color_abgr( ref.color_c, "C"  )
end
