if not FX.cur then
	aaa.layers.skip_rest()
	return
end

local fx = FX.cur

--	left center right

function fx:init()
	local ref = self.ref
	ref.tex_layer	=		aaa.layers.get_layer( ref.obj, 1 )
		--ref.tex_active	=		param.get_ref( ref.tex_layer, "active" )
		ref.tex_bind_offset	=		param.get_ref( ref.tex_layer, "bind_2d_offset" )
	ref.edit_layer	=		aaa.layers.get_layer( ref.obj, 2 )
		--ref.edit_layer_active	=		param.get_ref( ref.edit_layer, "active" )
		ref.edit_grid			=		aaa.obj.get_branch_by_class( ref.edit_layer, "bdd_grid_adjustable" )
			ref.edit_intercept	=		param.get_ref( ref.edit_grid, "ui_intercept" )
			ref.edit_draw		=		param.get_ref( ref.edit_grid, "ui_draw" )
			ref.edit_dataset	=		param.get_ref( ref.edit_grid, "dataset_id" )
	self.sel = -1
	self:set_cam( 0 )
	--	make sur the grid is ready for mapping (needed to be update with the good model for sizing)
	--	so we update first the tex layer which provide a c_model
	--todoc	AAASeed should not require this ?
	aaa.obj.update_then_draw( ref.tex_layer )
	aaa.obj.update_then_draw( ref.edit_layer )
end

function fx:set_cam( sel )
	if self.sel==sel then return end

	local ref = self.ref
	local b_edit = sel>0
	param.set( ref.edit_intercept, b_edit )
	param.set( ref.edit_draw, b_edit )
	if not b_edit then return end
	param.set( ref.tex_bind_offset, 128+sel-1 )
	param.set( ref.edit_dataset, sel )
	aaa.obj.become_ui( ref.edit_layer )
	aaa.obj.set_focus_ui( ref.edit_grid )
	ga:set_ui_group_active( false )
	self.sel = sel
end

function fx:draw()
	if not app then return end	--	avoid crash when F12 down all the time
	if not self.sel_edit then
		self.sel_edit =  app.cam_in.sel_edit
	end
	local sel = self.sel_edit:get_value()
	--self:print( "sel is "..sel )
	if sel<=0 then return end

	local ref = self.ref
	self:set_cam( sel )
	aaa.obj.update_then_draw( ref.tex_layer )
	aaa.obj.update_then_draw( ref.edit_layer )
end
