--
--	this run the simulator from a SLIDER_MULTI
--
if not FX.cur then
	aaa.layers.skip_rest()
	return
end

local fx = FX.cur

--	left center right

function fx:init()
	local ref = self.ref
	ref.layer = {}
	for i = 1,4 do
		ref.layer[i]	=		aaa.layers.get_layer( ref.obj, i )
	end
		--ref.tex_active	=		param.get_ref( ref.tex_layer, "active" )
	ref.carre_layer		=	aaa.obj.get( "ota_cam_draw_carre" )
		ref.carre_active	=	param.get_ref( ref.carre_layer, "active" )
		ref.grid			=	aaa.obj.get_branch_by_class( ref.carre_layer, "bdd_grid" )
			ref.x				=	param.get_ref( ref.grid, "center_x" )
			ref.y				=	param.get_ref( ref.grid, "center_y" )
		ref.model			=	aaa.layer.get_model( ref.carre_layer )
			ref.sx				=	param.get_ref( ref.model, "size_u" )
			ref.sy				=	param.get_ref( ref.model, "size_v" )
	param.set( ref.carre_active, false )
end

function fx:draw()
	FX.draw( self )

	local ref = self.ref
	param.set( ref.carre_active, true )
	local bu = ota.cam_in.bu_multi

	--if not bu then return end
	--local sx,sy = BUS:get_sxy()

	for i = 1, bu:get_elt_nb() do
		if bu:is_elt_active(i) then
			local x,y	= bu:get_elt_xy(	i )
			local sx,sy = bu:get_elt_sxy(	i )
			--self:print( x.." "..y  )
			--x = (x / 3 -) * 6
			--we are using the implicit size of 2 by 2 here
			x = ( x - .5 ) * ( 3*3 )
			y = ( y - .5 ) * ( 3   )
			--self:print( x.." "..y )
			param.set( ref.x, x )
			param.set( ref.y, y )
			param.set( ref.sx, sx*3 )
			param.set( ref.sy, sy )
			aaa.obj.update_then_draw( ref.carre_layer )
		end
	end
	param.set( ref.carre_active, false )
end
