if not FX.cur then
	return
end

local fx = FX.cur

--	left center right

function fx:init()
	self.nb = app:is_onsite() and 3 or 0

	self.serial = { 11462440, 11462459, 11462439 }

	local ref = self.ref
	ref.cam = {}
	for i=1,3 do
		ref.cam[i] = {}
		local cam = ref.cam[i]
		cam.layer	=		aaa.layers.get_layer( ref.obj, i )
			cam.layer_active	=		param.get_ref( cam.layer, "active" )
		cam.video	=		aaa.obj.get_branch_by_class( cam.layer, "tex_video" )
			cam.open			=		param.get_ref( cam.video, "capture_open" )
			cam.run				=		param.get_ref( cam.video, "capture_run" )
			cam.run_forced		=		param.get_ref( cam.video, "capture_run_forced" )
			cam.index			=		param.get_ref( cam.video, "capture_device_index" )
			cam.on_cpu			=		param.get_ref( cam.video, "image_on_cpu_wanted" )
			cam.img_index		=		param.get_ref( cam.video, "image_index" )
				--param.set( cam.index, i-1 )
			cam.use_id		=		param.get_ref( cam.video, "capture_device_id_use" )
				--param.set( cam.use_id, app:is_onsite() )
--		param.set( cam.layer_active, true )
--		param.set( cam.open, false )
--		param.set( cam.run, false )
--		aaa.obj.update_then_draw( cam.video )
		cam.flycap	=		aaa.obj.get_branch_by_class_no_error( cam.video, "flycapture2" )
		if cam.flycap then
			param.set( cam.flycap, "SerialNumber", fx.serial[i] )
			param.set( cam.open, true )
			param.set( cam.run, true )
			param.set( cam.layer_active, i <= self.nb )
			aaa.img.read( 128+i-1, app.dir.."fly_capture_ref_"..i..".png" )
		end
	end
end

function fx:draw()
	if false then
		local ref = self.ref
		local src = ref.cam[1].flycap
		for i=2,0 do
			local dst = ref.cam[i].flycap
			if dst then
				aaa.obj.set_param_from( dst, src )
			end
		end
	end
	FX.draw( self )
end

function fx:save_images()
	for i=1,self.nb do
		local cam = self.ref.cam[i]
		local index = param.get( cam.img_index )
		param.set( cam.on_cpu, true )
		repeat
			aaa.obj.update_then_draw( cam.video )
		until param.get( cam.img_index ) >= index+10
		param.set( cam.on_cpu, false )
		local t = aaa.time
		local str = app.dir.."fly_capture_"..i.."_at_"..t.hour.."_"..t.minute.."_"..t.second
		--aaa.print( "Saving img bind "..128+i.." in "..str )
		aaa.img.save( 128+i-1, str )
	end
end

function fx:load_img_ref()
	for i=1,3 do
		aaa.img.read( 128+i-1, app.dir.."fly_capture_ref_"..i..".png" )
	end
end

function fx:add_ui_window()
	FX.add_ui_window( self, false )
	bus_cur:add_but_trig_fn( "Save Images", nil, self.save_images, self ):set_color_back("save")
	bus_cur:add_but_trig_fn( "Load Ref",	nil, self.load_img_ref, self ):set_color_back("load")
	local bu = bus_cur:add_selector( "Edit" )
	self.sel_edit = bu

	self.bu_to_flip = {}
	local bu_i = 1

	local function add_tex( bind, x,y, sx,sy, name )
		local bu = app.ui.bus:add_monitor(	name, {x,y, sx,sy}, bind )
		bu:set_border( false )
		bu:set_text_xy( -.4, sy*.35 )
		bu:set_text_color( 1, 0, 0, .4 )
		bu:set_ui_top_size( true )
		bu:set_ui_active( true )
		bu:set_mobile( true )
		bu:set_fn_on_click_double( function(self) self:set_sxy( self:get_pos_orig_sx(), self:get_pos_orig_sy() ) end, bu )
		self.bu_to_flip[bu_i] = bu
		bu_i = bu_i + 1
		return bu
	end

	local H = 1
	local W = H * 4 / 3
	for i = 1,3 do
		add_tex( 128+i-1, (i-1.-2)*W,	0,			W, H,		"CAM "..i )
	end
	for i = 0,4,4 do
		add_tex( 136+i, -4, 			H*(2-i), 	H*3, H, 	"All" )
	end
	add_tex( 141, -4, 			0, 	H*3, H, 	"Gradient" )

	local bu = SLIDER_MULTI:create( "Simul",	{0,0, 3,1},	5 )
		self.bu_multi = bu
		app.ui.bus:add_bu( bu )
end