CLASS.DECLARE( "WSPACE", SPACE, {
	OX = 0,
	OZ = 0,
	b_corner = false,
	NB_X = 1,
	NB_Z = 1,
	title_factor = 1,	--todo really implement
	space_factor = 1,
	building_factor = 1,
	} )

function WSPACE:is_wspace()	return true end
function WSPACE:create( name, module )
	local self = WSPACE:create_instance( name )
	self:init( module )
	return self
end

function WSPACE:get_cam_layerss()	return self.ref.att_layers 	end
function WSPACE:init( module )
	if not self.ref then self.ref = {} end
	local ref = self.ref
	if ref.floor_layers then return end

	ref.module = module

	local gepare = param.get_ref
	ref.att_layers	=	aaa.obj.get_branch_by_name_symbo( module, "wspace_layers_att" )
	aaa.obj.update_then_draw( ref.att_layers )

		local cameras = aaa.obj.get_branch_by_class( ref.att_layers, "cameras" )
		ref.cam_top		= aaa.obj.get_branch_by_name_symbo( cameras, "wspace_cam_top"	)
		ref.cam			= aaa.obj.get_branch_by_name_symbo( cameras, "wspace_cam_floor"	)
			ref.target_x 	= gepare( ref.cam, "center_x" )
			ref.target_y 	= gepare( ref.cam, "center_y" )
			ref.target_z 	= gepare( ref.cam, "center_z" )
			ref.pos_x 		= gepare( ref.cam, "tra_x" )
			ref.pos_y 		= gepare( ref.cam, "tra_y" )
			ref.pos_z 		= gepare( ref.cam, "tra_z" )

	ref.att_3d		= aaa.obj.get_branch_by_name_symbo( ref.att_layers, "wspace_att" )
	aaa.obj.update_then_draw( ref.att_3d )

	ref.att_visu	= aaa.obj.get_branch_by_name_symbo( ref.att_layers, "wspace_attrib_visu" )

	--FLOOR
	ref.floor_layers	= aaa.obj.get_branch_by_name_symbo( module, "floor" )

	self:init_cam()
end

function WSPACE:init_cam()
	self.cam = {}
	local cam = self.cam
	cam.x = 0
	cam.y = .25
	cam.z = 0
	cam.angle = 0
end
function WSPACE:set_cam()
	local H = .5
	local ref = self.ref
	local cam = self.cam
	param.set( ref.pos_x, cam.x	)
	param.set( ref.pos_y, H	)
	param.set( ref.pos_z, cam.z	)
	local x,z
	x = math.cos( cam.angle )
	z = math.sin( cam.angle )
	param.set( ref.target_x, cam.x + x )
	param.set( ref.target_y, H	)
	param.set( ref.target_z, cam.z + z )
end

--todo in lib
local function do_neutral( v, min )
	if v < -min then
		v = ( v + min )	/ ( 1 - min )
	elseif v > min then
		v = ( v - min )	/ ( 1 - min )
	else
		v = 0
	end
	return v
end
local function limit_norm_2d( x, y, max )
	local n = math.sqrt( x*x + y*y )
	if n > max then
		n = max / n
		x = x * n
		y = y * n
	end
	return x, y
end

function WSPACE:update()
	self:init()

	self:update_buildings()

	if self.time_normal then
		--aaa.print( aaa.time.t )
		if self.time_normal < aaa.time.t then
			self.time_normal = nil
			self:normal( "after fast kill" )
		end
	end

	local tra		=	m42.move.tra
	local tra_lat	=	m42.move.tra_lat
	local rot		=	m42.move.rot
	--self:print( tra.." "..tra_lat.." "..rot )
	local ref = self.ref

	rot = do_neutral( rot, .1 )

	local cam = self.cam
	cam.angle = cam.angle + rot * aaa.time.dt * .7

	local si, co = math.cos( cam.angle ), math.sin( cam.angle )
	--aaa.print( d )
	local F = .7
	tra = do_neutral( tra, .1 ) * aaa.time.dt
	tra = tra * F
	tra_lat = do_neutral( tra_lat, .10 ) * aaa.time.dt
	tra_lat = tra_lat * F
	local z = co * tra - si * tra_lat
	local x = si * tra + co * tra_lat
	--aaa.print( "titit x z "..x.." "..z )
	x = cam.x + x
	z = cam.z + z

	if true then
		if self.limit then
			local s = self.limit.sx * .5 * self.space_factor
			x = clamp( x, -s, s )
			s = self.limit.sz * .5 * self.space_factor
			z = clamp( z, -s, s )
		else
			local S = 4
			x = wrap( x, -S, S )
			z = wrap( z, -S, S )
		end
	else
		local S = 6
		x, z = limit_norm_2d( x, z, S )
	end
	cam.x = x
	cam.z = z
	self:set_cam()
end

function WSPACE:update_buildings()
	local buildings = self.buildings
	local ws_defs = m42.wspace_def[self:get_name()]
	for i,ws_def in ipairs( ws_defs ) do
		self.buildings[i]:update( ws_def )
	end
end

function WSPACE:init_buildings()
	local name = self:get_name()
	self:print( name )
	self.buildings = {}
	local ws_defs = m42.wspace_def[name]
	for i,ws_def in ipairs( ws_defs ) do
		name = ws_def.name or ws_def.b_def
		local b = BUILDING:create( name, i, ws_def )
		table.insert( self.buildings, b )
		--aaa.print_inverse( "Out     "..b.bind )
	end
	if m42.b_start_load_www then
	--	self.time_init_end = aaa.time.t + 20
	else
	--	self.time_init_end = aaa.time.t - 1000.
	end
end
function WSPACE:find_building( x, z )
	for _,b in ipairs(self.buildings) do
		if b:is_inside( x, z ) then
			return b
		end
	end
	return nil
end
function WSPACE:try_to_enter_building()
	local b = self:find_building( self.cam.x, self.cam.z )
	return b
end
function WSPACE:quit_all_building()	--todo check and use
	for _,b in ipairs( self.building ) do
		b:quit()
	end
end

function WSPACE:draw_building( ox, oy )
	for _,b in ipairs(self.buildings) do
		b:draw( ox, oy )
		--aaa.print_inverse( "---------------------------"..b.bind )
	end
end

function WSPACE:transform_building( x, z, sx, sz, sy, rot )
	local F1 = self.space_factor
	x = (x+self.OX) * F1
	z = (z+self.OZ) * F1
	local F2 = self.building_factor * F1
	sx = sx * F2
	sy = sy * F2
	sz = sz * F2
	if self.b_corner then
		x = x + sx*.5
		z = z + sz*.5
	end
	rot = rot or 0.
	return x, z, sx, sz, sy, rot
end

function WSPACE:draw()
	local ref = self.ref

	aaa.obj.update_then_draw( ref.att_layers )

	aaa.obj.update_then_draw( m42.b_wspace_top and ref.cam_top or ref.cam )

	aaa.obj.update_then_draw( ref.floor_layers	)

	local OX = 8
	local OZ = 8
	for x = -self.NB_X*OX, self.NB_X*OX, OX do
		for y = -self.NB_Z*OZ, self.NB_Z*OZ, OZ do
			--todo solve this
			aaa.obj.update_then_draw( ref.att_3d )
			self:draw_building( x, y )
		end
	end

end
