CLASS.DECLARE( "SPACE_BEAR", SPACE )

function SPACE_BEAR:create( name )
	local self = SPACE_BEAR:create_instance( name )
	self.ui = {}
	self:define_ui()
	return self
end

function SPACE_BEAR:enter()
	oo.getsuper(SPACE_BEAR).enter(self)
	self.ui.bus:set_active( true )
end
function SPACE_BEAR:quit()
	self.ui.bus:set_active( false )
	oo.getsuper(SPACE_BEAR).quit(self)
end
function SPACE_BEAR:update()
	-- si besoin du temps pour limiter : aaa.time.t en second
	if self.ui.bu_minus:get_value_as_bool() then
		self:print( "- plafonnier pushed" )
		m42:send_osc("ceiling/less", 1)
	end
	if self.ui.bu_plus:get_value_as_bool() then
		self:print( "- plafonnier pushed" )
		m42:send_osc("ceiling/more", 1)
	end
	local v = self.ui.bu_hans:get_value()
	v = math.floor( v * 100 ) * .01
	if v ~= self.last_hans then
		self:print( "hans "..v )
		self.last_hans = v
		m42:send_osc("hans", v * 0.99)
	end
end

function SPACE_BEAR:define_ui()
	local bus = BUS:create( "Bear" )

	self.ui.bus = bus
	bus:set_active( true )
	bus:init_begin_add_to_ga()

		--	x, y, size_x, size_y, angle(en tours)
		local bu = bus:add_slider( "Hans", {-3, 0, 2, 1, 0.25 } )
		self.ui.bu_hans = bu

		local function change_bu( bu )
			bu:set_text_factor( .1 )
			bu:set_trig()
		end

		local S = 1.5
		bu = bus:add_button( "- plafonnier",	{1,1, S,S} )
		self.ui.bu_minus = bu
		change_bu( bu )

		bu = bus:add_button( "+ plafonnier",	{2.8,1, S,S} )
		self.ui.bu_plus = bu
		change_bu( bu )

	bus:init_end()

	bus:set_active(false)

	return bus
end
