
function m42:draw_background()
	bus_cur:draw_debug_str( "Back", -4, 1.3 )
end

function m42:draw_foreground()
	local self = m42
	--bus_cur:draw_debug_str( "Fore", -4, 1.2 )
	--	FBO_OUT
	if not self.b_ui_in_fbo and self.b_fbo_out then
		if self.skel then self.skel:draw_on_top() end
		self.fbo_and_out:draw_out()
	end
end

function m42:draw_foreground_top()
	local self = m42
	--bus_cur:draw_debug_str( "Fore", -4, 1.2 )
	--	FBO_OUT
	if self.b_ui_in_fbo and self.b_fbo_out then
		self.skel:draw_on_top()
		self.fbo_and_out:draw_out()
	end
end

local function set_layer_focus( bu )
	if bu:get_value_as_bool() then
		local space = m42.space_stack:get_top()
		local layers = space:get_cam_layerss()
		if layers then
			--aaa.obj.set_focus_ui( layers )
			aaa.obj.become_ui( layers )
		end
	end
end
function m42:define_ui_base()
	local bus = BUS:begin_window( "M42_first" )
	bus:set_bu_pos_load_save( true )

--	BU.set_pos_load_save_default( false )
	local bu

	bu = self:add_flag( "b_fbo_out",			"FBO OUT",			true	)
		bu:set_value_load_save( true )
	bu = self:add_flag( "b_ui_in_fbo",			"UI in FBO",		false	)
	bus:move_next()

	bu = self:add_flag( "b_grid_draw",			"Grille Draw",		false	)

	bus:move_next()
	bu = bus:add_selector( "Background" )
		--bu:set_text_draw( false )
		--bu.text_u = .22
		--bu.text_v = -1.15
		bu:set_nb_min_0( 3, 1 )
		--bu.do_mouse_move = back_color_do_click_down
		--bu:set_method_on_click(			app, "change_back_color",	bu )
		self.s_back = 0
		bu:set_item_text( 1, "No", "Utram" )
		bu:set_target_lua( self, "s_back" )
		bu:set_value_load_save( true )

	bu = self:add_flag( "b_skel_draw",			"Skel Draw",		true	)
		bu:set_value_load_save( true )
	bu = self:add_flag( "b_skel_dress", 		"Skel Dress",		false	)
		bu:set_value_load_save( true )
	bu = self:add_flag( "b_particle_draw", 		"Particle Draw",	false	)
		bu:set_value_load_save( true )
	bu = self:add_flag( "b_wspace", 			"Space",			false	)
		bu:set_value_load_save( true )
	bus:move_right( 1 )
		bu = self:add_flag( "b_wspace_draw",	"Space Draw",		true	)
		bu = self:add_flag( "b_wspace_top",		"Space top",		false	)
			bu:set_fn_on_click(	 set_layer_focus, bu )
		bu = self:add_flag( "b_www_update",		"Update_www",		true	)
	bus:move_left( 1 )
	bu = self:add_flag( "b_foreground_draw",	"Foreground Draw",	false	)

	bus:end_window()

	return bus
end

function m42.ui.add_text( bus, text, x, y )
	local bu = bus:add_text_info( text,	{x,y, .25,.25} )
	bu:set_ui_top_size( true )
	return bu
end

function m42.do_out( )
	m42.skel:store_gesture( "out" )
end

function m42:define_ui_wspace()
	local bus = BUS:begin_window( "WSpace" )

	local skel = self.skel

	local bu
	--bus:move_next()
	bus:add_but_trig_fn( "In", nil,	skel and skel.store_gesture, skel, "in" )
	bu = bus:add_slider_xy( "Pilot" )
	bu:center()
	self.ui.bu_pilot = bu
	bus:add_but_trig_fn( "Out", nil, skel and skel.store_gesture, skel, "out" )

	bu = bus:add_button( "No Out" )
	self.ui.bu_no_out = bu

	bus:end_window()

	return bus
end

function m42:add_switch_lua( text, tab, key, state )
	local bu =  bus_cur:add_button( text )
	key = "b_"..key
	if state == nil then
		if not tab[key] then
			tab[key] = false
		end
	else
		tab[key] = state
	end
	bu:set_target_lua( tab, key )
	return bu
end

function APP:define_www( x, y, sx, sy, name, addr )
	local bus = BUS:create( name )
	--bus:set_active( true )
	bus:init_begin()

		local bu

		local bu_www
		local rx = 16/9
		local h = 4
		local w = 4 * rx

		bu_www = BU_WWW:create( {h*.5*rx,2.1, w,h} )
		bu_www:set_pixel_size( 1024, 1024/rx )
		bu_www:disable_mobile()
		bu_www:set_www_page( addr, not self.b_start_load_www )
		bu_www:set_move_to_front( false )
		bus.bu_www = bu_www

		local  function add_but( x, text, fn )
			local bu = bus:add_trig( text,	{x,4.25, .3,.3} )
				bu:set_fn_on_click( fn, bu_www )
				bu:set_text_xy( -.26, -.28 )
			--bu:set_dplane(1000)
			--bu:move_to_front()
			return bu
		end

		local X		= 3.	--	.15
		local DX	= .35
		bu = add_but( X,	"<", BU_WWW.go_back )
		bu = add_but( X+DX, ">", BU_WWW.go_forward )

		bus:add_bu( bu_www ) -- added after to be under this other

	bus:init_end()

	bu = bus_cur:add_window( name, bus,	{x,y, 2*rx,2.2} )

	return bu
end

function m42:define_app_ui()
---[[
	local spaces = self.spaces
	spaces.bear	= SPACE_BEAR:create( "Bear" )
	if aaa.lua.global.get( "maa_show_pages_define") then
		spaces.maa	= SPACE:create( "Maa" )
		spaces.maa:set_bus( maa_show_pages_define( true ) )
	end
--]]

	self.ui.bus_base	= self:define_ui_base()

	local bu

	local bus = BUS:create( "Matrix 42" )
		self.ui.bus = bus
		bus:set_active( true )
		bus:set_bu_pos_load_save( true )
		bus:init_begin_add_to_ga()

		bu = bus:add_window(		"Base", self.ui.bus_base,			{-3,0,	2,2}	)

		if self.skel then
			bu = bus:add_window(	"Skel", self.skel:define_ui(),		{3,0,	4,2}	)
		end

		bu = bus:add_window(		"Space", self:define_ui_wspace(),	{0,0,	2,2}	)

	--	bu = ga:app:define_www( -2, 0,	3, 3,	"www1", "www.youtube.com" )
	--	bu = ga:app:define_www( -1, 0,	3, 3,	"www2", "www.vimeo.com" )
	--	bu = ga:app:define_www( 0, 0,	3, 3,	"www3", "www.youtube.com" )

		bu = bus:add_window(		"Scope", self:define_ui_scope(),	{0,2,	3,1.5}	)
			bu:__set_window_state("mini")

		bu = bus:add_window(		"Osc", self:define_ui_osc(),		{-1,2,	2,2}	)
			bu:__set_window_state("mini")

		bu = bus:add_window(		"Bodys", self.bodys:define_ui(),	{0,2,	2,2}	)
			bu:__set_window_state("mini")

	bus:init_end()

	bus:					set_method(	"draw_before",	self, "draw_background" )
	local bus_ctx = ga:get_bus_ctx()
	bus_ctx:get_regular():	set_method(	"draw_after",	self, "draw_foreground" )
	bus_ctx:get_top():		set_method(	"draw_after",	self, "draw_foreground_top" )

	ga:register_ui_group( bus )
	ga:set_ui_group_active( false )

	return bus
end