
-- Stat. Collection for M42

-- write appened values on a file at each end Session (visitor ID)

local stat_path = aaa.dir.make_media_path("Matrix42/Stats/")
local stat_filename = "M42_Stats.txt"
local stat_filepath = stat_path..stat_filename


-- STAT_FILE Class
CLASS.DECLARE( "STAT_FILE" )

function STAT_FILE:create( i )
	local self = STAT_FILE:create_instance( "stat_file_"..i )
	self:init( i )
	return self
end


function STAT_FILE:init( i )


	self.id 	= i

	self.count_events = {}
	self.count_events.enter_level0 = 0
	self.count_events.enter_web = 0
	self.count_events.enter_104 = 0
	self.count_events.enter_pong = 0

	self.count_events.web_cliks = 0

	self.count_time = {}
	self.count_time.active = 0
	self.count_time.inactive = 0
	self.count_time.com_watch = 0

	self.count_time.into_m42 = 0
	self.count_time.into_training = 0
	self.count_time.into_web = 0
	self.count_time.into_104 = 0
	self.count_time.into_pong = 0

	self.count_distance = {}
	self.count_distance.walk_m42 = 0
	self.count_distance.walk_in_training = 0


	self.global = {}
	self.global.n_visitors = 0

	self.global.n_visitors_web = 0
	self.global.n_visitors_104 = 0
	self.global.n_visitors_pong = 0

	self:print( "init done!" )

	end

function STAT_FILE:update(event_type, universe, value)

	-- updated on event push?

	-- event_type ={global, distance, Count_time, count_event, }
	-- universe = {matrix42, level0, level_104, web, pong,}


end

function STAT_FILE:write_txt(stat_filepath, visitor_id)

	v = {}
	v[1] = visitor_id

	v[2] = self.count_events.enter_training
	v[3] = self.count_events.enter_web
	v[4] = self.count_events.enter_104
	v[5] = self.count_events.enter_pong

	v[6] = self.count_events.web_cliks

	v[7] = self.count_time
	v[8] = self.count_time.active
	v[9] = self.count_time.inactive
	v[10] = self.count_time.com_watch

	v[11] = self.count_time.into_m42
	v[12] = self.count_time.into_training
	v[13] = self.count_time.into_web
	v[14] = self.count_time.into_104
	v[15] = self.count_time.into_pong

	v[16] = self.count_distance
	v[17] = self.count_distance.walk_m42
	v[18] = self.count_distance.walk_in_training

	v[19] = self.global.n_visitors

	v[20] = self.global.n_visitors_web
	v[21] = self.global.n_visitors_104
	v[22] = self.global.n_visitors_pong

	n_values = 22

	-- Write All values on a line in CSV (separator: ", ")

	file_handle = io.open(stat_filepath, "a+")

	for i = 1, n_values do
		file_handle:write(v[i])
		file_handle:write(", ")
	end

	local time_table = {}
	time_table = os.date ("*t", os.time())
	file_handle:write(time_table.year)
	file_handle:write(", ")
	file_handle:write(time_table.month)
	file_handle:write(", ")
	file_handle:write(time_table.day)
	file_handle:write(", ")
	file_handle:write(time_table.hour)
	file_handle:write(", ")
	file_handle:write(time_table.min)
	file_handle:write(", ")
	file_handle:write(time_table.sec)

	file_handle:write("\n")
	file_handle:close()
	self:print( "Stat file written!" )

end


 -- To DO:

 -- pass event and increase/upadate counts and values..

 -- import prev. global values (N visitors,..) from last session/ last visitor
 -- ..from last file opened
 