
--todo make an OSC object

--	send to Max using OSC
function m42:send_osc( what, ... )
	local osc = self.osc
	if not osc then return end
	osc.count = osc.count + 1
	local tag = "/bearstech/"..what
	if osc.b_verbose then
			--aaa.print( "m42:send_osc() "..eo.osc.count )
		if osc.b_send then
			aaa.print( osc.count.." : osc_send( "..tag..make_str_from_list( ... ).." )" )
		else
			aaa.print( "DONT : osc_send( "..tag..make_str_from_list( ... ).." )" )
		end
	end
	if osc.b_send then
		aaa.net.osc_send_no_bundle( osc.dst, tag, ... )
	end
	--aaa.sleep( osc_delay )
end

function m42:init_osc()
	self.osc = {}
	local osc = self.osc
	osc.count = 0
	osc.b_verbose = true
	osc.b_send = true

	osc.dst = 2
end

function m42:update_osc()
	local osc = self.osc
	if not osc then return end

	--self:print( "update_osc()" )
	if osc.bu then
		for i,bu in IPAIRS( osc.bu ) do
			--self:print( i )
			local val = bu:get_value()
			--2024 June Maa had to add this to avoid error ?
			if type(val)=="boolean" then
				val = val and 1 or 0
			end
			val = math.floor( val * 10 ) * .1
			if not bu.__osc_send or bu.__osc_send ~= val then
				self:send_osc( bu.what, val )
				bu.__osc_send = val
			end
		end
	end
	self:receive_osc()
end

function m42:draw_osc()
	local osc = self.osc
	if not osc then return end

end

function m42:receive_osc()
	repeat
		--self:print( "receive_osc()" )
		local tags, args = aaa.net.osc_take_by_start( "/bearstech" )
		if tags	then
			--self:print( "receive_osc() tags" )
			for i, v in ipairs(tags) do
				self:print( "tag\t"..v )
			end
		else
			break
		end
		for i, v in IPAIRS(args) do
			self:print( "\targs\t"..v )
		end
	until false
end

function m42:add_osc_trig_str( text, what, str )
	local bu =  bus_cur:add_trig( text )
		bu:set_method_on_click(		self, "send_osc", what, str )
	return bu
end
function m42:click_osc_bool( what, bu )
	self:send_osc( what, bu:get_value_as_bool() )
end
function m42:add_osc_bool( text, what )
	local bu =  bus_cur:add_button( text )
	bu:set_method_on_click(		app, "click_osc_bool", what, bu )
	return bu
end
function m42:click_osc_float( what, bu )
	self:send_osc( what, bu:get_value() )
end
function m42:add_osc_slider( text, what )
	local bu =  bus_cur:add_slider( text )
	bu.what = what
	return bu
end

function m42:define_ui_osc()
	local osc = self.osc
	if not osc then return end
	osc.bu = {}

	local bus = BUS:begin_window( "Osc" )

	local bu

	--self:add_osc_trig_str( "Play", "music/play/", "titre album" )
	--self:add_osc_trig_str( "Stop", "music/stop/", "none" )
	--self:add_osc_bool( "BEAR", "bear/" )
	bu = self:add_osc_slider( "Hans", "hans" )
	table.insert( osc.bu, bu )
	--bu = self:add_osc_slider( "Plafonier", "ceiling" )
    --bu:set_value( 1 )
	bu = self:add_osc_trig_str( "- plafonnier", "ceiling/less")
	table.insert( osc.bu, bu )
	bu = self:add_osc_trig_str( "+ plafonnier", "ceiling/more")
	table.insert( osc.bu, bu )


	bus:end_window()

	bus:set_method(	"draw_after",	self, "draw_osc" )

	return bus
end
