
function m42:do_arrow( v )
	aaa.mess.show( "do_arrow "..v )
	if v==1 then
		self.bodys:inc_index()
	elseif v==-1 then
		self.bodys:dec_index()
	end
end

function m42:draw()
	if not self:is_init_done() then return end

	local ref = self.ref
	--	FBO
	if self.b_fbo_out then
		self.fbo_and_out:draw_fbo()
	end
	--BACKDROP
	local s_back = self.s_back
	if s_back ~= 0 then
		--self:print( self.s_back )
		local backdrop = ref.backdrop
		if backdrop then
			local obj = backdrop[s_back]
			if obj then
				aaa.obj.update_then_draw(obj)
			else
				self:print_error( "No backdrop for key "..s_back )
				return
			end			
		else
			self:print_error( "No backdrop ref")
			return
		end
	end
	--self:print( aaa.obj.get_name(ref.backdrop[2]) )

	--	CAMERA
	aaa.obj.update_then_draw( ref.camera_layers )
	--	GRILLE
	if self.b_grid_draw then
		aaa.obj.update_then_draw( ref.grille_layers )
	end
	--	WSPACE
	--self:print( self.b_fix )

	if self.b_wspace and self.b_wspace_draw then
		local space = self.space_stack:get_top()
		space:draw()
	end

	local b = m42.building_cur
	if b then
		if b.ref then
			local ref = b.ref
			if ref.obj then
				aaa.obj.update_then_draw( ref.obj )
			end
		end
	end
	aaa.obj.update_then_draw( ref.camera_layers )


	--	SKELETON
	local skel = self.skel
	if skel then
		skel:draw_before()
		if self.b_skel_draw		then	skel:draw( false )			end
		if self.b_skel_dress	then
			m42.bodys:updraw( skel )
			gol.set_default()
			self.arrow:updraw()
		end
	else
		self:print_debug( "No skel" )
	end

	--	PARTICLE HALO
	if self.b_particle_draw then
		aaa.obj.update_then_draw( ref.part_grad_layer )
		aaa.obj.update_then_draw( ref.part_halo_layer )
	end
	--	PARTICLE
	if self.b_particle_draw then
		aaa.obj.update_then_draw( ref.part_grad_layer )
		aaa.obj.update_then_draw( ref.part_layer )
	end

	--	FOREGROUND
	if self.b_foreground_draw then
		aaa.obj.update_then_draw( ref.foreground_layers	)
	end
	--	FBO_OUT
	--if not self.b_ui_in_fbo and self.b_fbo_out then
	--	self.fbo_and_out:draw_out()
	--end


end

function m42:part_update()
	local ref = self.ref
	local b_skel = self.skel:is_on()

	if b_skel then
		param.set( ref.part_halo_nb_by_sec,	4096	)
		param.set( ref.part_nb_by_sec,		512		)
	else
		param.set( ref.part_halo_nb_by_sec,	0		)
		param.set( ref.part_nb_by_sec,		0		)
	end
end

local function do_neutral( v, min )
	if v < -min then
		v = ( v + min )	/ ( 1 - min )
	elseif v > min then
		v = ( v - min )	/ ( 1 - min )
	else
		v = 0
	end
	return v
end

function m42:print_move()
	self:print( m42.move.tra.."\t"..m42.move.tra_lat.."\t"..m42.move.rot )
end
function m42:update()
	if not self:is_init_done() then return end
	APP.update( self )

	self.time = aaa.time.t

	local skel = self.skel
	if skel then
		skel:update()
		--if true then return end

		if skel:is_kinect_active() then
			local b_skel = skel:is_on()
			if self.b_skel ~= b_skel then
				self:print( "skel change to "..b_skel )
				if b_skel then
				else
				end
				self.b_skel = b_skel
			end
			skel:update_multitouch()
			self:update_scope()
		end
	else
		self:print_debug( "No skel" )
	end

	if self.b_wspace then
		local tra, tra_lat, rot
		local space = self.space_stack:get_top()
		--space:print( space.is_wspace().." "..skel.selected_id.." "..self.b_fix )
		if not space.is_wspace() or self.b_fix then --todo
			tra, tra_lat, rot = 0,0,0
		else
			tra, tra_lat, rot = skel:get_tra_lat_rot()
		end

		local	bu = self.ui.bu_pilot
		local	o_tra = 0
		local	o_rot = 0
		--bu:print( "toto" )
	--	if bu then	--because not initialize
			o_tra = bu:get_value( 2 ) - .5
			o_rot = bu:get_value( 1 ) - .5
			--self:print( o_tra, o_rot )
			o_tra = do_neutral( o_tra, .1 ) * 8
			o_rot = do_neutral( o_rot, .1 ) * 4
	--	end
		m42.move = { tra=tra + o_tra, tra_lat=tra_lat, rot=rot + o_rot }
	--	self:print_move( )

		--self:print( self.b_fix.." "..tra.." "..rot )

		space:update()

		--if wspace.time_init_end then
		if space.is_wspace() and skel:is_gesture( "in" ) then
			local b = space:try_to_enter_building()
			if b then
				skel:set_gesture_used( "in" )
				local new_space = b:enter()
				if new_space then
					self.space_stack:push( new_space )
					self:print( "Level "..self.space_stack:get_size() )
					new_space:enter()
				end
			end
		end
		if self.space_stack:get_size()>1 and skel:is_gesture( "out" ) and self.ui.bu_no_out:get_value_as_bool() == false then
			skel:set_gesture_used( "out" )
			if m42.building_cur then
				m42.building_cur:quit()
			end
			self.space_stack:pop():quit()
		end
	end

--[[
	if not self.net_started and aaa.time.t > (self.time_aaaseed_start + 16.) then
		aaa.net.set_active( true )
		self.net_started = true
	end
--]]
	--self.set_frustum()

	if self.b_particle_draw then
		self:part_update()
	end
	self:update_osc()

	--aaa.print( "I DO IT" )
	self.flatland_tex = { 30, 44, 45 }
end

if IS_BUSS_OPEN() then
	m42:clear_init_done()
	m42:init_app()
	m42.b_start_load_www = false
elseif IS_BUSS_TOP_OPEN() then
	m42:define_app_ui()
else
	m42:update()
	m42:draw()
end

---- stand
----		group to draw
---- etiquette
---- click
--- bug gesture
-- button fake skel or use bu_acc
-- button in ouT
--	offset and size by wspace
-- nb repeat by wpace
-- putain d'offset des centre pour tete de bois
