
if not m42.wspace_def then
	m42.wspace_def = {}
end

BUILDING_DEF.put_table
{
	{	name = "pylon",
		color = "gray",
		geo = "cone", 	-- default "box"
	},

	{	name = "stand",
		type = "www",
		model = "stand",	-- default "none"
	},

	{	name= "babyfoot",
		type = "mc",
		model = "foosball",
		color = "gray",
	},

}

if not m42.spaces then return end
local space = m42.spaces.village_innov
if not space then return end

space.space_factor = .7
space.building_factor = .80
space.title_factor = .7
space.OX = -26
space.OZ = -16
space.limit = { sx=60, sz=32 }


local d = .05
local sx = 2 - d
local sz = .72 - d
local r = .34
m42.wspace_def.village_innov =
{
	{	b_def="pylon",	r=r,	x=2.06,		z=3.1,		sy=10,	},
	{	b_def="pylon",	r=r,	x=7.36, 	z=3.1, 		sy=10,	},
	{	b_def="pylon",	r=r,	x=2.06,		z=3.1,		sy=10,	},
	{	b_def="pylon",	r=r,	x=12.62,	z=3.1, 		sy=10, 	},
	{	b_def="pylon",	r=r,	x=17.95,	z=3.1, 		sy=10, 	},
	{	b_def="pylon",	r=r,	x=23.23,	z=3.1, 		sy=10,	},
	{	b_def="pylon",	r=r,	x=28.57, 	z=3.1, 		sy=10,	},
	{	b_def="pylon",	r=r,	x=33.82, 	z=3.1, 		sy=10, 	},
	{	b_def="pylon",	r=r,	x=39.13, 	z=3.1, 		sy=10, 	},
	{	b_def="pylon",	r=r,	x=2.06, 	z=23.08, 	sy=10, 	},
	{	b_def="pylon",	r=r,	x=7.36, 	z=23.08, 	sy=10, 	},
	{	b_def="pylon",	r=r,	x=12.62, 	z=23.08, 	sy=10, 	},
	{	b_def="pylon",	r=r,	x=17.95, 	z=23.08, 	sy=10, 	},
	{	b_def="pylon",	r=r,	x=23.23, 	z=23.08, 	sy=10, 	},
	{	b_def="pylon",	r=r,	x=28.57, 	z=23.08, 	sy=10, 	},
	{	b_def="pylon",	r=r,	x=33.82, 	z=23.08, 	sy=10, 	},
	{	b_def="pylon",	r=r,	x=39.13, 	z=23.08, 	sy=10, 	},

	{	name="babyfoot",			title="Baby Foot",		b_def="babyfoot",	sx=0.85,	sz=1.46,	sy=0.85,	x=7.44,	z=4.95	},

	{   name="villedufutur", 		title="Ville du Futur",	b_def="stand",  sx=4, 	sz=sz, sy=3, x=11.5, 	z=5.75,
		url="http://www.vectuel.com/",
	},
	--{   name="pun", 				title="PUN",			b_def="stand",  sx=sx, 	sz=sz, sy=3, x=9.32, 	z=9.37,		},
	{   name="mobilierurbain",		title="Mobilier Urbain",b_def="stand",  sx=sx, 	sz=1.44, sy=3, x=14, 	z=8.63,
		url="http://www.modulowatt.com/Modulowatt_Actualite_Mobilier_Urbain_Intelligent.html",
	},
	{   name="hubstartair",			title="HubStartAir",	b_def="stand",  sx=sx, 	sz=2, 	 sy=3, x=17.32, z=4.63,
		url="http://hubstart-paris.over-blog.com/",
	},
	{   name="variations",			title="Variations",		b_def="stand",  sx=3, 	sz=2, 	 sy=3, x=3.17, 	z=4.52,
		url="http://www.futur-en-seine.fr/projet/variations/",
	},
	--{   name="digitalshadows",  	title="Digital Shadows",b_def="stand",  sx=sx, 	sz=sz, sy=3, x=15.32, z=12.96,	},
	--{   name="chemindigital",  		title="Chemin Digital",	b_def="stand",  sx=sx, 	sz=sz, sy=3, x=19.32, z=12.96,	},
	{   name="videointer",  		title="Video Interactive",		b_def="stand",	sx=sx, 	sz=sz, sy=3, x=31.31, z=5.7,
		url="http://ak0.free.fr/aerodromek/aerodromek_index.html",
	},
	{   name="dataveyez",  			title="DataVeyez",		b_def="stand",	sx=sx, 	sz=sz, sy=3, x=11.43,	z=15.83,
		url="http://dataveyes.com/",
	},
  	{   name="imprimante3D",		title="Imprimante 3D",	b_def="stand",	sx=1.83,sz=1.71, sy=2, x=23.84, z=19.33,
		url="http://ckab.net/3d-printing",
	},
	{   name="salonlivremontreuil",	title="Salon du Livre de Montreuil",	b_def="stand",	sx=sx, 	sz=sz, sy=3, x=35.48, z=19.47,
		url="http://www.salon-livre-presse-jeunesse.net/accueil.html",
	},
	{   name="ifrath",				title="Ifrath",			b_def="stand",	sx=sx, 	sz=sz, sy=3, x=37.51, z=15.83,
		url="http://www.futur-en-seine.fr/projet/concours-jva-2012/",
	},
	{   name="ifrath2",				title="Ifrath 2",		b_def="stand",	sx=sx, 	sz=sz, sy=3, x=35.51, z=16.55,
		url="http://www.futur-en-seine.fr/projet/concours-jva-2012/",
	},
	{   name="laruche2",			title="Laruche qui dit oui",		b_def="stand",	sx=sx, 	sz=sz, sy=3, x=37.51, z=16.55,
		url="http://www.laruchequiditoui.fr/",
	},
	{   name="capdigital",			title="Cap Digital",	b_def="stand",	sx=4,   sz=1.44, sy=3, x=46.8, 	z=19.47,
		url="http://www.capdigital.com/",
	},
	{   name="europe",				title="Europe",			b_def="stand",	sx=4, 	sz=1.44, sy=3, x=46.79, z=4.98,
		url="http://www.iledefrance-europe.eu/evenements/detail-actualites-evenements/article/futur-en-seine-le-festival-du-numerique.html",
	},
	{   name="etablinumerique",		title="Etabli Num�rique",	b_def="stand",	sx=4, 	sz=1.44, sy=3, x=43.5, 	z=17.25,
		url="http://www.futur-en-seine.fr/prototype/etabli-numerique/",
	},
	{   name="francoisbrument",		title="Fran�ois Brument",	b_def="stand",	sx=4.39,sz=1.47, sy=6, x=26.18, z=13.97,
		url="http://www.in-flexions.com/",
	},
	{   name="parrot",				title="Parrot",			b_def="stand",	sx=2.76,sz=1.69, sy=4, x=26.18, z=12.24,
		url="http://www.parrot.com/fr",
	},
	{   name="mathieulehanneur",	title="Mathieu Lehanneur",	b_def="stand",	sx=2.84,sz=3.25, sy=4, x=23.33, z=12.24,
		url="http://www.mathieulehanneur.fr/works.php",
	},
	{   name="stephanevillard",		title="St�phane Villard",	b_def="stand",	sx=2.84,sz=1.78, sy=4, x=23.33, z=15.47,
		url="http://www.ggsv.fr/",
	},
	{   name="nodesign",			title="No Design",		b_def="stand",	sx=2.76,sz=1.69, sy=4, x=26.18, z=15.47,
		url="http://www.nodesign.net/",
	},

	{   name="pollux", 			b_def="stand", 	sx=sx,	sz=sz, 	sy=3, 	x=9.5,		z=5.03,
		title="Pollux",
		url="http://ckab.net/polluxnz-city",
	},
	{   name="arbreole", 		b_def="stand",  sx=sx, 	sz=sz, 	sy=3, 	x=11.5, 	z=5.03,
		title="Arbreole",
		url="http://arbreole.com/",
	},
	{   name="ornicra", 		b_def="stand",  sx=sx, 	sz=sz, 	sy=3, 	x=13.5, 	z=5.03,
		title="Onirca",
		url="http://www.youtube.com/watch?v=_2xYSh18V6A&feature=plcp",
	},
	{   name="evolvingcities", 	b_def="stand",  sx=sx, 	sz=sz, 	sy=3, 	x=9.5, 		z=5.75,
		title="Evolving Cities",
		url="http://evolvingcities.org",
	},
	{   name="smartgrid3d", 	b_def="stand",  sx=sx, 	sz=0.72, 	sy=3, 	x=5.32, 	z=8.65,
		title="Smart Grid 3D",
		url="http://www.futur-en-seine.fr/prototype/smart-grid-3d/",
	},
	{   name="ecitoyen", 		b_def="stand",  sx=sx, 	sz=sz, 	sy=3, 	x=7.32, 	z=8.65,
		title="Ecitoyen",
		url="http://3d-villes.com/",
	},
	{   name="sikiwis", 		b_def="stand",  sx=sx, 	sz=sz,	sy=3, 	x=9.32, 	z=8.65,
		title="Sikiwis",
		url="http://www.wikifun.com/page/worlddefault.aspx",
	},
	{   name="gobilab",  		b_def="stand",  sx=sx, 	sz=sz, 	sy=3, 	x=5.32, 	z=9.37,
		title="Gobilab",
		url="http://www.gobilab.com/",
	},
	{   name="buzzcar",   		b_def="stand", 	sx=sx, 	sz=sz, 	sy=3, 	x=7.32, 	z=9.37,
		title="BuzzCar",
		url="http://www.buzzcar.com/fr/",
	},
	{   name="jcdecaux",   		b_def="stand", 	sx=3, 	sz=4, 		sy=4, 	x=1.43, 	z=10.65,
		title="J.C. Decaux",
		url="http://www.jcdecaux.fr/",
	},
	{   name="eartsup",    		b_def="stand", 	sx=sx, 	sz=sz, 	sy=3, 	x=7.32, 	z=12.24,
		title="EartSup",
		url="http://www.e-artsup.net/",
	},
	{   name="dassault",    	b_def="stand",  sx=4, 	sz=1.44, 	sy=3, 	x=9.32, 	z=12.24,
		title="Dassault",
		url="http://www.3ds.com/",
	},
	{   name="noonmuseum",    	b_def="stand",  sx=sx, 	sz=sz, 	sy=3, 	x=13.32, 	z=12.24,
		title="Noon Museum",
		url="http://www.noomuseum.net/",
	},
	{   name="amenier",    		b_def="stand",  sx=sx, 	sz=sz, 	sy=3, 	x=15.32, 	z=12.24,
		title="Amenier",
		url="http://www.albertinemeunier.net/",
	},
	{   name="clameurs",    	b_def="stand", 	sx=sx, 	sz=sz, 	sy=3, 	x=17.32, 	z=12.24,
		title="Clameurs",
		url="http://clameurs.fr/",
	},
	{   name="odn",    			b_def="stand", 	sx=sx, 	sz=sz, 	sy=3, 	x=19.32, 	z=12.24,
		title="O. D. N.",
		url="https://sites.google.com/site/associationsiriusproductions/odn",
	},
	{   name="imarginal",   	b_def="stand",  sx=sx, 	sz=sz, 	sy=3, 	x=7.32, 	z=12.96,
		title="Imarginal",
		url="http://www.imarginal.com/",
	},
	{   name="remu",   			b_def="stand",  sx=sx, 	sz=sz, 	sy=3, 	x=13.32, 	z=12.96,
		title="Remu",
		url="http://www.mu.asso.fr/PANGEE-le-jardin-instrument",
	},
	{   name="solen",   		b_def="stand",  sx=sx, 	sz=sz, 	sy=3, 	x=17.32, 	z=12.96,
		title="Solen",
		url="http://solen-capdigital.com/",
	},
	{   name="sami",   			b_def="stand", 	sx=sx, 	sz=sz, 	sy=3, 	x=19.32, 	z=8.63,
		title="Sami",
		url="http://www.futur-en-seine.fr/wp/wp-content/uploads/2012/02/sami_400.jpg",
	},
	{   name="robotemox",   	b_def="stand", 	sx=sx, 	sz=sz, 	sy=3, 	x=21.32, 	z=8.63,
		title="Robot Emox",
		url="http://www.emox-robot.com/",
	},
	{   name="jazz",   			b_def="stand", 	sx=sx, 	sz=sz, 	sy=3,	x=19.32, 	z=9.35,
		title="Jazz",
		url="http://www.gostai.com/",
	},
	{   name="karotz",   		b_def="stand", 	sx=sx, 	sz=sz, 	sy=3, 	x=21.32, 	z=9.35,
		title="Karotz",
		url="http://blog.karotz.com/",
	},
	{   name="jardindesamours",	b_def="stand", 	sx=sx, 	sz=sz, 	sy=3, 	x=23.32, 	z=9.35,
		title="Jardin des Amours",
		url="http://www.futur-en-seine.fr/fens_2011/wp-content/uploads/2011/05/Coque-banc-face-580x267.jpg",
	},
	{   name="joshfire",  		b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=29.31, 	z=4.98,
		title="JoshFire",
		url="http://joshfire.com/",
	},
	{   name="withings",  		b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=31.31, 	z=4.98,
		title="Withings",
		url="http://www.withings.fr/",
	},
	{   name="clavierinter",  	b_def="stand",	sx=sx*2, 	sz=sz, 	sy=3, 	x=33.31, 	z=4.98,
		title="Clavier Inter",
		url="http://www.futur-en-seine.fr/wp/wp-content/uploads/2012/03/clavier-interactif1.jpg",
	},
	{   name="qobuz",  			b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=29.31, 	z=5.7,
		title="Qobuz",
		url="http://www.qobuz.com/",
	},
	{   name="augment",  		b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=33.31, 	z=5.7,
		title="Augment",
		url="http://www.futur-en-seine.fr/wp/wp-content/uploads/2012/04/visuel-augment-redimensionn%C3%A91.png",
	},
	{   name="qook",  			b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=35.31, 	z=5.7,
		title="qooq",
		url="http://www.qooq.com/",
	},
	{   name="sense",  			b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=39.31, 	z=4.98,
		title="Sense",
		url="http://open.sen.se/",
	},
	{   name="confortvisuel",  	b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=39.31, 	z=4.98,
		title="Confort Visuel",
		url="http://www.futur-en-seine.fr/wp/wp-content/uploads/2012/05/visuel_confortvisuel_2012.png",
	},
	{   name="stayingalive",  	b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=35.37, 	z=8.62,
		title="Staying Alive",
		url="http://www.futur-en-seine.fr/wp/wp-content/uploads/2012/05/Staying-Alive-8.png",
	},
	{   name="qiiqspa",  		b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=35.37, 	z=9.34,
		title="Qiispa",
		url="http://www.futur-en-seine.fr/wp/wp-content/uploads/2012/04/UPMC.png",
	},
	{   name="tweetgo",  		b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=7.43, 	z=15.83,
		title="Tweego",
		url="http://www.futur-en-seine.fr/wp/wp-content/uploads/2012/05/visuel-wdmtg.jpg",
	},
	{   name="metadata",  		b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=9.43, 	z=15.83,
		title="MetaData",
		url="http://www.futur-en-seine.fr/wp/wp-content/uploads/2012/04/logo.png",
	},
	{   name="mesagraph", 		b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=7.43, 	z=16.55,
		title="MesaGraph",
		url="http://www.futur-en-seine.fr/wp/wp-content/uploads/2012/05/Mesagraph-_-logo-v1.jpg",
	},
	{   name="digitas", 		b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=9.43, 	z=16.55,
		title="Digitas",
		url="http://www.digitas.fr/",
	},
	{   name="viewrz", 			b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=11.43, 	z=16.55,
		title="Viewrz",
		url="http://viewrz.com/",
	},
	{   name="hedera", 			b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=7.43, 	z=19.45,
		title="Hedera",
		url="http://www.hederatech.com/fr",
	},
	{   name="opensoftdata",	b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=9.43, 	z=19.45,
		title="Open Soft Data",
		url="http://http://www.opendatasoft.com/",
	},
	{   name="sotouch",			b_def="stand",	sx=4, 	sz=sz, 	sy=3,	x=7.43, 	z=20.17,
		title="SoTouch",
		url="http://www.futur-en-seine.fr/wp/wp-content/uploads/2012/05/visuel-so-touch-air-presenter.jpg",
	},
	{   name="quaero",			b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=11.43, 	z=20.17,
		title="Quaero",
		url="http://www.quaero.org",
	},
	{   name="hederaserveur",	b_def="stand",	sx=1, 	sz=1, 		sy=3, 	x=5.94, 	z=19.60,
		title="Hedera Serveur",
		url="http://www.hederatech.com/fr",
	},
	{   name="openvibe2",		b_def="stand",	sx=sx, 	sz=1.44, 	sy=3, 	x=15.36, 	z=15.83,
		title="Open Vibe 2",
		url="http://www.futur-en-seine.fr/wp/wp-content/uploads/2012/04/visuel-open-vibe.jpg",
	},
	{   name="fablabensci",		b_def="stand",	sx=4, 	sz=1.44, 	sy=3, 	x=17.36, 	z=15.83,
		title="Fabla Bensci",
		url="http://www.ensci.com/blog/fablab/",
	},
	{   name="tabletennis",		b_def="stand", 	sx=sx, 	sz=sz, 	sy=3, 	x=15.36, 	z=19.47,
		title="Table Tennis",
		url="http://www.futur-en-seine.fr/wp/wp-content/uploads/2012/04/TTST_Demo_HD-copy.jpg",
	},
	{   name="virtualclone",	b_def="stand",	sx=4, 	sz=sz, 	sy=3, 	x=17.36, 	z=19.47,
		title="Virual Clone",
		url="http://www.futur-en-seine.fr/wp/wp-content/uploads/2012/04/visuel-clone-studio.jpg",
	},
	{   name="sculpteo",		b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=21.36, 	z=19.47,
		title="Sculpteo",
		url="http://www.sculpteo.com/fr/",
	},
	{   name="jazztrump",		b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=15.36, 	z=20.19,
		title="Jazz Trump",
		url="http://www.futur-en-seine.fr/wp/wp-content/uploads/2012/04/Jazz_illu_hori.jpg",
	},
	{   name="justplay",		b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=17.36, 	z=20.19,
		title="Just Play",
		url="http://www.futur-en-seine.fr/wp/wp-content/uploads/2012/04/JustPlay-VIsuel.jpg",
	},
	{   name="mymwoo",			b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=21.36, 	z=20.19,
		title="Mymwoo",
		url="http://www.futur-en-seine.fr/wp/wp-content/uploads/2012/05/visuel-my-mwoo1.jpg",
	},
	{   name="angegardien",		b_def="stand",	sx=4, 	sz=sz, 	sy=3, 	x=29.55, 	z=19.47,
		title="Ange Gardien",
		url="http://www.futur-en-seine.fr/wp/wp-content/uploads/2012/02/ange_gardien.jpg",
	},
	{   name="laruche",			b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=29.55, 	z=20.19,
		title="La Ruche",
		url="http://www.la-ruche.net/",
	},
	{   name="owfapril",		b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=31.55, 	z=20.19,
		title="Owfapril",
		url="http://openworldforum.org",
	},
	{   name="etiennemineur",	b_def="stand",	sx=4, 	sz=sz, 	sy=3, 	x=37.48, 	z=19.47,
		title="Etienne Mineur",
		url="http://www.my-os.net/blog/",
	},
	{	name="musilabo",		b_def="stand",	sx=sx, 	sz=1.44, 	sy=3, 	x=41.48, 	z=19.47,
		title="MusiLabo",
		url="http://www.futur-en-seine.fr/wp/wp-content/uploads/2012/02/musilabo_visuel.png",
	},
  	{   name="babbleplanet",	b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=35.48, 	z=20.19,
		title="Babble Planet",
		url="http://www.babbleplanet.com/fr/",
	},
	{   name="aerys",			b_def="stand",	sx=4, 	sz=sz, 	sy=3, 	x=37.48, 	z=20.19,
		title="Aerys",
		url="http://www.futur-en-seine.fr/wp/wp-content/uploads/2012/05/visuel-aerys-dessine-moi-un-futur.jpg",
	},
	{   name="mailforgood",		b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=33.51, 	z=15.83,
		title="Mail For Good",
		url="http://www.futur-en-seine.fr/wp/wp-content/uploads/2012/04/infographie1.png",
	},
	{   name="reconnect",		b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=35.51, 	z=15.83,
		title="Reconnect",
		url="http://www.futur-en-seine.fr/wp/wp-content/uploads/2012/04/logo-reconnect.jpg",
	},
	{   name="gulibear",		b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=39.51, 	z=15.83,
		title="Guli Bear",
		url="http://www.futur-en-seine.fr/wp/wp-content/uploads/2012/05/gullibear-visuel.jpg",
	},
	{   name="idact",			b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=33.51, 	z=16.55,
		title="Idact",
		url="http://www.futur-en-seine.fr/wp/wp-content/uploads/2012/04/Bureau-de-Poste-plan1.png",
	},
	{   name="kolok",			b_def="stand",	sx=sx, 	sz=sz, 	sy=3, 	x=39.51, 	z=16.55,
		title="KoloK",
		url="http://www.futur-en-seine.fr/wp/wp-content/uploads/2012/04/KOLOL.jpg",
	},

}



