#define DAMP			0.95f
#define CENTER_FORCE	.1f
#define MOUSE_FORCE		3.0f
#define MIN_SPEED		0.001f
#define MIN_SPEED2		MIN_SPEED*MIN_SPEED
#define DT				0.02f

float extract_depht_uint( uint4 color )
{	//check the formula and check the kinect code

	//return ( ((color.x & 0xf) << 8) + ((color.y & 0xf) << 4) + (color.z & 0xf) ) * 0.001 ;
	return ((float)((color.y&0x03ffffff)>>16) ) / (256.*2.);
}
float extract_depht_float( float4 color )
{	//check the formula and check the kinect code
	int i;
	float f;
	i = color.x * 256.;
	i = i & 0xf;
	f = i << 8;

	i = color.y * 256;
	i = i & 0xf;
	f = f + (i << 4);
	i = color.z * 256;
	i = i & 0xf;
	f = f + i;
	//return ( ((color.x & 0xf) << 8) + ((color.y & 0xf) << 4) + (color.z & 0xf) ) * 0.001 ;
	//return ( color.x * 256. + color.y * 16. + color.z ) * .256;	// 1 / 16.
	return f * .001;
}

__kernel void Kinect_tex_to_3d(
							__global Particle*		particles
						,	__global float4*		pos_out
						,	__global float4*		col_out
						,	__global float4*		nor_out
						,	__global float4*		att_out
						,	const kernel_param		aaa
						,	const dataset_param		ds
//nvidia				__global __read_only image2d_t img,
//nvidia				__global __read_only image2d_t img2
						,	__read_only image2d_t	img
//						,	__read_only image2d_t	img2
)
{
	int id = get_global_id(0);					//	get the Particle index
	__global Particle *p = &particles[id];		//	get the particle struct
	int sub_id = id - aaa.i_offset;

//	get pixel color
	float2	img_size;	//	we need it later
	img_size.x =  get_image_width( img );
	img_size.y =  get_image_height( img );
	float2	pos;
	float x = (p->pos.x * aaa.p01 + aaa.p02) ;
	float y = (p->pos.y * aaa.p01 + aaa.p03) ;
	pos.x = (x + .5f) * img_size.x;
	pos.y = (y + .5f) * img_size.y;
	const sampler_t sampler		= CLK_FILTER_NEAREST | CLK_ADDRESS_CLAMP_TO_EDGE;
	//const sampler_t sampler		= CLK_FILTER_LINEAR	| CLK_ADDRESS_CLAMP;

	//uint4	color	= read_imageui( img, sampler, pos );
	//float	v = extract_depht_uint(color);

	float4	color	= read_imagef( img, sampler, pos );
	float	v = extract_depht_float(color);

//	eliminate early unwanted dots
	if( v == 0 )
	{
		//pos_out[id].x = -400;
		//pos_out[id].y = -4;
		pos_out[id].x = x * 1.33;
		pos_out[id].y = y;
		pos_out[id].z = 0;
		pos_out[id].w = 1;
		if( aaa.color > 0. )
		{
			col_out[id].x = 0.;
			col_out[id].y = 0.;
			col_out[id].z = 0.;
			col_out[id].w = 0.;
		}
		return;
	}

//	float4 one = {1,1,1,1};
	float z				=	v ;
	// x_meters = (x_pixelcoord - 160) * NUI_CAMERA_DEPTH_IMAGE_TO_SKELETON_MULTIPLIER_320x240 * z_meters;
	// y_meters = (y_pixelcoord - 120) * NUI_CAMERA_DEPTH_IMAGE_TO_SKELETON_MULTIPLIER_320x240 * z_meters;
	//	we need this z to compute x and y
	x				=	x * z * 0.89259375 * 1.3333333;
	y				=	y * z * 0.89259375;
//	x				=	x * z * .75 * 1.5;
//	y				=	y * z * .5625 * 1.5;	//	.75 * .75
	//	but then we can transform it

	/*
	float d = (z-ds.v[2])*(z-ds.v[2]) + (x-ds.v[0])*(x-ds.v[0]) + (y-ds.v[1])*(y-ds.v[1]) ;
	if( d > ds.v[3] )
	{
		//pos_out[id].x = -400;
		//pos_out[id].y = -4;
		pos_out[id].x = x * 1.33;
		pos_out[id].y = y;
		pos_out[id].z = 0;
		pos_out[id].w = 1;
		if( aaa.color > 0. )
		{
			col_out[id].x = 1.;
			col_out[id].y = 0.;
			col_out[id].z = 0.;
			col_out[id].w = 1.;
		}
		return;
	}

	x -= ds.v[0];
	y -= ds.v[1];
	z -= ds.v[2];
	z		= z + aaa.p02;
	*/
	float a;
	float c = 1;
	float s = 0;

	x += aaa.v01.x;
	y += aaa.v01.y;
	z += aaa.v01.z;

	s = sincos ( aaa.v02.x * M_PI * 2., &c );
	a = y * c + z * s;
	z = -y * s + z * c;
	y = a;

	s = sincos ( aaa.v02.y * M_PI * 2., &c );
	a = z * c + x * s;
	x = -z * s + x * c;
	z = a;

	s = sincos ( aaa.v02.z * M_PI * 2., &c );
	a = x * c + y * s;
	y = -x * s + y * c;
	x = a;

	x += aaa.p04;
	z += aaa.p05;

	s = sincos ( aaa.p06 * M_PI * 2., &c );
	a = z * c + x * s;
	x = -z * s + x * c;
	z = a;


	pos_out[id].x = x;
	pos_out[id].y = y;
	pos_out[id].z = z;
	pos_out[id].w = 1;

	if( aaa.color > 0. )
	{
/*		if( aaa.p07 > 0 )
		{
			color.x = v;
			color.y = v;
			color.z = v;
		}
		color.w = 1;
*/
		if( aaa.p07 > 0. )
		{
			/*if( y <= aaa.p07 || 2.2 <= y )
			{
				color.x = 0.;
				color.y = 0.;
				color.z = 0.;
				color.w = 0.;
				col_out[id] = color;
				return;
			}
			float l =  y * aaa.p06;
			*/
			//float l = 1-z*14.15;
			float l = -z;
			col_out[id].x = l;
			col_out[id].y = l;
			col_out[id].z = l;
			col_out[id].w = 1;
		}
		else
		{	//	color on the axis to help find transformation
			float l = aaa.p08 * .005;	//	param in cm and we need half here
			if( -l < y && y < l )
			{
				col_out[id].x = 0;
				col_out[id].y = 1;
				col_out[id].z = 0;
			}
			else if( -l < z && z < l )
			{
				col_out[id].x = 0;
				col_out[id].y = 0;
				col_out[id].z = 1;
			}
			else if( -l < x && x < l )
			{
				col_out[id].x = 1;
				col_out[id].y = 0;
				col_out[id].z = 0;
			}
			else
			{
				col_out[id].x = 1;
				col_out[id].y = 1;
				col_out[id].z = 1;
			}
		}

		col_out[id].w = 1;
	}

/*
	if( aaa.normal > 0. )
	{
		nor_out[id] = n;
	}
*/
}

