aaa.lua.global.declare_table( "body_def" )

local BASE_DIR = "RigidModel/"
--
--	Base
--
body_def.Base =
{
	name = "Base",
	model_dir	= BASE_DIR.."Picasso/",
	map_dir		= BASE_DIR.."Picasso/",
	elt_def =
	{
		{
			model = "BRAS_G.obj",
			map =	{ "BRAS_G.tga" },
			axe = 0,
			how = "arm_left",
		},
		{
			model = "AVBRAS_G.obj",
			map =	{ "AVBRAS_G.tga" },
			axe = 0,
			how = "forearm_left",
		},
		{
			model = "BRAS_G.obj",
			map =	{ "BRAS_G.tga" },
			axe = 0,
			how = "arm_right",
		},
		{
			model = "AVBRAS_G.obj",
			map =	{ "AVBRAS_G.tga" },
			axe = 0,
			how = "forearm_right",
		},
	}
}

--
--	Conserve
--
body_def.Conserve =
{
	name = "Conserve",
	model_dir	= BASE_DIR.."Conserve/",
	map_dir		= BASE_DIR.."Map_Env/",
	elt_def =
	{
		{--	Arm Left
			model = "BRAS.obj",
			axe = 2,
			how = "arm_left",
			map = { "uffizi.jpg" }
		},
		{--	ForeArm Left
			model = "AVBRASG.obj",
			axe = 2,
			how = "forearm_full_left",
			map = { "cur" }
		},
		{--	Arm Right
			model = "BRAS.obj",
			axe = 2,
			how = "arm_right",
			map = { "cur" }
		},
		{--	ForeArm Right
			model = "AVBRASD.obj",
			axe = 2,
			how = "forearm_full_right",
			map = { "cur" }
		},
		{--	Leg Left
			model = "FEMUR.obj",
			axe = 2,
			how = "leg_left",
			map = { "cur" }
		},
		{--	Leg Right
			model = "FEMUR.obj",
			axe = 2,
			how = "leg_right",
			map = { "cur" }
		},
		{--	ForeLeg Left
			model = "TIBIA.obj",
			axe = 2,
			how = "foreleg_left",
			map = { "cur" }
		},
		{--	ForeLeg Right
			model = "TIBIA.obj",
			axe = 2,
			how = "foreleg_right",
			map = { "cur" }
		},
		{--	Foot Left
			model = "FEMUR.obj",
			axe = 1,
			how = "foot_left",
			map = { "cur" }
		},
		{--	Foot Right
			model = "FEMUR.obj",
			axe = 1,
			how = "foot_right",
			map = { "cur" }
		},
		{--	Torso
			model = "TORSE.obj",
			axe = 2,
			how = "torso",
			map = { "cur" }
		},
		{--	Belly
			model = "VENTRE.obj",
			axe = 2,
			how = "belly",
			map = { "cur" }
		},
		{--	Head
			model = "TETE.obj",
			axe = 2,
			how = "head",
			map = { "cur" }
		},
		{--	Face
			model = "VISAGE.obj",
			axe = 2,
			how = "face",
		},
	},
}

--
--	Honda
--
body_def.Honda =
{
	name = "Honda",
	model_dir	= BASE_DIR.."Honda/",
	map_dir		= BASE_DIR.."Honda/",
	elt_def =
	{
		{--	Arm Left
			model = "BRAS.obj",
			axe = 2,
			how = "arm_left",
		},
		{--	ForeArm Left
			model = "AVBRASG.obj",
			axe = 2,
			how = "forearm_full_left",
		},
		{--	Arm Right
			model = "BRAS.obj",
			axe = 2,
			how = "arm_right",
		},
		{--	ForeArm Right
			model = "AVBRASD.obj",
			axe = 2,
			how = "forearm_full_right",
		},
		{--	Leg Left
			model = "FEMUR.obj",
			axe = 2,
			how = "leg_left",
		},
		{--	Leg Right
			model = "FEMUR.obj",
			axe = 2,
			how = "leg_right",
		},
		{--	ForeLeg Left
			model = "TIBIAG.obj",
			axe = 2,
			how = "foreleg_left",
		},
		{--	ForeLeg Right
			model = "TIBIAD.obj",
			axe = 2,
			how = "foreleg_right",
		},
		{--	Foot Left
			model = "PIED_G.obj",
			axe = 1,
			how = "foot_left",
		},
		{--	Foot Right
			model = "PIED_G.obj",
			axe = 1,
			how = "foot_right",
		},
		{--	Torso
			model = "TORSE.obj",
			axe = 2,
			how = "torso",
		},
		{--	Belly
			model = "VENTRE.obj",
			axe = 2,
			how = "belly",
		},
		{--	Head
			model = "TETE.obj",
			axe = 2,
			how = "head",
		},
		{--	Face
			model = "VISAGE.obj",
			axe = 2,
			how = "face",
		},
	},
}

--
--	Picasso
--
body_def.Picasso =
{
	name = "Picasso",
	model_dir	= BASE_DIR.."Picasso/",
	map_dir		= BASE_DIR.."Picasso/",
	elt_def =
	{
		{--	Arm Left
			model = "BRAS_G.obj",
			axe = 2,
			how = "arm_left",
			map =	{ "BRAS_G.tga" },
		},
		{--	ForeArm Left
			model = "AVBRAS_G.obj",
			axe = 2,
			how = "forearm_full_left",
			map =	{ "AVBRAS_G.tga" },
		},
		{--	Arm Right
			model = "BRAS_D.obj",
			axe = 2,
			how = "arm_right",
			map =	{ "BRAS_D.tga" },
		},
		{--	ForeArm Right
			model = "AVBRAS_D.obj",
			axe = 2,
			how = "forearm_full_right",
			map =	{ "AVBRAS_D.tga" },
		},
		{--	Leg Left
			model = "FEMUR_G.obj",
			axe = 2,
			how = "leg_left",
			map =	{ "FEMUR_G.tga" },
		},
		{--	Leg Right
			model = "FEMUR_D.obj",
			axe = 2,
			how = "leg_right",
			map =	{ "FEMUR_D.tga" },
		},
		{--	ForeLeg Left
			model = "TIBIA_G.obj",
			axe = 2,
			how = "foreleg_left",
			map =	{ "TIBIA_G.tga" },
		},
		{--	ForeLeg Right
			model = "TIBIA_D.obj",
			axe = 2,
			how = "foreleg_right",
			map =	{ "TIBIA_D.tga" },
		},
		{--	Foot Left
			model = "PIED_G.obj",
			axe = 0,
			how = "foreleg_left",
			map =	{ "PIED_G.tga" },
		},
		{--	Foot Right
			model = "PIED_D.obj",
			axe = 0,
			how = "foreleg_right",
			map =	{ "PIED_D.tga" },
		},
		{--	Torso
			model = "TORSE.obj",
			axe = 2,
			how = "torso",
			map =	{ "TORSE.tga" },
		},
		{--	Belly
			model = "VENTRE.obj",
			axe = 2,
			how = "belly",
			map =	{ "VENTRE.tga" },
		},
		{--	Head
			model = "TETE.obj",
			axe = 2,
			how = "head",
			map =	{ "TETE.tga" },
		},
		{--	Face
			model = "VISAGE.obj",
			axe = 2,
			how = "face",
		},
	},
}

--
--	LeSaint
--
body_def.LeSaint =
{
	name = "LeSaint",
	model_dir	= BASE_DIR.."LeSaint/",
	map_dir		= BASE_DIR.."LeSaint/",
	elt_def =
	{
		{--	Arm Left
			model = "BRAS.obj",
			axe = 2,
			how = "arm_left",
		},
		{--	ForeArm Left
			model = "AVBRAS.obj",
			axe = 2,
			how = "forearm_full_left",
		},
		{--	Arm Right
			model = "BRAS.obj",
			axe = 2,
			how = "arm_right",
		},
		{--	ForeArm Right
			model = "AVBRAS.obj",
			axe = 2,
			how = "forearm_full_right",
		},
		{--	Leg Left
			model = "FEMUR.obj",
			axe = 2,
			how = "leg_left",
		},
		{--	Leg Right
			model = "FEMUR.obj",
			axe = 2,
			how = "leg_right",
		},
		{--	ForeLeg Left
			model = "TIBIA.obj",
			axe = 2,
			how = "foreleg_left",
		},
		{--	ForeLeg Right
			model = "TIBIA.obj",
			axe = 2,
			how = "foreleg_right",
		},
		{--	Foot Left
			model = "PIED.obj",
			axe = 2,
			how = "foot_left",
		},
		{--	Foot Right
			model = "PIED.obj",
			axe = 2,
			how = "foot_right",
		},
		{--	Torso
			model = "TORSE.obj",
			axe = 2,
			how = "torso",
		},
		{--	Belly
			model = "VENTRE.obj",
			axe = 2,
			how = "belly",
		},
		{--	Head
			model = "TETE.obj",
			axe = 2,
			how = "head",
		},
		{--	Face
			model = "VISAGE.obj",
			axe = 2,
			how = "face",
		},
	},
}

