CLASS.DECLARE( "BUILDING_DEF", nil, {
	obj_by_name = {},
	} )

function BUILDING_DEF:create( name )
	local self = BUILDING_DEF:create_instance( name )
	return self
end
function BUILDING_DEF.get( name )
	local def = BUILDING_DEF.obj_by_name[ name ]
	return def
end
function BUILDING_DEF.put( def )
	BUILDING_DEF.obj_by_name[ def.name ] = def
end
function BUILDING_DEF.put_table( tab )
	for _,def in ipairs( tab ) do
		BUILDING_DEF.put( def )
	end
end

if CLASS.DECLARE( "BUILDING", nil, {class_ref = {}} ) then

	function BUILDING:init_class_ref()
		local module = aaa.module.get_cur()	--todo ok for now (matrix42 v1.0) but should be refined
		local ref = self.class_ref
		local pagere = param.get_ref
		--OBJ_3D
		ref.obj3d_layers	=	aaa.obj.get_branch_by_name_symbo( module, "wspace_obj3d" )

		local function build_obj_refs( r, str )
			r.layer	= aaa.obj.get_branch_by_name_symbo( ref.obj3d_layers, str.."_layer" )
				r.use_bdd	=	pagere( r.layer, "use_bdd" )
				param.set( r.use_bdd, "update_and_draw" )
				aaa.obj.update_then_draw( r.layer )
				param.set( r.use_bdd, "draw" )
				r.bind 		= 	pagere(	r.layer, "bind_2d_offset" )

				r.trs	=	aaa.obj.get_branch_by_name_symbo( r.layer, str.."_trs" )
					r.tx			=	pagere(  r.trs, "translate_x" )
					r.ty			=	pagere(  r.trs, "translate_y" )
					r.tz			=	pagere(  r.trs, "translate_z" )

					r.rx			=	pagere(  r.trs, "rotate_x" )
					r.ry 			=	pagere(  r.trs, "rotate_y" )
					r.rz			=	pagere(  r.trs, "rotate_z" )

					r.sx			=	pagere(  r.trs, "scale_x" )
					r.sy			=	pagere(  r.trs, "scale_y" )
					r.sz			=	pagere(  r.trs, "scale_z" )
				r.map	=	aaa.layer.get_mapping( r.layer )
					r.tex_v	=	pagere(  r.map, "tex_v" )
		end

		ref.cube = {}
		build_obj_refs( ref.cube, "cube" )
		ref.cube.color		=	aaa.obj.get_branch_by_name_symbo( ref.cube.layer, "cube_color" )
		--2021 Maa comment because don't iunderstand
		--	COLOR_REF.get_rgba_ref( ref.cube, "", ref.cube.color, "global_" )

		--ref.plate = {}
		--build_obj_refs( ref.plate, "plate" )
		ref.cone = {}
		build_obj_refs( ref.cone, "cone" )

		ref.rect = {}
		build_obj_refs( ref.rect, "rect" )

	end
	BUILDING:init_class_ref()
end

function BUILDING:create( name, id, ws_def )
	local self = BUILDING:create_instance( name )
	self.id = id
	self.ws_def = ws_def
	self.def_name = ws_def.b_def
	self:define_ui()
	return self
end

function BUILDING:get_def()	return BUILDING_DEF.get( self.def_name )	end

function BUILDING:update( ws_def )
	--self:print( "BUILDING:update() "..self.url )
	self.ws_def = ws_def
	self.space = m42.space_stack:get_top()

	local def = self:get_def()
	if not def then
		self:print_error( "define_ui no def skipping" )
		return
	end
	self.title = ws_def.title or (ws_def.name or def.name)
	if self.bu_www_inside and m42.b_www_update then
		--self:print( "bu_www_inside:update()" )
		self.bu_www_inside:update()
	end
	local video_filename = ws_def.video_filename
	if video_filename then
		local video = self.video
		if not video then
			video = VIDEOS:get( video_filename )
			if video then
				video.filename = video_filename
			end
			self.video = video
			video:set_restart()
			video:set_stop()
			video:set_loop( false )
			video:update()
			self.bind = video:get_bind()
		end
		if video then
			local cam = self.space.cam
			local x, z, sx, sz, sy, rot = self:get_coor()
			local d = V2.dist_from_xyxy( x, z, cam.x, cam.z )
			if d < 2. then
				video:start()
			elseif d > 2.5 then
				video:set_stop()
				if d > 3 then
					video:set_restart()
				end
				video:update()
			end
			local luma = ws_def.video_luma
			if luma then
				video:set_luma( luma[1], luma[2], luma[3] )
			end
		end
	end
	local image_filename = ws_def.image_filename
	if image_filename then
		local image = self.image_bind
		if not image then
			self:print( image_filename )
			MEDIA.set_dir(  )
			image = IMGS.get_bind( image_filename )
			self.image_bind = image
			self.bind = image
		end
	end
end

function BUILDING:get_title()	return self.title		end

function BUILDING:get_coor()
	local d = self.ws_def
--	local x, z, bx, sz, sy = d.x, d.z, d.sx, d.sz, d.sy
	if d.r then
		d.sx = d.r * 2.
		d.sz = d.r * 2.
	end
	for _,v in pairs( { "x", "z", "sx", "sy", "sz" } ) do
		if not d[v] then self:print( v.." nil" )  end
	end
	local x, z, sx, sz, sy, rot = d.x, d.z, d.sx, d.sz, d.sy, d.rot

	return self.space:transform_building( x, z, sx, sz, sy, rot )
end

function BUILDING:is_active()
	local d = self.ws_def
	return d.b_active == nil or d.b_active
end

function BUILDING:is_inside( x, z )
	if not self:is_active() then return end

	local d = self.ws_def
	--todo	we don't use rot here
	local bx, bz, bsx, bsz, bsy = self:get_coor()
	if inside( x, bx-bsx*.5, bx+bsx*.5 ) and inside( z, bz-bsz*.5, bz+bsz*.5 ) then
		return true
	end
	return false
end

function BUILDING:draw_obj( ref, x, y, z, sx, sy, sz, rot_y )
	param.set( ref.tx, x )
	param.set( ref.ty, y   )
	param.set( ref.tz, z )
	param.set( ref.rx, 0 )
	param.set( ref.ry, rot_y )
	param.set( ref.rz, 0 )
	param.set( ref.sx, sx )
	param.set( ref.sy, sy )
	param.set( ref.sz, sz )

	param.set( ref.tex_v, 1. )


--	param.set( ref.red,		1 )
--	param.set( ref.green,	1 )
--	param.set( ref.blue, 	1 )

	aaa.obj.update_then_draw( ref.layer )
end
function BUILDING:get_ref_geo( geo )
	local ref
	if geo then
		if geo == "cone" then
			ref	= self.class_ref.cone
		elseif geo == "rect" then
			ref	= self.class_ref.rect
		else
			ref	= self.class_ref.cube
		end
	else
		ref	= self.class_ref.cube
	end
	--else
	--	ref			= self.ref.plate
	--end
	return ref
end

function BUILDING:draw( ox, oz )
	if not self:is_active() then return end

	--if not self.time_init_end then return end

	--if inside( aaa.time.t, self.time_init_end, self.time_init_end + 1 ) then
	--	b.bus:set_active( false )
	--end

	--id = math.floor( math.fmod( id*.01257, NB ) ) + 1
	--aaa.print(id)
	local ref
	--if math.fmod( id, 2 )==1 then
	local d	 = self:get_def()
	if not d then
		self:print_error( "draw no def skipping" )
		return
	end
	local x, z, sx, sz, sy, rot = self:get_coor()
	local y = 0
	if d.model == "stand" then
		gol.enable_lighting()
		--gol.color_cyan()
		gol.set_texture_dim( 0 )
			local ssy = .125
			aaa.draw_box( sx, ssy ,sz,	x, ssy*.5, z )
			y = y + 2 * ssy
		gol.set_texture_dim( 2 )
	end
	ref = self:get_ref_geo( d.geo )


	--local ref = math.fmod( id, 2 )==1 and self.ref.cube or self.ref.plate
	--local bind = wrap( id, 0, 10.99999 )
	--aaa.print( id )
	--local t = self.att[id]
	x = x + ox
	z = z + oz
	--self:print( bx.." "..bz.."\t"..bsx.." "..bsz.." "..bsy )
	sy = sy * .5
	param.set( ref.bind, self.bind )
	--aaa.print_inverse( "----------"..b.bind )
	self:draw_obj( ref, x, y + sy*.5, z, sx, sy, sz, rot )

	if self.title then
		gol.push_matrix()
		gol.push_attrib()
			gol.disable_lighting()
				gol.color_yellow()
				gol.set_texture_dim( 0 )
				gol.set_line_width( 2 )
				gol.set_line_smooth( true )
				gol.draw_line_strip_3d(	x, sy, z,
										x, sy*1.5, z )
				gol.translate( x, y + sy*1.5, z )
				local id = self.id
				local angle = (aaa.time.t + id) * .1
				if ( id*.5 - math.floor( id*.5 ) ) > .48 then
					angle = -angle
				end
				gol.rotate_y( angle )
				gol.scale( self.space.title_factor )
				gol.translate( -.5 )
				--aaa.draw_str_xy( "toto", 0, sy  )
				aaa.draw_str_xy( self.title, 0, 0, .2, .2 )
			gol.enable_lighting()
		gol.pop_attrib()
		gol.pop_matrix()
	end

end

function BUILDING:place_bu( bu )
	bu:set_sxy( 4.5 * 2 *16 / 9 / 2.2, 4.5 )
	bu:set_xy( 0, 0 )
end

function BUILDING:define_ui( )
	local bus = BUS:create( self:get_name().."_outside" )
	local def = self:get_def()

	if not def then
		self:print_error( "define_ui no def skipping" )
		return
	end
	local ws_def = self.ws_def
	local url = ws_def.url or def.url
	self:print( "url : "..url )
	bus:set_active( true )
	bus:init_begin_add_to_ga()

		if url then
			self.url = url
			--todo deal with a bdd web with no BU/BUS around
			if def.type == "www" then
				local bu_www = app:define_www( -1, 0,	7, 5, self:get_name(), url )
				self:place_bu( bu_www )
				self.bu_www = bu_www
				self.bu_www_inside = bu_www:get_bus_down().bu_www
			else
				--self:print( "BU_WWW:create()" )
				bu_www = BU_WWW:create( {0,0, 1.333333, 1} )
				--bu_www:disable_mobile()
				bu_www:set_www_page( url, true )
				self.bu_www_inside = bu_www
			end
			--self:print_inverse( "------------ "..def.www_sx..", "..def.www_sy )
			self.bu_www_inside:set_pixel_size( def.www_sx or 1024, def.www_sy or 768 )
			self.bind = self.bu_www_inside:get_texture_bind_2d()
			self.bu_www_inside:trig_load()
			--self:print( def.type )
			--if not (b.type=="www") then
				--self:print_inverse( "----------------------------------- trig_load ---------------------" )

			--end
		else
			self.bind = 28	--texture sol
			--self.bind = 52	--texture rien
			--self.bind = 70 --texture pb
		end

	bus:init_end()

	--bus:set_active( false )
	self.bus = bus
	if def.type ~= "www" or not m42.b_start_load_www then
		bus:set_active(false)
		self.bu = self.bu_www
	end

	if self:get_name() == "Bearstech" then
		self.ref = {}	--todo this could be dangerous
		self.ref.obj = aaa.obj.get( "m42_office" )
	end

	if def.type == "wspace" then
	end
end

function BUILDING:quit()
	aaa.print_method()
	local def = self:get_def()
	self.bus:set_active(false)
	if self.bu then
		self.bu:__set_window_state("mini")
	end
	if pong and def.type == "pong" then pong.active = false end
	m42.building_cur = nil
	m42.skel:set_multitouch( false )
end

function BUILDING:enter()
	aaa.print_method()
	local def = self:get_def()
	--if b.name ~= "Pong" and (not b.ref or not b.ref.obj) then
		self.bus:set_active(true)
		if self.bu then
			self.bu:__set_window_state("normal")
			self:place_bu( self.bu )
		end
		if self.bu_www_inside and def.type == "www" then
			self.bu_www_inside:trig_load()
		end
	--end
	m42.building_cur = self
	m42.skel:set_multitouch( def.type == "www" or def.type == nil )
	local space = nil
	local space_name = def.space_name
	if space_name then
		self:print( "\t"..space_name )
		space = m42.spaces[space_name]
	else
		local class_name = def.space_class
		class_name = class_name and ( "SPACE_"..class_name ) or "SPACE"
		self:print( "try to create :"..class_name )
		local class = _G[class_name]
		if class then
			space = class:create( class_name )
		else
			self:print_error( "class "..class_name.." not defined" )
		end
	end
	self:print( "\t"..space )
	if space then
		space:update_buildings()	--	seems that draw is called before
		space.building_in = self
	end
	return space
end
