--
--	Owner DEV ( Patrice should not touch it )
--

--
--	BPART	infact this is a Body Part
--
CLASS.DECLARE( "BPART", nil, {base_dir = "../AAAAPPs/OldSchool/APP_Matrix42/"} )

--
--	TEXTURE BINDING
--
function BPART:add_bind_2d( id, obj )
	local ref = self.ref
	ref.map[id] = {}
	ref.map[id].bind_2d = param.get_ref( obj, "bind_2d" )
	ref.map[id].bank_2d = param.get_ref( obj, "bank_2d" )
end

function BPART:set_bind_2d_bank_bind( id, bank, bind )
	--table.print( self.ref.map, "B_PART map", 2 )
	local map = self.ref.map[id]
	param.set( map.bank_2d, bank )
	param.set( map.bind_2d, bind )
end
function BPART:set_bind_2d_cur( id )
	self:set_bind_2d_bank_bind( id, -1, -1 )
end
function BPART:set_bind_2d( bind, id )
	--aaa.print_method()
	local ba, bi = aaa.img.make_bank_bind_2d( bind )
	self:set_bind_2d_bank_bind( id, ba, bi )
end

--
--	REF
--
function BPART:__build_ref()
	local ref = self.ref
	ref.layer = {}
	ref.map = {}
	ref.map_use = {}

	ref.layers	=	self.layers
		ref.active	=	param.get_ref( ref.layers, "active" )
		--self:print( aaa.get_filename() )

		ref.layer[1]	=	aaa.layers.get_layer( ref.layers, 1 )
			self:add_bind_2d( 1, ref.layer[1] )
			ref.render		=	aaa.layer.get_rendering( ref.layer[1] )
				ref.light		=	param.get_ref( ref.render, "light" )
			ref.map_use[1] =	param.get_ref( ref.layer[1], "use_mapping" )
			ref.mapping		=	aaa.layer.get_mapping( ref.layer[1] )
			ref.tex_dim = {}
				ref.tex_dim[1] = param.get_ref( ref.mapping, "tex_use" )
			ref.texturing	=	aaa.obj.get_branch_by_class( ref.layer[1], "texturing" )
			--local filename = aaa.obj.get_name( ref.texturing )
			local tab	=	aaa.obj.get_branchs_by_class( ref.texturing, "texture_unit" )
			if tab then
				local nb = #tab
				--self:print( "found "..nb.." texture_unit" )
				for i = 1,nb do
					local unit = tab[i]
					ref.tex_dim[i+1] = param.get_ref( aaa.obj.get_branch_by_class( tab[i], "mapping" ), "tex_use" )
					--self:print( aaa.obj.get_filename( unit ) )
					self:add_bind_2d( i+1, unit )
				end
			end

		ref.layer[2]	=	aaa.layers.get_layer( ref.layers, 2 )
			self.shading = aaa.layer.create_shading( ref.layer[2], "layer_2" )
			ref.layer_2_shader_bdd_only = param.get_ref( ref.layer[2], "shader_bdd_only" )
			self:add_bind_2d( 5, ref.layer[2] )
			param.set( ref.layer[2], "transfo_three", "Owner" )
			aaa.obj.update_then_draw( ref.layer[2]  )
			self.transfo = TRANSFO_THREE:create( self:get_name(), aaa.obj.get_branch_by_class( ref.layer[2], "transfo_three" ) )
			--local tr = self.transfo
			--tr:set_obj_active( true )
			--tr:set_type( 3 )
			--tr:set_axe( 2 )
			--tr:set_scale( 1 )
			--tr:set_inter( 1. )

		ref.layer[3]	=	aaa.layers.get_layer( ref.layers, 3 )
			ref.bdd_tri			=	aaa.obj.get_branch_by_class( ref.layer[3], "bdd_tri" )
			ref.model_filename	=	param.get_ref( ref.bdd_tri, "model_filename" )
			ref.bbox_max = {}
			ref.bbox_max[1]		=	param.get_ref( ref.bdd_tri, "bounding_box_max_x" )
			ref.bbox_max[2]		=	param.get_ref( ref.bdd_tri, "bounding_box_max_y" )
			ref.bbox_max[3]		=	param.get_ref( ref.bdd_tri, "bounding_box_max_z" )
--[[
			self:add_bind_2d( 1, ref.layer[3] )
			local texturing = aaa.obj.get_branch_by_class( ref.layer[1], "texturing" )
			local filename = aaa.obj.get_name( texturing )
			local tab = aaa.obj.get_branchs_by_class( texturing, "texture_unit" )
			if tab then
				local nb = #tab
				self:print( "found "..nb.." texture_unit" )
				for i = 1,nb do
					local unit = tab[i]
					--self:print( aaa.obj.get_filename( unit ) )
					self:add_bind_2d( i+1, unit )
				end
			end
--]]
	aaa.layer.set_bdd_external( ref.layer[2], ref.bdd_tri )
	param.set( ref.layer[2], "use_bdd", "update_and_draw" )

	--	set to 0 to deactivate target morph
	for i=1,6 do self.shading:set_vert_vec4_w( i, 0. ) end
end

function BPART:assign()
	self:__build_ref()
	local ref_layer = self.ref.layer[1]
	param.set( ref_layer, "use_model",		"CURRENT" )
--	param.set( ref_layer, "use_rendering",	"CURRENT" )
	param.set( ref_layer, "use_shading",	"CURRENT" )
	param.set( ref_layer, "use_color",		"CURRENT" )
	param.set( ref_layer, "use_fog",		"none" )
	return self
end

function BPART:get_file_dir()	return self.base_dir.."body_part/" end
function BPART:build_filename_low( name, add )	return self:get_file_dir()..name.."/BPart_"..add	end
function BPART:build_filename( name )			return self:build_filename_low( name, self.letter )	end
function BPART:build_filename_a( name )			return self:build_filename_low( name, "A" )			end
function BPART:create( name, i )
	local	letter = string.char( i+64 )
	local	self = BPART:create_instance( name.."_"..letter )
	self.letter = letter
	self.letter_lowercase = string.char( i + 64 + 32 )
	self.bpart_index = i
	self.name_pure = name
	self.ref = {}
	self.bind = {}
--	self:assign()
	self:set_active( true )
	return self
end

function BPART:get_shading()		return self.shading	end

function BPART:set_focus()				aaa.obj.set_focus_ui( self.layers )						end
function BPART:set_focus_render()		aaa.obj.set_focus_ui( self.ref.render )					end
function BPART:focus_shading()			aaa.obj.set_focus_ui( self:get_shading():get_obj() )	end
function BPART:set_focus_mapping()		aaa.obj.set_focus_ui( self.ref.mapping )				end
function BPART:set_focus_texturing()	aaa.obj.set_focus_ui( self.ref.texturing )				end
function BPART:set_focus_layer( index )	aaa.obj.set_focus_ui( self.ref.layer[index] )			end

function BPART:draw_attr( )
	aaa.obj.update_then_draw( self.ref.layer[1] )
end

function BPART:process_def( body, def )
	local start_dir = app.media_dir_rel
	--self:print_inverse( "process_def()" )
	local ref = self.ref
	local map = def.map
	if map then
		--	todo refine
		local dir = start_dir
		if body.map_dir then dir = dir..body.map_dir end
		MEDIA.set_dir( dir )

		local bind
		for i=1,4 do
			--if i==1 then
			--	param.set( ref.layer_2_shader_bdd_only, 0 )
			--end
			local name = map[i]
			if name then
--[[
				if type(name) == "table" then
					if not self.seq then self.seq = {} end
					self.seq[i] = IMG_SEQ:create_from_array( "seq"..i, name )
					bind = -2
					if i==1 then
						param.set( ref.layer_2_shader_bdd_only, 0 )
					end

				elseif name == "caustic" then
					bind = -1	--todo refine with a seq nb
				else
--]]
				if name == "cur" then
					bind = nil
					if i == 1 then
						param.set( ref.map_use[1], -1 )
						self:set_bind_2d_cur( 1 )
						self:set_bind_2d_cur( 5 )
					end
				else
					bind = IMGS.get_bind_sxy_with_error_dialog( name )
				end
--			end
			end

			self.bind[i] = bind
			--if not bind then bind = 64 end	--refine this should be an empty texture for now
			if bind and bind > 0 then
				self:set_bind_2d( bind, i )
				--todo this go around a bug
				if i==1 then
					self:set_bind_2d( bind, 5 )
				end
			end
		end
	end
--[[
	local	sha = self.shading
	local	vertex = def.vertex or 1
	sha:set_vert_bind( 128 + vertex - 1 )
	local	pixel = def.pixel or 1
	sha:set_frag_bind( 128 + pixel - 1 )
--]]
	if def.model then
		local name = start_dir
		if body.model_dir then name = name..body.model_dir end
		name = name..def.model
		param.set( ref.model_filename, name )
		aaa.obj.update_then_draw( ref.bdd_tri )
	end

	self.how = def.how

	self.axe = def.axe
	local tr = self.transfo
	tr:set_axe( self.axe )
end

function BPART:reload_shader()
	SHADING.trig_reload_include()
	self.shading:trig_reload()
end


function BPART.draw_before()
end

local node_how = {
	arm_left			= { 6, 5, 3 },
	forearm_left		= { 7, 6, nil },
	forearm_full_left	= { 8, 6, 7 },
	arm_right			= { 10, 9, 3 },
	forearm_right		= { 11, 10, nil },
	forearm_full_right	= { 12, 10, 11 },
	leg_left			= { 14, 13, 1 },
	foreleg_left		= { 15, 14, nil },
	foreleg_full_left	= { 16, 14, 15 },
	foot_left			= { 15, 16, nil },
	leg_right			= { 18, 17, 1 },
	foreleg_right		= { 19, 18, nil },
	foreleg_full_right	= { 20, 18, 19 },
	foot_right			= { 19, 20, nil },
	torso				= { 5, 9, 2 },
	belly				= { 13, 17, 3 },
	head				= { 9, 5, 4 },
	face				= { 9, 5, 4 },
}

function BPART:set_transfo( mocap_channel, n1, n2, n3 )
	local tr = self.transfo
	tr:set_channel( mocap_channel )
	local how = self.how
	if how then
		how = node_how[how]
		n1 = how[1]
		n2 = how[2]
		n3 = how[3]
	end
	tr:set_start_node( n1 )
	tr:set_stop_node( n2 )
	if n3 then
		tr:set_third_node( n3 )
	end

end

function BPART:draw( )
	if not self:is_active() then return end

--	if GA.b_spy then aaa.spy.add_mark( "elt_"..crea.id, 2 ) end

	local ref_layer = self.ref.layer

	--	attributes
	if BPART.draw_last ~= self then
		aaa.obj.update_then_draw( ref_layer[1] )
		BPART.draw_last = self
	end

--[[
	local seqs = self.seq
	if seqs then
		local seq = seqs[1]
		if seq then
			self:set_bind_2d( seq:get_bind_rnd( crea.id ), 5 )
		end
	else
		--todo avoid to do this every time
		--self:set_bind_2d( self.bind[1], 5 )
	end

	local sha = self.sha
	sha:set_vert_vec3_6_table18( crea.pos )

	local race = crea.race
	--	1 2 3 for deformation on curve
	--	4 size factor ( < 1. )
	-- unused 5
	--	6 time used for animation
	sha:set_vert_float_1_6( crea.seg_len, crea.seg_len_over, crea.s_inter, crea.size_factor, crea.tail.angle, crea.race.tail.amp )
--]]
--	param.set( self.ref.layer_2_shader_bdd_only, 0 )
	aaa.obj.update_then_draw( ref_layer[2] )
	--	bdd
	--	aaa.obj.update_then_draw( ref_layer[3] )
--	gol.flush()
--[[
	local hack = self.__hack
	if not hack then hack = 0 end
	if hack == 127 then
		self.__hack = 0
		gol.flush()
	else
		self.__hack =  hack + 1
	end
--]]
end

function BPART:draw_transfo( mocap_channel, n1, n2, n3 )
	self:set_transfo( mocap_channel, n1, n2, n3 )
	self:draw()
end

function BPART:update()
	self:set_active( param.get_bool( self.ref.active ) )
end

--
--	LOAD / SAVE
--
function BPART:save( name )
	local filename = self:build_filename( name )
	local err = app:save_layers_or_module( self.layers, filename )
	if err then
		self:print_error( "err "..err.." saving file : "..filename )
	else
		self:print( filename.." saved" )
	end
end
function BPART:load_from_full_name( filename )
	local layers, err = app:create_layers( filename )
	if layers then
		self.layers = layers
		self:print( filename.." loaded" )
		self:assign()
	else
		self:print_error( "err "..err.." loading file : "..filename )
	end
end
function BPART:load( name )
	local filename = self:build_filename( name )
	if aaa.file.is_exist( filename..".aaa_layers_all" ) then
		self:load_from_full_name( filename )
	else
		filename = self:build_filename_a( name )
		self:load_from_full_name( filename )
	end
end

--
--	UI
--
function BPART:add_window( title, bus_down, pos )
	local SX = .5
	local SY = .5
	local SS = .1
	local bu = bus_cur:add_window( title, bus_down,		{1.5+pos[1]*SX,.5+pos[2]*SY, 1,1} )
	bu:set_size_orig_for_mini( pos[3]*SS, pos[4]*SS )
	return bu
end

function BPART:define_ui_internal( bus )
	local bu
	bu = bus:add_but_target_param( "Active", nil, self.ref.active )

--	bus:add_but_trig_method( "Layers", nil,	self, "set_focus" )
	bus:move_right( 1 )
		bus:add_but_trig_method(	"Layer A",		nil,	self,	"set_focus_layer",	1	)
		bus:move_right( 1 )
		--	bus:add_but_target_param(	"Light",		nil,	self.ref.light	)
--			bus:add_but_trig_method(	"Mapping",		nil,	self,	"set_focus_mapping"		)
--			bus:add_but_trig_method(	"Texturing",	nil,	self,	"set_focus_texturing"	)
			bus:move_right( 1 )
				for i=1,4 do
					bu = bus:add_but_target_param(	tostring(i-1),	nil,	self.ref.tex_dim[i]	)
					bu:set_min_max( 0., 2. )
				end
			bus:move_left( 1 )
		bus:move_left( 1 )
		bus:add_but_trig_method(	"Layer B",		nil,	self,	"set_focus_layer",	2	)
--		bus:move_right( 1 )
--			bus:add_but_trig_method(	"Shader",		nil,	self,	"focus_shading"		):set_color_back("focus")
--			bus:move_right( 1 )
--				bus:add_but_target_param(	"active",		nil,	self.shading.ref.active	)
--				bus:add_but_trig_method(	"Reload",		nil,	self,	"reload_shader"			)
--			bus:move_left( 1 )
--		bus:move_left( 1 )
		--bus:add_but_trig_method(	"Layer C",		nil,	self,	"set_focus_layer",	3	)
	bus:move_left( 1 )
	bus:move_next_col()

	self.ui = {}
	self.ui.bu_tex = {}
	local s = 1.
	for i = 1,2 do
		local bind = self.bind[i]
		if bind then
			bu = bus:add_monitor( "Mon_"..self:get_name()..i, {1,s*(2-i), s,s}, bind )
			bu:set_text( i - 1, .1 )
			bu:set_text_xy( .3, .3 )
			bu:set_text_draw( true )
			bu:set_text_color( 0, 1, 1 )
			self.ui.bu_tex[i] = bu
		end
	end
end

--		-2	-1	0	1	2
--6				F
--5				H
--4		AR		T		AL
--3		FAR		B		FAL
--2		HR	LR		LL	HL
--1			FLR		FLL
--0			FR		FL

local MAXY = 2
local MINY = 2
local bpart_ui =
{
	{	name="ArmL",	pos={	2,	4,	1,	MAXY	}	},
	{	name="FArmL",	pos={	2,	3,	1,	MAXY	}	},
	{	name="ArmR",	pos={	-2,	4,	1,	MAXY	}	},
	{	name="FArmR",	pos={	-2,	3,	1,	MAXY	}	},
	{	name="LegL",	pos={	1,	2,	1,	MAXY	}	},
	{	name="LegR",	pos={	-1,	2,	1,	MAXY	}	},
	{	name="FlegL",	pos={	1,	1,	1,	MAXY	}	},
	{	name="FlegR",	pos={	-1,	1,	1,	MAXY	}	},
	{	name="FootL",	pos={	1,	0,	2,	MINY	}	},
	{	name="FootR",	pos={	-1,	0,	2,	MINY	}	},
	{	name="Torso",	pos={	0,	4,	4,	MAXY	}	},
	{	name="Belly",	pos={	0,	3,	2,	MINY	}	},
	{	name="Head",	pos={	0,	5,	3,	3	}	},
	{	name="Face",	pos={	0,	6,	2,	2	}	},
}

function BPART:define_ui()
	local ui = bpart_ui[self.bpart_index]
	local bus = BUS:begin_window( ui.name, 2, 2 )
		bus:set_bu_pos_load_save( false )
		bus:set_grid_draw( false )

		bus:add_bup( {.2,.2, 1.8,1.8} ):set_size( 1.7, .2 )

		self:define_ui_internal( bus )
	bus:end_window()

	local bu = self:add_window( ui.name, bus, ui.pos )
	return bu
end