--
--	BODY
--
if CLASS.DECLARE( "BODY" ) then
	BODY.__ref_attrib_layer = aaa.obj.get( "body_layer_attribute" )
end

function BODY:create( name, nb_part )
	local self = BODY:create_instance( name )
	self:print( "CREATING" )
	self.bpart = {}
	self.nb_part = math.min( nb_part, 20 )
	for i=1,self.nb_part do
		self.bpart[i] = BPART:create( name, i )
	end
	self:load( name )
	local def = body_def[name]
	if def then
		self:process_def( def )
	else
		self:box_error( "no body_def."..name )
	end
	return self
end

function BODY:process_def( def )
	local elt_defs = def.elt_def
	self.model_dir = def.model_dir
	self.map_dir = def.map_dir
	if elt_defs then
		local bpart = self.bpart
		local len = 0.
		for i=1,self.nb_part do
			local elt_def = elt_defs[i]
			if elt_def then
				bpart[i]:process_def( self, elt_def )
			end
		end
	end
end
--]]

--
--	LOAD / SAVE
--
function BODY:build_filename_before( name )
	return self.bpart[1]:build_filename_low( name, "_Before" )
end
function BODY:load( name )
	--self:print_inverse( "TODO will load "..name )
	local bpart = self.bpart
	for i=1,self.nb_part do
		bpart[i]:load( name )
	end
	local filename = self:build_filename_before( name )

	local layers, err = app:create_layers( filename )
	if layers then
		self.layers_before = layers
		self:print( filename.." loaded" )
	else
		self:print_error( "err "..err.." loading file : "..filename )
	end
end
function BODY:save( name )
	self:print_inverse( "Saving BODY "..name )
	local bpart = self.bpart
	for i=1,self.nb_part do
		bpart[i]:save( name )
	end
	if self.layers_before then
		local filename = self:build_filename_before( name )
		local err = app:save_layers_or_module( self.layers_before, filename )
		if err then
			self:print_error( "err "..err.." saving file : "..filename )
		else
			self:print( filename.." saved" )
		end
	end
end

function BODY:load_by_index() self:load( self:get_name() ) end
function BODY:save_by_index() self:save( self:get_name() ) end -- could beself.name_..(self.index_save+1)

--
--	UI
--
function BODY:add_selector( key, nb_x, nb_y )
	bus_cur:move_next()
	local bu = bus_cur:add_selector( {nil,nil, nb_x,nb_y} )	--, "bank_"..text )
	bu:set_text_draw( false )
	--bu.text_u = .22
	--bu.text_v = -1.15
	bu:set_nb_min_0( nb_x, nb_y )
	self[key] = 0
	bu:set_target_lua( self, key )
end
function BODY:focus_before()
	aaa.obj.set_focus_ui( self.layers_before )
end
function BODY:define_ui_base()
	local bus = BUS:begin_window( self:get_name() )
		bus:set_bu_pos_load_save( false )

		local bu

		bu = bus:add_but_target_lua( "Active", 			nil,	self, "__b_active", true )

		bus:add_but_trig_method(	"BODY Save",		nil,	self, "save_by_index"	):set_color_back("save")
		bus:add_but_trig_method(	"Focus Before",		nil,	self, "focus_before"	):set_color_back("focus")

		bus:move_next_col()

		local s = 1
		local d = 1
		for i,elt in IPAIRS( self.bpart ) do
			local bu
			bu = elt:define_ui()
			bu:__set_window_state("mini")
		end
	bus:end_window()
	return bus
end

function BODY:define_ui( bus, x, y )
	local S = .24
	local bu = bus:add_window( self:get_name(), self:define_ui_base(),	{2.5,2, 1.5,2} )
	bu:set_sxy( 3, 4 )
	bu:set_pos_mini( {x*S,y*S*1.2, S,S} )
	bu:__set_window_state("mini")

	return bu
end

--
--	GLOBAL
--
function BODY.draw_before()
	BPART.draw_last = nil
	aaa.obj.update_then_draw(	BODY.__ref_attrib_layer		)
end

function BODY.draw_after()
end

--
--
--
function BODY:update()
	local bpart = self.bpart
	for i=1,self.nb_part do
		bpart[i]:update()
	end
end
function BODY:draw( mocap_channel )
	aaa.obj.update_then_draw( self.layers_before )
	local bpart = self.bpart
	for i=1,self.nb_part do
		bpart[i]:draw_transfo( mocap_channel )
	end
end
function BODY:updraw( mocap_channel )
	self:update()
	self:draw( mocap_channel )
end


--
--	BODYS
--
CLASS.DECLARE( "BODYS" )

function BODYS:init()
	self.body_by_name = {}
	self.body_by_index = {}
	self.body_nb = 0
end
function BODYS.create( name )
	local self = BODYS:create_instance( name )
	self:init()
--	self:process_def( race_def[name] )
	self.body_index = 1
	return self
end
function BODYS:get_nb()				return self.body_nb						end
function BODYS:build_index( id )	return wrap_int( id, 1, self:get_nb() )	end
function BODYS:set_index( id )
	self.body_index =  self:build_index( id )
	return self.body_index
end
function BODYS:inc_index()	return self:set_index( self.body_index + 1 )	end
function BODYS:dec_index()	return self:set_index( self.body_index - 1 )	end

function BODYS:draw_after()
	BODY.draw_after()
end
function BODYS:add( body_name, nb )
	if self.body_by_name[body_name] then
		self:print_debug( "have already a body with this name : "..body_name )
		return
	end
	local body = BODY:create( body_name, nb )
	if body then
		self.body_by_name[body_name] = body
		local body_nb = self:get_nb() + 1
		self.body_nb = body_nb
		self.body_by_index[body_nb] = body
		self:print( "body_by_index["..body_nb.."] is "..body_name )
	end
end
function BODYS:get( body_name )
	local body = self.body_by_name[body_name]
	if not body then
		self:print_error( "Can't find body "..body_name )
	end
	return body
end
function BODYS:get_by_index( id )
	return self.body_by_index[ self:build_index( id ) ]
end
function BODYS:get_cur()
	--self:print( self.body_index )
	return self:get_by_index( self.body_index )
end
function BODYS:define_ui()
	local bus = BUS:begin_window( "BODYS" )
	bus:set_bu_pos_load_save( false )

		bus:add_but_trig_method(	"+",		nil,	self,	"inc_index"	)
		bus:add_but_trig_method(	"-",		nil,	self,	"dec_index"	)

		local i = 1
		for k,body in pairs( self.body_by_index ) do
			local bu = body:define_ui( bus, 1, i )
			bu:set_method_on_click(	self, "set_index", i )
			i = i + 1
		end

	bus:end_window()

	return bus
end
function BODYS:update()
--	for k,race in PAIRS( self.races ) do
--		race:update()
--	end
end
function BODYS:draw()
	BPART.draw_before()
	BODY.draw_before()
--	for k,race in PAIRS( self.races ) do
--		race:update()
--	end
end
function BODYS:updraw( skel )
	self:update()
	skel:draw_attr()
--	self:print( #self.body_by_name )
	local body = self:get_cur()
	body:updraw( skel.mocap_channel_1 )
end