APP.DECLARE( "APP_BRO", APP )

--
--	BOID
--
function APP_BRO:boid_get_and_id( id )
	return self.ref.boid_bdd, id
end
function APP_BRO:boid_get_point_nb( id )
	--aaa.print( id )
	local boid = self:boid_get_and_id( id )
	return aaa.bdd.get_point_nb( boid )
end
function APP_BRO:boid_set_point( id, x, y )
	local boid, id = self:boid_get_and_id( id )
	aaa.bdd.set_point_by_id( boid, id, x, y )
end
function APP_BRO:boid_set_box( id, x, y )
	local boid, id = self:boid_get_and_id( id )
	aaa.bdd.set_box_by_id( boid, id, x, y )
end
function APP_BRO:boid_get_point( id )
--	aaa.print( "boid_get_point "..id )
	local boid, id = self:boid_get_and_id( id )
	return aaa.bdd.get_point_by_id( boid, id )
end
function APP_BRO:boid_updraw( b_restart )
	local ref = self.ref
	local boid = ref.boid_bdd
	--local see_boid = chanel.b_boid_show and "update_and_draw" or "update"
	--param.set( ref.boid_use_bdd, see_boid )
	if b_restart then
		param.set( boid, "restart_trig", 1 )
	end
	aaa.obj.update_then_draw( ref.boid_layer )
end

function APP_BRO:attach_bu( bu, i )
	bu.b_attached = true
	local x,y	=  bu:get_xy()
	self:boid_set_point( i, x, y )
end
function APP_BRO:deattach_bu( bu )
	bu.b_attached = false
end
function APP_BRO:boid_set_nb( nb )
	local boid = self.ref.boid_bdd
	param.set(	boid,	"nb_allocated",	nb	)
	param.set(	boid,	"nb_alive_min",	nb	)
	param.set(	boid,	"nb_alive_max",	nb	)
end
--
--
--
local function n5_show_hide_bu_table( tab, b )
	for _, bu in PAIRS( tab ) do
		--bu:print( "riri" )
		bu:set_active( b )
	end
end

--
--	POWER
--
function APP_BRO:set_power( min, max, bright )
	if self.power_min ~= min and self.power_max ~= max then
		aaa.power.set_battery_cpu( min, max )
		aaa.power.set_plugged_cpu( 0, .1 )
		self.power_min = min
		self.power_max = max
	end
	if self.power_bright ~= bright then
		aaa.power.set_brightness_battery( bright )
		aaa.power.set_brightness_plugged( .0 )
		self.power_bright = bright
	end
end
function APP_BRO:set_state( state )
	if self.state == state then return end
	if state == "full" then
		self:set_power( 0, .7, .7 )
	elseif state == "idle" then
		self:set_power( 0, .1, .1 )
	end
	self.state = state
end
function APP_BRO:mark_time_alive()
	--aaa.print( "maRK" )
	self.time_alive = aaa.time.t
	self:set_state( "full" )
end

--
--	serve here as the update for the app
--
function APP_BRO:draw_background( bus )
	local blob_nb = ga:get_blobs():get_blob_nb()
	if blob_nb == 0 then
		local DELAY = 30.
		--self:print( "test for restart : "..self.state.." "..(self.time_alive + DELAY).." "..aaa.time.t )
		if not (self.state == "idle") and (self.time_alive + DELAY) < aaa.time.t then
			self:print_debug( "not alive for "..DELAY.." sec " )
			if not self.ui.bu_root.b_n5_small then
				self:restart()
			end
			self:set_state( "idle" )
		end
	else
		self:mark_time_alive()
	end

	self:boid_updraw()

	--self:print( self.b_smooth )
	ga.__transfo_inter_time_factor = self.b_smooth and 4. or 128.

	if self.bu_flipping then
		if not self.bu_flipping:is_transfo_inter() then
			self.bu_flipping:set_ui_active( true )
			self.bu_flipping = nil
		end
	end

	local nb_boid = self:boid_get_point_nb()

	local bu = self.ui.bu_root
	local inter = bu:get_transfo_inter_smooth()
	if not inter then
		if bu.b_n5_small then
			inter = 0
		else
			inter = 1
		end
	end
	--self:print( "tyoto"..bu.b_n5_small )
	local boid_sy = interpolate( 1.8, 1, inter )
	local boid_y = interpolate( .2, 0, inter )

	--	when we at the beginning ( restart / parfume ) we are small
	--		and don't want to trigger restart after a timeout
	--		neither we want to look at video to check their state
	--		so we force alive at true
	local b_search_alive = not self.ui.bu_root.b_n5_small
	local b_alive = false
	-- ATTACH DETACH
	for i = 1, nb_boid do
		local bu = bus:get_bu(i)
		if not bu then
			break
		end
		bu:set_method_on_click_double()

		if not bu:is_full_page() then
			local b_contact = bu:is_contact()
			if bu.b_attached then
				if b_contact then -- and inside( bu.chanel.state, 1, 2 ) then
					self:deattach_bu( bu, i )
				end
			else
				if not b_contact then --and inside( bu.chanel.state, 0, 1 ) then
					self:attach_bu( bu, i )
				end
			end
			if bu.b_attached then
				if not bu.__pos_memory then
					local x, y = self:boid_get_point( i )	--todo crash if a layers is used
					--bu:print( i.." "..bu.b_attached.." "..x.." , "..y )

					bu:set_xy( x, y*boid_sy+boid_y )
					self:boid_set_box( i, 1., .25, 2. )
				end
			else
				local x,y	=  bu:get_xy()
				self:boid_set_point( i, x, y )
			end
		end
			--bu:print( i.." "..bu.b_attached )

		local bus_down = bu:get_bus_down()
		local inter
		local back_alpha
		if bu.__pos_memory then
			inter = 1.
			bu:set_mobile( false )
		else
			bus_down:stop_video_all()
			inter = 0.
			bu:set_mobile( true )
			bu:set_rot( false )
			bu:set_scale( false )
		end

		if bu:is_transfo_inter() then
			inter = bu:get_transfo_inter_smooth()
			bu:set_mobile( false )
			--bu:print( inter )
		end
		if true then
			for i = 1, bus_down:get_bu_nb()	 do
				local bu = bus_down:get_bu( i )
				if bu:is_video()  then
					local sy = bu.__sy_rt
					if not sy then
						sy = bu:get_sy()
					else
						--self:print( sy )
					end
					bu:set_video_scrub_sy( (sy-1.) / (4.5-1.) )
					if b_search_alive and not b_alive then
						b_alive = bu:is_video_playing()
					end
					if bu:is_video_at_end() then
						if bu:is_full_page() then
							bu:n5_really_flip_size()
						end
					end
					bu:set_alpha_bu( inter )
				elseif bu.__images then
					bu:set_alpha_bu( inter )
				end
			end
			bu.n5_inter = inter
			if inter > 0. then
				bus_down:show_video()
			else
				bus_down:hide_video()
			end
			--bus_down:print_inverse( "riorio" )
			if bus_down.n5_visibility_flip_list then
				--bus_down:print_inverse( "yuyuy" )
				n5_show_hide_bu_table( bus_down.n5_visibility_flip_list, inter > 0. )
			end
			bu:set_back_alpha( interpolate( 0, .7, inter ) )
		else
			for i = 1, bus_down:get_bu_nb()	 do
				local bu = bus_down:get_bu( i )
				bu:set_alpha_bu( 1 )
				bu:set_active( true )
			end
			bu:set_back_alpha( 1 )
		end
		--todo this done direct and heavy
		bus_down:set_video_loop( self.__b_video_loop )
	end

	if b_alive then
		self:mark_time_alive()
	end


--	local bu = bus.child[nb_boid+1]
--	if bu.b_n5_reverse_inter then
--		bu:print( "Target" )
--		bu:draw()
--	end
end

--
--
--
function APP_BRO:init_ref()
	local ref = self.ref
	local module = aaa.module.get_cur()
	ref.module		=	module
	ref.boid_layer	=	aaa.obj.get_down(	module,	"boid_layer"	)
	ref.boid_bdd	=	aaa.obj.get_down(	module,	"boid_bdd"		)
end

function BU:n5_draw_bottle( bind )
	local F = .5
	gol.push_matrix()
		gol.translate( 0, .5 )
		gol.scale( F * 2.62 / self.SX, F * 4.24 / self.SY )
		gol.set_texture_dim( 2 )
		gol.bind_texture( bind )
		gol.color_white()
			self:gol_draw_rect_uv_size( 8 )
		gol.color_green()
			self:gol_draw_rect_line()
		gol.set_texture_dim( 0 )
	gol.pop_matrix()
end

function BU:n5_root_do_click_down( x, y )
	if self.verbose >= 1 then aaa.print_method() end
	x, y = self:convert_xy_local_to_bus_up( x, y )
	local n5 = self.n5
	if not n5 then
		self.n5 = {}
		n5 = self.n5
	end
	n5.bx = x
	n5.by = y
	n5.time = aaa.time.t
end
function BU:n5_root_do_click_up()
	if self.verbose >= 1 then aaa.print_method() end
	local n5 = self.n5
	if n5 and chanel_n5.b_restart_on_long_click then
		local x,y = self.__blob_cur[1].x, self.__blob_cur[1].y
		--self:print( "BU:n5_root_do_click_up() "..(n5.bx-x)..", "..(n5.by-y) )
		local dist = V2.dist_from_xyxy( x, y, n5.bx, n5.by )
		--self:print( "do_click_up() for n5 "..x..", "..y )
		--self:print( "do_click_up() for n5 "..dist )
		local str
		if dist <= .1 then
			local delay = aaa.time.t - n5.time
			if delay > 5. then
				chanel_n5:restart()
			else
				str = "not long enough "..delay.." sec"
			end
		else
			str = "too far "..dist
		end
		if str then
			if self.verbose >= 1 then self:print( "n5_root_do_click_up() "..str ) end
		end
	end
	self.n5 = nil
	--local blob = ga:get_blobs():find_by_id( bu.__blob_start[1].id )
end

function APP_BRO:root_flip_full_page( b_force )
	if self.verbose >= 3 then aaa.print_method() end
	local bu = self.ui.bu_root
	local b_small = bu.b_n5_small
	if b_small then	--hack
	else
		if not self.b_allow_back and not b_force then
			return
		end
	end
	bu:set_window_state( "flip_full" )
	bu.__b_bus_down_active_ui = b_small
	b_small = not b_small
	bu.b_n5_small = b_small
	self:show_bottle_back_but( not b_small )
	self.ui.bu_fr:set_active( b_small )
	self.ui.bu_en:set_active( b_small )
end
function APP_BRO:show_bottle_back_but( b )
	if self.ui.bu_restart then
		self.ui.bu_restart:set_active( b )
	end
end
function APP_BRO:define( media_dir )
	self:init_lang_def()

	self.mbro = MBRO:create( self:get_name() )
	self.media_dir = media_dir
	local bus_down = self.mbro:define_pages( self.media_dir )
	self:boid_set_nb( self.mbro.__nb_sub_dir )
	bus_down:set_bu_pos_load_save( true )
	bus_down:set_method( "draw_before",	self,	"draw_background", bus_down	)

	local bind_bottle		= IMGS.get_bind( self.media_dir.."/N5_start_high.png" )
	local bind_bottle_small = IMGS.get_bind( self.media_dir.."/N5_128.png" )

	local bus = BUS:create( self:get_name() )
	bus:set_bu_pos_load_save( true )
	bus:set_active( true )
	bus:init_begin_add_to_ga()

		local SX = 8.
		local SY = 4.5
		local bu
		bu = bus:add_window( "N5_root", bus_down,	{0,0, SX,SY} )

			self.ui.bu_root = bu
			bus_down:set_transfo( SX,SY )
			bu:set_border( false )
			bu:set_text_draw( false )
			bu:set_ui_top( false )
			bu:set_mobile( false )
			local FS = .2
			bu:set_xy( 0, -.5 )
			bu:set_sxy( SX*FS, SY*FS )
			bu:cpy_cur_to_all( "APP_BRO:define" )
			bu.b_n5_small = true
			bu.SX = SX
			bu.SY = SY
--			bu.b_n5_reverse_inter = true
			bu:set_method(	"draw_custom",	bu, "n5_draw_bottle", bind_bottle )
			bu.__b_bus_down_active_ui = false
--	was there to go back on a click long
--			bu.do_click_down	=	BU.n5_root_do_click_down
--			bu.do_click_up		=	BU.n5_root_do_click_up

--deja		self:init_bu_root()
			bu:set_dplane(-42)

		self.ui.bu_root_big = bu
		bu = bus:add_button( "Flip Full Page", {0,0, 2,3.2} )
			bu:set_border( true )
			bu:set_method_on_click( self, "root_flip_full_page" )
			bu:set_visible( false )
			bu:set_dplane(-42)

	bus:init_end()

	local bus = BUS:create( self:get_name().."_on_top" )
	bus:set_active( true )
	bus:init_begin_add_to_ga()

		local X = 4.
		local Y = X * 9 / 16
		local S = .4
		local SH = S * .5
		local bu

		if true then
			--	bottle
			bu = bus:add_image( "bottle_small", {-X+SH,-Y+SH, S*.7,S*.7}, bind_bottle_small)
				--bu:assign_texture( bind_bottle_small )
				bu:set_border( false )
				--bu:set_active( true )
				bu:set_border_line( true )
				bu:set_method_on_click( self, "restart" ):set_color_back("restart")
			self.ui.bu_restart = bu
		end
		if true then
			local X = 2.5
			local BY = -Y+SH
			local SY = 1
			bu = bus:add_image( "french", {-X,BY, nil,SY}, self.media_dir.."/FRANCAIS.png", true )
				bu:change_name( "FRANCAIS" )
				bu:set_border( false )
				bu:set_border_line( true )
				bu:set_mobile( false )
				bu:set_method_on_click(	self, "start_with_lang", "french" )
				self.ui.bu_fr = bu

			bu = bus:add_image( "english", {X,BY, nil,SY}, self.media_dir.."/ENGLISH.png", true )
				bu:change_name( "ENGLISH" )
				bu:set_border( false )
				bu:set_border_line( true )
				bu:set_mobile( false )
				bu:set_method_on_click(	self, "start_with_lang", "english" )
				self.ui.bu_en = bu
		else
			--	FR / EN
			if false then
				--	draw a globe
				local obj = aaa.obj.get_down( self.ref.module, "globe" )
				local fx = FX:create( "Globe", obj )	--, b_active )

				bu = bus:add_button( nil, {X-SH,Y+SH, S,S} )
					bu:set_border( true )
					bu:set_border_line( true )
					bu:set_method_on_click( self, "flip_lang" )
					bu:set_method(	"draw_custom",	bu, "n5_draw_globe", fx )
			else
				--todo do a real buttin with tex on and off
				--local bind_fr = IMGS.get_bind( self.media_dir.."/lang.png" )
				bu = bus:add_image( "lang", {X-SH-.12,Y-SH, S,S}, self.media_dir.."/lang.png")
					bu:set_border( false )
					bu:set_border_line( true )
					bu:set_mobile( false )
					bu:set_method_on_click(	self, "flip_lang" )
					--bu:set_method_on_click_double(	self, "flip_lang" )
			end
		end

		bu = bus:add_wiz_power(	{-.78, -Y+SH, .12, .15} )
			self.ui.bu_power = bu
			bu:set_active( false )
			bu:set_text_color( 1, 1, 1, .6 )

		bu = bus:add_wiz_maaeb(	{0, Y-SH, .4} )
			self.ui.bu_maaeb = bu
			bu:set_active( false )

	bus:init_end()
end

function APP_BRO:show_power( b )		self.ui.bu_power:set_active( b )	end
function APP_BRO:show_maa( b )		self.ui.bu_maaeb:set_active( b )	end

if false then
	if chanel_n5 then
		local bu = chanel_n5.ui.bu_power
		bu:set_active( true )
		bu:set_text_color( 1, 1, 1, .6 )
	end
end

function BU:n5_draw_globe( fx )
	fx:draw()
end

function APP_BRO:init_bu_root()
	local bu = self.ui.bu_root
	bu:set_method_on_click( self, "root_flip_full_page" )
	bu:set_method_on_click_double()
	if not bu.b_n5_small then
		self:root_flip_full_page( true )
	end
end
function APP_BRO:restart()
	aaa.print_method()
	--aaa.debug.print_traceback()
	self:init_bu_root()
	self.mbro:reload_pos()
	if self.bu_flipping then
		self.bu_flipping:set_ui_active( true )
	end
	self.bu_flipping = nil
	self:show_bottle_back_but( false )
	self:set_lang( "english" )
	self:set_lang( "french" )
end
function APP:start_with_lang( la )
	self:set_lang( la )
	self:root_flip_full_page()
end

function APP_BRO:define_ui_inside()
	local bus = BUS:begin_window( "UI_"..self:get_name(), 2, 2 )

		local function add_slider_param( text, param_ref, min, max )
			local bu = bus:add_slider( text )
				bu:set_target_param( param_ref )
				bu:set_min_max( min, max )
			return bu
		end

		bus:set_bu_pos_load_save( false )
		bus:set_grid_draw( false )

		bus:add_bup( {.2,.2, 3.8,3.8} ):set_size( 1.8, .2 )

		local bu
		bus:add_but_trig_method(	"Restart",					nil,	self,				"restart"								):set_color_back("restart")
		bus:add_but_target_lua( 	"Restart_on_long_click",	nil,	self,				"b_restart_on_long_click",		true	)
		add_slider_param( 			"Volume",					aaa.audio.ref.volume,	nil,						0,		1.	)
		add_slider_param( 			"Pan",						aaa.audio.ref.pan,		nil,						-1.,	1.	)
		bus:move_next()
		bus:add_but_trig_method(	"Explorer Kill",			nil,	aaa,				"kill_explorer"					)
		bus:add_but_trig_method(	"Explorer Launch",			nil,	aaa,				"launch_explorer"				)
		bus:move_next()
		bus:add_but_target_lua(		"Smooth",					nil,	self,				"b_smooth",						true	)
		bus:add_but_target_lua(		"Simple Click",				nil,	self,				"b_click_simple",				true	)
		bus:add_but_target_lua(		"Allow Back",				nil,	self,				"b_allow_back",					false	)
		bus:add_but_target_lua(		"Video Loop",				nil,	self,				"__b_video_loop",				false	)

		bus:add_slider_target(		"l1_word_scale",			{1.4,	.8, 2.} 	)

		bus:move_next_col()
		ga:define_ui_perlinpinpin( bus, { false, true, false, true, true, false, true, true } )

	bus:end_window()

--	return bu
	return bus
end

function APP_BRO:define_app_ui()
	local bu
	local bus = BUS:create( "N5" )
	bus:set_active( true )
	bus:set_bu_pos_load_save( true )
	bus:init_begin_add_to_ga()

		bu = bus:add_window( "N5", self:define_ui_inside(),		{-3,0, 2,2} )

	bus:init_end()

	ga:register_ui_group( bus )
	ga:set_ui_group_active( false )

	return bus
end

function APP_BRO:do_key_special( key )
	local bu_power = self.ui.bu_power
	if not bu_power then return false end

	local b_key_used
	aaa.print( "chanel special_key "..key.." in "..aaa.script.get_name( ) )
	if key == 130 then
		self:mark_time_alive()
		local nb
		local cur = aaa.time.t
		local lt = bu_power.last_time
		if lt then
			if cur < lt + .8 then
				nb = bu_power.n5_count or 0
				nb = nb + 1
				self:print( "count to access wiz is "..nb )
				if nb >= 3 then
					self:show_power( true )
					if nb >= 12 then
						self:show_maa( true )
					end
				end
			else
				nb = nil
			end
		else
			delay = cur
		end
		bu_power.last_time	= cur
			bu_power.n5_count	= nb
		if nb==1 then
			self:restart()
		end
		--aaa.print( "win but on -> "..delay.." "..cur )
		bu_power.n5_delay_on = delay
		b_key_used = true
	else
		-- 2023 October before we did that when no key at all
		bu_power.n5_delay_on = nil
		b_key_used = false
	end

	if bu_power:is_active() then
		local delay = bu_power.n5_delay_off
		local cur = aaa.time.t
		if delay then
			if delay + 12. < cur then
				delay = nil
				self:show_power( false )
				self:show_maa( false )
			end
		else
			delay = cur
		end
		bu_power.n5_delay_off = delay
	end

	return b_key_used or oo.getsuper(APP_BRO).do_key_special( self, key )
end


--todo do a real callback function on the key

function APP_BRO:hook_quit( b_shutdown, b_shutdown_reboot )
	if self:is_onsite() then
		aaa.launch_explorer()
	end
	local obj = aaa.obj.get_from_top_by_class( "multitouch_master" )
	param.set(  obj, "disable_win_o", false )
	APP.hook_quit( self, b_shutdown, b_shutdown_reboot )
end

if IS_BUSS_OPEN() then
	ga.cam:set_ortho_size( 7.99 ) --	just inder 8. to avoid white around when full screen
	ga:set_reset_by_blob( false )
	ga:set_win8_samsung()
	aaa.img.set_free_when_on_board( true )
	GABUIN.set( nil, false, false, false, 10 )
	BU.__scale_min = .8
	BU.__scale_max = 10.
	BU.set_bind_border_video_to_image()
	--todo reestablish borders
	---BU:set_draw_lua( false )		--	border are not well done in lua

	--2021 Maa updated
	aaa.lua.global.declare( "chanel_n5" )
	chanel_n5 = APP.CREATE_INST( APP_BRO, "chanel" )
	--chanel_n5 = APP_BRO:create( "chanel" )
	if chanel_n5:is_onsite() then
		aaa.kill_explorer()
		aaa.net.stop_link_all()
		local obj = aaa.obj.get_from_top_by_class( "multitouch_master" )
		param.set( obj, "orientation", "Landscape" )
		param.set( aaa.ref.pref, "clean_render",			false	)
		aaa.flatland.set_draw( false )
		aaa.set_edit( false )
		ga:force_fullscreen()
	end
	chanel_n5:clear_init_done()	--todo refine

	if false then
		chanel_n5:define( app.media_dir_rel.."Chanel/Parfum_2013/N5" )
	else
		chanel_n5:define( app.media_dir_rel.."Celestins" )
	end
	chanel_n5:restart()
	chanel_n5:root_flip_full_page()
	chanel_n5:restart()
	chanel_n5:boid_updraw( true )
	chanel_n5:mark_time_alive()

	aaa.print_inverse( "there is "..VIDEOS:get_nb_used().." videos" )
elseif IS_BUSS_TOP_OPEN() then
	chanel_n5:define_app_ui()
	--chanel_n5:define_ui()
	ga:add_wiz( true, true, true )
end


